*DECK D9AIMP
      SUBROUTINE D9AIMP (X, AMPL, THETA)
C***BEGIN PROLOGUE  D9AIMP
C***SUBSIDIARY
C***PURPOSE  Evaluate the Airy modulus and phase.
C***LIBRARY   SLATEC (FNLIB)
C***CATEGORY  C10D
C***TYPE      DOUBLE PRECISION (R9AIMP-S, D9AIMP-D)
C***KEYWORDS  AIRY FUNCTION, FNLIB, MODULUS, PHASE, SPECIAL FUNCTIONS
C***AUTHOR  Fullerton, W., (LANL)
C***DESCRIPTION
C
C Evaluate the Airy modulus and phase for X .LE. -1.0
C
C Series for AM20       on the interval -1.56250E-02 to  0.
C                                        with weighted error   3.12E-32
C                                         log weighted error  31.51
C                               significant figures required  29.24
C                                    decimal places required  32.38
C
C Series for ATH0       on the interval -1.56250E-02 to  0.
C                                        with weighted error   2.75E-32
C                                         log weighted error  31.56
C                               significant figures required  30.17
C                                    decimal places required  32.42
C
C Series for AM21       on the interval -1.25000E-01 to -1.56250E-02
C                                        with weighted error   3.40E-32
C                                         log weighted error  31.47
C                               significant figures required  29.02
C                                    decimal places required  32.36
C
C Series for ATH1       on the interval -1.25000E-01 to -1.56250E-02
C                                        with weighted error   2.94E-32
C                                         log weighted error  31.53
C                               significant figures required  30.08
C                                    decimal places required  32.41
C
C Series for AM22       on the interval -1.00000E+00 to -1.25000E-01
C                                        with weighted error   3.76E-32
C                                         log weighted error  31.42
C                               significant figures required  29.47
C                                    decimal places required  32.36
C
C Series for ATH2       on the interval -1.00000E+00 to -1.25000E-01
C                                        with weighted error   4.97E-32
C                                         log weighted error  31.30
C                               significant figures required  29.79
C                                    decimal places required  32.23
C
C***REFERENCES  (NONE)
C***ROUTINES CALLED  D1MACH, DCSEVL, INITDS, XERMSG
C***REVISION HISTORY  (YYMMDD)
C   770701  DATE WRITTEN
C   890531  Changed all specific intrinsics to generic.  (WRB)
C   890531  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900315  CALLs to XERROR changed to CALLs to XERMSG.  (THJ)
C   900720  Routine changed from user-callable to subsidiary.  (WRB)
C***END PROLOGUE  D9AIMP
      integer nath1, nath2, nam22, nam21, nath0, nam20
      integer initds
      DOUBLE PRECISION X, AMPL, THETA, AM20CS(57), ATH0CS(53),
     1  AM21CS(60), ATH1CS(58), AM22CS(74), ATH2CS(72), PI4, SQRTX,
     2  XSML, Z,  D1MACH, DCSEVL
      real eta
      LOGICAL FIRST
      external initds, xermsg, d1mach, dcsevl
      intrinsic real, sqrt
      SAVE AM20CS, ATH0CS, AM21CS, ATH1CS, AM22CS, ATH2CS,
     1 PI4, NAM20, NATH0, NAM21, NATH1, NAM22, NATH2, XSML, FIRST
      DATA AM20CS(  1) / +.1087167490 8656185661 5730588125 D-1        /
      DATA AM20CS(  2) / +.3694892289 8266355509 1728665146 D-3        /
      DATA AM20CS(  3) / +.4406801004 8468956366 7507001327 D-5        /
      DATA AM20CS(  4) / +.1436867623 6191115392 9183952833 D-6        /
      DATA AM20CS(  5) / +.8242755523 9007830867 0628855353 D-8        /
      DATA AM20CS(  6) / +.6844267588 9366160617 3927278180 D-9        /
      DATA AM20CS(  7) / +.7395666972 8273928773 1004740213 D-10       /
      DATA AM20CS(  8) / +.9745956336 9682501763 8702600847 D-11       /
      DATA AM20CS(  9) / +.1500768858 2940577565 0973119497 D-11       /
      DATA AM20CS( 10) / +.2621479102 2152763420 6252854802 D-12       /
      DATA AM20CS( 11) / +.5083541113 7648718035 7278966914 D-13       /
      DATA AM20CS( 12) / +.1076847533 5881144049 2985997070 D-13       /
      DATA AM20CS( 13) / +.2460912866 1843342933 5914062617 D-14       /
      DATA AM20CS( 14) / +.6007863803 5865641843 6110373550 D-15       /
      DATA AM20CS( 15) / +.1554491561 0238807115 0651388384 D-15       /
      DATA AM20CS( 16) / +.4235351250 3557660442 6382780182 D-16       /
      DATA AM20CS( 17) / +.1208621662 8929984015 4401109189 D-16       /
      DATA AM20CS( 18) / +.3596096512 1465824086 1499706423 D-17       /
      DATA AM20CS( 19) / +.1111342183 8639563826 1774604677 D-17       /
      DATA AM20CS( 20) / +.3555595324 3236660989 3680289225 D-18       /
      DATA AM20CS( 21) / +.1174330216 0013930999 8766947387 D-18       /
      DATA AM20CS( 22) / +.3993974546 6107756138 9162200966 D-19       /
      DATA AM20CS( 23) / +.1395766715 2891631042 5606325640 D-19       /
      DATA AM20CS( 24) / +.5002400553 0923604139 3459280716 D-20       /
      DATA AM20CS( 25) / +.1835527609 5813267918 4834866457 D-20       /
      DATA AM20CS( 26) / +.6884909981 7920274319 7790112404 D-21       /
      DATA AM20CS( 27) / +.2636310356 1141701235 9996885105 D-21       /
      DATA AM20CS( 28) / +.1029248902 3733836028 7153563785 D-21       /
      DATA AM20CS( 29) / +.4092469666 7159488548 9762960571 D-22       /
      DATA AM20CS( 30) / +.1655585734 0673465103 9727903828 D-22       /
      DATA AM20CS( 31) / +.6807974670 6303335611 6599685727 D-23       /
      DATA AM20CS( 32) / +.2843265599 3407983241 9751134476 D-23       /
      DATA AM20CS( 33) / +.1205073983 4896525509 7287818819 D-23       /
      DATA AM20CS( 34) / +.5179612432 8750521797 6613610424 D-24       /
      DATA AM20CS( 35) / +.2256226134 2756281630 3268640887 D-24       /
      DATA AM20CS( 36) / +.9954188011 4774516883 2117078246 D-25       /
      DATA AM20CS( 37) / +.4445516963 9734242430 8280582053 D-25       /
      DATA AM20CS( 38) / +.2008651954 6150110142 5916097338 D-25       /
      DATA AM20CS( 39) / +.9177863441 5177516597 3885645402 D-26       /
      DATA AM20CS( 40) / +.4238729581 0558924066 1672197948 D-26       /
      DATA AM20CS( 41) / +.1977892720 0784609237 0846251490 D-26       /
      DATA AM20CS( 42) / +.9321163512 8462066568 0435253373 D-27       /
      DATA AM20CS( 43) / +.4434821332 4991809995 5611379722 D-27       /
      DATA AM20CS( 44) / +.2129456723 6557389559 4589552837 D-27       /
      DATA AM20CS( 45) / +.1031585696 5107597755 2209344907 D-27       /
      DATA AM20CS( 46) / +.5040237730 2259119915 7904590029 D-28       /
      DATA AM20CS( 47) / +.2483013045 7015594530 4046541005 D-28       /
      DATA AM20CS( 48) / +.1233017831 2856219605 4198238560 D-28       /
      DATA AM20CS( 49) / +.6170334499 2052174612 1976730507 D-29       /
      DATA AM20CS( 50) / +.3110926174 1591889723 3869792213 D-29       /
      DATA AM20CS( 51) / +.1579830852 0170617301 5269071503 D-29       /
      DATA AM20CS( 52) / +.8079319875 3828360767 8121339092 D-30       /
      DATA AM20CS( 53) / +.4159973941 3866756272 2951360052 D-30       /
      DATA AM20CS( 54) / +.2156109340 9771690047 1935862504 D-30       /
      DATA AM20CS( 55) / +.1124688572 6586917829 6752823613 D-30       /
      DATA AM20CS( 56) / +.5903315606 3283809112 3040811797 D-31       /
      DATA AM20CS( 57) / +.3117356676 9292856204 6280505333 D-31       /
      DATA ATH0CS(  1) / -.8172601764 1616344998 4020870054 3 D-1      /
      DATA ATH0CS(  2) / -.8004012824 7882732875 9648111306 8 D-3      /
      DATA ATH0CS(  3) / -.3186525268 7821132037 9555362824 2 D-5      /
      DATA ATH0CS(  4) / -.6688388266 4775093307 4169886503 3 D-7      /
      DATA ATH0CS(  5) / -.2931759284 9945645165 0682246318 4 D-8      /
      DATA ATH0CS(  6) / -.2011263760 8836216690 4903030718 6 D-9      /
      DATA ATH0CS(  7) / -.1877522678 0559734260 7400816665 2 D-10     /
      DATA ATH0CS(  8) / -.2199637137 7046012518 9900219984 8 D-11     /
      DATA ATH0CS(  9) / -.3071616682 5922724490 2574660558 6 D-12     /
      DATA ATH0CS( 10) / -.4936140553 6734183610 2560098538 9 D-13     /
      DATA ATH0CS( 11) / -.8902833722 5836604169 3523696986 6 D-14     /
      DATA ATH0CS( 12) / -.1768987764 6152726136 5681419946 7 D-14     /
      DATA ATH0CS( 13) / -.3817868689 0322770146 7819960960 0 D-15     /
      DATA ATH0CS( 14) / -.8851159014 8199475941 5628650998 4 D-16     /
      DATA ATH0CS( 15) / -.2184818181 4143659531 4967767956 8 D-16     /
      DATA ATH0CS( 16) / -.5700849046 9864523805 9944229511 9 D-17     /
      DATA ATH0CS( 17) / -.1563121122 1778753925 1603179549 5 D-17     /
      DATA ATH0CS( 18) / -.4481437996 7689950679 0668877635 3 D-18     /
      DATA ATH0CS( 19) / -.1337794883 7361880220 4456604409 8 D-18     /
      DATA ATH0CS( 20) / -.4143340036 8741144537 7685244544 2 D-19     /
      DATA ATH0CS( 21) / -.1327263385 7188050250 8048116465 2 D-19     /
      DATA ATH0CS( 22) / -.4385728589 1284405222 1575683595 5 D-20     /
      DATA ATH0CS( 23) / -.1491360695 9528180676 8620174395 6 D-20     /
      DATA ATH0CS( 24) / -.5208104738 6307113771 5423818877 3 D-21     /
      DATA ATH0CS( 25) / -.1864382222 3904989238 7252660497 9 D-21     /
      DATA ATH0CS( 26) / -.6830263751 1679690129 7543538188 1 D-22     /
      DATA ATH0CS( 27) / -.2557117058 0293296292 9620759134 7 D-22     /
      DATA ATH0CS( 28) / -.9770158640 2543002182 4690725404 6 D-23     /
      DATA ATH0CS( 29) / -.3805161433 4166790840 6842825488 6 D-23     /
      DATA ATH0CS( 30) / -.1509022750 7370540634 9392648299 5 D-23     /
      DATA ATH0CS( 31) / -.6087551341 2424249290 0556801452 5 D-24     /
      DATA ATH0CS( 32) / -.2495879513 8097114954 2598212405 8 D-24     /
      DATA ATH0CS( 33) / -.1039157654 5819209489 0958808427 4 D-24     /
      DATA ATH0CS( 34) / -.4390235913 9768465369 7459496905 1 D-25     /
      DATA ATH0CS( 35) / -.1880790678 4479902116 7582682058 2 D-25     /
      DATA ATH0CS( 36) / -.8165070764 1994629488 6302220575 3 D-26     /
      DATA ATH0CS( 37) / -.3589944503 7497505142 6643558504 1 D-26     /
      DATA ATH0CS( 38) / -.1597658126 6321328729 8129160870 8 D-26     /
      DATA ATH0CS( 39) / -.7193250175 7038239691 1380283530 5 D-27     /
      DATA ATH0CS( 40) / -.3274943012 7278565062 0935113272 1 D-27     /
      DATA ATH0CS( 41) / -.1507042445 7836906658 1697504727 2 D-27     /
      DATA ATH0CS( 42) / -.7006624198 3199047178 4396794914 0 D-28     /
      DATA ATH0CS( 43) / -.3289907402 9837182265 2881567835 6 D-28     /
      DATA ATH0CS( 44) / -.1559518084 3651465264 4532271149 6 D-28     /
      DATA ATH0CS( 45) / -.7460690508 2082545828 3385111972 1 D-29     /
      DATA ATH0CS( 46) / -.3600877034 8246620205 6327724943 1 D-29     /
      DATA ATH0CS( 47) / -.1752851437 4737722573 5040221919 7 D-29     /
      DATA ATH0CS( 48) / -.8603275775 1885129096 2377862872 4 D-30     /
      DATA ATH0CS( 49) / -.4256432603 2269465346 6803948010 5 D-30     /
      DATA ATH0CS( 50) / -.2122161865 0442629277 2365069820 6 D-30     /
      DATA ATH0CS( 51) / -.1065996156 7048790524 7206079856 1 D-30     /
      DATA ATH0CS( 52) / -.5393568608 8169491164 1068808689 2 D-31     /
      DATA ATH0CS( 53) / -.2748174851 0439548222 7849651787 0 D-31     /
      DATA AM21CS(  1) / +.5927902667 2130958837 5717482814 D-2        /
      DATA AM21CS(  2) / +.2005694053 9316518642 8695217690 D-2        /
      DATA AM21CS(  3) / +.9110818502 6227589355 3072526291 D-4        /
      DATA AM21CS(  4) / +.8498943063 7204715563 3172107475 D-5        /
      DATA AM21CS(  5) / +.1132979089 7691307663 7929215494 D-5        /
      DATA AM21CS(  6) / +.1875179461 0066649618 0950627804 D-6        /
      DATA AM21CS(  7) / +.3593065190 1824583269 9035211192 D-7        /
      DATA AM21CS(  8) / +.7657577140 7168386403 9093517470 D-8        /
      DATA AM21CS(  9) / +.1769999671 6803917392 5953460744 D-8        /
      DATA AM21CS( 10) / +.4362595556 5459893272 0546585535 D-9        /
      DATA AM21CS( 11) / +.1132916413 3785323003 5520085219 D-9        /
      DATA AM21CS( 12) / +.3072576909 8241924413 7868398126 D-10       /
      DATA AM21CS( 13) / +.8644824164 8220107554 1200465766 D-11       /
      DATA AM21CS( 14) / +.2510152500 6092440211 5104562212 D-11       /
      DATA AM21CS( 15) / +.7491024967 6444037160 1802227751 D-12       /
      DATA AM21CS( 16) / +.2289969284 8799407308 9565214432 D-12       /
      DATA AM21CS( 17) / +.7151136589 2798769494 9327491175 D-13       /
      DATA AM21CS( 18) / +.2276079249 5956684194 6395165061 D-13       /
      DATA AM21CS( 19) / +.7369421427 6088651396 9953227782 D-14       /
      DATA AM21CS( 20) / +.2423286752 6782749046 3991742006 D-14       /
      DATA AM21CS( 21) / +.8081537745 4823986928 3406558403 D-15       /
      DATA AM21CS( 22) / +.2730080798 0435608665 9174563386 D-15       /
      DATA AM21CS( 23) / +.9332360708 9138531847 3519474326 D-16       /
      DATA AM21CS( 24) / +.3225080996 8108462221 3867546973 D-16       /
      DATA AM21CS( 25) / +.1125819323 4644454121 7757573416 D-16       /
      DATA AM21CS( 26) / +.3966994639 8693882166 0259459530 D-17       /
      DATA AM21CS( 27) / +.1410065679 4431950466 0865034527 D-17       /
      DATA AM21CS( 28) / +.5053020865 3785121337 5537393032 D-18       /
      DATA AM21CS( 29) / +.1824615232 1594514119 7999102789 D-18       /
      DATA AM21CS( 30) / +.6635845682 6213046692 8029121642 D-19       /
      DATA AM21CS( 31) / +.2429637316 3127617974 1747455826 D-19       /
      DATA AM21CS( 32) / +.8952389151 2368780201 3669922963 D-20       /
      DATA AM21CS( 33) / +.3318452893 5005079126 0229250755 D-20       /
      DATA AM21CS( 34) / +.1237061961 8865831538 4437905922 D-20       /
      DATA AM21CS( 35) / +.4636366770 1239084030 6767734243 D-21       /
      DATA AM21CS( 36) / +.1746531359 4776447546 9758765989 D-21       /
      DATA AM21CS( 37) / +.6611168102 3499117630 7910643111 D-22       /
      DATA AM21CS( 38) / +.2514099189 9407248617 6125666459 D-22       /
      DATA AM21CS( 39) / +.9602749955 7173256869 4034386998 D-23       /
      DATA AM21CS( 40) / +.3683249522 8929639568 6436898078 D-23       /
      DATA AM21CS( 41) / +.1418431382 6915913614 5535939553 D-23       /
      DATA AM21CS( 42) / +.5483426742 7693583010 6345800990 D-24       /
      DATA AM21CS( 43) / +.2127610546 2311880665 0372562616 D-24       /
      DATA AM21CS( 44) / +.8284437008 4941859148 7734760953 D-25       /
      DATA AM21CS( 45) / +.3236705639 2612700142 1028600927 D-25       /
      DATA AM21CS( 46) / +.1268688829 6328605735 5055062493 D-25       /
      DATA AM21CS( 47) / +.4988438189 9212162693 5068934362 D-26       /
      DATA AM21CS( 48) / +.1967345844 6764939096 7119381790 D-26       /
      DATA AM21CS( 49) / +.7781359710 2032695771 3212064836 D-27       /
      DATA AM21CS( 50) / +.3086339414 9891115291 9192968451 D-27       /
      DATA AM21CS( 51) / +.1227446470 4545311978 9338037234 D-27       /
      DATA AM21CS( 52) / +.4894312791 3429220588 5241216204 D-28       /
      DATA AM21CS( 53) / +.1956468798 0290982117 5925099724 D-28       /
      DATA AM21CS( 54) / +.7839889529 2242617116 6311492266 D-29       /
      DATA AM21CS( 55) / +.3148969140 0248422374 8298978099 D-29       /
      DATA AM21CS( 56) / +.1267697631 3725068130 7067842559 D-29       /
      DATA AM21CS( 57) / +.5114706919 0690014164 1632107724 D-30       /
      DATA AM21CS( 58) / +.2068017097 9553877025 0900316706 D-30       /
      DATA AM21CS( 59) / +.8378913447 6851900132 5996867583 D-31       /
      DATA AM21CS( 60) / +.3401689919 7148980205 2339079577 D-31       /
      DATA ATH1CS(  1) / -.6972849916 2088838458 8814841503 7 D-1      /
      DATA ATH1CS(  2) / -.5108722790 6500449870 7344807796 1 D-2      /
      DATA ATH1CS(  3) / -.8644335996 9897550945 2533474951 2 D-4      /
      DATA ATH1CS(  4) / -.5604720044 2352635421 8869891612 5 D-5      /
      DATA ATH1CS(  5) / -.6045735125 6238974091 5637664007 7 D-6      /
      DATA ATH1CS(  6) / -.8639802632 4883343932 1972113849 9 D-7      /
      DATA ATH1CS(  7) / -.1480809484 3099271571 4778248078 0 D-7      /
      DATA ATH1CS(  8) / -.2885809334 5772360399 9944990871 2 D-8      /
      DATA ATH1CS(  9) / -.6191631975 6656996093 0919123180 0 D-9      /
      DATA ATH1CS( 10) / -.1431992808 8609578309 3136525987 9 D-9      /
      DATA ATH1CS( 11) / -.3518141102 1372147215 0461687432 1 D-10     /
      DATA ATH1CS( 12) / -.9084761919 9550782900 7033980805 1 D-11     /
      DATA ATH1CS( 13) / -.2446171672 6885984493 4328366476 7 D-11     /
      DATA ATH1CS( 14) / -.6826083203 2134462408 2899671026 4 D-12     /
      DATA ATH1CS( 15) / -.1964579931 1949401712 7854625780 2 D-12     /
      DATA ATH1CS( 16) / -.5808933227 1396931640 0919126585 6 D-13     /
      DATA ATH1CS( 17) / -.1759042249 5274419927 9540095902 4 D-13     /
      DATA ATH1CS( 18) / -.5440902932 7148966136 3253894531 9 D-14     /
      DATA ATH1CS( 19) / -.1715247407 4868068026 2235851945 1 D-14     /
      DATA ATH1CS( 20) / -.5500929233 5769915468 7110184716 1 D-15     /
      DATA ATH1CS( 21) / -.1791878287 7393172594 9515263875 4 D-15     /
      DATA ATH1CS( 22) / -.5920372520 0866941977 7841106223 1 D-16     /
      DATA ATH1CS( 23) / -.1981713027 8764839624 7097220659 0 D-16     /
      DATA ATH1CS( 24) / -.6713232347 0163522620 4998434379 0 D-17     /
      DATA ATH1CS( 25) / -.2299450243 6582811161 2235861983 2 D-17     /
      DATA ATH1CS( 26) / -.7957300928 2363765953 0463714563 4 D-18     /
      DATA ATH1CS( 27) / -.2779994027 2917841571 7229023373 9 D-18     /
      DATA ATH1CS( 28) / -.9798924361 3269852244 0679548081 4 D-19     /
      DATA ATH1CS( 29) / -.3482717006 0615743867 0264556584 9 D-19     /
      DATA ATH1CS( 30) / -.1247489122 5585990571 7330005808 4 D-19     /
      DATA ATH1CS( 31) / -.4501210041 4782281134 8775182445 2 D-20     /
      DATA ATH1CS( 32) / -.1635346244 0133521355 9611416466 7 D-20     /
      DATA ATH1CS( 33) / -.5980102897 7803362680 9876226594 1 D-21     /
      DATA ATH1CS( 34) / -.2200246286 2861234540 2819629547 5 D-21     /
      DATA ATH1CS( 35) / -.8142463073 5150858974 0820529151 9 D-22     /
      DATA ATH1CS( 36) / -.3029924773 6600425374 3233070967 4 D-22     /
      DATA ATH1CS( 37) / -.1133390098 5746235377 2294396968 9 D-22     /
      DATA ATH1CS( 38) / -.4260766024 7492957192 8304988979 1 D-23     /
      DATA ATH1CS( 39) / -.1609363396 2781897187 9750063445 3 D-23     /
      DATA ATH1CS( 40) / -.6106377190 8250262930 4533044428 7 D-24     /
      DATA ATH1CS( 41) / -.2326954318 0216940618 3657788757 3 D-24     /
      DATA ATH1CS( 42) / -.8903987877 4722526044 7412955818 6 D-25     /
      DATA ATH1CS( 43) / -.3420558530 0056750241 1791475234 1 D-25     /
      DATA ATH1CS( 44) / -.1319026715 2572726590 1721210060 7 D-25     /
      DATA ATH1CS( 45) / -.5104899493 6120430913 1619117738 6 D-26     /
      DATA ATH1CS( 46) / -.1982599478 4745474512 4244466346 6 D-26     /
      DATA ATH1CS( 47) / -.7725702356 8808305356 3611185151 9 D-27     /
      DATA ATH1CS( 48) / -.3020234733 6646801008 1577686357 3 D-27     /
      DATA ATH1CS( 49) / -.1184379739 0741699937 1294638080 0 D-27     /
      DATA ATH1CS( 50) / -.4658430227 9223085205 7325284010 6 D-28     /
      DATA ATH1CS( 51) / -.1837554188 1003846471 5750200661 3 D-28     /
      DATA ATH1CS( 52) / -.7268566894 4279909533 2187668480 0 D-29     /
      DATA ATH1CS( 53) / -.2882863120 3914681355 2708987562 6 D-29     /
      DATA ATH1CS( 54) / -.1146374629 4599063504 1759166463 9 D-29     /
      DATA ATH1CS( 55) / -.4570031437 7485330581 7999168853 3 D-30     /
      DATA ATH1CS( 56) / -.1826276602 0453461048 0993402879 9 D-30     /
      DATA ATH1CS( 57) / -.7315349993 3852504691 1106635093 3 D-31     /
      DATA ATH1CS( 58) / -.2936925599 9714297816 3781577386 6 D-31     /
      DATA AM22CS(  1) / -.1562844480 6253411275 3545828583 D-1        /
      DATA AM22CS(  2) / +.7783364452 3968130701 8943100334 D-2        /
      DATA AM22CS(  3) / +.8670577704 7718952840 6072812110 D-3        /
      DATA AM22CS(  4) / +.1569662731 5611371946 9953482266 D-3        /
      DATA AM22CS(  5) / +.3563962571 4328651132 4100666302 D-4        /
      DATA AM22CS(  6) / +.9245983354 2504315449 5080090994 D-5        /
      DATA AM22CS(  7) / +.2621101618 5042238952 3194982066 D-5        /
      DATA AM22CS(  8) / +.7918822165 1601256148 9469982263 D-6        /
      DATA AM22CS(  9) / +.2510415279 2101184780 3162690862 D-6        /
      DATA AM22CS( 10) / +.8265223206 6540773447 2997712940 D-7        /
      DATA AM22CS( 11) / +.2805711662 8130526439 6384290014 D-7        /
      DATA AM22CS( 12) / +.9768210904 8468078667 4631273890 D-8        /
      DATA AM22CS( 13) / +.3474079232 2771034328 7279035573 D-8        /
      DATA AM22CS( 14) / +.1258281321 6983691421 9092738164 D-8        /
      DATA AM22CS( 15) / +.4629882606 4189526449 7330784625 D-9        /
      DATA AM22CS( 16) / +.1727282588 1360407246 8143128696 D-9        /
      DATA AM22CS( 17) / +.6523192001 3115413514 8574124970 D-10       /
      DATA AM22CS( 18) / +.2490471685 2098205601 9881087112 D-10       /
      DATA AM22CS( 19) / +.9601568205 5376594807 8189890126 D-11       /
      DATA AM22CS( 20) / +.3734480020 6772685697 4776596757 D-11       /
      DATA AM22CS( 21) / +.1464175650 3205339172 2216189678 D-11       /
      DATA AM22CS( 22) / +.5782654711 6851282547 5827881553 D-12       /
      DATA AM22CS( 23) / +.2299154072 4470611856 0254184494 D-12       /
      DATA AM22CS( 24) / +.9197807112 3199725715 0883662365 D-13       /
      DATA AM22CS( 25) / +.3700600688 1309006580 7504045556 D-13       /
      DATA AM22CS( 26) / +.1496757616 9867298782 3326345205 D-13       /
      DATA AM22CS( 27) / +.6083611949 3846114872 0451399443 D-14       /
      DATA AM22CS( 28) / +.2484040871 1512139763 5425326873 D-14       /
      DATA AM22CS( 29) / +.1018624765 2676908072 7914465339 D-14       /
      DATA AM22CS( 30) / +.4193838563 5275398942 9640310957 D-15       /
      DATA AM22CS( 31) / +.1733189017 6293075614 9702493501 D-15       /
      DATA AM22CS( 32) / +.7188219023 8850851782 0445406811 D-16       /
      DATA AM22CS( 33) / +.2991236335 9840360771 2470896113 D-16       /
      DATA AM22CS( 34) / +.1248689904 3323862785 5713110880 D-16       /
      DATA AM22CS( 35) / +.5228293446 0948366192 8651193632 D-17       /
      DATA AM22CS( 36) / +.2195329617 2471339659 5998454359 D-17       /
      DATA AM22CS( 37) / +.9242983252 2977728115 4410024332 D-18       /
      DATA AM22CS( 38) / +.3901577082 3609140782 5543197309 D-18       /
      DATA AM22CS( 39) / +.1650938926 9386370721 3759030367 D-18       /
      DATA AM22CS( 40) / +.7002218157 1599436756 5716554487 D-19       /
      DATA AM22CS( 41) / +.2976518336 1678691557 3214963506 D-19       /
      DATA AM22CS( 42) / +.1267965390 8690207257 1134261229 D-19       /
      DATA AM22CS( 43) / +.5412434006 9707762868 7581725061 D-20       /
      DATA AM22CS( 44) / +.2314873502 1815525229 6382133283 D-20       /
      DATA AM22CS( 45) / +.9919202883 8656656346 2623851167 D-21       /
      DATA AM22CS( 46) / +.4258030153 2373235715 8897608174 D-21       /
      DATA AM22CS( 47) / +.1831018429 7302450167 8402003088 D-21       /
      DATA AM22CS( 48) / +.7886787123 1107537556 4526811022 D-22       /
      DATA AM22CS( 49) / +.3402546073 8622987495 6582997235 D-22       /
      DATA AM22CS( 50) / +.1470208814 0571253079 1860892535 D-22       /
      DATA AM22CS( 51) / +.6362110183 2491695773 3348071767 D-23       /
      DATA AM22CS( 52) / +.2757070506 8098072191 9395987768 D-23       /
      DATA AM22CS( 53) / +.1196458580 9010407135 6261780457 D-23       /
      DATA AM22CS( 54) / +.5199125457 2924214798 1768210567 D-24       /
      DATA AM22CS( 55) / +.2262176748 4710447526 0575286850 D-24       /
      DATA AM22CS( 56) / +.9855261137 5443181944 8565068283 D-25       /
      DATA AM22CS( 57) / +.4298706303 3250871722 3681286187 D-25       /
      DATA AM22CS( 58) / +.1877236416 6158063982 9657670189 D-25       /
      DATA AM22CS( 59) / +.8207219417 7284213726 8801052115 D-26       /
      DATA AM22CS( 60) / +.3592146656 0461550781 2767944463 D-26       /
      DATA AM22CS( 61) / +.1573905946 1277331561 1458940587 D-26       /
      DATA AM22CS( 62) / +.6903297810 3933383496 5319153586 D-27       /
      DATA AM22CS( 63) / +.3030920790 7896853460 7859331415 D-27       /
      DATA AM22CS( 64) / +.1332049341 6048121918 5689121944 D-27       /
      DATA AM22CS( 65) / +.5859788368 5152349011 7937981442 D-28       /
      DATA AM22CS( 66) / +.2580168684 8948780633 8425080457 D-28       /
      DATA AM22CS( 67) / +.1137124336 3728366722 3632182863 D-28       /
      DATA AM22CS( 68) / +.5015925572 2606850923 6430548549 D-29       /
      DATA AM22CS( 69) / +.2214458293 9550937332 2569708484 D-29       /
      DATA AM22CS( 70) / +.9784702838 8650728998 4691416411 D-30       /
      DATA AM22CS( 71) / +.4326954149 3418017011 2000952983 D-30       /
      DATA AM22CS( 72) / +.1914972881 9399457061 2929860440 D-30       /
      DATA AM22CS( 73) / +.8481646224 0239235417 1298331562 D-31       /
      DATA AM22CS( 74) / +.3759470651 7395591994 7455052934 D-31       /
      DATA ATH2CS(  1) / +.4405273458 7187789970 6112705777 5 D-2      /
      DATA ATH2CS(  2) / -.3042919452 3184546084 8384423987 3 D-1      /
      DATA ATH2CS(  3) / -.1385653283 7717937916 0269284265 3 D-2      /
      DATA ATH2CS(  4) / -.1804443908 9549523026 7048691095 2 D-3      /
      DATA ATH2CS(  5) / -.3380847108 3273086710 5746532361 8 D-4      /
      DATA ATH2CS(  6) / -.7678183535 2290230552 5767681776 5 D-5      /
      DATA ATH2CS(  7) / -.1967839443 7160353246 9093541707 7 D-5      /
      DATA ATH2CS(  8) / -.5483727115 8777003615 8614365928 1 D-6      /
      DATA ATH2CS(  9) / -.1625461550 5326124527 1269621225 8 D-6      /
      DATA ATH2CS( 10) / -.5053049981 2688950152 7763784207 8 D-7      /
      DATA ATH2CS( 11) / -.1631580701 1240668811 8385171561 7 D-7      /
      DATA ATH2CS( 12) / -.5434204112 3485175079 6343669481 7 D-8      /
      DATA ATH2CS( 13) / -.1857398556 4099003257 6385010963 0 D-8      /
      DATA ATH2CS( 14) / -.6489512033 3261088162 1351364067 6 D-9      /
      DATA ATH2CS( 15) / -.2310594885 8009447204 8299598707 9 D-9      /
      DATA ATH2CS( 16) / -.8363282183 2044116828 1932954674 5 D-10     /
      DATA ATH2CS( 17) / -.3071196844 8901914626 6066130389 1 D-10     /
      DATA ATH2CS( 18) / -.1142367142 4327168194 0951457989 2 D-10     /
      DATA ATH2CS( 19) / -.4298116066 3458030658 2247010897 1 D-11     /
      DATA ATH2CS( 20) / -.1633898699 5967154406 0164608663 2 D-11     /
      DATA ATH2CS( 21) / -.6269328620 0166194321 2344375407 6 D-12     /
      DATA ATH2CS( 22) / -.2426052694 8162573573 5615920399 1 D-12     /
      DATA ATH2CS( 23) / -.9461198321 6240390907 4252776505 2 D-13     /
      DATA ATH2CS( 24) / -.3716060313 4115048068 4779828126 9 D-13     /
      DATA ATH2CS( 25) / -.1469155684 0975267631 7013881030 9 D-13     /
      DATA ATH2CS( 26) / -.5843694726 1409119445 5640136309 4 D-14     /
      DATA ATH2CS( 27) / -.2337502595 5919512988 3267503493 4 D-14     /
      DATA ATH2CS( 28) / -.9399231371 1714354011 6016735841 1 D-15     /
      DATA ATH2CS( 29) / -.3798014669 3728945000 7633526371 5 D-15     /
      DATA ATH2CS( 30) / -.1541731043 9849725248 8344368177 5 D-15     /
      DATA ATH2CS( 31) / -.6285287079 5353071629 2566236520 2 D-16     /
      DATA ATH2CS( 32) / -.2572731812 8114554247 5538399277 4 D-16     /
      DATA ATH2CS( 33) / -.1057098119 3540178093 4097486655 5 D-16     /
      DATA ATH2CS( 34) / -.4359080267 4026969666 9599269996 4 D-17     /
      DATA ATH2CS( 35) / -.1803634315 9599780139 5317694554 0 D-17     /
      DATA ATH2CS( 36) / -.7486838064 3805368217 1943167691 4 D-18     /
      DATA ATH2CS( 37) / -.3117261367 3476046567 9959720998 5 D-18     /
      DATA ATH2CS( 38) / -.1301687980 9277007347 9287162069 6 D-18     /
      DATA ATH2CS( 39) / -.5450527587 5195224689 7388390990 9 D-19     /
      DATA ATH2CS( 40) / -.2288293490 1142318722 6863593190 3 D-19     /
      DATA ATH2CS( 41) / -.9631059503 8295386556 5506044008 8 D-20     /
      DATA ATH2CS( 42) / -.4063281001 5246140890 9219541643 4 D-20     /
      DATA ATH2CS( 43) / -.1718203980 9080267639 0041385851 0 D-20     /
      DATA ATH2CS( 44) / -.7281574619 8925363674 1532247332 8 D-21     /
      DATA ATH2CS( 45) / -.3092352652 6806431279 6068034579 0 D-21     /
      DATA ATH2CS( 46) / -.1315917855 9654404903 8341702325 4 D-21     /
      DATA ATH2CS( 47) / -.5610606786 0870555126 6490741266 8 D-22     /
      DATA ATH2CS( 48) / -.2396621894 0863552060 2030433789 5 D-22     /
      DATA ATH2CS( 49) / -.1025574332 3905812008 3295442392 4 D-22     /
      DATA ATH2CS( 50) / -.4396264138 1436564764 0360732366 3 D-23     /
      DATA ATH2CS( 51) / -.1887652998 3725773733 4250871945 0 D-23     /
      DATA ATH2CS( 52) / -.8118140359 5768076035 7943323044 5 D-24     /
      DATA ATH2CS( 53) / -.3496734274 3662868563 7595208921 4 D-24     /
      DATA ATH2CS( 54) / -.1508402925 1568732151 7175147586 7 D-24     /
      DATA ATH2CS( 55) / -.6516268284 7786710597 8777383434 1 D-25     /
      DATA ATH2CS( 56) / -.2818945797 5292074245 0594211458 3 D-25     /
      DATA ATH2CS( 57) / -.1221127596 5122627445 9809446450 5 D-25     /
      DATA ATH2CS( 58) / -.5296674341 1698671686 2001170507 3 D-26     /
      DATA ATH2CS( 59) / -.2300359270 7736734313 5887097174 4 D-26     /
      DATA ATH2CS( 60) / -.1000279482 3553674947 8122034893 0 D-26     /
      DATA ATH2CS( 61) / -.4354760404 1808793948 0689316217 9 D-27     /
      DATA ATH2CS( 62) / -.1898056134 7414775225 1548282703 0 D-27     /
      DATA ATH2CS( 63) / -.8282111868 7129746975 5400930931 5 D-28     /
      DATA ATH2CS( 64) / -.3617815493 0665690065 8621348437 4 D-28     /
      DATA ATH2CS( 65) / -.1582018896 1780036548 5894184363 6 D-28     /
      DATA ATH2CS( 66) / -.6925068597 8022700117 7282038324 7 D-29     /
      DATA ATH2CS( 67) / -.3034390239 7786291289 0862972733 5 D-29     /
      DATA ATH2CS( 68) / -.1330889568 1667252247 6197744650 9 D-29     /
      DATA ATH2CS( 69) / -.5842848522 1730901204 8760697170 6 D-30     /
      DATA ATH2CS( 70) / -.2567488423 2383026311 2127435767 8 D-30     /
      DATA ATH2CS( 71) / -.1129232322 2688821857 9150581915 1 D-30     /
      DATA ATH2CS( 72) / -.4970947029 7533369165 5057010502 3 D-31     /
      DATA PI4 / 0.7853981633 9744830961 5660845819 88D0 /
      DATA FIRST /.TRUE./
C***FIRST EXECUTABLE STATEMENT  D9AIMP
      IF (FIRST) THEN
         ETA = 0.1*REAL(D1MACH(3))
         NAM20 = INITDS (AM20CS, 57, ETA)
         NATH0 = INITDS (ATH0CS, 53, ETA)
         NAM21 = INITDS (AM21CS, 60, ETA)
         NATH1 = INITDS (ATH1CS, 58, ETA)
         NAM22 = INITDS (AM22CS, 74, ETA)
         NATH2 = INITDS (ATH2CS, 72, ETA)
C
         XSML = -1.0D0/D1MACH(3)**0.3333D0
      ENDIF
      FIRST = .FALSE.
C
      IF (X.GE.(-4.0D0)) GO TO 20
      Z = 1.0D0
      IF (X.GT.XSML) Z = 128.D0/X**3 + 1.0D0
      AMPL = 0.3125D0 + DCSEVL (Z, AM20CS, NAM20)
      THETA = -0.625D0 + DCSEVL (Z, ATH0CS, NATH0)
      GO TO 40
C
 20   IF (X.GE.(-2.0D0)) GO TO 30
      Z = (128.D0/X**3 + 9.0D0)/7.0D0
      AMPL = 0.3125D0 + DCSEVL (Z, AM21CS, NAM21)
      THETA = -0.625D0 + DCSEVL (Z, ATH1CS, NATH1)
      GO TO 40
C
 30   IF (X .GE. (-1.0D0)) CALL XERMSG ('SLATEC', 'D9AIMP',
     +   'X MUST BE LE -1.0', 1, 2)
C
      Z = (16.D0/X**3 + 9.0D0)/7.0D0
      AMPL = 0.3125D0 + DCSEVL (Z, AM22CS, NAM22)
      THETA = -0.625D0 + DCSEVL (Z, ATH2CS, NATH2)
C
 40   SQRTX = SQRT(-X)
      AMPL = SQRT(AMPL/SQRTX)
      THETA = PI4 - X*SQRTX*THETA
C
      RETURN
      END
