*DECK DE1
      DOUBLE PRECISION FUNCTION DE1 (X)
C***BEGIN PROLOGUE  DE1
C***PURPOSE  Compute the exponential integral E1(X).
C***LIBRARY   SLATEC (FNLIB)
C***CATEGORY  C5
C***TYPE      DOUBLE PRECISION (E1-S, DE1-D)
C***KEYWORDS  E1 FUNCTION, EXPONENTIAL INTEGRAL, FNLIB,
C             SPECIAL FUNCTIONS
C***AUTHOR  Fullerton, W., (LANL)
C***DESCRIPTION
C
C DE1 calculates the double precision exponential integral, E1(X), for
C positive double precision argument X and the Cauchy principal value
C for negative X.  If principal values are used everywhere, then, for
C all X,
C
C    E1(X) = -Ei(-X)
C or
C    Ei(X) = -E1(-X).
C
C
C Series for AE10       on the interval -3.12500E-02 to  0.
C                                        with weighted error   4.62E-32
C                                         log weighted error  31.34
C                               significant figures required  29.70
C                                    decimal places required  32.18
C
C
C Series for AE11       on the interval -1.25000E-01 to -3.12500E-02
C                                        with weighted error   2.22E-32
C                                         log weighted error  31.65
C                               significant figures required  30.75
C                                    decimal places required  32.54
C
C
C Series for AE12       on the interval -2.50000E-01 to -1.25000E-01
C                                        with weighted error   5.19E-32
C                                         log weighted error  31.28
C                               significant figures required  30.82
C                                    decimal places required  32.09
C
C
C Series for E11        on the interval -4.00000E+00 to -1.00000E+00
C                                        with weighted error   8.49E-34
C                                         log weighted error  33.07
C                               significant figures required  34.13
C                                    decimal places required  33.80
C
C
C Series for E12        on the interval -1.00000E+00 to  1.00000E+00
C                                        with weighted error   8.08E-33
C                                         log weighted error  32.09
C                        approx significant figures required  30.4
C                                    decimal places required  32.79
C
C
C Series for AE13       on the interval  2.50000E-01 to  1.00000E+00
C                                        with weighted error   6.65E-32
C                                         log weighted error  31.18
C                               significant figures required  30.69
C                                    decimal places required  32.03
C
C
C Series for AE14       on the interval  0.          to  2.50000E-01
C                                        with weighted error   5.07E-32
C                                         log weighted error  31.30
C                               significant figures required  30.40
C                                    decimal places required  32.20
C
C***REFERENCES  (NONE)
C***ROUTINES CALLED  D1MACH, DCSEVL, INITDS, XERMSG
C***REVISION HISTORY  (YYMMDD)
C   770701  DATE WRITTEN
C   890531  Changed all specific intrinsics to generic.  (WRB)
C   891115  Modified prologue description.  (WRB)
C   891115  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900315  CALLs to XERROR changed to CALLs to XERMSG.  (THJ)
C   920618  Removed space from variable names.  (RWC, WRB)
C***END PROLOGUE  DE1
      integer initds
      integer ntae10, ntae11, ntae12, nte11, nte12, ntae13, ntae14
      DOUBLE PRECISION X, AE10CS(50), AE11CS(60), AE12CS(41), E11CS(29),
     1  E12CS(25), AE13CS(50), AE14CS(64), XMAX, XMAXT, D1MACH, DCSEVL
      real eta
      LOGICAL FIRST
      external d1mach, dcsevl, initds, xermsg
      intrinsic real, log, exp, abs
      SAVE AE10CS, AE11CS, AE12CS, E11CS, E12CS, AE13CS, AE14CS,
     1 NTAE10, NTAE11, NTAE12, NTE11, NTE12, NTAE13, NTAE14, XMAX,
     2 FIRST
      DATA AE10CS(  1) / +.3284394579 6166990878 7384420188 1 D-1      /
      DATA AE10CS(  2) / -.1669920452 0313628514 7618434338 7 D-1      /
      DATA AE10CS(  3) / +.2845284724 3613468074 2489985325 2 D-3      /
      DATA AE10CS(  4) / -.7563944358 5162064894 8786693853 3 D-5      /
      DATA AE10CS(  5) / +.2798971289 4508591575 0484318087 9 D-6      /
      DATA AE10CS(  6) / -.1357901828 5345310695 2556392625 5 D-7      /
      DATA AE10CS(  7) / +.8343596202 0404692558 5610290490 6 D-9      /
      DATA AE10CS(  8) / -.6370971727 6402484382 7524298853 2 D-10     /
      DATA AE10CS(  9) / +.6007247608 8118612357 6083156158 4 D-11     /
      DATA AE10CS( 10) / -.7022876174 6797735907 5062615008 8 D-12     /
      DATA AE10CS( 11) / +.1018302673 7036876930 9665234688 3 D-12     /
      DATA AE10CS( 12) / -.1761812903 4308800404 0630996642 2 D-13     /
      DATA AE10CS( 13) / +.3250828614 2353606942 4403035387 7 D-14     /
      DATA AE10CS( 14) / -.5071770025 5058186788 2487225904 4 D-15     /
      DATA AE10CS( 15) / +.1665177387 0432942981 7248608415 6 D-16     /
      DATA AE10CS( 16) / +.3166753890 7975144006 7700353655 5 D-16     /
      DATA AE10CS( 17) / -.1588403763 6641415151 3311834353 8 D-16     /
      DATA AE10CS( 18) / +.4175513256 1380188330 0303461848 4 D-17     /
      DATA AE10CS( 19) / -.2892347749 7071419067 1071447885 2 D-18     /
      DATA AE10CS( 20) / -.2800625903 3966081035 0634058966 9 D-18     /
      DATA AE10CS( 21) / +.1322938639 5392709037 0758002378 1 D-18     /
      DATA AE10CS( 22) / -.1804447444 1773016272 8388783355 7 D-19     /
      DATA AE10CS( 23) / -.7905384086 5226160762 9164481760 4 D-20     /
      DATA AE10CS( 24) / +.4435711366 3695701039 4623583802 7 D-20     /
      DATA AE10CS( 25) / -.4264103994 9781208688 6530920655 5 D-21     /
      DATA AE10CS( 26) / -.3920101766 9371175415 5371316204 8 D-21     /
      DATA AE10CS( 27) / +.1527378051 3439942663 4375232697 1 D-21     /
      DATA AE10CS( 28) / +.1024849527 0493723393 1030878311 7 D-22     /
      DATA AE10CS( 29) / -.2134907874 7714335762 6271140588 2 D-22     /
      DATA AE10CS( 30) / +.3239139475 1600282670 6169470036 6 D-23     /
      DATA AE10CS( 31) / +.2142183762 2998899547 6264316829 6 D-23     /
      DATA AE10CS( 32) / -.8234609419 6010184147 0034808231 2 D-24     /
      DATA AE10CS( 33) / -.1524652829 6458094796 1369440114 0 D-24     /
      DATA AE10CS( 34) / +.1378208282 4606391346 6848036432 5 D-24     /
      DATA AE10CS( 35) / +.2131311202 8339478795 2322499925 3 D-26     /
      DATA AE10CS( 36) / -.2012649651 5264841218 1746676312 7 D-25     /
      DATA AE10CS( 37) / +.1995535662 2633580161 0631178267 3 D-26     /
      DATA AE10CS( 38) / +.2798995808 9840034649 4868652031 9 D-26     /
      DATA AE10CS( 39) / -.5534511845 3896266376 4081927782 3 D-27     /
      DATA AE10CS( 40) / -.3884995396 1599688616 8254402614 6 D-27     /
      DATA AE10CS( 41) / +.1121304434 5073593828 5068035467 9 D-27     /
      DATA AE10CS( 42) / +.5566568152 4237409482 5656383351 4 D-28     /
      DATA AE10CS( 43) / -.2045482929 8104997004 4853393817 6 D-28     /
      DATA AE10CS( 44) / -.8453813992 7123362334 1145749367 4 D-29     /
      DATA AE10CS( 45) / +.3565758433 4312915628 1611111628 7 D-29     /
      DATA AE10CS( 46) / +.1383653872 1256347055 3994909887 1 D-29     /
      DATA AE10CS( 47) / -.6062167864 4513724365 8453376477 8 D-30     /
      DATA AE10CS( 48) / -.2447198043 9893132674 3765511918 9 D-30     /
      DATA AE10CS( 49) / +.1006850640 9339983480 1154818048 0 D-30     /
      DATA AE10CS( 50) / +.4623685555 0148690156 6434146167 4 D-31     /
      DATA AE11CS(  1) / +.2026315064 7078889499 4012365173 81 D+0     /
      DATA AE11CS(  2) / -.7365514099 1203130439 5368987280 34 D-1     /
      DATA AE11CS(  3) / +.6390934911 8361915862 7532838400 20 D-2     /
      DATA AE11CS(  4) / -.6079725270 5247911780 6531533639 99 D-3     /
      DATA AE11CS(  5) / -.7370649862 0176629330 6814114934 84 D-4     /
      DATA AE11CS(  6) / +.4873285744 9450183453 4649924880 76 D-4     /
      DATA AE11CS(  7) / -.2383706484 0448290766 5884894602 35 D-5     /
      DATA AE11CS(  8) / -.3051861262 8561521027 0273322461 21 D-5     /
      DATA AE11CS(  9) / +.1705033157 2564559009 6880329929 07 D-6     /
      DATA AE11CS( 10) / +.2383420452 7487747258 6015981364 03 D-6     /
      DATA AE11CS( 11) / +.1078177255 6163166562 5968723640 20 D-7     /
      DATA AE11CS( 12) / -.1795569284 7399102653 6426914465 99 D-7     /
      DATA AE11CS( 13) / -.4128407234 1950457727 9123946404 36 D-8     /
      DATA AE11CS( 14) / +.6862214858 8631968618 3468445266 64 D-9     /
      DATA AE11CS( 15) / +.5313018312 0506356147 6020096759 61 D-9     /
      DATA AE11CS( 16) / +.7879688026 1490694831 3050228935 15 D-10    /
      DATA AE11CS( 17) / -.2626176232 9356522290 3416752712 32 D-10    /
      DATA AE11CS( 18) / -.1548368763 6308261963 1257562941 00 D-10    /
      DATA AE11CS( 19) / -.2581896237 7261390492 8024051225 91 D-11    /
      DATA AE11CS( 20) / +.5954287919 1591072658 9035299593 52 D-12    /
      DATA AE11CS( 21) / +.4645140038 7681525833 7849193214 05 D-12    /
      DATA AE11CS( 22) / +.1155785502 3255861496 2880062037 31 D-12    /
      DATA AE11CS( 23) / -.1047523687 0835799012 3175471896 70 D-14    /
      DATA AE11CS( 24) / -.1189665350 2709004368 1044892609 29 D-13    /
      DATA AE11CS( 25) / -.4774907749 0261778752 6430193499 50 D-14    /
      DATA AE11CS( 26) / -.8107764961 5772777976 2497347541 35 D-15    /
      DATA AE11CS( 27) / +.1343556925 0031554199 3769879981 78 D-15    /
      DATA AE11CS( 28) / +.1413453002 2913106260 2488738812 87 D-15    /
      DATA AE11CS( 29) / +.4945159257 3953173115 5206632328 83 D-16    /
      DATA AE11CS( 30) / +.7988404848 0080665648 8585873993 67 D-17    /
      DATA AE11CS( 31) / -.1400863218 8089809829 2487119353 93 D-17    /
      DATA AE11CS( 32) / -.1481424695 8417372107 7228040016 80 D-17    /
      DATA AE11CS( 33) / -.5582617364 6025601904 0106939371 13 D-18    /
      DATA AE11CS( 34) / -.1144207454 2191647264 7830725445 98 D-18    /
      DATA AE11CS( 35) / +.2537182387 9566853500 5240184799 23 D-20    /
      DATA AE11CS( 36) / +.1320532815 4805359813 2788633890 97 D-19    /
      DATA AE11CS( 37) / +.6293026108 1586809166 2874267894 85 D-20    /
      DATA AE11CS( 38) / +.1768827042 4882713734 9992613325 48 D-20    /
      DATA AE11CS( 39) / +.2326618798 5146045209 6742968874 32 D-21    /
      DATA AE11CS( 40) / -.6780306081 1125233043 7738318441 13 D-22    /
      DATA AE11CS( 41) / -.5944087695 9676373802 8741505318 91 D-22    /
      DATA AE11CS( 42) / -.2361821453 1184415968 5325925034 66 D-22    /
      DATA AE11CS( 43) / -.6021449972 4601478214 1684787445 76 D-23    /
      DATA AE11CS( 44) / -.6551790647 4348299071 3704441446 39 D-24    /
      DATA AE11CS( 45) / +.2938875529 7497724587 0420386993 49 D-24    /
      DATA AE11CS( 46) / +.2260160620 0642115173 2157287585 10 D-24    /
      DATA AE11CS( 47) / +.8953436924 5958628745 0912068730 87 D-25    /
      DATA AE11CS( 48) / +.2401592347 1098457555 7720674577 06 D-25    /
      DATA AE11CS( 49) / +.3411837688 8907172955 6664230434 13 D-26    /
      DATA AE11CS( 50) / -.7161707169 4630342052 3550133452 79 D-27    /
      DATA AE11CS( 51) / -.7562039065 9281725157 9286519807 99 D-27    /
      DATA AE11CS( 52) / -.3377461215 7467324637 9529207808 00 D-27    /
      DATA AE11CS( 53) / -.1047932570 3300941711 5264303322 45 D-27    /
      DATA AE11CS( 54) / -.2165455025 2170342240 8548802013 86 D-28    /
      DATA AE11CS( 55) / -.7529712574 5288269994 6892984320 00 D-30    /
      DATA AE11CS( 56) / +.1910317939 2798935768 6380840004 26 D-29    /
      DATA AE11CS( 57) / +.1149210496 6530338547 7907288337 06 D-29    /
      DATA AE11CS( 58) / +.4389697058 2661751514 4103591936 00 D-30    /
      DATA AE11CS( 59) / +.1232088323 9205686471 6471577258 66 D-30    /
      DATA AE11CS( 60) / +.2222017445 7553175317 5385811626 66 D-31    /
      DATA AE12CS(  1) / +.6362958979 6747038767 1298878068 03 D+0     /
      DATA AE12CS(  2) / -.1308116867 5067634385 8126711211 35 D+0     /
      DATA AE12CS(  3) / -.8436741021 3053930014 4876621297 52 D-2     /
      DATA AE12CS(  4) / +.2656849153 1006685413 0294280689 06 D-2     /
      DATA AE12CS(  5) / +.3282272178 1658133778 7921701425 17 D-3     /
      DATA AE12CS(  6) / -.2378344777 1430248269 5798078510 50 D-4     /
      DATA AE12CS(  7) / -.1143980430 8100055514 4470767970 47 D-4     /
      DATA AE12CS(  8) / -.1440594343 3238338455 2397176993 23 D-5     /
      DATA AE12CS(  9) / +.5241595665 1148829963 7728180616 64 D-8     /
      DATA AE12CS( 10) / +.3840730640 7844323480 9792030597 16 D-7     /
      DATA AE12CS( 11) / +.8588024486 0267195879 6605157593 44 D-8     /
      DATA AE12CS( 12) / +.1021922662 5855003286 3399695539 11 D-8     /
      DATA AE12CS( 13) / +.2174913232 3289724542 8213398059 92 D-10    /
      DATA AE12CS( 14) / -.2209023814 2623144809 5235038117 41 D-10    /
      DATA AE12CS( 15) / -.6345753354 4928753294 3836222088 01 D-11    /
      DATA AE12CS( 16) / -.1083774656 6857661115 3405397329 19 D-11    /
      DATA AE12CS( 17) / -.1190982287 2222586730 2622004402 77 D-12    /
      DATA AE12CS( 18) / -.2843868238 9265590299 5087660086 61 D-14    /
      DATA AE12CS( 19) / +.2508032702 6686769668 5871954875 46 D-14    /
      DATA AE12CS( 20) / +.7872964152 8559842431 5977264212 65 D-15    /
      DATA AE12CS( 21) / +.1547506634 7785217148 4843346373 29 D-15    /
      DATA AE12CS( 22) / +.2257532283 1665075055 2726081972 90 D-16    /
      DATA AE12CS( 23) / +.2223335286 7266608760 2813808366 93 D-17    /
      DATA AE12CS( 24) / +.1696781956 3544153513 4641946623 99 D-19    /
      DATA AE12CS( 25) / -.5760831625 5947682105 3100873045 33 D-19    /
      DATA AE12CS( 26) / -.1759123577 4646878055 6253694088 53 D-19    /
      DATA AE12CS( 27) / -.3628605637 5103174394 7553286826 66 D-20    /
      DATA AE12CS( 28) / -.5923556979 7328991652 5581434880 00 D-21    /
      DATA AE12CS( 29) / -.7603038092 6310191114 4291368959 99 D-22    /
      DATA AE12CS( 30) / -.6254784352 1711763842 6414284799 99 D-23    /
      DATA AE12CS( 31) / +.2548336075 9307648606 0376064000 00 D-24    /
      DATA AE12CS( 32) / +.2559861573 1739857020 1688746666 66 D-24    /
      DATA AE12CS( 33) / +.7137623935 7899318800 2070528000 00 D-25    /
      DATA AE12CS( 34) / +.1470375993 9567568181 5789568000 00 D-25    /
      DATA AE12CS( 35) / +.2510552476 5386733555 1986346666 66 D-26    /
      DATA AE12CS( 36) / +.3588666638 7790890886 5836373333 33 D-27    /
      DATA AE12CS( 37) / +.3988603515 6771301763 3177599999 99 D-28    /
      DATA AE12CS( 38) / +.2176367694 7356220478 8053333333 33 D-29    /
      DATA AE12CS( 39) / -.4614699848 7618942367 6074666666 66 D-30    /
      DATA AE12CS( 40) / -.2071351787 7481987707 1530666666 66 D-30    /
      DATA AE12CS( 41) / -.5189037856 3534371596 9706666666 66 D-31    /
      DATA E11CS(  1) / -.1611346165 5571494025 7206639275 66180 D+2  /
      DATA E11CS(  2) / +.7794072778 7426802769 2722458917 41497 D+1  /
      DATA E11CS(  3) / -.1955405818 8631419507 1272838128 14491 D+1  /
      DATA E11CS(  4) / +.3733729386 6277945611 5171908656 90209 D+0  /
      DATA E11CS(  5) / -.5692503191 0929019385 2638922200 51166 D-1  /
      DATA E11CS(  6) / +.7211077769 6600918537 8477248126 35813 D-2  /
      DATA E11CS(  7) / -.7810490144 9841593997 7151840890 64148 D-3  /
      DATA E11CS(  8) / +.7388093356 2621681878 9748813661 77858 D-4  /
      DATA E11CS(  9) / -.6202861875 8082045134 3581336079 09712 D-5  /
      DATA E11CS( 10) / +.4681600230 3176735524 4058238683 62657 D-6  /
      DATA E11CS( 11) / -.3209288853 3298649524 0725530272 28719 D-7  /
      DATA E11CS( 12) / +.2015199748 7404533394 8262622130 19548 D-8  /
      DATA E11CS( 13) / -.1167368681 6697793105 3562716950 15419 D-9  /
      DATA E11CS( 14) / +.6276270667 2039943397 7887483796 15573 D-11 /
      DATA E11CS( 15) / -.3148154167 2275441045 2467818023 93600 D-12 /
      DATA E11CS( 16) / +.1479904174 4493474210 8944722517 33333 D-13 /
      DATA E11CS( 17) / -.6545709158 3979673774 2634015880 53333 D-15 /
      DATA E11CS( 18) / +.2733687222 3137291142 5080127487 99999 D-16 /
      DATA E11CS( 19) / -.1081352434 9754406876 7217276245 33333 D-17 /
      DATA E11CS( 20) / +.4062832804 0434303295 3003485866 66666 D-19 /
      DATA E11CS( 21) / -.1453553935 8960455858 9143722666 66666 D-20 /
      DATA E11CS( 22) / +.4963274618 1648636830 1984426666 66666 D-22 /
      DATA E11CS( 23) / -.1620861269 6636044604 8665600000 00000 D-23 /
      DATA E11CS( 24) / +.5072144803 8607422226 4319999999 99999 D-25 /
      DATA E11CS( 25) / -.1523581113 3372207813 9733333333 33333 D-26 /
      DATA E11CS( 26) / +.4400151125 6103618696 5333333333 33333 D-28 /
      DATA E11CS( 27) / -.1223614194 5416231594 6666666666 66666 D-29 /
      DATA E11CS( 28) / +.3280921666 1066001066 6666666666 66666 D-31 /
      DATA E11CS( 29) / -.8493345226 8306432000 0000000000 00000 D-33 /
      DATA E12CS(  1) / -.3739021479 22027951166 869820482 7 D-1      /
      DATA E12CS(  2) / +.4272398606 2209577260 4917917652 8 D-1      /
      DATA E12CS(  3) / -.1303182079 8497005441 5392055219 726 D+0    /
      DATA E12CS(  4) / +.1441912402 4698890734 1095893982 137 D-1    /
      DATA E12CS(  5) / -.1346170780 5106802211 6121527983 553 D-2    /
      DATA E12CS(  6) / +.1073102925 3063779997 6115850970 073 D-3    /
      DATA E12CS(  7) / -.7429999516 1194364961 0283062223 163 D-5    /
      DATA E12CS(  8) / +.4537732569 0753713938 6383211511 827 D-6    /
      DATA E12CS(  9) / -.2476417211 3906013184 6547423802 912 D-7    /
      DATA E12CS( 10) / +.1220765813 7459095370 0228167846 102 D-8    /
      DATA E12CS( 11) / -.5485141480 6409239382 1357398028 261 D-10   /
      DATA E12CS( 12) / +.2263621421 3007879929 3688162377 002 D-11   /
      DATA E12CS( 13) / -.8635897271 6980097940 4172916282 240 D-13   /
      DATA E12CS( 14) / +.3062915536 6933299758 1032894881 279 D-14   /
      DATA E12CS( 15) / -.1014857188 5594414755 7128906734 933 D-15   /
      DATA E12CS( 16) / +.3154821740 3406987754 6855328426 666 D-17   /
      DATA E12CS( 17) / -.9236042407 6924095448 4015923200 000 D-19   /
      DATA E12CS( 18) / +.2555042679 7081400244 0435029333 333 D-20   /
      DATA E12CS( 19) / -.6699128056 8456684721 7882453333 333 D-22   /
      DATA E12CS( 20) / +.1669254054 3538731943 1987199999 999 D-23   /
      DATA E12CS( 21) / -.3962549251 8437964185 6000000000 000 D-25   /
      DATA E12CS( 22) / +.8981358965 9851133201 0666666666 666 D-27   /
      DATA E12CS( 23) / -.1947633669 9301643332 2666666666 666 D-28   /
      DATA E12CS( 24) / +.4048360190 2463003306 6666666666 666 D-30   /
      DATA E12CS( 25) / -.8079815676 9984512000 0000000000 000 D-32   /
      DATA AE13CS(  1) / -.6057732466 4060345999 3193827377 47 D+0     /
      DATA AE13CS(  2) / -.1125352434 8366090030 6497688527 18 D+0     /
      DATA AE13CS(  3) / +.1343226624 7902779492 4878593294 14 D-1     /
      DATA AE13CS(  4) / -.1926845187 3811457249 2468389913 03 D-2     /
      DATA AE13CS(  5) / +.3091183377 2060318335 5867374753 68 D-3     /
      DATA AE13CS(  6) / -.5356413212 9618418776 3935597951 47 D-4     /
      DATA AE13CS(  7) / +.9827812880 2474923952 4918827172 37 D-5     /
      DATA AE13CS(  8) / -.1885368984 9165182826 9028919389 10 D-5     /
      DATA AE13CS(  9) / +.3749431935 6894735406 9640421905 31 D-6     /
      DATA AE13CS( 10) / -.7682345587 0552639273 7334656805 56 D-7     /
      DATA AE13CS( 11) / +.1614327056 7198777552 9563000608 68 D-7     /
      DATA AE13CS( 12) / -.3466802211 4907354566 3090602260 27 D-8     /
      DATA AE13CS( 13) / +.7587542091 9036277572 8897470541 14 D-9     /
      DATA AE13CS( 14) / -.1688643332 9881412573 5145266367 03 D-9     /
      DATA AE13CS( 15) / +.3814570674 9552265682 8042509272 72 D-10    /
      DATA AE13CS( 16) / -.8733026632 4446292706 8517182723 34 D-11    /
      DATA AE13CS( 17) / +.2023672864 5867960961 7943110643 30 D-11    /
      DATA AE13CS( 18) / -.4741328303 9555834655 2103408201 60 D-12    /
      DATA AE13CS( 19) / +.1122117204 8389864324 7317999289 20 D-12    /
      DATA AE13CS( 20) / -.2680422543 4840309912 8268090933 95 D-13    /
      DATA AE13CS( 21) / +.6457851441 7716530343 5803690672 12 D-14    /
      DATA AE13CS( 22) / -.1568276050 1666478830 3057028491 94 D-14    /
      DATA AE13CS( 23) / +.3836786539 9315404861 8215164414 08 D-15    /
      DATA AE13CS( 24) / -.9451717302 7579130478 8710489325 56 D-16    /
      DATA AE13CS( 25) / +.2343481228 8949573293 8966664391 33 D-16    /
      DATA AE13CS( 26) / -.5845866158 0214714576 1231944198 82 D-17    /
      DATA AE13CS( 27) / +.1466622986 7947778605 8736174191 95 D-17    /
      DATA AE13CS( 28) / -.3699392347 6444472706 5925382744 74 D-18    /
      DATA AE13CS( 29) / +.9379015993 6721242136 0142918178 13 D-19    /
      DATA AE13CS( 30) / -.2389367322 1937873136 3082240873 81 D-19    /
      DATA AE13CS( 31) / +.6115062462 9497608051 9342238378 66 D-20    /
      DATA AE13CS( 32) / -.1571858532 7554025507 7198532881 06 D-20    /
      DATA AE13CS( 33) / +.4057238728 5585397769 5192944913 06 D-21    /
      DATA AE13CS( 34) / -.1051402655 4738034990 5663671227 73 D-21    /
      DATA AE13CS( 35) / +.2734966493 0638667785 8060031317 33 D-22    /
      DATA AE13CS( 36) / -.7140160408 0205796099 3555742719 99 D-23    /
      DATA AE13CS( 37) / +.1870555243 2235079986 7569242111 99 D-23    /
      DATA AE13CS( 38) / -.4916746816 6870480520 4780209493 33 D-24    /
      DATA AE13CS( 39) / +.1296498811 9684031730 9160871253 33 D-24    /
      DATA AE13CS( 40) / -.3429251568 8362864461 6239404373 33 D-25    /
      DATA AE13CS( 41) / +.9097224164 3887034329 1048209066 66 D-26    /
      DATA AE13CS( 42) / -.2420211231 4316856489 9348479999 99 D-26    /
      DATA AE13CS( 43) / +.6456361293 4639510757 6704750933 33 D-27    /
      DATA AE13CS( 44) / -.1726913273 5340541122 3159876266 66 D-27    /
      DATA AE13CS( 45) / +.4630861165 9151500715 1942314666 66 D-28    /
      DATA AE13CS( 46) / -.1244870363 7214131241 7551701333 33 D-28    /
      DATA AE13CS( 47) / +.3354457409 0520678532 9070079999 99 D-29    /
      DATA AE13CS( 48) / -.9059886852 1070774437 5439359999 99 D-30    /
      DATA AE13CS( 49) / +.2452414705 1474238587 2732160000 00 D-30    /
      DATA AE13CS( 50) / -.6652817873 3552062817 1079679999 99 D-31    /
      DATA AE14CS(  1) / -.1892918000 7530168254 9567994282 0 D+0      /
      DATA AE14CS(  2) / -.8648117855 2598714899 6881705682 4 D-1      /
      DATA AE14CS(  3) / +.7224101543 7465947470 2151483918 4 D-2      /
      DATA AE14CS(  4) / -.8097559457 5573861971 5965561018 1 D-3      /
      DATA AE14CS(  5) / +.1099913443 2661388671 7925115700 2 D-3      /
      DATA AE14CS(  6) / -.1717332998 9377673714 9535881448 7 D-4      /
      DATA AE14CS(  7) / +.2985627514 4792833228 2534249500 3 D-5      /
      DATA AE14CS(  8) / -.5659649145 7719300565 6016726715 5 D-6      /
      DATA AE14CS(  9) / +.1152680839 7141400192 2658350166 3 D-6      /
      DATA AE14CS( 10) / -.2495030440 2693382288 4212876506 5 D-7      /
      DATA AE14CS( 11) / +.5692324201 8337543670 3937036814 0 D-8      /
      DATA AE14CS( 12) / -.1359957664 8056003384 9003093917 6 D-8      /
      DATA AE14CS( 13) / +.3384662888 7608845901 8451292585 9 D-9      /
      DATA AE14CS( 14) / -.8737853904 4746819523 5084931658 0 D-10     /
      DATA AE14CS( 15) / +.2331588663 2226597186 1261340047 0 D-10     /
      DATA AE14CS( 16) / -.6411481049 2137859697 5316519632 6 D-11     /
      DATA AE14CS( 17) / +.1812246980 2048164333 8435948468 2 D-11     /
      DATA AE14CS( 18) / -.5253831761 5584606888 1940384046 6 D-12     /
      DATA AE14CS( 19) / +.1559218272 5919256988 5502860982 5 D-12     /
      DATA AE14CS( 20) / -.4729168297 0803987184 7642936946 6 D-13     /
      DATA AE14CS( 21) / +.1463761864 3932435020 7619949380 8 D-13     /
      DATA AE14CS( 22) / -.4617388988 7129241022 3217362360 4 D-14     /
      DATA AE14CS( 23) / +.1482710348 2893693237 8923966037 1 D-14     /
      DATA AE14CS( 24) / -.4841672496 2392291469 7316573441 7 D-15     /
      DATA AE14CS( 25) / +.1606215575 7002904081 1657196618 8 D-15     /
      DATA AE14CS( 26) / -.5408917538 9571709478 9502378425 2 D-16     /
      DATA AE14CS( 27) / +.1847470159 3468978813 7023140231 0 D-16     /
      DATA AE14CS( 28) / -.6395830792 7590944705 0061042505 0 D-17     /
      DATA AE14CS( 29) / +.2242780721 6997594572 5023327617 0 D-17     /
      DATA AE14CS( 30) / -.7961369173 9839475527 4455530864 6 D-18     /
      DATA AE14CS( 31) / +.2859308111 5401974598 0861992927 2 D-18     /
      DATA AE14CS( 32) / -.1038450244 7011371459 0069713744 6 D-18     /
      DATA AE14CS( 33) / +.3812040607 0979757808 6684100831 9 D-19     /
      DATA AE14CS( 34) / -.1413795417 7172007687 1756272369 6 D-19     /
      DATA AE14CS( 35) / +.5295367865 1827409583 0544259481 5 D-20     /
      DATA AE14CS( 36) / -.2002264245 0268259021 3721113143 9 D-20     /
      DATA AE14CS( 37) / +.7640262751 2751960147 3684861091 8 D-21     /
      DATA AE14CS( 38) / -.2941119006 8687878833 1126352336 2 D-21     /
      DATA AE14CS( 39) / +.1141823539 0789271930 3769148358 6 D-21     /
      DATA AE14CS( 40) / -.4469308475 9552984252 4702071848 9 D-22     /
      DATA AE14CS( 41) / +.1763262410 5717507706 3049140852 0 D-22     /
      DATA AE14CS( 42) / -.7009968187 9259023563 5151826234 0 D-23     /
      DATA AE14CS( 43) / +.2807573556 5583789222 8775750751 5 D-23     /
      DATA AE14CS( 44) / -.1132560944 9810864321 4188889156 2 D-23     /
      DATA AE14CS( 45) / +.4600574684 3750179461 5676423372 7 D-24     /
      DATA AE14CS( 46) / -.1881448598 9761334598 6460914810 8 D-24     /
      DATA AE14CS( 47) / +.7744916111 5077308454 4432847803 7 D-25     /
      DATA AE14CS( 48) / -.3208512760 5853689267 0270382626 1 D-25     /
      DATA AE14CS( 49) / +.1337445542 9108397606 1993042138 4 D-25     /
      DATA AE14CS( 50) / -.5608671881 8022170488 9477173521 0 D-26     /
      DATA AE14CS( 51) / +.2365839716 5285374837 1006947327 9 D-26     /
      DATA AE14CS( 52) / -.1003656195 0253053340 6583452685 6 D-26     /
      DATA AE14CS( 53) / +.4281490878 0941611312 8664255692 7 D-27     /
      DATA AE14CS( 54) / -.1836345261 8153181996 9132695825 0 D-27     /
      DATA AE14CS( 55) / +.7917798231 3495400000 9746867814 4 D-28     /
      DATA AE14CS( 56) / -.3431542358 7422203610 2501577523 1 D-28     /
      DATA AE14CS( 57) / +.1494705493 8971032374 7506600891 7 D-28     /
      DATA AE14CS( 58) / -.6542620279 8657054397 3904242005 3 D-29     /
      DATA AE14CS( 59) / +.2877581395 1991711143 4048735368 5 D-29     /
      DATA AE14CS( 60) / -.1271557211 7960247110 2798120004 2 D-29     /
      DATA AE14CS( 61) / +.5644615555 6487225223 8804462250 6 D-30     /
      DATA AE14CS( 62) / -.2516994994 2840951060 8061683029 3 D-30     /
      DATA AE14CS( 63) / +.1127259818 9275102063 7036880418 1 D-30     /
      DATA AE14CS( 64) / -.5069814875 8004608555 6258471936 0 D-31     /
      DATA FIRST /.TRUE./
C***FIRST EXECUTABLE STATEMENT  DE1
      IF (FIRST) THEN
         ETA = 0.1*REAL(D1MACH(3))
         NTAE10 = INITDS (AE10CS, 50, ETA)
         NTAE11 = INITDS (AE11CS, 60, ETA)
         NTAE12 = INITDS (AE12CS, 41, ETA)
         NTE11 = INITDS (E11CS, 29, ETA)
         NTE12 = INITDS (E12CS, 25, ETA)
         NTAE13 = INITDS (AE13CS, 50, ETA)
         NTAE14 = INITDS (AE14CS, 64, ETA)
C
         XMAXT = -LOG(D1MACH(1))
         XMAX = XMAXT - LOG(XMAXT)
      ENDIF
      FIRST = .FALSE.
C
      IF (X.GT.(-1.D0)) GO TO 50
      IF (X.GT.(-32.D0)) GO TO 20
      DE1 = EXP(-X)/X * (1.D0 + DCSEVL (64.D0/X+1.D0, AE10CS, NTAE10))
      RETURN
C
 20   IF (X.GT.(-8.D0)) GO TO 30
      DE1 = EXP(-X)/X * (1.D0 + DCSEVL ((64.D0/X+5.D0)/3.D0, AE11CS,
     1  NTAE11))
      RETURN
C
 30   IF (X.GT.(-4.D0)) GO TO 40
      DE1 = EXP(-X)/X * (1.D0 + DCSEVL (16.D0/X+3.D0, AE12CS, NTAE12))
      RETURN
C
 40   DE1 = -LOG(-X) + DCSEVL ((2.D0*X+5.D0)/3.D0, E11CS, NTE11)
      RETURN
C
 50   IF (X.GT.1.0D0) GO TO 60
      IF (X .EQ. 0.D0) CALL XERMSG ('SLATEC', 'DE1', 'X IS 0', 2, 2)
      DE1 = (-LOG(ABS(X)) - 0.6875D0 + X)  + DCSEVL (X, E12CS, NTE12)
      RETURN
C
 60   IF (X.GT.4.0D0) GO TO 70
      DE1 = EXP(-X)/X * (1.D0 + DCSEVL ((8.D0/X-5.D0)/3.D0, AE13CS,
     1  NTAE13))
      RETURN
C
 70   IF (X.GT.XMAX) GO TO 80
      DE1 = EXP(-X)/X * (1.D0 + DCSEVL (8.D0/X-1.D0, AE14CS, NTAE14))
      RETURN
C
 80   CALL XERMSG ('SLATEC', 'DE1', 'X SO BIG E1 UNDERFLOWS', 1, 1)
      DE1 = 0.D0
      RETURN
C
      END
