C
C
      SUBROUTINE XERMSG (LIBRAR, SUBROU, MESSAG, NERR, LEVEL)
C
C ACTION: SLATEC error message handler for the SIMFIT package
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 10/12/2001
C
C         This version does not include the functionality of the true
C         SLATEC error handler because most of the errors will be trapped
C         by the NAG routines that call the SLATEC routines.
C         MAXLEV and MINLEV set the upper and lower limits.
C         MINLEV = 2 implies...ignore possibly misleading warnings
C
      IMPLICIT   NONE
      INTEGER    NERR, LEVEL
      INTEGER    MAXLEV, MINLEV
      PARAMETER (MAXLEV = 2, MINLEV = 0)
      INTEGER    ICOUNT, JCOUNT, L
      CHARACTER  LIBRAR*(*), SUBROU*(*), MESSAG*(*)
      CHARACTER  LETTER*1, LINE*100
      CHARACTER  BLANK*1, CIPHER(0:2)*9, DOLLAR*1
      PARAMETER (BLANK = ' ', DOLLAR = '$')
      INTRINSIC  LEN
      DATA       CIPHER / '(ADVICE) ', '(WARNING)', '(*FATAL*)' /
C
C Check severity of error message
C
      IF (LEVEL.LT.MINLEV .OR. LEVEL.GT.MAXLEV) RETURN
C
C Start the table
C
      WRITE (*,100) LIBRAR
      WRITE (*,200) SUBROU
      WRITE (*,300) NERR
      WRITE (*,400) LEVEL, CIPHER(LEVEL)
      WRITE (*,500)
C
C Initialise for parsing the message
C
      L = LEN(MESSAG)
      IF (L.GT.0) THEN
         LETTER = MESSAG(L:L)
         DO WHILE (LETTER.EQ.BLANK .AND. L.GT.0)
            L = L - 1
            LETTER = MESSAG(L:L)
         ENDDO
      ENDIF
      IF (L.EQ.0) RETURN
      ICOUNT = 0
      JCOUNT = 0
      LINE = BLANK
C
C Deal with message letter by letter
C
      DO WHILE (ICOUNT.LT.L)
         ICOUNT = ICOUNT + 1
         JCOUNT = JCOUNT + 1
         LETTER = MESSAG(ICOUNT:ICOUNT)
         IF (JCOUNT.EQ.72 .OR. ICOUNT.EQ.L) THEN
C
C End of 72 character line or end of message
C
            LINE(JCOUNT:JCOUNT) = LETTER
            WRITE (*,600) LINE
            LINE = BLANK
            JCOUNT = 0
         ELSEIF (LETTER.EQ.DOLLAR) THEN
C
C $ has been encountered
C
            IF (MESSAG(ICOUNT + 1:ICOUNT + 1).EQ.DOLLAR) THEN
C
C another $ has been encountered
C
               ICOUNT = ICOUNT + 1
               WRITE (*,600) LINE
               LINE = BLANK
               JCOUNT = 0
            ELSE
C
C Build up LINE
C
               LINE(JCOUNT:JCOUNT) = LETTER
            ENDIF
         ELSE
C
C Build up LINE
C
            LINE(JCOUNT:JCOUNT) = LETTER
         ENDIF
      ENDDO
  100 FORMAT ('Library =',1X,A)
  200 FORMAT ('Routine =',1X,A)
  300 FORMAT ('  Error =',I3)
  400 FORMAT ('  Level =',I3,1X,A)
  500 FORMAT ('Message =')
  600 FORMAT (A)
      END
C
C

