c
c Edited by W.G.Bardsley, 18/12/2001
c ==================================
c Replaced all external elementaries by intrinsics
c Note: tol must be real not double precision in call to initds
c

      subroutine d9sifg (x, f, g)
c december 1980 edition.  w. fullerton, bell labs.
      integer nf1, nf2, ng1, ng2, ng3, initds
      double precision x, f, g, f1cs(43), f2cs(99), g1cs(44),
     1  g2cs(44), g3cs(56), xbnd, xbndg, xbig, xmaxf, xmaxg,
     2  dcsevl, d1mach
      real tol
      external d1mach, dcsevl, initds
      intrinsic exp, log, sqrt, min
c
c series for f1   on the interval  2.00000e-02 to  6.25000e-02
c                                        with weighted error   2.45e-32
c                                         log weighted error  31.61
c                               significant figures required  30.42
c                                    decimal places required  32.43
c
      data f1  cs(  1) / -0.1191081969 0513636103 4820196582 8918d0/
      data f1  cs(  2) / -0.0247823144 9962362475 9007415082 3133d0/
      data f1  cs(  3) /  0.0011910281 4533578212 6812036305 4457d0/
      data f1  cs(  4) / -0.0000927027 7143885617 4830860036 0706d0/
      data f1  cs(  5) /  0.0000093373 1415682709 9686820458 2766d0/
      data f1  cs(  6) / -0.0000011058 2878205571 4393897942 6306d0/
      data f1  cs(  7) /  0.0000001464 7720714601 6216933655 0799d0/
      data f1  cs(  8) / -0.0000000210 6944962876 8953260122 7548d0/
      data f1  cs(  9) /  0.0000000032 2934923668 4823638285 7374d0/
      data f1  cs( 10) / -0.0000000005 2065296175 2937582801 4986d0/
      data f1  cs( 11) /  0.0000000000 8748788845 7027875026 8316d0/
      data f1  cs( 12) / -0.0000000000 1521761870 5612366829 4574d0/
      data f1  cs( 13) /  0.0000000000 0272571924 0541957390 0583d0/
      data f1  cs( 14) / -0.0000000000 0050070530 7596855629 0255d0/
      data f1  cs( 15) /  0.0000000000 0009402409 0272606851 1779d0/
      data f1  cs( 16) / -0.0000000000 0001800144 4479180367 8336d0/
      data f1  cs( 17) /  0.0000000000 0000350626 2143274178 5826d0/
      data f1  cs( 18) / -0.0000000000 0000069352 8292676914 9709d0/
      data f1  cs( 19) /  0.0000000000 0000013909 2513645421 6568d0/
      data f1  cs( 20) / -0.0000000000 0000002824 8688507417 0585d0/
      data f1  cs( 21) /  0.0000000000 0000000580 3130569357 9081d0/
      data f1  cs( 22) / -0.0000000000 0000000120 4690157337 5820d0/
      data f1  cs( 23) /  0.0000000000 0000000025 2505244365 5940d0/
      data f1  cs( 24) / -0.0000000000 0000000005 3398026880 5594d0/
      data f1  cs( 25) /  0.0000000000 0000000001 1385578627 4122d0/
      data f1  cs( 26) / -0.0000000000 0000000000 2446286150 5259d0/
      data f1  cs( 27) /  0.0000000000 0000000000 0529365932 0439d0/
      data f1  cs( 28) / -0.0000000000 0000000000 0115318494 0277d0/
      data f1  cs( 29) /  0.0000000000 0000000000 0025278656 8318d0/
      data f1  cs( 30) / -0.0000000000 0000000000 0005573864 5378d0/
      data f1  cs( 31) /  0.0000000000 0000000000 0001235824 5621d0/
      data f1  cs( 32) / -0.0000000000 0000000000 0000275435 0842d0/
      data f1  cs( 33) /  0.0000000000 0000000000 0000061690 6808d0/
      data f1  cs( 34) / -0.0000000000 0000000000 0000013881 7443d0/
      data f1  cs( 35) /  0.0000000000 0000000000 0000003137 5329d0/
      data f1  cs( 36) / -0.0000000000 0000000000 0000000712 1249d0/
      data f1  cs( 37) /  0.0000000000 0000000000 0000000162 2778d0/
      data f1  cs( 38) / -0.0000000000 0000000000 0000000037 1206d0/
      data f1  cs( 39) /  0.0000000000 0000000000 0000000008 5221d0/
      data f1  cs( 40) / -0.0000000000 0000000000 0000000001 9633d0/
      data f1  cs( 41) /  0.0000000000 0000000000 0000000000 4538d0/
      data f1  cs( 42) / -0.0000000000 0000000000 0000000000 1052d0/
      data f1  cs( 43) /  0.0000000000 0000000000 0000000000 0245d0/
c
c series for f2   on the interval  0.00000e+00 to  2.00000e-02
c                                        with weighted error   2.38e-32
c                                         log weighted error  31.62
c                               significant figures required  30.01
c                                    decimal places required  32.62
c
      data f2  cs(  1) / -0.0348409253 8970132330 8360497337 45577d0/
      data f2  cs(  2) / -0.0166842205 6779596873 2467863122 78676d0/
      data f2  cs(  3) /  0.0006752901 2412377385 0452078592 39727d0/
      data f2  cs(  4) / -0.0000535066 6225447013 6287855775 57429d0/
      data f2  cs(  5) /  0.0000062693 4217790075 2670507594 31626d0/
      data f2  cs(  6) / -0.0000009526 6388019916 6806777904 14293d0/
      data f2  cs(  7) /  0.0000001745 6292242509 8804255044 27666d0/
      data f2  cs(  8) / -0.0000000368 7954030653 0933070976 46628d0/
      data f2  cs(  9) /  0.0000000087 2026777051 3952640758 16938d0/
      data f2  cs( 10) / -0.0000000022 6019703919 7387485304 23167d0/
      data f2  cs( 11) /  0.0000000006 3246249765 2506125204 44877d0/
      data f2  cs( 12) / -0.0000000001 8889118884 7178692409 11480d0/
      data f2  cs( 13) /  0.0000000000 5967746729 9978133726 20472d0/
      data f2  cs( 14) / -0.0000000000 1980443117 3722390111 96007d0/
      data f2  cs( 15) /  0.0000000000 0686413954 7721033837 13264d0/
      data f2  cs( 16) / -0.0000000000 0247310193 0701991060 74890d0/
      data f2  cs( 17) /  0.0000000000 0092263594 5499414041 96042d0/
      data f2  cs( 18) / -0.0000000000 0035523634 9992617844 97297d0/
      data f2  cs( 19) /  0.0000000000 0014076049 6253515914 61820d0/
      data f2  cs( 20) / -0.0000000000 0005726228 4997476527 94311d0/
      data f2  cs( 21) /  0.0000000000 0002386537 5454131718 10106d0/
      data f2  cs( 22) / -0.0000000000 0001017141 8907645971 42232d0/
      data f2  cs( 23) /  0.0000000000 0000442594 5310783644 24968d0/
      data f2  cs( 24) / -0.0000000000 0000196344 9330491897 61979d0/
      data f2  cs( 25) /  0.0000000000 0000088688 7483148104 61024d0/
      data f2  cs( 26) / -0.0000000000 0000040743 3450273115 46948d0/
      data f2  cs( 27) /  0.0000000000 0000019016 8372156753 39859d0/
      data f2  cs( 28) / -0.0000000000 0000009009 7072974780 42442d0/
      data f2  cs( 29) /  0.0000000000 0000004329 2112740956 68667d0/
      data f2  cs( 30) / -0.0000000000 0000002108 1444653224 79526d0/
      data f2  cs( 31) /  0.0000000000 0000001039 6379070264 52274d0/
      data f2  cs( 32) / -0.0000000000 0000000518 8910079489 31936d0/
      data f2  cs( 33) /  0.0000000000 0000000261 9553248698 99371d0/
      data f2  cs( 34) / -0.0000000000 0000000133 6903999513 01570d0/
      data f2  cs( 35) /  0.0000000000 0000000068 9410577029 31664d0/
      data f2  cs( 36) / -0.0000000000 0000000035 9053626104 37250d0/
      data f2  cs( 37) /  0.0000000000 0000000018 8780772557 91706d0/
      data f2  cs( 38) / -0.0000000000 0000000010 0161252655 94380d0/
      data f2  cs( 39) /  0.0000000000 0000000005 3607256915 78228d0/
      data f2  cs( 40) / -0.0000000000 0000000002 8931989749 44827d0/
      data f2  cs( 41) /  0.0000000000 0000000001 5740651002 02625d0/
      data f2  cs( 42) / -0.0000000000 0000000000 8630271064 31206d0/
      data f2  cs( 43) /  0.0000000000 0000000000 4767156028 62288d0/
      data f2  cs( 44) / -0.0000000000 0000000000 2652227399 98504d0/
      data f2  cs( 45) /  0.0000000000 0000000000 1485828650 63866d0/
      data f2  cs( 46) / -0.0000000000 0000000000 0837972359 23135d0/
      data f2  cs( 47) /  0.0000000000 0000000000 0475659164 22711d0/
      data f2  cs( 48) / -0.0000000000 0000000000 0271690733 53112d0/
      data f2  cs( 49) /  0.0000000000 0000000000 0156127388 81686d0/
      data f2  cs( 50) / -0.0000000000 0000000000 0090245550 78347d0/
      data f2  cs( 51) /  0.0000000000 0000000000 0052460970 49119d0/
      data f2  cs( 52) / -0.0000000000 0000000000 0030664508 18697d0/
      data f2  cs( 53) /  0.0000000000 0000000000 0018019962 50957d0/
      data f2  cs( 54) / -0.0000000000 0000000000 0010644430 50752d0/
      data f2  cs( 55) /  0.0000000000 0000000000 0006319421 58881d0/
      data f2  cs( 56) / -0.0000000000 0000000000 0003770138 12246d0/
      data f2  cs( 57) /  0.0000000000 0000000000 0002259975 42918d0/
      data f2  cs( 58) / -0.0000000000 0000000000 0001361008 44814d0/
      data f2  cs( 59) /  0.0000000000 0000000000 0000823332 32003d0/
      data f2  cs( 60) / -0.0000000000 0000000000 0000500259 86091d0/
      data f2  cs( 61) /  0.0000000000 0000000000 0000305262 45684d0/
      data f2  cs( 62) / -0.0000000000 0000000000 0000187051 64021d0/
      data f2  cs( 63) /  0.0000000000 0000000000 0000115084 04393d0/
      data f2  cs( 64) / -0.0000000000 0000000000 0000071087 14611d0/
      data f2  cs( 65) /  0.0000000000 0000000000 0000044080 65533d0/
      data f2  cs( 66) / -0.0000000000 0000000000 0000027437 60867d0/
      data f2  cs( 67) /  0.0000000000 0000000000 0000017141 44851d0/
      data f2  cs( 68) / -0.0000000000 0000000000 0000010747 68860d0/
      data f2  cs( 69) /  0.0000000000 0000000000 0000006762 59777d0/
      data f2  cs( 70) / -0.0000000000 0000000000 0000004269 81348d0/
      data f2  cs( 71) /  0.0000000000 0000000000 0000002705 00637d0/
      data f2  cs( 72) / -0.0000000000 0000000000 0000001719 33331d0/
      data f2  cs( 73) /  0.0000000000 0000000000 0000001096 36138d0/
      data f2  cs( 74) / -0.0000000000 0000000000 0000000701 32573d0/
      data f2  cs( 75) /  0.0000000000 0000000000 0000000450 01784d0/
      data f2  cs( 76) / -0.0000000000 0000000000 0000000289 63835d0/
      data f2  cs( 77) /  0.0000000000 0000000000 0000000186 97009d0/
      data f2  cs( 78) / -0.0000000000 0000000000 0000000121 04646d0/
      data f2  cs( 79) /  0.0000000000 0000000000 0000000078 59065d0/
      data f2  cs( 80) / -0.0000000000 0000000000 0000000051 16867d0/
      data f2  cs( 81) /  0.0000000000 0000000000 0000000033 40627d0/
      data f2  cs( 82) / -0.0000000000 0000000000 0000000021 86851d0/
      data f2  cs( 83) /  0.0000000000 0000000000 0000000014 35340d0/
      data f2  cs( 84) / -0.0000000000 0000000000 0000000009 44523d0/
      data f2  cs( 85) /  0.0000000000 0000000000 0000000006 23117d0/
      data f2  cs( 86) / -0.0000000000 0000000000 0000000004 12101d0/
      data f2  cs( 87) /  0.0000000000 0000000000 0000000002 73208d0/
      data f2  cs( 88) / -0.0000000000 0000000000 0000000001 81558d0/
      data f2  cs( 89) /  0.0000000000 0000000000 0000000001 20934d0/
      data f2  cs( 90) / -0.0000000000 0000000000 0000000000 80737d0/
      data f2  cs( 91) /  0.0000000000 0000000000 0000000000 54022d0/
      data f2  cs( 92) / -0.0000000000 0000000000 0000000000 36227d0/
      data f2  cs( 93) /  0.0000000000 0000000000 0000000000 24348d0/
      data f2  cs( 94) / -0.0000000000 0000000000 0000000000 16401d0/
      data f2  cs( 95) /  0.0000000000 0000000000 0000000000 11074d0/
      data f2  cs( 96) / -0.0000000000 0000000000 0000000000 07497d0/
      data f2  cs( 97) /  0.0000000000 0000000000 0000000000 05091d0/
      data f2  cs( 98) / -0.0000000000 0000000000 0000000000 03470d0/
      data f2  cs( 99) /  0.0000000000 0000000000 0000000000 02377d0/
c
c series for g1   on the interval  2.00000e-02 to  6.25000e-02
c                                        with weighted error   7.23e-32
c                                         log weighted error  31.14
c                               significant figures required  30.35
c                                    decimal places required  31.96
c
      data g1  cs(  1) / -0.3040578798 2534959544 9972668209 1083d0/
      data g1  cs(  2) / -0.0566890984 5971205877 3133915611 8269d0/
      data g1  cs(  3) /  0.0039046158 1732756439 1998407155 4082d0/
      data g1  cs(  4) / -0.0003746075 9592022606 1861933986 7489d0/
      data g1  cs(  5) /  0.0000435431 5565598436 7955222084 0065d0/
      data g1  cs(  6) / -0.0000057417 2944530250 4656197072 3475d0/
      data g1  cs(  7) /  0.0000008282 5521045026 2974193761 6492d0/
      data g1  cs(  8) / -0.0000001278 2458925946 4272788391 3223d0/
      data g1  cs(  9) /  0.0000000207 9783529486 8788443925 7529d0/
      data g1  cs( 10) / -0.0000000035 3132059219 9079804203 2682d0/
      data g1  cs( 11) /  0.0000000006 2108242363 0895106863 1449d0/
      data g1  cs( 12) / -0.0000000001 1252154744 4629264933 6987d0/
      data g1  cs( 13) /  0.0000000000 2090889176 8442160526 7019d0/
      data g1  cs( 14) / -0.0000000000 0397158317 3768172768 9158d0/
      data g1  cs( 15) /  0.0000000000 0076904313 1427208993 9005d0/
      data g1  cs( 16) / -0.0000000000 0015146967 4273161351 9826d0/
      data g1  cs( 17) /  0.0000000000 0003028921 4655235968 4119d0/
      data g1  cs( 18) / -0.0000000000 0000613997 0383470882 5400d0/
      data g1  cs( 19) /  0.0000000000 0000126006 0582951093 3553d0/
      data g1  cs( 20) / -0.0000000000 0000026150 2925093948 3683d0/
      data g1  cs( 21) /  0.0000000000 0000005482 7884489179 6821d0/
      data g1  cs( 22) / -0.0000000000 0000001160 3818212952 6571d0/
      data g1  cs( 23) /  0.0000000000 0000000247 7165410712 9795d0/
      data g1  cs( 24) / -0.0000000000 0000000053 3067275322 3389d0/
      data g1  cs( 25) /  0.0000000000 0000000011 5566607559 8465d0/
      data g1  cs( 26) / -0.0000000000 0000000002 5228054774 4957d0/
      data g1  cs( 27) /  0.0000000000 0000000000 5542903855 0786d0/
      data g1  cs( 28) / -0.0000000000 0000000000 1225220842 1297d0/
      data g1  cs( 29) /  0.0000000000 0000000000 0272366431 8684d0/
      data g1  cs( 30) / -0.0000000000 0000000000 0060870783 1422d0/
      data g1  cs( 31) /  0.0000000000 0000000000 0013672487 4476d0/
      data g1  cs( 32) / -0.0000000000 0000000000 0003085662 6806d0/
      data g1  cs( 33) /  0.0000000000 0000000000 0000699521 2319d0/
      data g1  cs( 34) / -0.0000000000 0000000000 0000159258 7569d0/
      data g1  cs( 35) /  0.0000000000 0000000000 0000036405 1056d0/
      data g1  cs( 36) / -0.0000000000 0000000000 0000008353 9465d0/
      data g1  cs( 37) /  0.0000000000 0000000000 0000001924 0303d0/
      data g1  cs( 38) / -0.0000000000 0000000000 0000000444 6816d0/
      data g1  cs( 39) /  0.0000000000 0000000000 0000000103 1182d0/
      data g1  cs( 40) / -0.0000000000 0000000000 0000000023 9887d0/
      data g1  cs( 41) /  0.0000000000 0000000000 0000000005 5976d0/
      data g1  cs( 42) / -0.0000000000 0000000000 0000000001 3100d0/
      data g1  cs( 43) /  0.0000000000 0000000000 0000000000 3074d0/
      data g1  cs( 44) / -0.0000000000 0000000000 0000000000 0723d0/
c
c series for g2   on the interval  5.00000e-03 to  2.00000e-02
c                                        with weighted error   3.25e-32
c                                         log weighted error  31.49
c                               significant figures required  30.32
c                                    decimal places required  32.31
c
      data g2  cs(  1) / -0.1211802894 7316462635 4183404685 8267d0/
      data g2  cs(  2) / -0.0316761386 3949502867 0140792350 5610d0/
      data g2  cs(  3) /  0.0013383199 7788626801 6381942949 2182d0/
      data g2  cs(  4) / -0.0000895511 0113922524 2553190506 9518d0/
      data g2  cs(  5) /  0.0000079155 5629617182 1311524946 7924d0/
      data g2  cs(  6) / -0.0000008438 7933222415 2018141898 2080d0/
      data g2  cs(  7) /  0.0000001029 9804256775 3014664722 7274d0/
      data g2  cs(  8) / -0.0000000139 2957506051 8383579583 4444d0/
      data g2  cs(  9) /  0.0000000020 4227039598 7598040067 7594d0/
      data g2  cs( 10) / -0.0000000003 1965346942 0642703543 4752d0/
      data g2  cs( 11) /  0.0000000000 5281478326 5726769861 5312d0/
      data g2  cs( 12) / -0.0000000000 0913395546 7267103373 5289d0/
      data g2  cs( 13) /  0.0000000000 0164262512 3896776044 4819d0/
      data g2  cs( 14) / -0.0000000000 0030558970 3932266000 2410d0/
      data g2  cs( 15) /  0.0000000000 0005856558 2578577971 7892d0/
      data g2  cs( 16) / -0.0000000000 0001152291 9773094012 0563d0/
      data g2  cs( 17) /  0.0000000000 0000232094 6911998853 7310d0/
      data g2  cs( 18) / -0.0000000000 0000047743 5583417753 5025d0/
      data g2  cs( 19) /  0.0000000000 0000010009 9676580018 0573d0/
      data g2  cs( 20) / -0.0000000000 0000002135 3377808225 6704d0/
      data g2  cs( 21) /  0.0000000000 0000000462 7719077736 7671d0/
      data g2  cs( 22) / -0.0000000000 0000000101 7580741022 7657d0/
      data g2  cs( 23) /  0.0000000000 0000000022 6765739988 4672d0/
      data g2  cs( 24) / -0.0000000000 0000000005 1163077607 6426d0/
      data g2  cs( 25) /  0.0000000000 0000000001 1676701491 3108d0/
      data g2  cs( 26) / -0.0000000000 0000000000 2693542767 2470d0/
      data g2  cs( 27) /  0.0000000000 0000000000 0627566584 1146d0/
      data g2  cs( 28) / -0.0000000000 0000000000 0147588055 7531d0/
      data g2  cs( 29) /  0.0000000000 0000000000 0035014531 4739d0/
      data g2  cs( 30) / -0.0000000000 0000000000 0008375773 2152d0/
      data g2  cs( 31) /  0.0000000000 0000000000 0002019181 5152d0/
      data g2  cs( 32) / -0.0000000000 0000000000 0000490356 7705d0/
      data g2  cs( 33) /  0.0000000000 0000000000 0000119912 3348d0/
      data g2  cs( 34) / -0.0000000000 0000000000 0000029517 0610d0/
      data g2  cs( 35) /  0.0000000000 0000000000 0000007311 3112d0/
      data g2  cs( 36) / -0.0000000000 0000000000 0000001821 7843d0/
      data g2  cs( 37) /  0.0000000000 0000000000 0000000456 5148d0/
      data g2  cs( 38) / -0.0000000000 0000000000 0000000115 0151d0/
      data g2  cs( 39) /  0.0000000000 0000000000 0000000029 1267d0/
      data g2  cs( 40) / -0.0000000000 0000000000 0000000007 4125d0/
      data g2  cs( 41) /  0.0000000000 0000000000 0000000001 8953d0/
      data g2  cs( 42) / -0.0000000000 0000000000 0000000000 4868d0/
      data g2  cs( 43) /  0.0000000000 0000000000 0000000000 1256d0/
      data g2  cs( 44) / -0.0000000000 0000000000 0000000000 0325d0/
c
c series for g3   on the interval  0.00000e+00 to  5.00000e-03
c                                        with weighted error   3.83e-32
c                                         log weighted error  31.42
c                               significant figures required  29.71
c                                    decimal places required  32.29
c
      data g3  cs(  1) / -0.0280574367 8094729284 0281526433 5299d0/
      data g3  cs(  2) / -0.0137271597 1622369754 0910050808 9556d0/
      data g3  cs(  3) /  0.0002894032 6387602960 2744894127 3751d0/
      data g3  cs(  4) / -0.0000114129 2393911971 4590874362 2517d0/
      data g3  cs(  5) /  0.0000006813 9655907262 4299772020 7302d0/
      data g3  cs(  6) / -0.0000000547 9522896046 5236366905 8052d0/
      data g3  cs(  7) /  0.0000000055 2074299182 1252910940 6521d0/
      data g3  cs(  8) / -0.0000000006 6414641993 2292002249 1428d0/
      data g3  cs(  9) /  0.0000000000 9223736634 8704110856 4960d0/
      data g3  cs( 10) / -0.0000000000 1442990888 8668286261 1718d0/
      data g3  cs( 11) /  0.0000000000 0249639048 9203071024 8705d0/
      data g3  cs( 12) / -0.0000000000 0047082406 7587524472 2971d0/
      data g3  cs( 13) /  0.0000000000 0009572176 5921675998 8140d0/
      data g3  cs( 14) / -0.0000000000 0002078899 6609580903 0537d0/
      data g3  cs( 15) /  0.0000000000 0000478750 9997087743 1627d0/
      data g3  cs( 16) / -0.0000000000 0000116190 7058337717 3759d0/
      data g3  cs( 17) /  0.0000000000 0000029565 0896926783 6974d0/
      data g3  cs( 18) / -0.0000000000 0000007852 9498825649 2025d0/
      data g3  cs( 19) /  0.0000000000 0000002169 2226436825 6612d0/
      data g3  cs( 20) / -0.0000000000 0000000621 1351583167 6342d0/
      data g3  cs( 21) /  0.0000000000 0000000183 8456883845 0977d0/
      data g3  cs( 22) / -0.0000000000 0000000056 1088748213 7276d0/
      data g3  cs( 23) /  0.0000000000 0000000017 6186280528 0062d0/
      data g3  cs( 24) / -0.0000000000 0000000005 6811105054 1451d0/
      data g3  cs( 25) /  0.0000000000 0000000001 8778627958 2313d0/
      data g3  cs( 26) / -0.0000000000 0000000000 6353169415 1124d0/
      data g3  cs( 27) /  0.0000000000 0000000000 2196880236 8238d0/
      data g3  cs( 28) / -0.0000000000 0000000000 0775466655 0395d0/
      data g3  cs( 29) /  0.0000000000 0000000000 0279101835 6581d0/
      data g3  cs( 30) / -0.0000000000 0000000000 0102317852 5247d0/
      data g3  cs( 31) /  0.0000000000 0000000000 0038169340 3919d0/
      data g3  cs( 32) / -0.0000000000 0000000000 0014476789 5606d0/
      data g3  cs( 33) /  0.0000000000 0000000000 0005577951 2634d0/
      data g3  cs( 34) / -0.0000000000 0000000000 0002181723 9071d0/
      data g3  cs( 35) /  0.0000000000 0000000000 0000865664 6309d0/
      data g3  cs( 36) / -0.0000000000 0000000000 0000348215 7895d0/
      data g3  cs( 37) /  0.0000000000 0000000000 0000141918 8130d0/
      data g3  cs( 38) / -0.0000000000 0000000000 0000058571 4314d0/
      data g3  cs( 39) /  0.0000000000 0000000000 0000024466 0482d0/
      data g3  cs( 40) / -0.0000000000 0000000000 0000010338 7099d0/
      data g3  cs( 41) /  0.0000000000 0000000000 0000004417 7299d0/
      data g3  cs( 42) / -0.0000000000 0000000000 0000001908 0079d0/
      data g3  cs( 43) /  0.0000000000 0000000000 0000000832 6038d0/
      data g3  cs( 44) / -0.0000000000 0000000000 0000000366 9553d0/
      data g3  cs( 45) /  0.0000000000 0000000000 0000000163 2875d0/
      data g3  cs( 46) / -0.0000000000 0000000000 0000000073 3357d0/
      data g3  cs( 47) /  0.0000000000 0000000000 0000000033 2327d0/
      data g3  cs( 48) / -0.0000000000 0000000000 0000000015 1906d0/
      data g3  cs( 49) /  0.0000000000 0000000000 0000000007 0020d0/
      data g3  cs( 50) / -0.0000000000 0000000000 0000000003 2539d0/
      data g3  cs( 51) /  0.0000000000 0000000000 0000000001 5240d0/
      data g3  cs( 52) / -0.0000000000 0000000000 0000000000 7193d0/
      data g3  cs( 53) /  0.0000000000 0000000000 0000000000 3420d0/
      data g3  cs( 54) / -0.0000000000 0000000000 0000000000 1638d0/
      data g3  cs( 55) /  0.0000000000 0000000000 0000000000 0790d0/
      data g3  cs( 56) / -0.0000000000 0000000000 0000000000 0383d0/
c
      data nf1, nf2, ng1, ng2, ng3 / 5*0 /
      data xbnd, xbndg, xbig, xmaxf, xmaxg / 5*0.0d0 /
c
      if (nf1.ne.0) go to 10
      tol = 0.1d0*d1mach(3)
      nf1 = initds (f1cs, 43, tol)
      nf2 = initds (f2cs, 99, tol)
      ng1 = initds (g1cs, 44, tol)
      ng2 = initds (g2cs, 44, tol)
      ng3 = initds (g3cs, 56, tol)
c
      xbig = sqrt(1.0d0/d1mach(3))
      xmaxf = exp (min (-log(d1mach(1)), log(d1mach(2))) - .01d0)
      xmaxg = 1.0d0/sqrt(d1mach(1))
      xbnd = sqrt (50.0d0)
      xbndg = sqrt (200.d0)
c
 10   continue
c
c uncomment the next line to switch seteru back on
c
c10   if (x.lt.4.0d0) call seteru (
c****1  34hd9sifg  approxs invalid for x lt 4, 34, 1, 2)
c
      if (x.gt.xbnd) go to 20
      f = (1.0d0 + dcsevl ((1.d0/x**2-0.04125d0)/.02125d0, f1cs, nf1))/x
      g = (1.0d0 + dcsevl((1.d0/x**2-.04125d0)/.02125d0, g1cs,ng1))/x**2
      return
c
 20   if (x.gt.xbig) go to 30
      f = (1.0d0 + dcsevl (100.d0/x**2-1.d0, f2cs, nf2))/x
      if (x.le.xbndg) g = (1.0d0 + dcsevl ((10000.d0/x**2-125.d0)/75.d0,
     1  g2cs, ng2))/x**2
      if (x.gt.xbndg) g = (1.0d0 + dcsevl (400.d0/x**2-1.d0, g3cs,
     1  ng3))/x**2
      return
c
 30   f = 0.d0
      if (x.lt.xmaxf) f = 1.0d0/x
      g = 0.d0
      if (x.lt.xmaxg) g = 1.0d0/x**2
      return
c
      end
