C
C
      SUBROUTINE GKSR04 (NOUT, NPAR, NPTS,
     +                   RESID, S, THEORY, WRESID, X, Y, 
     +                   VERDIC,
     +                   GETVER, GRAPH)
C
C ACTION : Supply NPAR, NPTS, RESID, S, THEORY, X, Y then calculate VERDIC and/or plot residuals
C ADVICE : This version calls GKS004 for graphics
C          NOUT = Unit for output of tables to main data file
C          GETVER = .TRUE. then calculate VERDIC
C          GRAPH = .TRUE. then display the residuals if required
C AUTHOR : W. G. Bardsley, University of Manchester, U.K
C          14/09/2017 derived from GKSR01
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: NOUT, NPAR, NPTS
      DOUBLE PRECISION,    INTENT (IN)  :: S(NPTS), THEORY(NPTS),
     +                                     X(NPTS), Y(NPTS)
      DOUBLE PRECISION,    INTENT (IN)  :: RESID(NPTS), WRESID(NPTS)
      CHARACTER (LEN = *), INTENT (OUT) :: VERDIC
      LOGICAL,             INTENT (IN)  :: GETVER, GRAPH
C
C Locals
C      
      INTEGER    L0, L3, N2
      PARAMETER (L0 = 0, L3 = 3, N2 = 2)
      INTEGER    ICOLOR, IX, IY, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4,
     +           NUMOPT = 5, NSTART = 7, NTEXT = NSTART + NUMOPT - 1)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      INTEGER    I, IFAIL, NSCORE
      INTEGER    NNEG, NPOS, NRUN, NR1, NR5
      DOUBLE PRECISION TOL1, TOL2, TOL3
      PARAMETER (TOL1 = 1.0D+35, TOL2 = 1.0D-06, TOL3 = 1.0D-10)
      DOUBLE PRECISION PNT01, PNT05
      PARAMETER  (PNT01 = 0.01D+00, PNT05 = 0.05D+00)
      DOUBLE PRECISION CENT, ONE, TWO, ZERO
      PARAMETER (CENT = 100.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           ZERO = 0.0D+00)
      DOUBLE PRECISION AVRR, DW, PROBR, PROBS, PROBT, RBIG, RSMALL
      DOUBLE PRECISION G01ECF$, PGCHI, SSQ, WSSQ
      DOUBLE PRECISION PC1, PC2, PC3, PC4, R, TMAX, TMIN, YABS
      DOUBLE PRECISION SMIN, SMAX, X0(2), Y0(2)
      DOUBLE PRECISION DNPTS, P, W
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      CHARACTER  PTITLE*40, XTITLE*20, YTITLE*20
      CHARACTER  TEXT(30)*100
      CHARACTER  MSSAGE*16
      LOGICAL    AXES, SAVEIT
      PARAMETER (AXES = .TRUE., SAVEIT = .TRUE.)
      LOGICAL    WEIGHT
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    ACCEPT, REPEET
      EXTERNAL   CORCOF, GKS004, PROBRS, PUTIFA, LBOX01, GKSR03, HNPLOT
      EXTERNAL   G01ECF$
      INTRINSIC  ABS, MAX, SQRT, DBLE, LOG
      DATA NUMPOS / NUMOPT*1 /
      DATA NUMBLD / NTEXT*0 /
      VERDIC = BLANK
      IF (GETVER) THEN
C
C Initialise
C
         DNPTS = DBLE(NPTS)
C
C First find out if weights are not equal to one
C
         WEIGHT = .FALSE.
         SMAX = ONE + TOL2
         SMIN = ONE - TOL2
         I = 1
         DO WHILE (I.LE.NPTS .AND. .NOT.WEIGHT)
            IF (S(I).LT.SMIN .OR. S(I).GT.SMAX) WEIGHT = .TRUE.
            I = I + 1
         ENDDO
C
C Initialise counters then calculate YABS, WRESID and assign CIPHER
C
         AVRR = ZERO
         PC1 = ZERO
         PC2 = ZERO
         PC3 = ZERO
         PC4 = ZERO
         RBIG = ZERO
         RSMALL = TOL1
         TMAX = THEORY(1)
         TMIN = TMAX
         YABS = ZERO
C
C Main loop to set up residuals and counters
C
         DO I = 1, NPTS
            IF (THEORY(I).GT.TMAX) TMAX = THEORY(I)
            IF (THEORY(I).LT.TMIN) TMIN = THEORY(I)
            YABS = YABS + ABS(Y(I))
            WSSQ = 
     +      ABS(RESID(I)/MAX(TOL2,(ABS(Y(I)) + ABS(THEORY(I)))/TWO))
            AVRR = AVRR + WSSQ
            IF (WSSQ.GT.RBIG) RBIG = WSSQ
            IF (WSSQ.LT.RSMALL) RSMALL = WSSQ
            IF (WSSQ.GT.1.6D+00) THEN
               PC4 = PC4 + ONE
            ELSEIF (WSSQ.GT.0.8D+00) THEN
               PC4 = PC4 + ONE
            ELSEIF (WSSQ.GT.0.4D+00) THEN
               PC3 = PC3 + ONE
            ELSEIF (WSSQ.GT.0.2D+00) THEN
               PC2 = PC2 + ONE
            ELSEIF (WSSQ.GT.0.1D+00) THEN
               PC1 = PC1 + ONE
            ENDIF
         ENDDO
C
C Transform all counters
C
         AVRR = CENT*AVRR/DNPTS
         RBIG = CENT*RBIG
         RSMALL = CENT*RSMALL
         YABS = YABS/DNPTS
         PC1 = CENT*PC1/DNPTS
         PC2 = CENT*PC2/DNPTS
         PC3 = CENT*PC3/DNPTS
         PC4 = CENT*PC4/DNPTS
C
C Work out DW, SSQ, WSSQ then AIC and SC and R-squared
C
         DW = ZERO
         SSQ = RESID(1)**2
         WSSQ = WRESID(1)**2
         DO I = 2, NPTS
            DW = DW + (RESID(I) - RESID(I - 1))**2
            SSQ = SSQ + RESID(I)**2
            WSSQ = WSSQ + WRESID(I)**2
         ENDDO
         DW = DW/MAX(SSQ, TOL3**2)
         CALL CORCOF (NPTS,
     +                R, Y, THEORY)
         I = NPTS - NPAR
         IF (WEIGHT) THEN
            IF (I.GT.0) THEN
               IFAIL = 1
               PGCHI = G01ECF$('Upper-tail', WSSQ, DBLE(I), IFAIL)
               CALL PUTIFA (IFAIL, NOUT, 'G01ECF/GKSR01')
            ELSE
               PGCHI = ZERO
            ENDIF
         ELSE
            IF (I.GT.0 .AND. YABS.GT.TOL3) THEN
               PGCHI = 100.0D+00*SQRT(WSSQ/DBLE(I))/YABS
            ELSE
               PGCHI = 100.0D+00
            ENDIF
         ENDIF
C
C Run and sign tests then work out the verdict
C
         I = 1
         CALL PROBRS (I, NOUT, NNEG, NPOS, NPTS, NRUN, NR1, NR5,
     +                PROBR, PROBS, PROBT, RESID)
         NSCORE = 0
         IF (WEIGHT) THEN
            IF (PGCHI.GT.PNT01) NSCORE = NSCORE + 1
            IF (PGCHI.GT.PNT05) NSCORE = NSCORE + 1
         ELSE
            IF (PGCHI.LT.10.0D+00) NSCORE = NSCORE + 1
            IF (PGCHI.LT.20.0D+00) NSCORE = NSCORE + 1
         ENDIF
         IF (PROBR.GT.PNT01) NSCORE = NSCORE + 1
         IF (PROBR.GT.PNT05) NSCORE = NSCORE + 1
         IF (AVRR.LT.5.0D+00) NSCORE = NSCORE + 1
         IF (AVRR.LT.10.0D+00) NSCORE = NSCORE + 1
         IF (AVRR.LT.20.0D+00) NSCORE = NSCORE + 1
         IF (RBIG.LT.40.0D+00) NSCORE = NSCORE + 1
         IF (RSMALL.LT.1.0D+00) NSCORE = NSCORE + 1
         IF (PC3+PC4.LT.10.0D+00) NSCORE = NSCORE + 1
         IF (PC1+PC2+PC3+PC4.LT.25.0D+00) NSCORE = NSCORE + 1
         CALL GKSR03 (NOUT, NPTS, P, WRESID, W, MSSAGE, ACCEPT)
         IF (ACCEPT) THEN
            IF (P.GT.PNT01) NSCORE = NSCORE + 1
            IF (P.GT.PNT05) NSCORE = NSCORE + 1
         ENDIF
         IF (NSCORE.LE.0) THEN
            VERDIC = 'terrible'
         ELSEIF (NSCORE.EQ.1) THEN
            VERDIC = 'very bad'
         ELSEIF (NSCORE.EQ.2) THEN
            VERDIC = 'bad'
         ELSEIF (NSCORE.EQ.3) THEN
            VERDIC = 'very poor'
         ELSEIF (NSCORE.EQ.4) THEN
            VERDIC = 'poor'
         ELSEIF (NSCORE.EQ.5) THEN
            VERDIC = 'fair'
         ELSEIF (NSCORE.EQ.6) THEN
            VERDIC = 'reasonable'
         ELSEIF (NSCORE.EQ.7) THEN
            VERDIC = 'quite good'
         ELSEIF (NSCORE.EQ.8) THEN
            VERDIC = 'good'
         ELSEIF (NSCORE.EQ.9) THEN
            VERDIC = 'very good'
         ELSEIF (NSCORE.EQ.10) THEN
            VERDIC = 'excellent'
         ELSEIF (NSCORE.EQ.11) THEN
            VERDIC = 'fantastic'
         ELSE
            VERDIC = 'incredible'
         ENDIF
      ENDIF
C
C Graphs of residuals and weighted residuals if required
C
      IF (GRAPH) THEN
         NUMBLD(1) = 4
         NUMDEC = 3
         REPEET = .TRUE.
         DO WHILE (REPEET)
            Y0(1) = ZERO
            Y0(2) = ZERO
            WRITE (TEXT,100)
            IFAIL = 1
            CALL LBOX01 (ICOLOR, IX, IY, IFAIL, NUMBLD, NUMDEC, NUMOPT,
     +                   NUMPOS, NSTART, NTEXT,
     +                   TEXT,
     +                   BORDER, FLASH, HIGH)
            IF (NUMDEC.EQ.1) THEN
               X0(1) = X(1)
               X0(2) = X(NPTS)
               PTITLE = 'Residuals Against X-Variable'
               XTITLE = 'X-Variable'
               YTITLE = 'Residuals'
               CALL GKS004 (L0, L3, L0, L0, L3, L0, L0, L0,
     +                      NPTS, N2, N2, N2,
     +                      X, X0, X0, X0, RESID, Y0, Y0, Y0,
     +                      PTITLE, XTITLE, YTITLE,
     +                      AXES, SAVEIT)
            ELSEIF (NUMDEC.EQ.2) THEN
               X0(1) = TMIN
               X0(2) = TMAX
               IF (WEIGHT) THEN
                  PTITLE = 'Wtd. Residuals Against Best-Fit-Y'
                  YTITLE = 'Weighted Residuals'
               ELSE
                  PTITLE = 'Residuals Against Best-Fit-Y'
                  YTITLE = 'Residuals'
               ENDIF
               XTITLE = 'Best-Fit Y-Values'
               CALL GKS004 (L0, L3, L0, L0, L3, L0, L0, L0,
     +                      NPTS, N2, N2, N2,
     +                      THEORY, X0, X0, X0, WRESID, Y0, Y0, Y0,
     +                      PTITLE, XTITLE, YTITLE,
     +                      AXES, SAVEIT)
            ELSEIF (NUMDEC.EQ.3) THEN
               IFAIL = 1
               CALL HNPLOT (IFAIL, NPTS, WRESID)
            ELSEIF (NUMDEC.EQ.4) THEN
               IFAIL = 2
               CALL HNPLOT (IFAIL, NPTS, WRESID)
            ELSEIF (NUMDEC.EQ.NUMOPT) THEN
               REPEET = .FALSE.
            ENDIF
            NUMDEC = NUMOPT
         ENDDO
      ENDIF
C
C Format statments
C      
   
  100 FORMAT (
     + 'Options for plotting residuals'
     +/
     +/'You can now assess the goodness of fit by'
     +/'plotting residuals if all s = 1, or weighted'
     +/'residuals if weights have been supplied.' 
     +/
     +/'Residuals against X-variable'
     +/'Residuals against Best-fit-Y'
     +/'Half-Normal residuals plot'
     +/'Full-Normal residuals plot'
     +/'Quit ... Exit residuals plotting options' )
      END
C
C
