C
C
      SUBROUTINE M_ANOVA0 (NIN, NOUT)
C
C ACTION: Call Analysis of Variance routines
C AUTHOR: W. G. Bardsley, University of Manchester, U.K., 03/04/2006
C         23/07/2007 edited for version 6
C         26/02/2009 added VAREQ0
C         27/07/2014 added INTENT and replaced LBOX02 by LSTBOX    
C
C Note: NSAV = 1 corresponds to 1-way ANOVA for future development
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER, INTENT (IN) :: NIN, NOUT
C
C Locals
C
      INTEGER    ICOLOR, NUMOPT, NUMSTA
      PARAMETER (ICOLOR = 9, NUMOPT = 18, NUMSTA = 3)
      INTEGER    NDEC
      INTEGER    NUMSAV, NUMTXT
      PARAMETER (NUMSAV = 9)
      INTEGER    NCSAV(NUMSAV), NRSAV(NUMSAV), NUMBLD(30)
      INTEGER    ISEND, JSEND, KSEND, NCOL, NF, NROW, NSAV
      CHARACTER  TEXT(30)*100
      CHARACTER  FNAME*1024, PATH*1024, TITLE*80
      CHARACTER  FSAV(NUMSAV)*1024, TSAV(NUMSAV)*80
      CHARACTER  BLANK*1, PATTERN*10
      PARAMETER (BLANK = ' ', PATTERN = 'anova?.tf?')
      LOGICAL    AGAIN
      LOGICAL    FRAME, UPDOWN, NEXT
      PARAMETER (FRAME = .FALSE., UPDOWN = .TRUE.)
      LOGICAL    SUPPLY
      EXTERNAL   M_ANOVA1, M_ANOVAM, VAREQ0
      EXTERNAL   LSTBOX, VIEWER, DEMDIR, TUTOR1, REVPRO
      SAVE       NCSAV, NRSAV
      SAVE       FSAV, TSAV
      DATA       NUMBLD / 30*0 /
      DATA       NCSAV / 0, 0, 0, 0, 0, 0, 0, 0, 0 /
      DATA       NRSAV / 0, 0, 0, 0, 0, 0, 0, 0, 0 /
      DATA       FSAV  /  BLANK, BLANK, BLANK, BLANK, BLANK, BLANK,
     +                    BLANK, BLANK, BLANK /
      DATA       TSAV  /  BLANK, BLANK, BLANK, BLANK, BLANK, BLANK,
     +                    BLANK, BLANK, BLANK  /
C
C Initialise
C
      NF = NOUT
C
C Main loop
C
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
         WRITE (TEXT,100)
         NUMTXT = NUMSTA + NUMOPT - 1
         NDEC = NUMOPT - 1
         NUMBLD(1) = 4
         CALL LSTBOX (NUMBLD, NDEC, NUMOPT, NUMSTA, NUMTXT,  
     +                TEXT)
         NUMBLD(1) = 0
C
C Define NSAV
C
         IF (NDEC.GE.1 .AND. NDEC.LE.3) THEN
            NSAV = 1
         ELSEIF (NDEC.GE.4 .AND. NDEC.LE.6) THEN
            NSAV = 2
         ELSEIF (NDEC.GE.7 .AND. NDEC.LE.11) THEN
            NSAV = NDEC - 4
         ELSE
            NSAV = 0
         ENDIF
C
C Define NCOL, NROW, FNAME, TITLE
C
         IF (NSAV.GE.1 .AND. NSAV.LE.NUMSAV) THEN
            NCOL = NCSAV(NSAV)
            NROW = NRSAV(NSAV)
            FNAME = FSAV(NSAV)
            TITLE = TSAV(NSAV)
         ELSE
            NCOL = 0
            NROW = 0
            FNAME = BLANK
            TITLE = BLANK
         ENDIF
C
C Call the ANOVA routines
C
         IF (NDEC.GE.1 .AND. NDEC.LE.3) THEN
            JSEND = NDEC
            SUPPLY = .TRUE.
            CALL M_ANOVA1 (JSEND, NF, NIN,
     +                     SUPPLY)
         ELSEIF (NDEC.GE.4 .AND. NDEC.LE.6) THEN
            ISEND = 2
            KSEND = NDEC - 3
            CALL M_ANOVAM (ISEND, KSEND, NCOL, NF, NIN, NROW,
     +                     FNAME, TITLE)
         ELSEIF (NDEC.EQ.7) THEN
            ISEND = 3
            KSEND = 0
            CALL M_ANOVAM (ISEND, KSEND, NCOL, NF, NIN, NROW,
     +                     FNAME, TITLE)
         ELSEIF (NDEC.EQ.8) THEN
            ISEND = 4
            KSEND = 1
            CALL M_ANOVAM (ISEND, KSEND, NCOL, NF, NIN, NROW,
     +                     FNAME, TITLE)
         ELSEIF (NDEC.EQ.9) THEN
            ISEND = 5
            KSEND = 1
            CALL M_ANOVAM (ISEND, KSEND, NCOL, NF, NIN, NROW,
     +                     FNAME, TITLE)
         ELSEIF (NDEC.GE.10 .AND. NDEC.LE.13) THEN
            ISEND = NDEC - 4
            KSEND = NDEC - 9
            CALL M_ANOVAM (ISEND, KSEND, NCOL, NF, NIN, NROW,
     +                     FNAME, TITLE)
         ELSEIF (NDEC.EQ.14) THEN
            CALL VAREQ0 (NIN, NOUT)
           
         ELSEIF (NDEC.EQ.NUMOPT - 3) THEN
            CALL DEMDIR (ISEND,
     +                   PATH)
            ISEND = 2
            CALL VIEWER (ISEND,
     +                   FNAME, PATH, PATTERN)
         ELSEIF (NDEC.EQ.NUMOPT - 2) THEN
            CALL REVPRO (NOUT) 
         ELSEIF (NDEC.EQ.NUMOPT - 1) THEN
            WRITE (TEXT,200)
            NUMBLD(1) = 1
            NUMBLD(10) = 1
            NUMTXT = 23
            NEXT = .TRUE.
            CALL TUTOR1 (ICOLOR, NUMBLD, NUMTXT,
     +                   TEXT,
     +                   FRAME, NEXT, UPDOWN)
            NUMBLD(1) = 0
            NUMBLD(10) = 0
            WRITE (TEXT,300)
            NUMBLD(1) = 1
            NUMBLD(10) = 1
            NUMBLD(14) = 1
            NUMTXT = 22
            NEXT = .TRUE.
            CALL TUTOR1 (ICOLOR, NUMBLD, NUMTXT,
     +                   TEXT,
     +                   FRAME, NEXT, UPDOWN)
            NUMBLD(1) = 0
            NUMBLD(10) = 0
            NUMBLD(14) = 0
            WRITE (TEXT,400)
            NUMTXT = 23
            NEXT = .FALSE.
            NUMBLD(1) = 1
            NUMBLD(7) = 1
            NUMBLD(13) = 1
            CALL TUTOR1 (ICOLOR, NUMBLD, NUMTXT,
     +                   TEXT,
     +                   FRAME, NEXT, UPDOWN)
            NUMBLD(1) = 0
            NUMBLD(7) = 0
            NUMBLD(13) = 0
         ELSEIF (NDEC.EQ.NUMOPT) THEN
            AGAIN = .FALSE.
         ENDIF
C
C Define NCSAV, NRSAV, FSAV, TSAV
C
         IF (AGAIN .AND. NSAV.GT.0 .AND.
     +       NCOL.GT.1 .AND. NROW .GT.1) THEN
            NCSAV(NSAV) = NCOL
            NRSAV(NSAV) = NROW
            FSAV(NSAV) = FNAME
            TSAV(NSAV) = TITLE
         ENDIF
      ENDDO
C
C Format statements
C
  100 FORMAT (
     + 'The SIMSTAT ANOVA options'
     +/
     +/'1-way and Kruskal-Wallis nonparametric'
     +/'1-way only'
     +/'1-way Kruskal-Wallis only'
     +/'2-way and Friedman nonparametric'
     +/'2-way only'
     +/'2-way Friedman only'
     +/'Repeated measures'
     +/'Latin Squares'
     +/'Groups and subgroups'
     +/'Factorial: 0 blocks, 2 factors'
     +/'Factorial: k blocks, 2 factors'
     +/'Factorial: 0 blocks, 3 factors'
     +/'Factorial: k blocks, 3 factors'
     +/'Test variance homogeneity (Bartlett/Levene)'
     +/'View ANOVA test files'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit Simstat ANOVA options')
  200 FORMAT (
     + 'Analysis of variance (ANOVA)'
     +/   
     +/'Parametric tests for analysis of variance require that the data'
     +/'are normally distributed, and groups have equal variances. In'    
     +/'general, ANOVA techniques are robust to small deviations from'    
     +/'normality but transformations are often required to achieve'    
     +/'homogeneity of variance. Nonparametric techniques are weaker,'    
     +/'but do not require normality'   
     +/   
     +/'Transformations and tests for variance homogeneity'   
     +/   
     +/'In situations where the data are normally distributed, the'   
     +/'Bartlett test should be used. This is identical to the F test'  
     +/'with two groups of the same size but, with two groups, ANOVA'    
     +/'is equivalent to the t test, where Simfit routinely does the'   
     +/'Shapiro-Wilks normality test, and F test for variance equality.'   
     +/'The Levene test using medians should be used with non-normal'  
     +/'data, although means can be used with approximately normal data'   
     +/'while 5% trimmed means should be used with large tails (e.g.,'    
     +/'resembling a Cauchy distribution). Variance homogeneity tests'   
     +/'can be done interactively in order to explore the effects of'
     +/'variance stabilising transformations before resorting to'
     +/'routine data pre-processing.')   
  300 FORMAT (
     + '1-way ANOVA and/or Kruskal-Wallis (e.g. anova1.tf1)'
     +/'For a completely randomised design with no blocks and with'
     +/'not all samples of the same size, you can create separate'
     +/'vector files for the sets of observations at each treatment,'
     +/'then make a library file. You can also read in the individual'
     +/'files, or use multiple file selection from a project archive.'
     +/'However, with equal numbers of observations, it is best to make'
     +/'a data matrix. If H0 is rejected, you can do a Tukey-Q test.'
     +/
     +/'2-way row and column ANOVA and/or Friedman (e.g. anova2.tf2)'
     +/'For a randomised complete block design, make a data matrix with'
     +/'treatment occurring once in each block with no replicates.'
     +/
     +/'Repeated measures and/or Friedman (e.g. anova6.tf1)'
     +/'The data matrix must have rows corresponding to cases with'
     +/'columns of observations that are consistent with corresponding'
     +/'treatments, e.g. columns at same time points. If the sphericity'
     +/'test rejects homogeneous variance then treating repeat measures'
     +/'as a column-only variety of 2-way ANOVA may be invalid and you'
     +/'should consider fitting individual responses with appropriate'
     +/'longitudinal models or, if there are more rows than columns,'
     +/'you could think about using other techniques, e.g. MANOVA.')
  400 FORMAT (
     + 'Latin square design (e.g. anova3.tf1)'
     +/'Make a data matrix with treatment numbers 1 to n in the upper'
     +/'n by n part of the matrix in the form of a Latin Square, and'
     +/'the lower n by n part of the matrix containing observations.'
     +/'You can use random Latin squares generated by SIMSTAT.'
     +/
     +/'Groups and subgroups design (e.g. anova4.tf1)'
     +/'For hierarchical classification and subgroups of possibly'
     +/'unequal sizes, make a data matrix with column 1 = group,'
     +/'column 2 = subgroup and column 3 = replicates. Groups and'
     +/'subgroups must be as consecutive, nondecreasing integers.'
     +/
     +/'Factorial design (e.g. anova5.tfl, anova5.tf2)'
     +/'If there is no blocking (i.e. no. blocks = 1) then set column 1'
     +/'equal to 1. If there are n blocks the data must be arranged so'
     +/'that block 1 occurs first, then block 2, etc. so column 1 must'
     +/'have consecutive nondecreasing integers from 1 to n. Column 2'
     +/'must contain nondecreasing integers corresponding to levels of'
     +/'factor A (within blocks). Column 3 must contain nondecreasing'
     +/'integers corresponding to levels of factor B (within levels of'
     +/'factor A within blocks) and so on. The last column must be the'
     +/'observations corresponding to the blocks in column 1 and the'
     +/'levels of factors in columns, 2, 3, and so on.')
      END
C
C
