C
C
      SUBROUTINE M_POLBIN (NIN, NOUT)
C
C ACTION: temporary front end to POLBIN
C AUTHOR: w.g.bardsley, university of manchester, u.k., 28/02/2006
C         21/02/2015 added INTENT and increased NGRAF to 240 
C
      IMPLICIT NONE
C
C Arguments
C
      INTEGER, INTENT (IN) :: NIN, NOUT
C
C Local allocatable arrays
C
      DOUBLE PRECISION, ALLOCATABLE :: T(:), W(:), X(:), XGRAF(:),
     +                                 YGRAF(:), Z(:,:)
C
C Locals
C
      INTEGER    NGRAF, NMAX, NPOLY, NZXY
      PARAMETER (NGRAF = 240, NPOLY = 101, NMAX = NPOLY, NZXY = 1)
      INTEGER    I, IERR, IFAIL, ISEND, NPTS, NPTS1
      PARAMETER (NPTS1 = 4)
      DOUBLE PRECISION ZX(NZXY), ZY(NZXY), X1(NPTS1)
      DOUBLE PRECISION XMAX, XMIN
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      LOGICAL    YESNO
      LOGICAL    ABORT, FIXNPT, LABEL
      PARAMETER (FIXNPT = .FALSE., LABEL = .TRUE.)
      CHARACTER  FNAME*1024, TITLE*80
      EXTERNAL   GETL01
      EXTERNAL   VEC1IN, POLBIN, PUTADV, PUTIFA
      SAVE       XMAX, XMIN
      DATA       XMAX, XMIN / 100.0D+00, 0.01D+00 /
      DATA       X1 / 1.0D+02, 1.0D+01, 1.0D+00, 1.0D-01 /       
      IERR = 0
      IF (ALLOCATED(T)) DEALLOCATE(T, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(W)) DEALLOCATE(W, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(XGRAF)) DEALLOCATE(XGRAF, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(YGRAF)) DEALLOCATE(YGRAF, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(Z)) DEALLOCATE(Z, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(T(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(W(8*NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(X(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(XGRAF(NGRAF), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(YGRAF(NGRAF), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(Z(2,NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      YESNO = .TRUE.  
      CALL GETL01 (
     +'Use default binding constants (otherwise input your own values)', 
     +YESNO)  
      IF (YESNO) THEN
         ABORT = .FALSE.
         NPTS = NPTS1
         DO I = 1, NPTS1
            X(I) = X1(I)
         ENDDO   
      ELSE      
         CALL PUTADV (
     +'Input n positive overall binding constants K(1), (2),..., K(n)')
         ISEND = 3
         CALL VEC1IN (ISEND, NIN, NMAX, NPTS,
     +                X,
     +                FNAME, TITLE,
     +                ABORT, FIXNPT, LABEL)
         IF (.NOT.ABORT) THEN
            DO I = 1, NPTS
               IF (X(I).LE.ZERO) ABORT = .TRUE.
            ENDDO
            IF (ABORT) CALL PUTADV ('K(i) must be positive')
         ENDIF
      ENDIF
      IF (.NOT.ABORT) THEN
         CALL POLBIN (IFAIL, NOUT, NGRAF, NMAX, NPTS, NZXY,
     +                T, X, W, XGRAF, XMAX, XMIN, YGRAF, Z, ZX, ZY)
         CALL PUTIFA (IFAIL, NOUT, 'POLBIN/M_POLBIN')
      ENDIF
      DEALLOCATE(T, STAT = IERR)
      DEALLOCATE(W, STAT = IERR)
      DEALLOCATE(X, STAT = IERR)
      DEALLOCATE(XGRAF, STAT = IERR)
      DEALLOCATE(YGRAF, STAT = IERR)
      DEALLOCATE(Z, STAT = IERR)
      END
C
C





