
c
c
      subroutine m_zeros1 (nout, nx,
     +                     x,
     +                     titlex)
c
c action: call zeros1 for zeros of a polynomial
c author: w.g.bardsley, university of manchester, u.k., 04/02/2006
c
c   nout: (input/unchanged) preconnected unit for results
c     nx: (input/unchanged) number of coefficients
c      x: (input/unchanged) vector of coefficients
c titlex: (input/unchanged) title of polynomial
c
      implicit   none
c
c arguments
c
      integer    nout, nx
      double precision x(nx)
      character  titlex*(*)
c
c local allocatable workspaces
c
      double precision, allocatable :: w(:), z(:,:)
c
c locals
c
      integer    icount, ierr, m, n, nin, nrmax
      integer    nmax, nmin
      parameter (nmax = 101, nmin = 1)
      character  line*100
      character (len = 12) i12, form12 
      logical    abort, dsplay, file, supply
      parameter (dsplay = .true., file = .true., supply = .true.)
      external   zeros1, putfat, form12
      save       icount
      data       icount / 0 /
      if (nx.lt.nmin) then
c
c too few coefficients
c
         write (line,100) nmin - 1
         call putfat (line)
      elseif (nx.gt.nmax) then
c
c too many coefficients
c
         write (line,200) nmax - 1
         call putfat (line)
      else
c
c allocate workspace then call zeros1
c
         nin = 3
         m = nx
         n = nx - 1
         nrmax = m
         ierr = 0
         if (allocated(w)) deallocate(w, stat = ierr)
         if (ierr.ne.0) return
         if (allocated(z)) deallocate(z, stat = ierr)
         if (ierr.ne.0) return
         allocate(w(2*(nrmax + 1)), stat = ierr)
         if (ierr.ne.0) return
         allocate(z(nrmax,2), stat = ierr)
         if (ierr.ne.0) return
         icount = icount + 1
         i12 = form12(nx - 1)
         write (nout,300) icount, trim(i12), titlex
         call zeros1 (m, n, nin, nout, nrmax,
     +                x, w, z,
     +                abort, dsplay, file, supply)
         deallocate(w, stat = ierr)
         deallocate(z, stat = ierr)
      endif
  100 format ('Degree of polynomial <',i3)
  200 format ('Degree of polynomial >',i4)
  300 format (
     +/'Analysis of polynomial',i3,1x,'(degree =',1x,a,')'
     +/'=========================='
     +/'Data:',1x,a)
      end
c
c

