C
C
      SUBROUTINE ANOVA0 (IWRK, JWRK, NCMAX, NF, NIN, NRMAX, NSMALL,
     +                   A1,
     +                   FSAV, TSAV,
     +                   USE1)
C
C ACTION: Call Analysis of Variance routines
C AUTHOR: W. G. Bardsley, University of Manchester, U.K., 1/2/95
C         16/12/1996 Transferred from FTEST to DLL
C         30/04/1997 win32 version
C         06/07/2000 added ANOVA4
C         27/04/2002 added repeated-measurements
C         21/09/2003 redimensioned IWRK and added A1, A2, A3, ANOVA5,
C                    SPHER1, MATTIN, etc.
C         08/04/2005 added JSEND and KSEND to re-initialise NTYPE in
C                    ANOVA1 and ANOVA2 if required
C         10/01/2006 deleted A2 and A3 from argumentlist and calls to ANOVA2
C         16/01/2006 introduced allocatable workspaces
C         27/03/2006 added NYMAX, GBAR, NEWDAT, SUPPLY
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    NCMAX, NRMAX, NSMALL
      INTEGER    IWRK(3*NRMAX), JWRK(NCMAX,NCMAX), NF, NIN
      DOUBLE PRECISION A1(NRMAX,NCMAX)
      CHARACTER  FSAV(NSMALL)*(*), TSAV(NSMALL)*(*)
      LOGICAL    USE1(NSMALL)
C
C Local allocatable arrays
C
      DOUBLE PRECISION, ALLOCATABLE :: B(:), GBAR(:), X(:), Y(:), Z(:)
C
C Locals
C
      INTEGER    NMAX, NOMAX
      INTEGER    ICOLOR, NUMOPT, NUMSTA
      PARAMETER (ICOLOR = 9, NUMOPT = 13, NUMSTA = 3)
      INTEGER    NDEC, NUMTXT
      INTEGER    MODE
      PARAMETER (MODE = 0)
      INTEGER    NUMBLD(30)
      INTEGER    IERR, ISEND, ITYPE, JSEND, KSEND
      INTEGER    NVAL(12)
      CHARACTER  TEXT(30)*100
      CHARACTER  CVAL(12)*1024, FNAME*1024, PATH*1024, TITLE*80
      CHARACTER  PATTERN*10
      PARAMETER (PATTERN = 'anova?.tf?')
      LOGICAL    AGAIN, MATRIX
      LOGICAL    FRAME, UPDOWN, NEXT
      PARAMETER (FRAME = .FALSE., UPDOWN = .TRUE.)
      LOGICAL    NEWDAT, SUPPLY
      PARAMETER (SUPPLY = .FALSE.)
      EXTERNAL   ANOVA1, ANOVA2, ANOVA3, ANOVA4, ANOVA5
      EXTERNAL   LSTBOX, VIEWER, CONFIG, TUTOR1
      INTRINSIC  MAX
      DATA       NUMBLD / 30*0 /
C
C Allocate workspace
C
      IERR = 0
      IF (ALLOCATED(B)) DEALLOCATE(B, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(GBAR)) DEALLOCATE(GBAR, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(Y)) DEALLOCATE(Y, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(Z)) DEALLOCATE(Z, STAT = IERR)
      IF (IERR.NE.0) RETURN
      NMAX = NRMAX*MAX(NCMAX,NSMALL)
      NOMAX = MAX(NCMAX,NSMALL)
      ALLOCATE(B(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(GBAR(NSMALL), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(X(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(Y(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(Z(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Main loop
C
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
         WRITE (TEXT,100)
         NDEC = NUMOPT - 1
         NUMTXT = NUMSTA + NUMOPT - 1
         NUMBLD(1) = 4
         CALL LSTBOX (NUMBLD, NDEC, NUMOPT, NUMSTA, NUMTXT, 
     +                TEXT)
         NUMBLD(1) = 0
         IF (NDEC.EQ.1) THEN
            JSEND = 1
            CALL ANOVA1 (JSEND, NCMAX, NF, NIN, NMAX, IWRK, NOMAX,
     +                   NRMAX, NSMALL,
     +                   A1, B, GBAR, X, Y,
     +                   FSAV, TSAV,
     +                   MATRIX, NEWDAT, SUPPLY, USE1)
         ELSEIF (NDEC.EQ.2) THEN
            JSEND = 2
            CALL ANOVA1 (JSEND, NCMAX, NF, NIN, NMAX, IWRK, NOMAX,
     +                   NRMAX, NSMALL,
     +                   A1, B, GBAR, X, Y,
     +                   FSAV, TSAV,
     +                   MATRIX, NEWDAT, SUPPLY, USE1)
         ELSEIF (NDEC.EQ.3) THEN
            JSEND = 3
            CALL ANOVA1 (JSEND, NCMAX, NF, NIN, NMAX, IWRK, NOMAX,
     +                   NRMAX, NSMALL,
     +                   A1, B, GBAR, X, Y,
     +                   FSAV, TSAV,
     +                   MATRIX, NEWDAT, SUPPLY, USE1)
         ELSEIF (NDEC.EQ.4) THEN
            ISEND = 1
            KSEND = 1
            CALL ANOVA2 (ISEND, KSEND, NCMAX, NF, NIN, NMAX, NRMAX,
     +                   A1, B, X, Y,
     +                   FNAME, TITLE,
     +                   NEWDAT, SUPPLY, USE1)
         ELSEIF (NDEC.EQ.5) THEN
            ISEND = 1
            KSEND = 2
            CALL ANOVA2 (ISEND, KSEND, NCMAX, NF, NIN, NMAX, NRMAX,
     +                   A1, B, X, Y,
     +                   FNAME, TITLE,
     +                   NEWDAT, SUPPLY, USE1)
         ELSEIF (NDEC.EQ.6) THEN
            ISEND = 1
            KSEND = 3
            CALL ANOVA2 (ISEND, KSEND, NCMAX, NF, NIN, NMAX, NRMAX,
     +                   A1, B, X, Y,
     +                   FNAME, TITLE,
     +                   NEWDAT, SUPPLY, USE1)
         ELSEIF (NDEC.EQ.7) THEN
            CALL ANOVA3 (NCMAX, JWRK, NF, NIN, NRMAX,
     +                   A1, X(1), X(NCMAX + 1), X(2*NCMAX + 2), B, Y,
     +                   FNAME, TITLE,
     +                   NEWDAT, SUPPLY)
         ELSEIF (NDEC.EQ.8) THEN
            CALL ANOVA4 (NCMAX, NF, NIN, NRMAX,
     +                   A1, B, X, Y, Z,
     +                   FNAME, TITLE,
     +                   NEWDAT, SUPPLY)
         ELSEIF (NDEC.EQ.9) THEN
            CALL ANOVA5 (ITYPE, IWRK, NCMAX, NF, NIN, NRMAX,
     +                   A1, B, X, Y, Z,
     +                   FNAME, TITLE,
     +                   NEWDAT, SUPPLY)
         ELSEIF (NDEC.EQ.10) THEN
            ISEND = 2
            KSEND = 2
            CALL ANOVA2 (ISEND, KSEND, NCMAX, NF, NIN, NMAX, NRMAX,
     +                   A1, B, X, Y,
     +                   FNAME, TITLE,
     +                   NEWDAT, SUPPLY, USE1)
         ELSEIF (NDEC.EQ.11) THEN
            CALL CONFIG (MODE, NVAL, CVAL)
            PATH = CVAL(3)
            ISEND = 2
            CALL VIEWER (ISEND, FNAME, PATH, PATTERN)
         ELSEIF (NDEC.EQ.NUMOPT - 1) THEN
            WRITE (TEXT,200)
            NUMBLD(1) = 1
            NUMBLD(7) = 1
            NUMBLD(11) = 1
            NUMBLD(17) = 1
            NUMTXT = 21
            NEXT = .TRUE.
            CALL TUTOR1 (ICOLOR, NUMBLD, NUMTXT,
     +                   TEXT,
     +                   FRAME, NEXT, UPDOWN)
            NUMBLD(7) = 0
            NUMBLD(11) = 0
            NUMBLD(17) = 0
            NUMBLD(13) = 1
            WRITE (TEXT,300)
            NUMTXT = 21
            NEXT = .FALSE.
            CALL TUTOR1 (ICOLOR, NUMBLD, NUMTXT,
     +                   TEXT,
     +                   FRAME, NEXT, UPDOWN)
            NUMBLD(13) = 0
         ELSEIF (NDEC.EQ.NUMOPT) THEN
            AGAIN = .FALSE.
         ENDIF
      ENDDO
C
C Deallocate workspaces
C
      DEALLOCATE(B, STAT = IERR)
      DEALLOCATE(GBAR, STAT = IERR)
      DEALLOCATE(X, STAT = IERR)
      DEALLOCATE(Y, STAT = IERR)
      DEALLOCATE(Z, STAT = IERR)
C
C Format statements
C
  100 FORMAT (
     + 'The SIMSTAT ANOVA options'
     +/
     +/'1-way and Kruskal-Wallis nonparametric'
     +/'1-way only'
     +/'1-way Kruskal-Wallis only'
     +/'2-way and Friedman nonparametric'
     +/'2-way only'
     +/'2-way Friedman only'
     +/'Latin Square'
     +/'Groups and subgroups'
     +/'Factorial design'
     +/'Repeated measures'
     +/'View test files'
     +/'Help'
     +/'Quit ... Exit ANOVA options')
  200 FORMAT (
     + '1-way ANOVA and/or Kruskal-Wallis (e.g. anova1.tfl)'
     +/'For a completely randomised design with no blocks, create'
     +/'vector files for the replicate observations at each treatment'
     +/'then make a library file. With equal numbers of replicates a'
     +/'data matrix can be input. Use Tukey-Q if H0 is rejected.'
     +/
     +/'2-way row and column ANOVA and/or Friedman (e.g. anova2.tf2)'
     +/'For a randomised complete block design, make a data matrix with'
     +/'treatment occurring once in each block with no replicates.'
     +/
     +/'Latin square design (e.g. anova3.tf1)'
     +/'Make a data matrix with treatment numbers 1 to n in the upper'
     +/'n by n part of the matrix in the form of a Latin Square, and'
     +/'the lower n by n part of the matrix containing observations.'
     +/'Use random Latin squares generated by simfit.'
     +/
     +/'Groups and subgroups design (e.g. anova4.tf1)'
     +/'For hierarchical classification and subgroups of possibly'
     +/'unequal sizes, make a data matrix with column 1 = group,'
     +/'column 2 = subgroup and column 3 = replicates. Groups and'
     +/'subgroups must be as consecutive, nondecreasing integers.')
  300 FORMAT (
     + 'Factorial design (e.g. anova5.tfl, anova5.tf2)'
     +/'If there is no blocking (i.e. no. blocks = 1) then set column 1'
     +/'equal to 1. If there are n blocks the data must be arranged so'
     +/'that block 1 occurs first, then block 2, etc. so column 1 must'
     +/'have consecutive nondecreasing integers from 1 to n. Column 2'
     +/'must contain nondecreasing integers corresponding to levels of'
     +/'factor A (within blocks). Column 3 must contain nondecreasing'
     +/'integers corresponding to levels of factor B (within levels of'
     +/'factor A within blocks) and so on. The last column must be the'
     +/'observations corresponding to the blocks in column 1 and the'
     +/'levels of factors in columns, 2, 3, and so on.'
     +/
     +/'Repeated measures and/or Friedman (e.g. anova6.tf1)'
     +/'The data matrix must have rows corresponding to cases with'
     +/'columns of observations that are consistent with corresponding'
     +/'treatments, e.g. columns at same time points. If the sphericity'
     +/'test rejects homogeneous variance then treating repeat measures'
     +/'as a column-only variety of 2-way ANOVA may be invalid and you'
     +/'should consider fitting individual responses with appropriate'
     +/'longitudinal models or, if there are more rows than columns,'
     +/'you could think about using other techniques, e.g. MANOVA.')
      END
C
C
