C
C
      SUBROUTINE ANOVA1 (JSEND, NCMAX, NF, NIN, NMAX, NOBS, NOMAX,
     +                   NRMAX, NSMALL,
     +                   A, B, GBAR, X, Y,
     +                   FSAV, TSAV,
     +                   MATRIX, NEWDAT, SUPPLY, USE1)
C
C ACTION: One way ANOVA
C AUTHOR: W. G. Bardsley, University of Manchester, U.K., 31/1/95
C         16/12/1996 Transferred from FTEST to DLL
C         30/04/1997 win32 version
C         10/12/1999 added Tukey Q
C         24/06/2000 extensive revision and provided choice for methods
C                    NTYPE = 1: Parametric and Nonparametric
C                    NTYPE = 2: Parametric
C                    NTYPE = 3: Nonparametric
C                    Also created temporary files from matrix input
C         13/10/2000 warned about Tukey
C         21/04/2002 added EBPLOT$
C         18/11/2002 added means only plot
C         29/11/2002 corrected error caused by introducing means only plot
C         13/01/2003 alternatives 'Diagrama de Baras' and 'Diagrama de Whiskers'
C                    and transformed all USE to USE1
C         16/05/2003 added call to PFILES
C         08/04/2005 added JSEND to argument list to re-initialise NTYPE
C         27/03/2006 added NOMAX, MATRIX, NEWDAT, SUPPLY to arguments, and
c                    allocated LTEMP, now NMAX >= max. overall sample size
C                    as Y holds all data, FTEMP deleted, and also extensive
C                    revision
C         02/03/2009 introduced READY for plots etc.
C         17/03/2011 added call to RPPLOT$ 
C         21/03/2012 replaced EBPLOT$ and BWPLOT$ by EBPLOT and BWPLOT
C         27/07/2014 added INTENTS
C         21/09/2016 added BWPLUS, BLANK13/BLANK8, DOT13/DOT8 and improved some other code
C         23/08/2020 initialised logical variables
C         16/08/2021 added E_NUMBERS and E_FORMATS, etc.
C         04/07/2022 corrected errors only encountered in /CHECKMATE with the definition of D13(i) depending on NTYPE
C
C The arguments depend on whether SUPPLY = .TRUE. as follows:
C  JSEND: (input/unchanged) input value for NTYPE
C  NCMAX: (input/unchanged) max. col. dimension for A depending on SUPPLY
C     NF: (input/unchanged) preconnected unit for results
C    NIN: (input/unchanged) unconnected unit for reading in data
C   NMAX: (input/unchanged) max. overall data size depending on SUPPLY
C   NOBS: (input/output) observations per column or file depending on SUPPLY
C  NOMAX: (input/unchanged) max. no. columns or files depending on SUPPLY
C  NRMAX: (input/unchanged) max. row dimension for A
C NSMALL: (input/unchanged) max. no. of vector files
C      A: (input/output) depending on SUPPLY
C      B: workspace...must have dimension >= size of data set
C   GBAR: workspace...must have dimension >= no. of columns/files
C      X: workspace...must have dimension >= size of data set
C      Y: workspace...mjust have dimension >= size of data set
C   FSAV: (input/output) vector file names depending on SUPPLY
C   TSAV: (input/output) vector file titles depending on SUPPLY
C NEWDAT: (output) used to request another data set
C MATRIX: (input/output) depending on SUPPLY
C SUPPLY: (input/unchanged) as follows:
C   USE1: workspace
C
C Note: When SUPPLY = .TRUE. and MATRIX = .TRUE.
C       ========================================
C       Data matrix A is supplied with NOMAX >= NCOL and NMAX >= NCOL*NROW
C       but only FSAV(1) and TSAV(1) are referenced so NSMALL > = 1
C       Also all NOBS(i) = NROW
C       When SUPPLY = .TRUE. and MATRIX = .FALSE.
C       =========================================
C       FSAV, TSAV, and NOBS, are supplied so NOMAX >= NSMALL > 1
C       A is not referenced so MAX >= 1, and NCMAX >= 1
C       The NOBS(i) must equal the individual file sizes and
C       NMAX >= sum of all NOBS(i)
C       Other cases
C       ===========
C       Data can be read in interactively as a matrix or vector files
C       so preferably NCMAX = NSMALL = NOMAX >> 1, NRMAX >>1, and
C       NMAX >= NCMAX*NRMAX
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NCMAX, NMAX, NOMAX, NRMAX, 
     +                                       NSMALL
      INTEGER,             INTENT (IN)    :: JSEND, NF, NIN
      INTEGER,             INTENT (INOUT) :: NOBS(NOMAX)
      DOUBLE PRECISION,    INTENT (INOUT) :: A(NRMAX,NCMAX), B(NMAX),
     +                                       GBAR(NOMAX), X(NMAX),
     +                                       Y(NMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FSAV(NSMALL), TSAV(NSMALL)
      LOGICAL,             INTENT (INOUT) :: MATRIX, USE1(NOMAX)
      LOGICAL,             INTENT (IN)    :: SUPPLY
      LOGICAL,             INTENT (OUT)   :: NEWDAT
C
C Local allocatable arrays
C
      INTEGER, ALLOCATABLE :: NSORT(:)
      CHARACTER (LEN = 4), ALLOCATABLE :: LTEMP(:)
      CHARACTER (LEN = 6), ALLOCATABLE :: COLUMN(:)
C
C Locals
C
      INTEGER    NCOL, NFILES, NROW
      INTEGER    I, IERR, ISEND, J, IDF(3), IFAIL, N, K, L
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NOPT, NSTART, NUMTXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 0)
      INTEGER    NDEC, NUMBLD(30), NUMPOS(20)
      INTEGER    ICOUNT, NTYPE
      INTEGER    IPREV, ITYPE, NBIG, NOUT1, NTEMP, NTOP
      PARAMETER (ITYPE = 2)
      INTEGER    N0, N1, N2, N3, N5
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N5 = 5)
      DOUBLE PRECISION ONE, F100, PNT05
      PARAMETER (ONE = 1.0D+00, F100 = 100.0D+00, PNT05 = 0.05D+00)
      DOUBLE PRECISION EPSI, F, FP, GM, H, P, SS(3), XTEMP
      DOUBLE PRECISION G01CEF$, RTOL, X02AMF$, XTOL, ZTOL, X02AJF$
      CHARACTER (LEN = 1024) FNAME
      CHARACTER (LEN = 100 ) LINE, TEXT(30)
      CHARACTER (LEN = 80  ) CHOP80, TITLE, TRIM80
      CHARACTER (LEN = 40  ) INFO, TTEMP(4)
      CHARACTER (LEN = 20  ) BANDW, SYMBOL, TYPE1
      CHARACTER (LEN = 13  ) BLANK13, DOT13
      PARAMETER (BLANK13 = '             ', DOT13 = '    ...      ')
      CHARACTER (LEN = 13  ) D13(8), SHOWRJ, SHOWLJ
      CHARACTER (LEN = 8   ) BLANK8, DOT8
      PARAMETER (BLANK8 = '        ', DOT8 = '  ...   ')
      CHARACTER (LEN = 6   ) WORD6
      CHARACTER (LEN = 1   ) BLANK
      PARAMETER (BLANK = ' ',
     +           INFO = 'Tick columns required')
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    TAB_BOT, TAB_MID, TAB_TOP
      PARAMETER (TAB_TOP = .TRUE., TAB_MID = .TRUE., TAB_BOT = .TRUE.)
      LOGICAL    FIXCOL, FIXROW, LABEL
      PARAMETER (FIXCOL = .FALSE., FIXROW = .FALSE., LABEL = .TRUE.)
      LOGICAL    ABORT, AGAIN, LIBFIL, OK, PROJ, READY, TUKEY
      EXTERNAL   E_FORMATS, SHOWRJ, SHOWLJ
      EXTERNAL   PUTADV, PUTIFA, MATTIN, TBOX01, TABLE1, TRIML1, GETNOU,
     +           VECFIL, TUKEYQ, PUTWAR, PFILES, CHKBOX, CHOP80, TRIM80,
     +           ISITMF
      EXTERNAL   BWPLOT, GKS001, EBPLOT, RPPLOT, BWPLUS
      EXTERNAL   G01CEF$, G04AEF$, G08AFF$, X02AMF$, X02AJF$
      INTRINSIC  SQRT, LOG, ASIN, DBLE, MIN, MAX
      SAVE       ICOUNT, NTYPE
      DATA       ICOUNT, NTYPE / 0, 1 /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / 20*1 /
C
C Initialise logical variables at 23/08/2020 because OK and/or AGAIN were giving problems 
C      
      ABORT = .FALSE.
      AGAIN = .FALSE.
      LIBFIL = .FALSE.
      OK = .FALSE.
      PROJ = .FALSE.
      READY = .FALSE.
      TUKEY = .FALSE.  
C
C Initialise NEWDAT and check if SUPPLY = .true.
C
      NEWDAT = .FALSE.
      IF (NCMAX.LT.N1 .OR. NOMAX.LT.N1 .OR. NRMAX.LT.N1 .OR.
     +    NSMALL.LT.N1 .OR. NMAX.LT.N3) RETURN
      IF (SUPPLY) THEN
         IF (MATRIX) THEN
            FNAME = FSAV(1)
            CALL ISITMF (NCOL, NROW,
     +                   FNAME)
            IF (NCOL.LT.N2 .OR. NROW.LT.N2 .OR. NROW.GT.NRMAX .OR.
     +          NCOL.GT.NOMAX .OR. NCOL*NROW.GT.NMAX) RETURN
            NFILES = NCOL
            TITLE = TSAV(1)
         ELSE
            IF (NSMALL.LT.N2 .OR. NSMALL.GT.NOMAX) RETURN
            NFILES = NSMALL
         ENDIF
         NDEC = N3
      ELSE
         NFILES = N0
         NDEC = N1
      ENDIF
      E_NUMBERS = E_FORMATS()
C      
C Allocate
C
      IERR = N0
      IF (ALLOCATED(NSORT)) DEALLOCATE(NSORT, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(LTEMP)) DEALLOCATE(LTEMP, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(COLUMN)) DEALLOCATE(COLUMN, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      NBIG = MAX(NCMAX,NSMALL)
      NTEMP = NBIG
      ALLOCATE(NSORT(NBIG), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE(LTEMP(NTEMP), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE(COLUMN(NBIG), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      DO I = N1, NTEMP
         WRITE (COLUMN(I),'(I6)') I
      ENDDO
C
C Check value of JSEND
C
      IF (JSEND.GE.1 .AND. JSEND.LE.3) NTYPE = JSEND
C
C Initialise (Note: in this version NTEMP = NSMALL...may change in future)
C
      DO I = N1, NOMAX
         USE1(I) = .TRUE.
      ENDDO
      IPREV = N0
      RTOL = 1.0D+09*X02AMF$()
      EPSI = 1.0D+01*X02AJF$()
      XTOL = ONE - EPSI
      ZTOL = ONE/RTOL
      NTOP = MIN(NTEMP,NSMALL)
      READY = .FALSE.
      TUKEY = .FALSE.
      BANDW = '(NA)'
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
C
C Main menu
C
         IF (TUKEY .AND. NTYPE.NE.3) THEN
             WRITE (SYMBOL,'(I4,'' comparisons'')') (K*(K - 1))/2
             CALL TRIML1 (SYMBOL)
         ELSE
             SYMBOL = '(NA)'
         ENDIF
         IF (TUKEY) THEN
            WRITE (BANDW,'(I3,2X,A)') K, 'columns'
            CALL TRIML1 (BANDW)
            READY = .TRUE.
         ELSE
            READY = .FALSE.
            BANDW = '(NA)'
         ENDIF
         IF (NTYPE.EQ.1) THEN
            TYPE1 = 'Both'
         ELSEIF (NTYPE.EQ.2) THEN
            TYPE1 = 'Parametric'
         ELSE
            TYPE1 = 'Nonparametric'
         ENDIF
         WRITE (TEXT,100) SYMBOL, BANDW, BANDW, BANDW, BANDW, BANDW, 
     +                    TYPE1
         NOPT = 19
         NSTART = 7
         NUMTXT = NSTART + NOPT - 1
         NUMBLD(1) = 1
         CALL TBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, NOPT,
     +                NUMPOS, NSTART, NUMTXT,
     +                TEXT,
     +                TAB_TOP, TAB_MID, TAB_BOT)
         NUMBLD(1) = 0
C
C Check if consistent or return requested
C
         IF (NDEC.GT.1 .AND. NDEC.LT.NOPT .AND. NFILES.LT.N2) THEN
            CALL PUTADV ('First input your current data')
            NDEC = N1
            OK = .FALSE.
            TUKEY = .FALSE.
         ELSEIF (NDEC.EQ.1) THEN
C
C NDEC = 1: Data input ... First find out input type required
C =========
C
            READY = .FALSE.
            IF (SUPPLY) THEN
               NEWDAT = .TRUE.
               DEALLOCATE(NSORT, STAT = IERR)
               DEALLOCATE(LTEMP, STAT = IERR)
               DEALLOCATE(COLUMN, STAT = IERR)
               RETURN
            ENDIF
            OK = .FALSE.
            READY = .FALSE.
            TUKEY = .FALSE.
            NOPT = 4
            NDEC = NOPT - 1
            NSTART = 7
            NUMTXT = NSTART + NOPT - 1
            WRITE (TEXT,200)
            NUMBLD(1) = 4
            CALL TBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, NOPT,
     +                   NUMPOS, NSTART, NUMTXT,
     +                   TEXT,
     +                   TAB_TOP, TAB_MID, TAB_BOT)
            NUMBLD(1) = 0
            IF (NDEC.EQ.1) THEN
               IPREV = N0
               MATRIX = .TRUE.
               LIBFIL = .FALSE.
               PROJ = .FALSE.
            ELSEIF (NDEC.EQ.2) THEN
               MATRIX = .FALSE.
               LIBFIL = .FALSE.
               PROJ = .FALSE.
            ELSEIF (NDEC.EQ.3) THEN
               MATRIX = .FALSE.
               LIBFIL = .TRUE.
               PROJ = .FALSE.
            ELSE
               MATRIX = .FALSE.
               LIBFIL = .FALSE.
               PROJ = .TRUE.
            ENDIF
            IF (MATRIX) THEN
C
C Read in a data matrix
C
               ISEND = N0
               CLOSE (UNIT = NIN)
               FNAME = 'Data typed in interactively'
               CALL MATTIN (ISEND, NCMAX, NCOL, NIN, NRMAX, NROW,
     +                      A, B,
     +                      FNAME, TITLE,
     +                      ABORT, FIXCOL, FIXROW, LABEL)
               CLOSE (UNIT = NIN)
               IF (ABORT) NCOL = N0
               IF (NCOL.LT.N2) NCOL = N0
               NFILES = MIN(NCOL,NTOP)
               IF (NCOL.GE.N2) THEN
                  DO I = N1, NFILES
                     NOBS(I) = NROW
                  ENDDO
               ENDIF
            ELSEIF (.NOT.PROJ) THEN
C
C Read in files
C
               CALL VECFIL (NFILES, NIN, NMAX, NTOP,
     +                      X,
     +                      FSAV, TSAV,
     +                      ABORT, LIBFIL)
               IF (NFILES.LT.N2) NFILES = N0
               IF (.NOT.ABORT .AND. NFILES.GT.N1) THEN
                  DO I = N1, NFILES
                     USE1(I) = .TRUE.
                 ENDDO
               ENDIF
            ELSEIF (PROJ) THEN
C
C Project archive
C
               CALL GETNOU (NOUT1)
               CLOSE (UNIT = NOUT1)
               CALL PFILES (IPREV, ITYPE, NFILES, NIN, NTOP, NOUT1,
     +                      FSAV,
     +                      USE1)
               CLOSE (UNIT = NOUT1)
               IF (NFILES.GT.N1) THEN
                  ABORT = .FALSE.
                  DO I = N1, NFILES
                     USE1(I) = .TRUE.
                  ENDDO
               ELSE
                  ABORT = .TRUE.
                  NFILES = N0
               ENDIF
            ENDIF
            IF (ABORT .OR. NFILES.LT.N2) THEN
               NDEC = 1
            ELSE
               NDEC = 3
            ENDIF
            IF (NFILES.LT.N2) CALL PUTADV (
     +         'Must have at least 2 columns')
         ELSEIF (NDEC.EQ.2) THEN
C
C Add/delete data columns
C

            READY = .FALSE. 
            TUKEY = .FALSE.
            OK = .TRUE.
            DO WHILE (OK)
               CALL CHKBOX (NFILES,
     +                      COLUMN, INFO,
     +                      USE1)
               J = N0
               DO I = N1, NFILES
                  IF (USE1(I)) J = J + N1
               ENDDO
               IF (J.LT.N2) THEN
                  CALL PUTADV ('Must have at least 2 columns')
                  OK = .TRUE.
               ELSE
                  OK = .FALSE.
               ENDIF
            ENDDO
            NDEC = 3
         ELSEIF (NDEC.LT.12) THEN
C
C 1 < NDEC < 12: Do ANOVA
C ==============
C
            READY = .FALSE.
            OK = .TRUE.
            N = N0
            K = N0
            DO I = N1, NFILES
               IF (OK .AND. USE1(I)) THEN
                  K = K + N1
                  IF (.NOT.MATRIX) THEN
                     CLOSE (UNIT = NIN)
                     OPEN (UNIT = NIN, FILE = FSAV(I))
                     READ (NIN,'(A)') TITLE
                     READ (NIN,*) NOBS(K), J
                  ENDIF
                  NSORT(K) = I
                  DO J = N1, NOBS(K)
                     IF (N.LT.NMAX) THEN
                        N = N + N1
                     ELSE
                        CALL PUTADV ('Sample size is too large')
                        DEALLOCATE(LTEMP, STAT = IERR)
                        RETURN
                     ENDIF
                     IF (MATRIX) THEN
                        Y(N) = A(J,I)
                     ELSE
                        READ (NIN,*) Y(N)
                     ENDIF
                     IF (NDEC.GT.3) THEN
C
C Variance stabilising transformation requested
C
                        IF (Y(N).GT.RTOL) THEN
                           IF (NDEC.EQ.4) THEN
                              Y(N) = LOG(Y(N))
                           ELSEIF (NDEC.EQ.5) THEN
                              Y(N) = SQRT(Y(N))
                           ELSEIF (NDEC.LE.8) THEN
                              F = Y(N)/F100
                              IF (F.LE.EPSI .OR. F.GE.XTOL) THEN
                                 CALL PUTADV ('x out of range for % ?')
                                 NDEC = N1
                                 OK = .FALSE.
                              ENDIF
                              IF (OK .AND. NDEC.EQ.6) THEN
                                 Y(N) = ASIN(SQRT(F))
                              ELSEIF (OK .AND. NDEC.EQ.7) THEN
                                 FP = F/(ONE - F)
                                 IF (FP.LE.RTOL .OR. FP.GE.ZTOL) THEN
                                    CALL PUTADV (
     +                                   'x out of range for % ?')
                                    NDEC = N1
                                    OK = .FALSE.
                                 ELSEIF (OK) THEN
                                    Y(N) = LOG(FP)
                                 ENDIF
                              ELSEIF (OK) THEN
                                 IFAIL = N1
                                 Y(N) = G01CEF$(F, IFAIL)
                                 CALL PUTIFA (IFAIL, NF,
     +                                       'G01CEF/ANOVA1')
                                 IF (IFAIL.NE.N0) OK = .FALSE.
                              ENDIF
                           ELSE
                              F = Y(N)
                              IF (F.LE.EPSI .OR. F.GE.XTOL) THEN
                                 CALL PUTADV ('x out of range for p ?')
                                 NDEC = N1
                                 OK = .FALSE.
                              ENDIF
                              IF (OK .AND. NDEC.EQ.9) THEN
                                 Y(N) = ASIN(SQRT(F))
                              ELSEIF (OK .AND. NDEC.EQ.10) THEN
                                 FP = F/(ONE - F)
                                 IF (FP.LE.RTOL .OR. FP.GE.ZTOL) THEN
                                    CALL PUTADV (
     +                                   'x out of range for p ?')
                                    NDEC = N1
                                    OK = .FALSE.
                                 ELSEIF (OK) THEN
                                    Y(N) = LOG(FP)
                                 ENDIF
                              ELSEIF (OK) THEN
                                 IFAIL = N1
                                 Y(N) = G01CEF$(F, IFAIL)
                                 CALL PUTIFA (IFAIL, NF,
     +                                       'G01CEF/ANOVA1')
                                 IF (IFAIL.NE.N0) OK = .FALSE.
                              ENDIF
                           ENDIF
                        ELSE
                           CALL PUTADV (
     +                    'x-value too small for transform')
                           NDEC = N1
                           OK = .FALSE.
                        ENDIF
                     ENDIF
                  ENDDO
               ENDIF
            ENDDO
            CLOSE (UNIT = NIN)
            LINE = 'x (untransformed data)'
            IF (OK) THEN
               IF (NDEC.EQ.4) THEN
                  LINE = 'log(x)'
               ELSEIF (NDEC.EQ.5) THEN
                  LINE = 'sqrt(x)'
               ELSEIF (NDEC.EQ.6) THEN
                  LINE = 'arcsin[sqrt(x/100)]'
               ELSEIF (NDEC.EQ.7) THEN
                  LINE = 'log[x/(100 - x)]'
               ELSEIF (NDEC.EQ.8) THEN
                  LINE = 'Phi_inverse(x/100)'
               ELSEIF (NDEC.EQ.9) THEN
                  LINE = 'arcsin[sqrt(x)]'
               ELSEIF (NDEC.EQ.10) THEN
                  LINE = 'log[x/(1 - x)]'
               ELSEIF (NDEC.EQ.11) THEN
                  LINE = 'Phi_inverse(x)'
               ENDIF
C
C Output the results
C
               IF (K.GT.N0) THEN
                  WRITE (NF,300) BLANK
                  WRITE (NF,300) '***'
                  WRITE (NF,300) BLANK
                  WRITE (NF,300) 'Data for 1-way Analysis of Variance'
                  WRITE (NF,300) '-----------------------------------'                  
                  IF (MATRIX) THEN
                     WRITE (NF,300) TRIM80(FNAME)
                     WRITE (NF,300) CHOP80(TITLE)
                     DO I = N1, NFILES
                        IF (.NOT.USE1(I)) THEN
                           WRITE (WORD6,'(I6)') I
                           CALL TRIML1 (WORD6)
                           WRITE (NF,'(1X,A,1X,A)')
     +                     '*suppressed column', WORD6
                        ENDIF
                     ENDDO
                  ELSE
                     IF (NFILES.LE.20) THEN
                        DO I = N1, NFILES
                           IF (USE1(I)) THEN
                              WRITE (NF,300) TRIM80(FSAV(I))
                           ELSE
                              WRITE (NF,'(1X,A)') '*file suppressed'                        
                           ENDIF
                        ENDDO
                     ELSE
                        DO I = N1, NFILES
                           IF (.NOT.USE1(I)) THEN
                              WRITE (WORD6,'(I6)') I
                              CALL TRIML1 (WORD6)
                              WRITE (NF,'(1X,A,1X,A)')
     +                        '*suppressed file', WORD6
                           ENDIF
                        ENDDO
                     ENDIF
                  ENDIF
                  IF (NTYPE.NE.3) THEN
                     IFAIL = N1
                     READY = .FALSE.
                     TUKEY = .FALSE.
                     CALL G04AEF$(Y, N, K, NOBS, GBAR, GM, SS, IDF, F,
     +                            FP, IFAIL)
                     IF (IFAIL.EQ.N0) THEN
                        READY = .TRUE.
                        TUKEY = .TRUE.
                     ELSE
                        CALL PUTIFA (IFAIL, NF, 'G04AEF/ANOVA1')
                     ENDIF     
                  ENDIF
                  IF (NTYPE.NE.2) THEN
                     READY = .FALSE.
                     IFAIL = N1
                     CALL G08AFF$(Y, N, NOBS, K, X, H, P, IFAIL)
                     IF (IFAIL.EQ.N0) THEN
                        READY = .TRUE.
                     ELSE   
                        CALL PUTIFA (IFAIL, NF, 'G08AFF/ANOVA1')
                     ENDIF   
                  ENDIF
                  ICOUNT = ICOUNT + N1
C
C -------------------------------------------------------------------------
C                  
                  IF (E_NUMBERS) THEN
                     IF (NTYPE.EQ.1) THEN
                        WRITE (TEXT,400) ICOUNT, GM, LINE(1:22),
     +                                   SS(1), IDF(1),
     +                                   SS(1)/DBLE(IDF(1)),
     +                                   F, FP,
     +                                   SS(2), IDF(2),
     +                                   SS(2)/DBLE(IDF(2)),
     +                                   BLANK13, BLANK8,
     +                                   SS(3), IDF(3), BLANK13,
     +                                   BLANK13,
     +                                   BLANK8, H, K - N1, P
                        WRITE (NF,300) BLANK
                        WRITE (NF,400) ICOUNT, GM, LINE(1:22),
     +                                 SS(1), IDF(1),
     +                                 SS(1)/DBLE(IDF(1)),
     +                                 F, FP,
     +                                 SS(2), IDF(2),
     +                                 SS(2)/DBLE(IDF(2)),
     +                                 DOT13, DOT8,
     +                                 SS(3), IDF(3), DOT13, DOT13, 
     +                                 DOT8,
     +                                 H, K - N1, P
                        NUMTXT = 12
                     ELSEIF (NTYPE.EQ.2) THEN
                        WRITE (TEXT,500) ICOUNT, GM, LINE(1:22),
     +                                   SS(1), IDF(1), 
     +                                   SS(1)/DBLE(IDF(1)),
     +                                   F, FP,
     +                                   SS(2), IDF(2),
     +                                   SS(2)/DBLE(IDF(2)),
     +                                   BLANK13, BLANK8,
     +                                   SS(3), IDF(3), BLANK13, 
     +                                   BLANK13,
     +                                   BLANK8
                        WRITE (NF,300) BLANK
                        WRITE (NF,500) ICOUNT, GM, LINE(1:22),
     +                                 SS(1), IDF(1),
     +                                 SS(1)/DBLE(IDF(1)),
     +                                 F, FP,
     +                                 SS(2), IDF(2),
     +                                 SS(2)/DBLE(IDF(2)),
     +                                 DOT13, DOT8,
     +                                 SS(3), IDF(3), DOT13, DOT13, DOT8
                        NUMTXT = 7
                     ELSE
                        WRITE (TEXT,600) ICOUNT, LINE(1:22),
     +                                   H, K - N1, P
                        WRITE (NF,300) BLANK
                        WRITE (NF,600) ICOUNT, LINE(1:22),
     +                                 H, K - N1, P
                        NUMTXT = 7
                     ENDIF
                  ELSE
C
C-----------------------------------------------------------------------------
C                   
C 04/07/2022 The calculation of D13(I) depends of the value of NTYPE as follows:
C            H is not defined for NTYPE = 2 and the other variables are not defined for NTYPE = 3      
C
                    IF (NTYPE.NE.3) THEN 
                       D13(1) = SHOWLJ(GM)
                       D13(2) = SHOWRJ(SS(1))
                       XTEMP = SS(1)/DBLE(IDF(1))
                       D13(3) = SHOWRJ(XTEMP)
                       D13(4) = SHOWRJ(F)
                       D13(5) = SHOWRJ(SS(2))
                       XTEMP = SS(2)/DBLE(IDF(2))
                       D13(6) = SHOWRJ(XTEMP)
                       D13(7) = SHOWRJ(SS(3)) 
                    ENDIF   
                    IF (NTYPE.NE.2) D13(8) = SHOWRJ(H) 
                    IF (NTYPE.EQ.1) THEN
                        WRITE (TEXT,450) ICOUNT, TRIM(D13(1)),
     +                                   LINE(1:22),
     +                                   D13(2), IDF(1),
     +                                   D13(3),
     +                                   D13(4), FP,
     +                                   D13(5), IDF(2),
     +                                   D13(6),
     +                                   BLANK13, BLANK8,
     +                                   D13(7), IDF(3), BLANK13,
     +                                   BLANK13,
     +                                   BLANK8, D13(8), K - N1, P
                        WRITE (NF,300) BLANK
                        WRITE (NF,450) ICOUNT, TRIM(D13(1)),
     +                                 LINE(1:22),
     +                                 D13(2), IDF(1),
     +                                 D13(3),
     +                                 D13(4), FP,
     +                                 D13(5), IDF(2),
     +                                 D13(6),
     +                                 DOT13, DOT8,
     +                                 D13(7), IDF(3), DOT13, DOT13, 
     +                                 DOT8,
     +                                 D13(8), K - N1, P
                        NUMTXT = 12
                     ELSEIF (NTYPE.EQ.2) THEN
                        WRITE (TEXT,550) ICOUNT, TRIM(D13(1)),
     +                                   LINE(1:22),
     +                                   D13(2), IDF(1), 
     +                                   D13(3),
     +                                   D13(4), FP,
     +                                   D13(5), IDF(2),
     +                                   D13(6),
     +                                   BLANK13, BLANK8,
     +                                   D13(7), IDF(3), BLANK13, 
     +                                   BLANK13,
     +                                   BLANK8
                        WRITE (NF,300) BLANK
                        WRITE (NF,550) ICOUNT, TRIM(D13(1)), LINE(1:22),
     +                                 D13(2), IDF(1),
     +                                 D13(3),
     +                                 D13(4), FP,
     +                                 D13(5), IDF(2),
     +                                 D13(6),
     +                                 DOT13, DOT8,
     +                                 D13(7), IDF(3), DOT13, DOT13,
     +                                 DOT8
                        NUMTXT = 7
                     ELSE
                        WRITE (TEXT,650) ICOUNT, LINE(1:22),
     +                                   D13(8), K - N1, P
                        WRITE (NF,300) BLANK
                        WRITE (NF,650) ICOUNT, LINE(1:22),
     +                                 D13(8), K - N1, P
                        NUMTXT = 7
                     ENDIF
                  ENDIF  
C
C--------------------------------------------------------------------------
C
                  J = 15
                  CALL TABLE1 (J, 'OPEN')
                  DO I = N1, NUMTXT
                     IF (I.EQ.1) THEN
                        J = 4
                     ELSEIF (NTYPE.EQ.1 .AND. I.EQ.9) THEN
                        J = 4
                     ELSEIF (NTYPE.EQ.3 .AND. I.EQ.4) THEN
                        J = 4
                     ELSE
                        J = 0
                     ENDIF
                     CALL TABLE1 (J, TEXT(I))
                  ENDDO
                  CALL TABLE1 (J, 'CLOSE')
               ENDIF
            ENDIF
            NDEC = 3
         ELSEIF (NDEC.EQ.12) THEN
C
C NDEC = 12:
C ==========
C Tukey Q test with : K = no. groups, IDF(2) = no. deg freedom (error)
C                     NF = output unit, NOBs = no. observations,
C                     NSORT = column numbers, SS(2) = error SSQ,
C                     GBAR = means
C
            IF (OK .AND. TUKEY .AND. NTYPE.NE.3 .AND. READY) THEN
               IF (FP.GT.PNT05) CALL PUTWAR (
     +'Not significant. Tukey Q should only be used when p < 0.05')
               CALL TUKEYQ (K, IDF(2), NF, NOBS, NSORT,
     +                      SS(2)/DBLE(IDF(2)), GBAR)
            ELSE
               CALL PUTADV ('First do parametric 1-way ANOVA')
            ENDIF
         ELSEIF (NDEC.EQ.13) THEN
C
C NDEC = 13: Box and whisker plot
C ==========
C
            IF (OK .AND. READY) THEN
               J = N0
               DO I = N1, NFILES
                  IF (USE1(I)) THEN
                     J = J + N1
                     WRITE (LTEMP(J),'(I4)') I
                  ENDIF
              ENDDO
C
C NOTE: 'Box and Whisker Plot' is the title required by GKSF2B$ to interpret
C        the data as a Box and Whisker Plot and MUST NOT be altered
C        In Spanish TTEMP(1) = 'Diagrama be Whiskers'
C        The other TEMP values are arbitrary
C
               TTEMP(1) = 'Box and Whisker Plot'
               TTEMP(2) = 'Columns'
               TTEMP(3) = 'Medians'
               TTEMP(4) = ' '
               ISEND = 2
               CALL BWPLOT (ISEND, NOBS, K, N,
     +                      Y,
     +                      LTEMP, TTEMP)
            ELSE
               CALL PUTADV ('First do parametric 1-way ANOVA')
            ENDIF
         ELSEIF (NDEC.EQ.14) THEN
C
C NDEC = 14: Box and whisker plot plus scattered data
C ==========
C
            IF (OK .AND. READY) THEN
               J = N0
               DO I = N1, NFILES
                  IF (USE1(I)) THEN
                     J = J + N1
                     WRITE (LTEMP(J),'(I4)') I
                  ENDIF
              ENDDO
C
C NOTE: 'Box and Whisker Plot' is the title required by GKSF2B$ to interpret
C        the data as a Box and Whisker Plot and MUST NOT be altered
C        In Spanish TTEMP(1) = 'Diagrama be Whiskers'
C        The other TEMP values are arbitrary
C
               TTEMP(1) = 'Box and Whisker Plot'
               TTEMP(2) = 'Columns'
               TTEMP(3) = 'Medians'
               TTEMP(4) = ' '
               ISEND = 2
               CALL BWPLUS (ISEND, NOBS, K, N,
     +                      Y,
     +                      LTEMP, TTEMP)
            ELSE
               CALL PUTADV ('First do parametric 1-way ANOVA')
            ENDIF
            
         ELSEIF (NDEC.EQ.15) THEN
C
C NDEC = 15: range and percentiles plot
C ==========
C
            IF (OK .AND. READY) THEN
               J = N0
               DO I = N1, NFILES
                  IF (USE1(I)) THEN
                     J = J + N1
                     WRITE (LTEMP(J),'(I4)') I
                  ENDIF
               ENDDO
               TTEMP(1) = 'Range and Percentiles'
               TTEMP(2) = 'Samples'
               TTEMP(3) = 'Percentiles'
               TTEMP(4) = ' '
               CALL RPPLOT (NOBS, K, N,
     +                      Y,
     +                      TTEMP)
            ELSE
               CALL PUTADV ('First do parametric 1-way ANOVA')
            ENDIF            
         ELSEIF (NDEC.EQ.16) THEN
C
C NDEC = 16: Barchart errorbar plot
C ==========
C
            IF (OK .AND. READY) THEN
               J = N0
               DO I = N1, NFILES
                  IF (USE1(I)) THEN
                     J = J + N1
                     WRITE (LTEMP(J),'(I4)') I
                  ENDIF
              ENDDO
C
C NOTE: 'Barchart & Errorbars' is the title required by GKSF2B$ to interpret
C        the data as a Barchart & Errorbars and MUST NOT be altered
C        In Spanish TTEMP(1) = 'Diagrama be Barras'
C        The other TEMP values are arbitrary
C
               TTEMP(1) = 'Barchart & Errorbars'
               TTEMP(2) = 'Columns'
               TTEMP(3) = 'Means'
               TTEMP(4) = ' '
               ISEND = 2
               CALL EBPLOT (ISEND, NOBS, K, N,
     +                      Y,
     +                      LTEMP, TTEMP)
            ELSE
               CALL PUTADV ('First do parametric 1-way ANOVA')
            ENDIF
         ELSEIF (NDEC.EQ.17) THEN
C
C NDEC = 17: Scatter plot
C ==========
C
            IF (OK .AND. READY) THEN
               L = N0
               DO I = N1, NFILES
                  IF (USE1(I)) THEN
                     DO J = N1, NOBS(I)
                        L = L + N1
                        B(L) = DBLE(I)
                     ENDDO
                  ENDIF
               ENDDO
               CALL GKS001 (N0, N5, N,
     +                      B, Y,
     +                     'Scatter Plot', 'Columns', 'Values')
            ELSE
               CALL PUTADV ('First do parametric 1-way ANOVA')
            ENDIF
         ELSEIF (NDEC.EQ.NOPT - 1) THEN
C
C NDEC = NOPT - 1: Type
C =====================
C
            NOPT = 3
            NSTART = 6
            NUMTXT = NSTART + NOPT - 1
            WRITE (TEXT,700)
            NUMBLD(1) = 4
            CALL TBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NTYPE, NOPT,
     +                   NUMPOS, NSTART, NUMTXT,
     +                   TEXT,
     +                   TAB_TOP, TAB_MID, TAB_BOT)
            NUMBLD(1) = 0
            TUKEY = .FALSE.
            OK = .FALSE.
            NDEC = 3
         ELSEIF (NDEC.EQ.NOPT) THEN
C
C NDEC = NOPT: Quit
C ============
C
            NEWDAT = .FALSE.
            AGAIN = .FALSE.
         ENDIF
      ENDDO
C
C Deallocate
C
      DEALLOCATE(NSORT, STAT = IERR)
      DEALLOCATE(LTEMP, STAT = IERR)
      DEALLOCATE(COLUMN, STAT = IERR)
C
C Format statements
C
  100 FORMAT (
     + '1-way ANOVA'
     +/
     +/'Use data untransformed and only use the variance stabilisation'
     +/'if you have good reasons to do so, and know what you are doing.'
     +/'Note: log is to base e and x can be a percentage or proportion.'
     +/
     +/'Input new 1-Way ANOVA data'
     +/'Suppress/Restore columns'
     +/'ANOVA: x (original data)'
     +/'ANOVA: log(x))'
     +/'ANOVA: sqrt(x)'
     +/'ANOVA: arcsin(sqrt(x/100))   `(0 < x < 100)'
     +/'ANOVA: log(x/(100 - x))      `(0 < x < 100)'
     +/'ANOVA: Phi_inverse(x/100))   `(0 < x < 100)'
     +/'ANOVA: arcsin(sqrt(x))       `(0 < x < 1)'
     +/'ANOVA: log(x/(1 - x))        `(0 < x < 1)'
     +/'ANOVA: Phi_inverse(x)        `(0 < x < 1)'
     +/'Tukey Q test for contrasts   `',A
     +/'Plot box-whiskers (only)     `',A
     +/'Plot box-whiskers (plus data)`',A
     +/'Plot range and percentiles   `',A
     +/'Plot bars and error-bars     `',A
     +/'Plot scattered data          `',A
     +/'Parameteric/Nonparametric    `',A
     +/'Quit                         `Exit 1-way ANOVA')
  200 FORMAT (
     + 'Methods for supplying multiple samples'
     +/
     +/'Data can be supplied as a matrix, as individual column'
     +/'vectors, from a library file, or by using multiple file'
     +/'selection from a vector file project archive.'
     +/
     +/'Input data in matrix form'
     +/'Input individual column vectors'
     +/'Read in from a library file'
     +/'Select from a project archive')
  300 FORMAT (1X,A)
  400 FORMAT (
     + ' 1-Way Analysis of Variance:',I3,' (Grand Mean',1P,E13.5,')'
     +/
     +/' Transformation:-',2X,A
     +/' Source          ',7X,'SSQ',7X,'NDOF',7X,'MSQ',11X,'F',9X,'p'
     +/' Between Groups  ',1X,1P,E13.5,I6,2(1X,E13.5),0P,F8.4
     +/' Residual        ',1X,1P,E13.5,I6,1X,E13.5,3X,A13,A8
     +/' Total           ',1X,1P,E13.5,I6,1X,A13,3X,A13,A8/
     +/' Kruskal-Wallis Nonparametric One Way Analysis of Variance'/
     +/'  Test-statistic   NDOF   p'
     +/1X,1P,E13.5,I8,0P,F8.4)
  450 FORMAT (
     + ' 1-Way Analysis of Variance:',I3,' (Grand Mean',1X,A,')'
     +/
     +/' Transformation:-',2X,A
     +/' Source          ',7X,'SSQ',7X,'NDOF',7X,'MSQ',14X,'F',6X,'p'
     +/' Between Groups  ',1X,A13,I6,2(1X,A13),F8.4
     +/' Residual        ',1X,A13,I6,1X,A13,3X,A13,A8
     +/' Total           ',1X,A13,I6,1X,A13,3X,A13,A8/
     +/' Kruskal-Wallis Nonparametric One Way Analysis of Variance'/
     +/'  Test-statistic   NDOF   p'
     +/1X,A13,I8,F8.4)    
  500 FORMAT (
     + ' 1-Way Analysis of Variance:',I3,' (Grand Mean',1P,E13.5,')'
     +/
     +/' Transformation:-',2X,A
     +/' Source          ',7X,'SSQ',7X,'NDOF',7X,'MSQ',11X,'F',9X,'p'
     +/' Between Groups  ',1X,1P,E13.5,I6,2(1X,E13.5),0P,F8.4
     +/' Residual        ',1X,1P,E13.5,I6,1X,E13.5,2X,A13,A8
     +/' Total           ',1X,1P,E13.5,I6,A13,3X,A13,A8)
  550 FORMAT (
     + ' 1-Way Analysis of Variance:',I3,' (Grand Mean',1X,A,')'
     +/
     +/' Transformation:-',2X,A
     +/' Source          ',7X,'SSQ',7X,'NDOF',7X,'MSQ',14X,'F',6X,'p'
     +/' Between Groups  ',1X,A13,I6,2(1X,A13),F8.4
     +/' Residual        ',1X,A13,I6,1X,A13,2X,A13,A8
     +/' Total           ',1X,A13,I6,A13,3X,A13,A8)    
  600 FORMAT (
     + ' 1-Way Analysis of Variance:',I3
     +/
     +/' Transformation:-',2X,A
     +/' Kruskal-Wallis Nonparametric One Way Analysis of Variance'/
     +/'  Test-statistic   NDOF   p'
     +/1X,1P,E13.5,I8,0P,F8.4)
  650 FORMAT (
     + ' 1-Way Analysis of Variance:',I3
     +/
     +/' Transformation:-',2X,A
     +/' Kruskal-Wallis Nonparametric One Way Analysis of Variance'/
     +/'  Test-statistic   NDOF   p'
     +/1X,A13,I8,F8.4)    
  700 FORMAT (
     + 'Options for 1-way ANOVA'
     +/
     +/'You can do parameteric ANOVA followed by Tukey Q'
     +/'and/or Kruskal-Wallis nonparametric ANOVA'
     +/
     +/'Parametric and Nonparametric'
     +/'Parametric only'
     +/'Nonparametric only')
      END
C
C
