C
C
      SUBROUTINE ANOVA2 (ISEND, KSEND, NCMAX, NF, NIN, NMAX, NRMAX,
     +                   A, B, X, Y,
     +                   FNAME, TITLE,
     +                   NEWDAT, SUPPLY, USE1)
C
C ACTION: Two way ANOVA
C AUTHOR: W. G. Bardsley, University of Manchester, U.K.
C         Derived from ANOVA1/ANOVA2 ... 24/06/2000
C         27/04/2002 added ISEND
C         22/09/2003 added A2, A3, DMAUCH, PMAUCH, SMAUCH, NUMNEG and call
C                    to SPHER1
C         08/10/2003 replaced SPHER1 by SPHER2 and added HOTEL2
C         20/10/2003 corrected degrees of freedom for F and rearranged output
C         08/04/2005 added KSEND to argument list to re-initialise NTYPE
C         10/01/2005 moved A2 and A3 from arguments to allocatables
C         31/03/2006 added NRMAX, NEWDAT, and SUPPLY to arguments, deleted XC
C                    and edited to force data input from matrices only
C         28/07/2006 made W1 and W2 allocatable to allow M > N in 2-way but 
C                    added traps to prevent repeat measures when M > N 
C         27/07/2014 minor revision and added INTENTS and KSEND 
C         19/08/2021 added E_NUMBERS and E_FORMATS, etc.
C         30/08/2021 set DOT8 = BLANK8, DOT11 = BLANK11, DOT13 = BLANK13 to improve results file
C
C  ISEND: (input/unchanged) as follows:
C         ISEND = 1: 2-way ANOVA output
C         ISEND = 2: Repeated-measurements output
C  KSEND: (input/unchanged) as follows: NTYPE = KSEND if KSEND in range (1,3)
C  NCMAX: (input/unchanged) dimension
C     NF: (input/unchanged) preconnected input unit for results
C    NIN: (input/unchanged) unconnected unit for data input
C   NMAX: (input/unchanged) dimension where NMAX >= NCOL*NROW
C  NRMAX: (input/unchanged) dimension
C      A: (input/output) depending on SUPPLY
C      B: workspace
C      X: workspace
C      Y: workspace
C  FNAME: (input/output) depending on SUPPLY
C  TITLE: (input/output) depending on SUPPLY
C NEWDAT: (output) returned asc.TRUE. if new data are requested
C SUPPLY: (input/unchanged) as follows:
C         if SUPPLY = .TRUE. then supply A in file = FNAME, title = TITLE
C         and A, FNAME, TITLE are returned unchanged
C         o/w data are read in interactively
C   USE1: workspace!
C
C Note: A is the original data but the transformed matrix A1 has NCOL1
C       columns where NCOL1 < NCOL if any columns are suppressed.
C       The leading dimension of A1, A2, and A3 is NRMAX1 which must
C       satisfy NRMAX1 >= MAX(NRMAX, 2*(NCMAX - 1)) if (ISEND = 2)
C
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NCMAX, NMAX, NRMAX
      INTEGER,             INTENT (IN)    :: ISEND, KSEND, NF, NIN
      DOUBLE PRECISION,    INTENT (INOUT) :: A(NRMAX,NCMAX), B(NMAX),
     +                                       X(NMAX), Y(NMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, TITLE
      LOGICAL,             INTENT (IN)    :: SUPPLY
      LOGICAL,             INTENT (OUT)   :: NEWDAT
      LOGICAL,             INTENT (INOUT) :: USE1(NCMAX)

C
C Local allocatable arrays
C
      DOUBLE PRECISION, ALLOCATABLE :: A1(:,:), A2(:,:), A3(:,:), W1(:),
     +                                 W2(:), XC(:,:)
      CHARACTER (LEN = 6), ALLOCATABLE :: TICKER(:)
C
C Locals
C
      INTEGER    NCOL, NCOL1, NROW
      INTEGER    I, IERR, IFAIL, IX, J, K, N, NUMNEG, NRMAX1
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NOPT, NSTART, NUMTXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 0)
      INTEGER    NDEC, NUMBLD(25), NUMPOS(15)
      INTEGER    ICOUNT, JCOUNT, KCOUNT, NDOF, NTYPE
      INTEGER    N0, N1, N2, N3, N4
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4)
      INTEGER    JSEND, JTYPE, NG
      PARAMETER (JSEND = 3, JTYPE = 1, NG = 1)
      DOUBLE PRECISION ZERO, ONE, F100
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, F100 = 100.0D+00)
      DOUBLE PRECISION EPSI, F, FP, P
      DOUBLE PRECISION FR
      DOUBLE PRECISION BIGN, GMEAN, RNCOL, RNROW
      DOUBLE PRECISION BETCOL, BETROW, RESID, TOTAL
      DOUBLE PRECISION COLMEAN, RESMEAN, ROWMEAN
      DOUBLE PRECISION FCOL, FROW, PCOL, PROW
      DOUBLE PRECISION DMAUCH, PMAUCH, SMAUCH, WMAUCH
      DOUBLE PRECISION DNCM1, DNRM1, D1, D2, EG, EH, EL, PG, PH, PL
      DOUBLE PRECISION D1HOT, D2HOT, PHOT, SHOT, T2HOT
      DOUBLE PRECISION G01EDF$, G01CEF$, RTOL, X02AMF$, XTOL, ZTOL,
     +                 X02AJF$
      CHARACTER (LEN = 100) LINE, TEXT(30)
      CHARACTER (LEN = 80 ) TRIM80, WORD80
      CHARACTER (LEN = 40 ) TTEMP
      PARAMETER (TTEMP = 'Tick columns required')
      CHARACTER (LEN = 20 ) TYPE1
      CHARACTER (LEN = 13 ) D13(12), SHOWLJ, SHOWRJ 
      CHARACTER (LEN = 13 ) BLANK13, DOT13
      PARAMETER (BLANK13 = '             ', DOT13 = BLANK13)
      CHARACTER (LEN = 12 ) I12(1), FORM12 
      CHARACTER (LEN = 11 ) BLANK11,  DOT11
      PARAMETER (BLANK11 = '           ', DOT11 = BLANK11)
      CHARACTER (LEN = 8  ) BLANK8, DOT8
      PARAMETER (BLANK8 = '        ', DOT8 = BLANK8)
      CHARACTER (LEN = 6  ) BLANK6, DOT6
      PARAMETER (BLANK6 = '      ', DOT6 = BLANK6)
      CHARACTER (LEN = 1  ) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    TAB_BOT, TAB_MID, TAB_TOP
      PARAMETER (TAB_TOP = .TRUE., TAB_MID = .TRUE., TAB_BOT = .TRUE.)
      LOGICAL    FIXCOL, FIXROW, LABEL
      PARAMETER (FIXCOL = .FALSE., FIXROW = .FALSE., LABEL = .TRUE.)
      LOGICAL    ABORT, AGAIN, OK
      LOGICAL    E_FORMATS, E_NUMBERS
      EXTERNAL   SHOWLJ, SHOWRJ, E_FORMATS, FORM12
      EXTERNAL   PUTFAT, PUTIFA, MATTIN, TBOX01, TABLE1, SPHER2, HOTEL2,
     +           CHKBOX, ISITMF, TRIM80
      EXTERNAL   G01CEF$, X02AMF$, G01EDF$, G08AEF$, X02AJF$
      INTRINSIC  SQRT, LOG, ASIN, DBLE, MAX
      SAVE       ICOUNT, JCOUNT, KCOUNT, NTYPE
      DATA       ICOUNT, JCOUNT, KCOUNT, NTYPE / 0, 0, 0, 1 /
      DATA       NUMBLD / 25*0 /
      DATA       NUMPOS / 15*1 /
C
C Initialise newdat
C
      NEWDAT = .FALSE.
      IF (NCMAX.LT.N2 .OR. NMAX.LT.N4 .OR. NRMAX.LT.N2) RETURN
C
C Check ISEND
C
      IF (ISEND.LT.N1 .OR. ISEND.GT.N2) THEN
         CALL PUTFAT ('ISEND out of range in call to ANOVA2')
         RETURN
      ENDIF
      E_NUMBERS = E_FORMATS()
C
C Check KSEND
C
      IF (KSEND.GE.N1 .AND. KSEND.LE.N3) NTYPE = KSEND
C
C Read in NCOL and NROW if data are supplied
C
      IF (SUPPLY) THEN
         CALL ISITMF (NCOL, NROW,
     +                FNAME)
         IF (NROW.LT.N2 .OR. NCOL.LT.N2) RETURN 
         IF (ISEND.EQ.N2 .AND. NCOL.GT.NROW) THEN
            CALL PUTFAT (
     +'MANOVA requires no. rows >= no. columns...just use 2-way ANOVA')
            RETURN
         ENDIF
         NDEC = N3
      ELSE
         NCOL = N0
         NROW = N0
         NDEC = N1
      ENDIF
C
C Allocate workspaces
C
      IERR = N0
      IF (ALLOCATED(A1)) DEALLOCATE(A1, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(A2)) DEALLOCATE(A2, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(A3)) DEALLOCATE(A3, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(XC)) DEALLOCATE(XC, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(TICKER)) DEALLOCATE(TICKER, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ISEND.EQ.N2) THEN
         NRMAX1 = MAX(NRMAX,2*(NCMAX - 1)) + 1
      ELSE
         NRMAX1 = NRMAX
      ENDIF
      ALLOCATE(A1(NRMAX1,NCMAX), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ISEND.EQ.N2) THEN
         ALLOCATE(A2(NRMAX1,NCMAX), STAT = IERR)
         IF (IERR.NE.N0) RETURN
         ALLOCATE(A3(NRMAX1,NCMAX), STAT = IERR)
         IF (IERR.NE.N0) RETURN
      ENDIF
      ALLOCATE(XC(NCMAX,NRMAX), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE(TICKER(NCMAX), STAT = IERR)
      IF (IERR.NE.N0) RETURN
C
C Initialise
C
      RTOL = 1.0D+09*X02AMF$()
      EPSI = 1.0D+01*X02AJF$()
      XTOL = ONE - RTOL
      ZTOL = ONE/RTOL
      DO I = N1, NCMAX
         USE1(I) = .TRUE.
         WRITE (TICKER(I),'(I6)') I
      ENDDO
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
C
C Main menu
C
         IF (NTYPE.EQ.1) THEN
            TYPE1 = 'Both'
         ELSEIF (NTYPE.EQ.2) THEN
            TYPE1 = 'Parametric'
         ELSE
            TYPE1 = 'Nonparametric'
         ENDIF
         IF (ISEND.EQ.1) THEN
            WRITE (TEXT,100) TYPE1
         ELSEIF (ISEND.EQ.2) THEN
            WRITE (TEXT,200) TYPE1
         ENDIF
         NOPT = 13
         NSTART = 9
         NUMBLD(1) = 4
         NUMTXT = NSTART + NOPT - 1
         CALL TBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, NOPT,
     +                NUMPOS, NSTART, NUMTXT,
     +                TEXT,
     +                TAB_TOP, TAB_MID, TAB_BOT)
         NUMBLD(1) = 0
C
C Check if consistent or return requested
C
         IF (NDEC.GT.1 .AND. NDEC.LT.NOPT .AND. NCOL.LT.2) THEN
            CALL PUTFAT ('First input your current data')
            NDEC = N1
         ELSEIF (NDEC.EQ.1) THEN
C
C NDEC = 1: Data input
C =========
C
            IF (SUPPLY) THEN
               NEWDAT = .TRUE.
               DEALLOCATE(A1, STAT = IERR)
               IF (ALLOCATED(A2)) DEALLOCATE(A2, STAT = IERR)
               IF (ALLOCATED(A3)) DEALLOCATE(A3, STAT = IERR)
               IF (ALLOCATED(XC)) DEALLOCATE(XC, STAT = IERR)
               DEALLOCATE(TICKER, STAT = IERR)
               RETURN
            ELSE
C
C Read in a data matrix
C
               I = N0
               CLOSE (UNIT = NIN)
               FNAME = BLANK
               CALL MATTIN (I, NCMAX, NCOL, NIN, NRMAX, NROW,
     +                      A, B,
     +                      FNAME, TITLE,
     +                      ABORT, FIXCOL, FIXROW, LABEL)
               CLOSE (UNIT = NIN)
               IF (ABORT) THEN
                  NCOL = N0
                  NROW = N0
               ENDIF
               IF (.NOT.ABORT .AND. NCOL.LT.N2) THEN
                  ABORT = .TRUE.
                  CALL PUTFAT ('Must have at least 2 columns')
                  NCOL = N0
                  NROW = N0
               ENDIF
               IF (.NOT.ABORT .AND. NROW.LT.N2) THEN
                  ABORT = .TRUE.
                  CALL PUTFAT ('Must have at least 2 rows')
                  NCOL = N0
                  NROW = N0
               ENDIF 
               IF (.NOT.ABORT .AND. ISEND.EQ.N2 .AND. NCOL.GT.NROW) THEN
                  ABORT = .TRUE.
                  CALL PUTFAT ('Must have no. rows >= no. columns')
                  NCOL = N0
                  NROW = N0
               ENDIF   
            ENDIF
            IF (ABORT .OR. NCOL.LT.N2 .OR. NROW.LT.N2) THEN
               NDEC = 1
            ELSE
               NDEC = 3
            ENDIF
         ELSEIF (NDEC.EQ.2) THEN
C
C NDEC = 2: Add/delete data columns
C =========
C
            OK = .TRUE.
            DO WHILE (OK)
                CALL CHKBOX (NCOL,
     +                       TICKER, TTEMP,
     +                       USE1)
               J = N0
               DO I = N1, NCOL
                  IF (USE1(I)) J = J + N1
               ENDDO
               IF (J.LT.N2) THEN
                  CALL PUTFAT ('Must have at least 2 columns')
                  OK = .TRUE.
               ELSE
                  OK = .FALSE.
               ENDIF
            ENDDO
            NDEC = 3
         ELSEIF (NDEC.LT.12) THEN
C
C 2 < NDEC < 12: Do ANOVA...N adds up to the size and K to active columns
C ==============
C
            OK = .TRUE.
            N = N0
            K = N0
            DO I = N1, NCOL
               IF (OK .AND. USE1(I)) THEN
                  K = K + N1
                  DO J = N1, NROW
                     IF (N.LT.NMAX) THEN
                        N = N + N1
                     ELSE
                        CALL PUTFAT ('Sample size too large')
                        DEALLOCATE(A1, STAT = IERR)
                        IF (ALLOCATED(A2)) DEALLOCATE(A2, STAT = IERR)
                        IF (ALLOCATED(A3)) DEALLOCATE(A3, STAT = IERR)
                        IF (ALLOCATED(XC)) DEALLOCATE(XC, STAT = IERR)
                        DEALLOCATE(TICKER, STAT = IERR)
                        RETURN
                     ENDIF
                     Y(N) = A(J,I)
                     IF (NDEC.GT.3) THEN
C
C Variance stabilising transformation requested
C
                        IF (Y(N).GT.RTOL) THEN
                           IF (NDEC.EQ.4) THEN
                              Y(N) = LOG(Y(N))
                           ELSEIF (NDEC.EQ.5) THEN
                              Y(N) = SQRT(Y(N))
                           ELSEIF (NDEC.LE.8) THEN
                              F = Y(N)/F100
                              IF (F.LE.EPSI .OR. F.GE.XTOL) THEN
                                 CALL PUTFAT ('x out of range for % ?')
                                 NDEC = N1
                                 OK = .FALSE.
                              ENDIF
                              IF (OK .AND. NDEC.EQ.6) THEN
                                 Y(N) = ASIN(SQRT(F))
                              ELSEIF (OK .AND. NDEC.EQ.7) THEN
                                 FP = F/(ONE - F)
                                 IF (FP.LE.RTOL .OR. FP.GE.ZTOL) THEN
                                    CALL PUTFAT (
     +                                   'x out of range for % ?')
                                    NDEC = N1
                                    OK = .FALSE.
                                 ELSEIF (OK) THEN
                                    Y(N) = LOG(FP)
                                 ENDIF
                              ELSEIF (OK) THEN
                                 IFAIL = N1
                                 Y(N) = G01CEF$(F, IFAIL)
                                 CALL PUTIFA (IFAIL, NF,
     +                                       'G01CEF/ANOVA1')
                                 IF (IFAIL.NE.N0) OK = .FALSE.
                              ENDIF
                           ELSE
                              F = Y(N)
                              IF (F.LE.EPSI .OR. F.GE.XTOL) THEN
                                 CALL PUTFAT ('x out of range for p ?')
                                 NDEC = N1
                                 OK = .FALSE.
                              ENDIF
                              IF (OK .AND. NDEC.EQ.9) THEN
                                 Y(N) = ASIN(SQRT(F))
                              ELSEIF (OK .AND. NDEC.EQ.10) THEN
                                 FP = F/(ONE - F)
                                 IF (FP.LE.RTOL .OR. FP.GE.ZTOL) THEN
                                    CALL PUTFAT (
     +                                   'x out of range for p ?')
                                    NDEC = N1
                                    OK = .FALSE.
                                 ELSEIF (OK) THEN
                                    Y(N) = LOG(FP)
                                 ENDIF
                              ELSEIF (OK) THEN
                                 IFAIL = N1
                                 Y(N) = G01CEF$(F, IFAIL)
                                 CALL PUTIFA (IFAIL, NF,
     +                                       'G01CEF/ANOVA1')
                                 IF (IFAIL.NE.N0) OK = .FALSE.
                              ENDIF
                           ENDIF
                        ELSE
                           CALL PUTFAT (
     +                    'x-value too small for transform')
                           NDEC = N1
                           OK = .FALSE.
                        ENDIF
                     ENDIF
                  ENDDO
               ENDIF
            ENDDO
            IF (OK .AND. K.GT.N1) THEN
               IF (NDEC.EQ.4) THEN
                  LINE = 'log(x)'
               ELSEIF (NDEC.EQ.5) THEN
                  LINE = 'sqrt(x)'
               ELSEIF (NDEC.EQ.6) THEN
                  LINE = 'arcsin[sqrt(x/100)]'
               ELSEIF (NDEC.EQ.7) THEN
                  LINE = 'log[x/(100 - x)]'
               ELSEIF (NDEC.EQ.8) THEN
                  LINE = 'Phi_inverse(x/100)'
               ELSEIF (NDEC.EQ.9) THEN
                  LINE = 'arcsin[sqrt(x)]'
               ELSEIF (NDEC.EQ.10) THEN
                  LINE = 'log[x/(1 - x)]'
               ELSEIF (NDEC.EQ.11) THEN
                  LINE = 'Phi_inverse(x)'
               ELSE
                  LINE = 'x (untransformed data)'
               ENDIF
C
C Define new matrix A1 and NCOL, original A is not changed
C
               NCOL1 = K
               K = N0
               DO I = N1, NCOL1
                  DO J = N1, NROW
                     K = K + N1
                     A1(J,I) = Y(K)
                  ENDDO
               ENDDO
               WRITE (NF,400) BLANK
               WRITE (NF,400) '***'
               IF (NDEC.GE.4 .AND. NDEC.LE.11) THEN
                  WRITE (NF,400) BLANK
                  WRITE (NF,400) LINE
               ENDIF
               WRITE (NF,400) BLANK
               IF (ISEND.EQ.1) THEN
                  ICOUNT = ICOUNT + N1
                  WRITE (NF,500) ICOUNT
               ELSEIF (ISEND.EQ.2) THEN
                  JCOUNT = JCOUNT + N1
                  WRITE (NF,600) JCOUNT
               ENDIF
               WORD80 = TRIM80(FNAME)
               WRITE (NF,400) WORD80
               IF (NCOL1.LT.NCOL) THEN
                  IF (NCOL - NCOL1.LE.20) THEN
                     DO I = N1, NCOL
                        IF (.NOT.USE1(I)) WRITE (NF,'(1X,A,I6)')
     +                                 '*suppressed column', I
                     ENDDO
                  ELSE
                     WRITE (NF,'(1X,A,I6)')
     +               '*No. of suppressed columns is', NCOL - NCOL1                                  
                  ENDIF
               ENDIF
C
C Sphericity test if repeated measures
C
               IF (ISEND.EQ.2) THEN
                  NDOF = NROW - N1
                  CALL SPHER2 (JSEND, JTYPE, NCOL1, NDOF, NG, NF,
     +                         NRMAX1, NROW, NUMNEG,
     +                         A1, A2, A3, DMAUCH, EG, EH, EL, PMAUCH,
     +                         SMAUCH, WMAUCH, X, Y,
     +                         ABORT)
               ENDIF
               IF (NTYPE.NE.3) THEN
C
C 2-WAY ANOVA
C Grand mean (GMEAN) and total ssq (TOTAL)
C
                  GMEAN = ZERO
                  DO I = N1, NCOL1
                     DO J = N1, NROW
                        GMEAN = GMEAN + A1(J,I)
                     ENDDO
                  ENDDO
                  BIGN = DBLE(NCOL1*NROW)
                  GMEAN = GMEAN/BIGN
                  TOTAL = ZERO
                  DO I = N1, NCOL1
                     DO J = N1, NROW
                        TOTAL = TOTAL + (A1(J,I) - GMEAN)**2
                     ENDDO
                  ENDDO
C
C Column means B(1),..., B(NCOL1) and between columns (BETCOL)
C
                  RNROW = DBLE(NROW)
                  DO I = N1, NCOL1
                     B(I) = ZERO
                     DO J = N1, NROW
                        B(I) = B(I) + A1(J,I)
                     ENDDO
                     B(I) = B(I)/RNROW
                  ENDDO
                  BETCOL = ZERO
                  DO I =  N1, NCOL1
                     BETCOL = BETCOL + (B(I) - GMEAN)**2
                  ENDDO
                  BETCOL = RNROW*BETCOL
C
C Row means B(1),..., B(NROW) and between rows (BETROW)
C
                  RNCOL = DBLE(NCOL1)
                  DO I = N1, NROW
                     B(I) = ZERO
                     DO J = N1, NCOL1
                        B(I) = B(I) + A1(I,J)
                     ENDDO
                     B(I) = B(I)/RNCOL
                  ENDDO
                  BETROW = ZERO
                  DO I = N1, NROW
                     BETROW = BETROW + (B(I) - GMEAN)**2
                  ENDDO
                  BETROW = RNCOL*BETROW
C
C RESID, mean squares, variance ratios and p values
C
                  RESID = TOTAL - BETCOL - BETROW
                  IF (RESID.LT.ZERO) RESID = ZERO
                  DNCM1 = RNCOL - ONE
                  DNRM1 = RNROW - ONE
                  COLMEAN = BETCOL/DNCM1
                  ROWMEAN = BETROW/DNRM1
                  RESMEAN = RESID/(DNCM1*DNRM1)
                  IF (RESMEAN.LE.RTOL) THEN
                     CALL PUTFAT (
     +           'Singular data set ... Analysis not possible')
                     RESMEAN = RTOL
                  ENDIF
                  FCOL = COLMEAN/RESMEAN
                  FROW = ROWMEAN/RESMEAN
                  D1 = DNCM1
                  D2 = DNCM1*DNRM1
                  IFAIL = N1
                  PCOL = G01EDF$('Upper-tail', FCOL, D1, D2, IFAIL)
                  CALL PUTIFA (IFAIL, NF, 'G01EDF/ANOVA2')
                  IF (ISEND.EQ.2) THEN
                     D1 = EG*DNCM1
                     D2 = EG*DNCM1*DNRM1
                     IFAIL = N1
                     PG = G01EDF$('Upper-tail', FCOL, D1, D2, IFAIL)
                     CALL PUTIFA (IFAIL, NF, 'G01EDF/ANOVA2')
                     D1 = EH*DNCM1
                     D2 = EH*DNCM1*DNRM1
                     IFAIL = N1
                     PH = G01EDF$('Upper-tail', FCOL, D1, D2, IFAIL)
                     CALL PUTIFA (IFAIL, NF, 'G01EDF/ANOVA2')
                     D1 = EL*DNCM1
                     D2 = EL*DNCM1*DNRM1
                     IFAIL = N1
                     PL = G01EDF$('Upper-tail', FCOL, D1, D2, IFAIL)
                     CALL PUTIFA (IFAIL, NF, 'G01EDF/ANOVA2')
                  ENDIF
                  IFAIL = N1
                  D1 = DNRM1
                  D2 = DNCM1*DNRM1
                  PROW = G01EDF$('Upper-tail', FROW, D1, D2, IFAIL)
                  CALL PUTIFA (IFAIL, NF, 'G01EDF/ANOVA2')
               ENDIF
               IF (NTYPE.NE.2) THEN
C
C Friedman calculations
C
                  DO I = N1, NCOL1
                     DO J = N1, NROW
                        XC(I,J) = A1(J,I)
                     ENDDO
                  ENDDO
                  IX = NCMAX
                  K = NCOL1
                  N = NROW
                  IFAIL = N1 
                  IF (ALLOCATED(W1)) DEALLOCATE(W1, STAT = IERR) 
                  IF (ALLOCATED(W2)) DEALLOCATE(W2, STAT = IERR)
                  ALLOCATE(W1(K), STAT = IERR) 
                  ALLOCATE(W2(K), STAT = IERR)
                  CALL G08AEF$(XC, IX, K, N, W1, W2, FR, P, IFAIL)
                  KCOUNT = KCOUNT + N1
                  CALL PUTIFA (IFAIL, NF, 'G08AEF/ANOVA2')
                  DEALLOCATE(W1, STAT = IERR)
                  DEALLOCATE(W2, STAT = IERR)
               ENDIF
C
C Output the results
C
               IF (E_NUMBERS) THEN
C------------------------------------------------------------------------------
C Start of calls with new format
C------------------------------------------------------------------------------
               IF (NCOL1.GT.N1) THEN
                  IF (ISEND.EQ.1 .AND. NTYPE.EQ.1) THEN
                     NUMTXT = 13
                     D13(1) = SHOWLJ(GMEAN)
                     D13(2) = SHOWRJ(BETROW)
                     D13(3) = SHOWRJ(ROWMEAN)
                     D13(4) = SHOWRJ(FROW)
                     D13(5) = SHOWRJ(BETCOL)
                     D13(6) = SHOWRJ(COLMEAN)
                     D13(7) = SHOWRJ(FCOL)
                     D13(8) = SHOWRJ(RESID)
                     D13(9) = SHOWRJ(RESMEAN)
                     D13(10) = SHOWRJ(TOTAL) 
                     D13(11) = SHOWRJ(FR)
                     WRITE (TEXT,700) ICOUNT, GMEAN,
     +                      BETROW, NROW - N1, ROWMEAN, FROW, PROW,
     +                      BETCOL, NCOL1 - N1, COLMEAN, FCOL, PCOL,
     +                      RESID, (NCOL1 - N1)*(NROW - N1), RESMEAN,
     +                      BLANK13, BLANK8,
     +                      TOTAL, (NCOL1*NROW - N1),
     +                      BLANK13, BLANK13, BLANK8,
     +                      FR, NCOL1 - N1, P
                     WRITE (NF,800) ICOUNT, GMEAN,
     +                      BETROW, NROW - N1, ROWMEAN, FROW, PROW,
     +                      BETCOL, NCOL1 - N1, COLMEAN, FCOL, PCOL,
     +                      RESID, (NCOL1 - N1)*(NROW - N1), RESMEAN,
     +                      DOT13, DOT8,     
     +                      TOTAL, (NCOL1*NROW - N1),
     +                      DOT13, DOT13, DOT8,     
     +                      FR, NCOL1 - N1, P
                  ELSEIF (ISEND.EQ.2 .AND. NTYPE.EQ.1) THEN
                     NUMTXT = 16
                     WRITE (TEXT,900) JCOUNT, GMEAN,
     +                      BETROW, NROW - N1, 
     +                      BETCOL, NCOL1 - N1, COLMEAN, FCOL, PCOL,
     +                      PG, PH, PL,
     +                      RESID, (NCOL1 - N1)*(NROW - N1),
     +                      RESMEAN, TOTAL, (NCOL1*NROW - N1),
     +                      FR, NCOL - N1, P
                     WRITE (NF,1000) JCOUNT, GMEAN,
     +                      BETROW, NROW - N1, DOT13, DOT13, DOT8,
     +                      BETCOL, NCOL1 - N1, COLMEAN, FCOL, PCOL,
     +                      DOT11, DOT13, DOT6, DOT13, DOT13, PG,
     +                      DOT11, DOT13, DOT6, DOT13, DOT13, PH,
     +                      DOT11, DOT13, DOT6, DOT13, DOT13, PL,
     +                      RESID, (NCOL1 - N1)*(NROW - N1), RESMEAN, 
     +                      DOT13, DOT8,
     +                      TOTAL, (NCOL1*NROW - N1), 
     +                      DOT13, DOT13, DOT8,
     +                      FR, NCOL - N1, P
                  ELSEIF (ISEND.EQ.1 .AND. NTYPE.EQ.2) THEN
                     NUMTXT = 7
                     WRITE (TEXT,1100) ICOUNT, GMEAN,
     +                      BETROW, NROW - N1, ROWMEAN, FROW, PROW,
     +                      BETCOL, NCOL1 - N1, COLMEAN, FCOL, PCOL,
     +                      RESID, (NCOL1 - N1)*(NROW - N1), RESMEAN,
     +                      BLANK13, BLANK8,
     +                      TOTAL, (NCOL1*NROW - N1),
     +                      BLANK13, BLANK13, BLANK8
                     WRITE (NF,1200) ICOUNT, GMEAN,
     +                      BETROW, NROW - N1, ROWMEAN, FROW, PROW,
     +                      BETCOL, NCOL1 - N1, COLMEAN, FCOL, PCOL,
     +                      RESID, (NCOL1 - N1)*(NROW - N1), RESMEAN,
     +                      DOT13, DOT8,     
     +                      TOTAL, (NCOL1*NROW - N1),
     +                      DOT13, DOT13, DOT8     
                  ELSEIF (ISEND.EQ.2 .AND. NTYPE.EQ.2) THEN
                     NUMTXT = 10
                     WRITE (TEXT,1300) JCOUNT, GMEAN,
     +                      BETROW, NROW - N1, 
     +                      BETCOL, NCOL1 - N1, COLMEAN, FCOL, PCOL,
     +                      PG, PH, PL,
     +                      RESID, (NCOL1 - N1)*(NROW - N1), RESMEAN,
     +                      TOTAL, (NCOL1*NROW - N1)
                     WRITE (NF,1400) JCOUNT, GMEAN,
     +                      BETROW, NROW - N1, DOT13, DOT13, DOT8,
     +                      BETCOL, NCOL1 - N1, COLMEAN, FCOL, PCOL,
     +                      DOT11, DOT13, DOT6, DOT13, DOT13, PG,
     +                      DOT11, DOT13, DOT6, DOT13, DOT13, PH,
     +                      DOT11, DOT13, DOT6, DOT13, DOT13, PL,
     +                      RESID, (NCOL1 - N1)*(NROW - N1), RESMEAN,
     +                      DOT13, DOT8, 
     +                      TOTAL, (NCOL1*NROW - N1), DOT13, DOT13, DOT8
                  ELSE
                     NUMTXT = 5
                     WRITE (TEXT,1500) KCOUNT, FR, NCOL1 - N1, P
                     WRITE (NF,1600) KCOUNT, FR, NCOL1 - N1, P
                  ENDIF
               ENDIF
C--------------------------------------------------------------------------------
               ELSE  
C--------------------------------------------------------------------------------
               IF (NCOL1.GT.N1) THEN
                  IF (ISEND.EQ.1 .AND. NTYPE.EQ.1) THEN
                     NUMTXT = 13
                     D13(1) = SHOWLJ(GMEAN)
                     D13(2) = SHOWRJ(BETROW)
                     D13(3) = SHOWRJ(ROWMEAN)
                     D13(4) = SHOWRJ(FROW)
                     D13(5) = SHOWRJ(BETCOL)
                     D13(6) = SHOWRJ(COLMEAN)
                     D13(7) = SHOWRJ(FCOL)
                     D13(8) = SHOWRJ(RESID)
                     D13(9) = SHOWRJ(RESMEAN)
                     D13(10) = SHOWRJ(TOTAL) 
                     D13(11) = SHOWLJ(FR)
                     I12(1) = FORM12(NCOL1 - N1)
                     WRITE (TEXT,750) ICOUNT, TRIM(D13(1)),
     +                      D13(2), NROW - N1, D13(3), D13(4), PROW,
     +                      D13(5), NCOL1 - N1, D13(6), D13(7), PCOL,
     +                      D13(8), (NCOL1 - N1)*(NROW - N1), D13(9),
     +                      BLANK13, BLANK8,     
     +                      D13(10), (NCOL1*NROW - N1),
     +                      BLANK13, BLANK13, BLANK8,     
     +                      D13(11), I12(1), P
                     WRITE (NF,850) ICOUNT, TRIM(D13(1)),
     +                      D13(2), NROW - N1, D13(3), D13(4), PROW,
     +                      D13(5), NCOL1 - N1, D13(6), D13(7), PCOL,
     +                      D13(8), (NCOL1 - N1)*(NROW - N1), D13(9),
     +                      DOT13, DOT8,     
     +                      D13(10), (NCOL1*NROW - N1),
     +                      DOT13, DOT13, DOT8,     
     +                      D13(11), I12(1), P
                  ELSEIF (ISEND.EQ.2 .AND. NTYPE.EQ.1) THEN
                     NUMTXT = 16
                     D13(1) = SHOWLJ(GMEAN)
                     D13(2) = SHOWRJ(BETROW)
                     D13(3) = SHOWRJ(BETCOL)
                     D13(4) = SHOWRJ(COLMEAN)
                     D13(5) = SHOWRJ(FCOL) 
c                     D13(6) = SHOWRJ(PG)
c                     D13(7) = SHOWRJ(PH)
c                     D13(8) = SHOWRJ(PL)
                     D13(9) = SHOWRJ(RESID)
                     D13(10) = SHOWRJ(RESMEAN)
                     D13(11) = SHOWRJ(TOTAL)
                     D13(12) = SHOWLJ(FR)
                     I12(1) = FORM12(NCOL - N1) 
                     WRITE (TEXT,950) JCOUNT, TRIM(D13(1)),
     +                      D13(2), NROW - N1, 
     +                      D13(3), NCOL1 - N1, D13(4), D13(5), PCOL,
     +                      PG, PH, PL,
     +                      D13(9), (NCOL1 - N1)*(NROW - N1),
     +                      D13(10), D13(11), (NCOL1*NROW - N1),
     +                      D13(12), I12(1), P
                     WRITE (NF,1050) JCOUNT, TRIM(D13(1)),
     +                      D13(2), NROW - N1, DOT13, DOT13, DOT8,
     +                      D13(3), NCOL1 - N1, D13(4), D13(5), PCOL,
     +                      DOT11, DOT13, DOT6, DOT13, DOT13, PG,
     +                      DOT11, DOT13, DOT6, DOT13, DOT13, PH,
     +                      DOT11, DOT13, DOT6, DOT13, DOT13, PL,
     +                      D13(9), (NCOL1 - N1)*(NROW - N1), D13(10), 
     +                      DOT13, DOT8,
     +                      D13(11), (NCOL1*NROW - N1), 
     +                      DOT13, DOT13, DOT8,
     +                      D13(12), I12(1), P
                  ELSEIF (ISEND.EQ.1 .AND. NTYPE.EQ.2) THEN
                     NUMTXT = 7
                     D13(1) = SHOWLJ(GMEAN)
                     D13(2) = SHOWRJ(BETROW)
                     D13(3) = SHOWRJ(ROWMEAN)
                     D13(4) = SHOWRJ(FROW)
                     D13(5) = SHOWRJ(BETCOL)
                     D13(6) = SHOWRJ(COLMEAN)
                     D13(7) = SHOWRJ(FCOL)
                     D13(8) = SHOWRJ(RESID)
                     D13(9) = SHOWRJ(RESMEAN)
                     D13(10) = SHOWRJ(TOTAL)
                     WRITE (TEXT,1150) ICOUNT, TRIM(D13(1)),
     +                      D13(2), NROW - N1, D13(3), D13(4), PROW,
     +                      D13(5), NCOL1 - N1, D13(6), D13(7), PCOL,
     +                      D13(8), (NCOL1 - N1)*(NROW - N1), D13(9),
     +                      BLANK13, BLANK8,
     +                      D13(10), (NCOL1*NROW - N1),
     +                      BLANK13, BLANK13, BLANK8
                     WRITE (NF,1250) ICOUNT, TRIM(D13(1)),
     +                      D13(2), NROW - N1, D13(3), D13(4), PROW,
     +                      D13(5), NCOL1 - N1, D13(6), D13(7), PCOL,
     +                      D13(8), (NCOL1 - N1)*(NROW - N1), D13(9),
     +                      DOT13, DOT8,     
     +                      D13(10), (NCOL1*NROW - N1),
     +                      DOT13, DOT13, DOT8     
                  ELSEIF (ISEND.EQ.2 .AND. NTYPE.EQ.2) THEN
                     D13(1) = SHOWLJ(GMEAN)
                     D13(2) = SHOWRJ(BETROW)
                     D13(3) = SHOWRJ(BETCOL)
                     D13(4) = SHOWRJ(COLMEAN)
                     D13(5) = SHOWRJ(FCOL)
                     D13(6) = SHOWRJ(RESID)
                     D13(7) = SHOWRJ(RESMEAN)
                     D13(8) = SHOWRJ(TOTAL)
                     NUMTXT = 10
                     WRITE (TEXT,1350) JCOUNT, TRIM(D13(1)),
     +                      D13(2), NROW - N1, 
     +                      D13(3), NCOL1 - N1, D13(4), D13(5), PCOL,
     +                      PG, PH, PL,
     +                      D13(6), (NCOL1 - N1)*(NROW - N1), D13(7),
     +                      D13(8), (NCOL1*NROW - N1)
                     WRITE (NF,1450) JCOUNT, TRIM(D13(1)),
     +                      D13(2), NROW - N1, DOT13, DOT13, DOT8,
     +                      D13(3), NCOL1 - N1, D13(4), D13(5), PCOL,
     +                      DOT11, DOT13, DOT6, DOT13, DOT13, PG,
     +                      DOT11, DOT13, DOT6, DOT13, DOT13, PH,
     +                      DOT11, DOT13, DOT6, DOT13, DOT13, PL,
     +                      D13(6), (NCOL1 - N1)*(NROW - N1), D13(7),
     +                      DOT13, DOT8, 
     +                      D13(8), (NCOL1*NROW - N1), DOT13, DOT13, 
     +                      DOT8
                  ELSE
                     NUMTXT = 5
                     D13(1) = SHOWLJ(FR)
                     I12(1) = FORM12(NCOL1 - N1)
                     WRITE (TEXT,1550) KCOUNT, D13(1), I12(1), P
                     WRITE (NF,1650) KCOUNT, D13(1), I12(1), P
                  ENDIF
               ENDIF
C-----------------------------------------------------------------------------------
C End of calls with new formats
C-----------------------------------------------------------------------------------
               ENDIF  
               
               J = 15
               CALL TABLE1 (J, 'OPEN')
               DO I = 1, NUMTXT
                  IF (I.EQ.1) THEN
                     J = 4
                  ELSEIF (I.EQ.3 .AND. NUMTXT.GT.5) THEN
                     J = 4   
                  ELSEIF (ISEND.EQ.1.AND.NTYPE.EQ.1.AND.I.EQ.9) THEN
                     J = 4
                  ELSEIF (ISEND.EQ.2.AND.NTYPE.EQ.1.AND.I.EQ.12) THEN
                     J = 4
                  ELSE
                     J = 0
                  ENDIF
                  CALL TABLE1 (J, TEXT(I))
               ENDDO
               CALL TABLE1 (J,'CLOSE')
               IF (ISEND.EQ.2 .AND. NROW.GT.NCOL1) THEN
                   CALL HOTEL2 (JSEND, NCOL1, NF, NRMAX1, NROW,
     +                          A1, A2, A3, D1HOT, D2HOT, PHOT, SHOT,
     +                          T2HOT, X, Y,
     +                          ABORT)
               ENDIF
            ENDIF
            NDEC = 3
         ELSEIF (NDEC.EQ.12) THEN
C
C Type
C
            NOPT = 3
            NSTART = 3
            NUMTXT = NSTART + NOPT - 1
            WRITE (TEXT,1700)
            CALL TBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NTYPE, NOPT,
     +                   NUMPOS, NSTART, NUMTXT,
     +                   TEXT,
     +                   TAB_TOP, TAB_MID, TAB_BOT)
            NDEC = 3
         ELSEIF (NDEC.EQ.NOPT) THEN
            NEWDAT = .FALSE.
            AGAIN = .FALSE.
         ENDIF
      ENDDO
C
C Deallocate workspace
C
      DEALLOCATE(A1, STAT = IERR)
      IF (ALLOCATED(A2)) DEALLOCATE(A2, STAT = IERR)
      IF (ALLOCATED(A3)) DEALLOCATE(A3, STAT = IERR)
      IF (ALLOCATED(XC)) DEALLOCATE(XC, STAT = IERR)
C
C Format statements
C
  100 FORMAT (
     + '2-way ANOVA'
     +/
     +/'Input a n rows by m columns data matrix with no missing values.'
     +/'Then you can edit [remove/restore column(s) in] the active set.'
     +/'Use data untransformed and only use the variance stabilisation'
     +/'if you have good reasons to do so, and know what you are doing.'
     +/'Note: log is to base e and x can be a percentage or proportion.'
     +/
     +/'Input new 2-Way ANOVA data'
     +/'Suppress/restore columns'
     +/'ANOVA [on x (data untransformed)]'
     +/'ANOVA [on log(x))]'
     +/'ANOVA [on sqrt(x)]'
     +/'ANOVA [on arcsin(sqrt(x/100))]`(0 < x < 100)'
     +/'ANOVA [on log(x/(100 - x))]   `(0 < x < 100)'
     +/'ANOVA [on Phi_inverse(x/100))]`(0 < x < 100)'
     +/'ANOVA [on arcsin(sqrt(x))]    `(0 < x < 1)'
     +/'ANOVA [on log(x/(1 - x))]     `(0 < x < 1)'
     +/'ANOVA [on Phi_inverse(x)]     `(0 < x < 1)'
     +/'Parametric/nonparametric      `',A
     +/'Quit                          `Exit 2-way ANOVA')
  200 FORMAT (
     + 'Repeated measurements ANOVA'
     +/
     +/'Input a n rows by m columns data matrix with no missing values.'
     +/'Then you can edit [remove/restore column(s) in] the active set.'
     +/'Use data untransformed and only use the variance stabilisation'
     +/'if you have good reasons to do so, and know what you are doing.'
     +/'Note: log is to base e and x can be a percentage or proportion.'
     +/
     +/'Input new repeat-measures data'
     +/'Suppress/restore columns'
     +/'ANOVA [on x (data untransformed)]'
     +/'ANOVA [on log(x))]'
     +/'ANOVA [on sqrt(x)]'
     +/'ANOVA [on arcsin(sqrt(x/100))]`(0 < x < 100)'
     +/'ANOVA [on log(x/(100 - x))]   `(0 < x < 100)'
     +/'ANOVA [on Phi_inverse(x/100))]`(0 < x < 100)'
     +/'ANOVA [on arcsin(sqrt(x))]    `(0 < x < 1)'
     +/'ANOVA [on log(x/(1 - x))]     `(0 < x < 1)'
     +/'ANOVA [on Phi_inverse(x)]     `(0 < x < 1)'
     +/'Parametric/nonparametric      `',A
     +/'Quit                          `Exit Repeat Measures ANOVA')
  400 FORMAT (1X,A)
  500 FORMAT (
     + 1X,'Data for 2-way Analysis of Variance',I4
     +/1X,'---------------------------------------')
  600 FORMAT (
     + 1X,'Data for Repeat-Measures Analysis of Variance',I4
     +/1X,'-------------------------------------------------')
  700 FORMAT (
     + 'Results for 2-Way ANOVA:',I4,' (Grand mean',1P,E13.5,')'
     +/
     +/'Source                SSQ',7X,'NDOF',7X,'MSSQ',10X,'F',9X,'p'
     +/'Between rows   ',1P,1X,E13.5, I6, 2(1X,E13.5),0P,F8.4,
     +/'Between columns',1P,1X,E13.5, I6, 2(1X,E13.5),0P,F8.4,
     +/'Residual       ',1P,1X,E13.5, I6,  1X,E13.5,4X,A13,A8,
     +/'Total          ',1P,1X,E13.5, I6,  4X,A13,1X,A13,A8   
     +/
     +/'Friedman Nonparametric Two-Way Analysis of Variance'
     +/
     +/'Test-Statistic =',1P,1X,E13.5
     +/'No. Deg. Free. =',I8
     +/'Significance   =',0P,F8.4)
  750 FORMAT (
     + 'Results for 2-Way ANOVA:',I4,' (Grand mean',1X,A,')'
     +/
     +/'Source                  SSQ',5X,'NDOF',7X,'MSSQ',12X,'F',7X,'p'
     +/'Between rows   ',1X,A13, I6, 2(1X,A13),F8.4,
     +/'Between columns',1X,A13, I6, 2(1X,A13),F8.4,
     +/'Residual       ',1X,A13, I6,  1X,A13,1X,A13,A8,
     +/'Total          ',1X,A13, I6,  1X,A13,1X,A13,A8   
     +/
     +/'Friedman Nonparametric Two-Way Analysis of Variance'
     +/
     +/'Test-Statistic =',1X,A13
     +/'No. Deg. Free. =',1X,A
     +/'Significance   =',F7.4)   
C---------------------------------------------------------------------------       
  800 FORMAT (
     +/' Results for 2-Way ANOVA:',I4,' (Grand mean',1P,E13.5,')'
     +/' ----------------------------'
     +/' Source                SSQ',7X,'NDOF',7X,'MSSQ',10X,'F',9X,'p'
     +/' Between rows   ',1P,1X,E13.5, I6, 2(1X,E13.5),0P,F8.4,
     +/' Between columns',1P,1X,E13.5, I6, 2(1X,E13.5),0P,F8.4,
     +/' Residual       ',1P,1X,E13.5, I6,   1X,E13.5,4X,A13,A8,
     +/' Total          ',1P,1X,E13.5, I6,   4X,A13,1X,A13,A8
     +/
     +/' Friedman Nonparametric Two-Way Analysis of Variance'
     +/' ---------------------------------------------------'
     +/' Test-Statistic =',1P,1X,E13.5
     +/' No. Deg. Free. =',I8
     +/' Significance   =',0P,F8.4)
  850 FORMAT (
     +/' Results for 2-Way ANOVA:',I4,' (Grand mean',1X,A,')'
     +/' ----------------------------'
     +/' Source                  SSQ',5X,'NDOF',7X,'MSSQ',12X,'F',7X,'p'
     +/' Between rows   ',1X,A13, I6, 2(1X,A13),F8.4,
     +/' Between columns',1X,A13, I6, 2(1X,A13),F8.4,
     +/' Residual       ',1X,A13, I6,   1X,A13,1X,A13,A8,
     +/' Total          ',1X,A13, I6,   1X,A13,1X,A13,A8
     +/
     +/' Friedman Nonparametric Two-Way Analysis of Variance'
     +/' ---------------------------------------------------'
     +/' Test-Statistic =',1X,A13
     +/' No. Deg. Free. =',1X,A
     +/' Significance   =',F7.4)     
C-----------------------------------------------------------------     
  900 FORMAT (
     + 'Repeat-measures ANOVA:',I4,' (Grand mean',1P,E13.5,')'
     +/
     +/'Source           SSQ',7X,'NDOF',7X,'MSSQ',10X,'F',10X,'p'
     +/'Subjects  ',1P,1X,E13.5, I6, 
     +/'Treatments',1P,1X,E13.5, I6, 2(1X,E13.5),0P,F9.4,
     +/58X,0P,F11.6,'(Greenhouse-Geisser)'
     +/58X,0P,F11.6,'(Huyhn-Feldt)'
     +/58X,0P,F11.6,'(Lower-bound)'
     +/'Remainder ',1P,1X,E13.5, I6,  1X,E13.5,
     +/'Total     ',1P,1X,E13.5, I6,  
     +/
     +/'Friedman Nonparametric Two-Way Analysis of Variance'
     +/
     +/'Test Statistic =',1P,1X,E13.5
     +/'No. Deg. Free. =',I8
     +/'Significance   =',0P,F8.4)
  950 FORMAT (
     + 'Repeat-measures ANOVA:',I4,' (Grand mean',1X,A,')'
     +/
     +/'Source           SSQ',7X,'NDOF',7X,'MSSQ',10X,'F',9X,'p'
     +/'Subjects  ',1X,A13, I6, 
     +/'Treatments',1X,A13, I6, 2(1X,A13),F9.4,
     +/58X,F11.6,'(Greenhouse-Geisser)'
     +/58X,F11.6,'(Huyhn-Feldt)'
     +/58X,F11.6,'(Lower-bound)'
     +/'Remainder ',1X,A13, I6,  1X,A13,
     +/'Total     ',1X,A13, I6,  
     +/
     +/'Friedman Nonparametric Two-Way Analysis of Variance'
     +/
     +/'Test Statistic =',1X,A13
     +/'No. Deg. Free. =',1X,A
     +/'Significance   =',F7.4)  
C------------------------------------------------------------        
 1000 FORMAT (
     +/' Repeat-measures ANOVA:',I4,' (Grand mean',1P,E13.5,')'
     +/' --------------------------'
     +/' Source           SSQ',7X,'NDOF',7X,'MSSQ',10X,'F',9X,'p'
     +/' Subjects  ',1P,1X,E13.5, I6, 1X,A13, 1X,A13, A8,
     +/' Treatments',1P,1X,E13.5, I6, 2(1X,E13.5),0P,F9.4,
     +/1X,A10,1X,A13,A6,1X,A13,1X,A13,0P,F11.6,'(Greenhouse-Geisser)'
     +/1X,A10,1X,A13,A6,1X,A13,1X,A13,0P,F11.6,'(Huyhn-Feldt)'
     +/1X,A10,1X,A13,A6,1X,A13,1X,A13,0P,F11.6,'(Lower-bound)'
     +/' Remainder ',1P,1X,E13.5, I6,  1X,E13.5, 1X,A13, A8
     +/' Total     ',1P,1X,E13.5, I6,  1X,A13  , 1X,A13, A8 
     +/
     +/' Friedman Nonparametric Two-Way Analysis of Variance'
     +/' ---------------------------------------------------'
     +/' Test-Statistic =',1P,1X,E13.5
     +/' No. Deg. Free. =',I8
     +/' Significance   =',0P,F8.4)
 1050 FORMAT (
     +/' Repeat-measures ANOVA:',I4,' (Grand mean',1X,A,')'
     +/' --------------------------'
     +/' Source           SSQ',7X,'NDOF',7X,'MSSQ',10X,'F',9X,'p'
     +/' Subjects  ',1X,A13, I6, 1X,A13, 1X,A13, A8,
     +/' Treatments',1X,A13, I6, 2(1X,A13),F9.4,
     +/1X,A10,1X,A13,A6,1X,A13,1X,A13,F11.6,'(Greenhouse-Geisser)'
     +/1X,A10,1X,A13,A6,1X,A13,1X,A13,F11.6,'(Huyhn-Feldt)'
     +/1X,A10,1X,A13,A6,1X,A13,1X,A13,F11.6,'(Lower-bound)'
     +/' Remainder ',1X,A13, I6,  1X,A13, 1X,A13, A8
     +/' Total     ',1X,A13, I6,  1X,A13, 1X,A13, A8 
     +/
     +/' Friedman Nonparametric Two-Way Analysis of Variance'
     +/' ---------------------------------------------------'
     +/' Test-Statistic =',1X,A13
     +/' No. Deg. Free. =',1X,A
     +/' Significance   =',F7.4)    
C----------------------------------------------------------------      
 1100 FORMAT (
     + 'Results for 2-way ANOVA:',I4,' (Grand mean',1P,E11.3,')'
     +/
     +/'Source                 SSQ',5X,'NDOF',8X,'MSSQ',11X,'F',8X,'p'
     +/'Between rows   ',1P,1X,E13.5, I6, 2(1X,E13.5),0P,F8.4,
     +/'Between columns',1P,1X,E13.5, I6, 2(1X,E13.5),0P,F8.4,
     +/'Residual       ',1P,1X,E13.5, I6, 1X,E13.5, 1X,A13, A8,
     +/'Total          ',1P,1X,E13.5, I6, 1X,A13,   1X,A13, A8)
 1150 FORMAT (
     + 'Results for 2-way ANOVA:',I4,' (Grand mean',1X,A,')'
     +/
     +/'Source                 SSQ',5X,'NDOF',8X,'MSSQ',11X,'F',8X,'p'
     +/'Between rows   ',1X,A13, I6, 2(1X,A13),F8.4,
     +/'Between columns',1X,A13, I6, 2(1X,A13),F8.4,
     +/'Residual       ',1X,A13, I6,   1X,A13, 1X,A13, A8,
     +/'Total          ',1X,A13, I6,   1X,A13, 1X,A13, A8)  
C-----------------------------------------------------------------------        
 1200 FORMAT (
     +/' Results for 2-way ANOVA:',I4,' (Grand mean',1P,E13.5,')'
     +/' ----------------------------'
     +/' Source                 SSQ',5X,'NDOF',8X,'MSSQ',11X,'F',8X,'p'
     +/' Between rows   ',1P,1X,E13.5, I6, 2(1X,E13.5),0P,F8.4,
     +/' Between columns',1P,1X,E13.5, I6, 2(1X,E13.5),0P,F8.4,
     +/' Residual       ',1P,1X,E13.5, I6, 1X, E13.5, 1X,A13, A8
     +/' Total          ',1P,1X,E13.5, I6, 1X,  A13,  1X,A13, A8)
 1250 FORMAT (
     +/' Results for 2-way ANOVA:',I4,' (Grand mean',1X,A,')'
     +/' ----------------------------'
     +/' Source                 SSQ',5X,'NDOF',8X,'MSSQ',11X,'F',8X,'p'
     +/' Between rows   ',1X,A13, I6, 2(1X,A13),F8.4,
     +/' Between columns',1X,A13, I6, 2(1X,A13),F8.4,
     +/' Residual       ',1X,A13, I6, 1X, A13, 1X,A13, A8
     +/' Total          ',1X,A13, I6, 1X, A13, 1X,A13, A8)   
C------------------------------------------------------------------       
 1300 FORMAT (
     + 'Repeat-measures ANOVA:',I3,' (Grand mean',1P,E13.5,')'
     +/
     +/'Source           SSQ',7X,'NDOF',7X,'MSSQ',10X,'F',10X,'p'
     +/'Subjects  ',1P,1X,E13.5, I6, 
     +/'Treatments',1P,1X,E13.5, I6, 2(1X,E13.5),1X,0P,F9.4,
     +/59X,0P,F11.6,'(Greenhouse-Geisser)'
     +/59X,0P,F11.6,'(Huyhn-Feldt)'
     +/59X,0P,F11.6,'(Lower-bound)'
     +/'Remainder ',1P,1X,E13.5, I6,  1X,E13.5,
     +/'Total     ',1P,1X,E13.5, I6)
 1350 FORMAT (
     + 'Repeat-measures ANOVA:',I3,' (Grand mean',1X,A,')'
     +/
     +/'Source           SSQ',7X,'NDOF',7X,'MSSQ',10X,'F',11X,'p'
     +/'Subjects  ',1X,A13, I6, 
     +/'Treatments',1X,A13, I6, 2(1X,A13),2X,F8.4,
     +/59X,0P,F11.6,'(Greenhouse-Geisser)'
     +/59X,0P,F11.6,'(Huyhn-Feldt)'
     +/59X,0P,F11.6,'(Lower-bound)'
     +/'Remainder ',1X,A13, I6,  1X,A13,
     +/'Total     ',1X,A13, I6)  
C-------------------------------------------------------------------        
 1400 FORMAT (
     +/' Repeat-measures ANOVA:',I4,' (Grand mean',1P,E13.5,')'
     +/' --------------------------'
     +/' Source             SSQ',7X,'NDOF',7X,'MSSQ',10X,'F',10X,'p'
     +/' Subjects  ',1P,1X,E13.5, I6, 1X,A13, 1X,A13, 1X,A8,
     +/' Treatments',1P,1X,E13.5, I6, 2(1X,E13.5),1X,0P,F9.4,
     +/1X,A10,1X,A13,A6,1X,A13,1X,A13,1X,0P,F11.6,'(Greenhouse-Geisser)'
     +/1X,A10,1X,A13,A6,1X,A13,1X,A13,1X,0P,F11.6,'(Huyhn-Feldt)'
     +/1X,A10,1X,A13,A6,1X,A13,1X,A13,1X,0P,F11.6,'(Lower-bound)'
     +/' Remainder ',1P,1X,E13.5, I6,  1X,E13.5, 1X,A13, A8,
     +/' Total     ',1P,1X,E13.5, I6,  1X,A13, 1X,A13, A8)
 1450 FORMAT (
     +/' Repeat-measures ANOVA:',I4,' (Grand mean',1X,A,')'
     +/' --------------------------'
     +/' Source             SSQ',7X,'NDOF',7X,'MSSQ',10X,'F',10X,'p'
     +/' Subjects  ',1X,A13, I6, 1X,A13, 1X,A13, 1X,A8,
     +/' Treatments',1X,A13, I6, 2(1X,A13),1X,F9.4,
     +/1X,A10,1X,A13,A6,1X,A13,1X,A13,1X,F11.6,'(Greenhouse-Geisser)'
     +/1X,A10,1X,A13,A6,1X,A13,1X,A13,1X,F11.6,'(Huyhn-Feldt)'
     +/1X,A10,1X,A13,A6,1X,A13,1X,A13,1X,F11.6,'(Lower-bound)'
     +/' Remainder ',1X,A13, I6,  1X,A13, 1X,A13, A8,
     +/' Total     ',1X,A13, I6,  1X,A13, 1X,A13, A8)  
C------------------------------------------------------------------------        
 1500 FORMAT (
     + 'Results for 2-way Friedman nonparametric ANOVA:',I4
     +/
     +/'Test-Statistic =',1P,1X,E13.5
     +/'No. Deg. Free. =',I8
     +/'Significance   =',0P,F8.4)
 1550 FORMAT (
     + 'Results for 2-way Friedman nonparametric ANOVA:',I4
     +/
     +/'Test-Statistic =',1X,A13
     +/'No. Deg. Free. =',1X,A
     +/'Significance   =',F7.4)     
C-----------------------------------------------------------------------     
 1600 FORMAT (
     +/' Results for 2-way Friedman nonparametric ANOVA:',I4
     +/' ---------------------------------------------------'
     +/
     +/' Test-Statistic =',1P,1X,E13.5
     +/' No. Deg. Free. =',I8
     +/' Significance   =',0P,F8.4)
 1650 FORMAT (
     +/' Results for 2-way Friedman nonparametric ANOVA:',I4
     +/' ---------------------------------------------------'
     +/
     +/' Test-Statistic =',1X,A13
     +/' No. Deg. Free. =',1X,A
     +/' Significance   =',F7.4)   
C------------------------------------------------------------       
 1700 FORMAT (
     + 'Choose the mode required'
     +/
     +/'Parametric and Nonparametric'
     +/'Parametric only'
     +/'Nonparametric only')
      END
C
C
