C
C
      SUBROUTINE ANOVA3 (IA, LCODE, NF, NIN, NRMAX,
     +                   A, AMC, AMR, AMT, B, DATA1,
     +                   FNAME, TITLE,
     +                   NEWDAT, SUPPLY)
C
C ACTION: ANOVA for Latin Square Design
C AUTHOR: W. G. Bardsley, University of Manchester, U.K., 31/1/95
C         16/12/1996 Transferred from FTEST to DLL
C         30/04/1997 win32 version
C         07/02/2001 added CHOP80 and TRIM80
C         27/03/2006 added FNAME, TITLE, NEWDAT, and SUPPLy to arguments
C                    and re-dimensioned DATA1 from NRMAX to IA**2
C         11/05/2010 introduced NKLCFG to switch on/off the test file advice  
C         30/04/2011 introduced call to TFILEQ   
C         23/09/2016 minor editing  
C         16/08/2021 added E_NUMBERS and E_FORMATS, etc.
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    IA, LCODE(IA,IA), NF, NIN, NRMAX
      DOUBLE PRECISION A(NRMAX,IA), AMC(IA), AMR(IA), AMT(IA), B(IA),
     +                 DATA1(IA**2)
      CHARACTER  FNAME*(*), TITLE*(*)
      LOGICAL    NEWDAT, SUPPLY
C
C Locals
C
      INTEGER    ICOLOR, IXL, IYL, NUMTXT, N1, N21
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, N1 = 1, N21 = 21)
      INTEGER    I, J, K, M, N, ND, IERRDF, MM1
      INTEGER    ISEND, NCMAX, NCOL, NROW
      INTEGER    ICOUNT
      INTEGER    KVAL9, NKLCFG
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      DOUBLE PRECISION ERR, GMEAN, VAR(5),
     +           V1, V2, V3, V4, V5, V6, V7, V8, RMM1, RN, ERRDF, RND1,
     +           P1, P2, P3
      DOUBLE PRECISION RTOL, G01EDF$, X02AMF$
      CHARACTER (LEN = 100) LINE, TEXT(30), TEMP(30)
      CHARACTER (LEN = 80 ) CHOP80, TRIM80, WORD80
      CHARACTER (LEN = 13 ) BLANK13, DOT13
      PARAMETER (BLANK13 = '             ', DOT13 = '   ...       ')
      CHARACTER (LEN = 13 ) D13(26), SHOWLJ, SHOWRJ
      CHARACTER (LEN = 8  ) BLANK8, DOT8
      PARAMETER (BLANK8 = '        ', DOT8 = '   ...  ') 
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    ABORT, FIXCOL, FIXROW, LABEL
      PARAMETER (FIXCOL = .FALSE., FIXROW = .FALSE., LABEL = .FALSE.)
      EXTERNAL   E_FORMATS, SHOWLJ, SHOWRJ 
      EXTERNAL   MATTIN, PUTFAT, TRIM80, CHOP80
      EXTERNAL   G04ADF$, G01EDF$, X02AMF$
      EXTERNAL   TABLE1, YESNO2, ISITMF
      EXTERNAL   NKLCFG, TFILEQ
      INTRINSIC  NINT, DBLE
      SAVE       ICOUNT
      DATA       ICOUNT / 0 /
C
C Initialise NEWDAT and check file provided if SUPPLY = .TRUE.
C
      NEWDAT = .FALSE.
      IF (SUPPLY) THEN
         CALL ISITMF (NCOL, NROW,
     +                FNAME)
         IF (NCOL.GT.IA .OR. NROW.GT.NRMAX) RETURN
         NCMAX = IA
      ENDIF
      RTOL = 1.0D+09*X02AMF$()
C
C LABEL 20: start of analysis
C =========
C
      E_NUMBERS = E_FORMATS()
      
   20 CONTINUE
      IF (.NOT.SUPPLY) THEN
C
C Read in and check data if SUPPLY = .FALSE.
C
         ISEND = 2
         NCMAX = IA
         CLOSE (UNIT = NIN)
         KVAL9 = NKLCFG(N21)
         IF (KVAL9.EQ.N1) CALL TFILEQ (
     +'Now input a data file formatted like anova3.tf1')
         CALL MATTIN (ISEND, NCMAX, NCOL, NIN, NRMAX, NROW,
     +                A, B,
     +                FNAME, TITLE,
     +                ABORT, FIXCOL, FIXROW, LABEL)
         CLOSE (UNIT = NIN)
         IF (ABORT) GOTO 40
      ENDIF
      IF (NROW.NE.2*NCOL) THEN
         CALL PUTFAT ('No. rows must be 2xno. cols. in Latin Square')
         GOTO 40
      ENDIF
      IF (NCOL.LT.2) THEN
         CALL PUTFAT ('Insufficient data')
         GOTO 40
      ENDIF
C
C Prepare for calculations then call to NAG routine
C
      GMEAN = ZERO
      N = NCOL
      M = 0
      DO I = 1, N
         DO J = 1, N
            LCODE(I,J) = NINT(A(I,J))
            M = M + 1
            DATA1(M) = A(I + N, J)
            GMEAN = GMEAN + DATA1(M)
         ENDDO
      ENDDO
      GMEAN = GMEAN/DBLE(M)
      CALL G04ADF$(DATA1, VAR, AMR, AMC, AMT, LCODE, IA, N, M)
      ND = N - 1
      IERRDF = ND*(ND - 1)
      ERRDF = IERRDF
      IF (ERRDF.LE.RTOL) THEN
         CALL PUTFAT ('Calculation impossible')
         GOTO 40
      ENDIF
      ERR = VAR(4)/ERRDF
      RND1 = DBLE(ND)
      IF (ERR.LE.RTOL .OR. RND1.LE.RTOL) THEN
         CALL PUTFAT ('Calculation impossible')
         GOTO 40
      ENDIF
      V1 = VAR(1)/RND1
      V2 = V1/ERR
      V3 = VAR(2)/RND1
      V4 = V3/ERR
      V5 = VAR(3)/RND1
      V6 = V5/ERR
      V7 = VAR(4)/ERRDF
      MM1 = M - 1
      RMM1 = MM1
      V8 = VAR(5)/RMM1
      DO I = 1, N
         RN = DBLE(N)
         AMR(I) = AMR(I)/RN
         AMC(I) = AMC(I)/RN
         AMT(I) = AMT(I)/RN
      ENDDO
      I = 1
      P1 = G01EDF$('Upper-tail', V2, DBLE(ND), DBLE(IERRDF), I)
      I = 1
      P2 = G01EDF$('Upper-tail', V4, DBLE(ND), DBLE(IERRDF), I)
      I = 1
      P3 = G01EDF$('Upper-tail', V6, DBLE(ND), DBLE(IERRDF), I)
      ICOUNT = ICOUNT + 1
      WORD80 = TRIM80(FNAME)
C
C--------------------------------------------------------------
C     
      IF (E_NUMBERS) THEN 
         WRITE (TEMP,100) ICOUNT, GMEAN, WORD80, CHOP80(TITLE)
         WRITE (NF,'(A)') ' '
         WRITE (NF,'(A)') '***'
         WRITE (NF,'(A)') ' '
         WRITE (NF,100) ICOUNT, GMEAN, WORD80, CHOP80(TITLE)
         DO I = 1, 6
            TEXT(I) = TEMP(I)
         ENDDO
         WRITE (TEMP,200) ND, VAR(1), V1, V2, P1,
     +                    ND, VAR(2), V3, V4, P2,
     +                    ND, VAR(3), V5, V6, P3
         WRITE (NF,200) ND, VAR(1), V1, V2, P1,
     +                  ND, VAR(2), V3, V4, P2,
     +                  ND, VAR(3), V5, V6, P3
         DO I = 1, 3
            TEXT(6 + I) = TEMP(I)
         ENDDO
         WRITE (TEMP,300) IERRDF, VAR(4), V7, BLANK13, BLANK8,  
     +                    MM1,    VAR(5), V8, BLANK13, BLANK8 
         WRITE (NF,300) IERRDF, VAR(4), V7, DOT13, DOT8,   
     +                  MM1,    VAR(5), V8, DOT13, DOT8
         DO I = 1, 2
            TEXT(9 + I) = TEMP(I)
         ENDDO
         IF (N.LT.9) THEN
            WRITE (TEMP,400) (AMR(K), K = 1, N)
            WRITE (NF,400) (AMR(K), K = 1, N)
            TEXT(12) = TEMP(1)
            TEXT(13) = TEMP(2)
            WRITE (TEMP,500) (AMC(K), K = 1, N)
            WRITE (NF,500) (AMC(K), K = 1, N)
            TEXT(14) = TEMP(1)
            TEXT(15) = TEMP(2)
            WRITE (TEMP,600) (AMT(K), K = 1, N)
            WRITE (NF,600) (AMT(K), K = 1, N)
            TEXT(16) = TEMP(1)
            TEXT(17) = TEMP(2)
            NUMTXT = 17
         ELSE
            NUMTXT = 11
         ENDIF
C
C------------------------------------------------------------------------------
C
      ELSE
         D13(1) = SHOWLJ(GMEAN)
         WRITE (TEMP,150) ICOUNT, TRIM(D13(1)), WORD80, CHOP80(TITLE)
         WRITE (NF,'(A)') ' '
         WRITE (NF,'(A)') '***'
         WRITE (NF,'(A)') ' '
         WRITE (NF,150) ICOUNT, TRIM(D13(1)), WORD80, CHOP80(TITLE)
         DO I = 1, 6
            TEXT(I) = TEMP(I)
         ENDDO
         D13(1) = SHOWRJ(VAR(1))
         D13(2) = SHOWRJ(V1)
         D13(3) = SHOWRJ(V2)
         D13(4) = SHOWRJ(VAR(2))
         D13(5) = SHOWRJ(V3)
         D13(6) = SHOWRJ(V4)
         D13(7) = SHOWRJ(VAR(3))
         D13(8) = SHOWRJ(V5)
         D13(9) = SHOWRJ(V6)
         WRITE (TEMP,250) ND, D13(1), D13(2), D13(3), P1,
     +                    ND, D13(4), D13(5), D13(6), P2,
     +                    ND, D13(7), D13(8), D13(9), P3
         WRITE (NF,250) ND, D13(1), D13(2), D13(3), P1,
     +                  ND, D13(4), D13(5), D13(6), P2,
     +                  ND, D13(7), D13(8), D13(9), P3
         DO I = 1, 3
            TEXT(6 + I) = TEMP(I)
         ENDDO
         D13(1) = SHOWRJ(VAR(4))
         D13(2) = SHOWRJ(V7)
         D13(3) = SHOWRJ(VAR(5))
         D13(4) = SHOWRJ(V8)
         WRITE (TEMP,350) IERRDF, D13(1), D13(2), BLANK13, BLANK8,  
     +                    MM1,    D13(3), D13(4), BLANK13, BLANK8 
         WRITE (NF,350) IERRDF, D13(1), D13(2), DOT13, DOT8,   
     +                  MM1,    D13(3), D13(4), DOT13, DOT8
         DO I = 1, 2
            TEXT(9 + I) = TEMP(I)
         ENDDO
         IF (N.LT.9) THEN
            DO K = 1, N
               D13(K) = SHOWRJ(AMR(K))
            ENDDO   
            WRITE (TEMP,450) (D13(K), K = 1, N)
            WRITE (NF,450) (D13(K), K = 1, N)
            TEXT(12) = TEMP(1)
            TEXT(13) = TEMP(2)
            
            DO K = 1, N
               D13(K) = SHOWRJ(AMC(K))
            ENDDO     
            WRITE (TEMP,550) (D13(K), K = 1, N)
            WRITE (NF,550) (D13(K), K = 1, N)
            TEXT(14) = TEMP(1)
            TEXT(15) = TEMP(2)
            
            DO K = 1, N
               D13(K) = SHOWRJ(AMT(K))
            ENDDO   
            WRITE (TEMP,650) (D13(K), K = 1, N)
            WRITE (NF,650) (D13(K), K = 1, N)
            TEXT(16) = TEMP(1)
            TEXT(17) = TEMP(2)
            NUMTXT = 17
         ELSE
            NUMTXT = 11
         ENDIF    
      ENDIF   
C
C------------------------------------------------------------------------------
C      
      J = 15
      CALL TABLE1 (J, 'OPEN')
      DO I = 1, NUMTXT
         IF (I.EQ.1 .OR. I.EQ.6) THEN
            J = 4
         ELSE
            J = 0
         ENDIF
         CALL TABLE1 (J, TEXT(I))
      ENDDO
      CALL TABLE1 (J, 'CLOSE')
C
C LABEL 40: analysis is ended so ask if a another go is wanted
C ========
C
   40 CONTINUE
      WRITE (LINE,700)
      ABORT = .TRUE.
      CALL YESNO2 (ICOLOR, IXL, IYL,
     +             LINE,
     +             ABORT)
      IF (ABORT) THEN
         IF (SUPPLY) THEN
            NEWDAT = .TRUE.
         ELSE
            GOTO 20
         ENDIF
      ENDIF
C
C Format statements
C
  100 FORMAT (
     + ' Three Way Analysis of Variance:',I3,' (Grand mean',1P,E13.5,')'
     +/' Latin Square data origin and title:'
     +/1X,A
     +/1X,A/
     +/' Source        NDOF     SSQ           MSQ           F',
     +'          p')    
  150 FORMAT (
     + ' Three Way Analysis of Variance:',I3,' (Grand mean',1X,A,')'
     +/' Latin Square data origin and title:'
     +/1X,A
     +/1X,A/
     +/' Source        NDOF       SSQ           MSQ            F',
     +'       p')              
  200 FORMAT (' Rows      ',I6,1P,3(1X,E13.5),0P,F8.4,
     +/       ' Columns   ',I6,1P,3(1X,E13.5),0P,F8.4,
     +/       ' Treatments',I6,1P,3(1X,E13.5),0P,F8.4)
  250 FORMAT (' Rows      ',I6,3(1X,A13),F8.4,
     +/       ' Columns   ',I6,3(1X,A13),F8.4,
     +/       ' Treatments',I6,3(1X,A13),F8.4)     
  300 FORMAT (' Error     ',I6,1P,2(1X,E13.5),1X,A13,A8,
     +/       ' Total     ',I6,1P,2(1X,E13.5),1X,A13,A8)
  350 FORMAT (' Error     ',I6,2(1X,A13),1X,A13,A8,
     +/       ' Total     ',I6,2(1X,A13),1X,A13,A8)     
  400 FORMAT (' Row means:'/1P,26(1X,E13.5))
  450 FORMAT (' Row means:'/26(1X,A13))  
  500 FORMAT (' Column means:'/1P,26(1X,E13.5))
  550 FORMAT (' Column means:'/26(1X,A13))  
  600 FORMAT (' Treatment means:'/1P,26(1X,E13.5))
  650 FORMAT (' Treatment means:'/26(1X,A13))  
  700 FORMAT ('Analyse another 3-way ANOVA (Latin Square) data set ?')
      END
C
C
