C
C
      SUBROUTINE ANOVA4 (NCMAX, NF, NIN, NMAX,
     +                   A, B, X, Y, Z,
     +                   FNAME, TITLE,
     +                   NEWDAT, SUPPLY)
C
C ACTION: Two way ANOVA
C AUTHOR: W. G. Bardsley, University of Manchester, U.K.
C         06/07/2000 derived from ANOVA1
C         27/03/2006 added FNAME, TITLE, NEWDAT and SUPPLY to arguments
C         20/08/2021 added E_NUMBERS and E_FORMATS, etc. 
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    NCMAX, NF, NIN, NMAX
      DOUBLE PRECISION A(NMAX,NCMAX), B(NMAX), X(NMAX), Y(NMAX), Z(NMAX)
      LOGICAL    NEWDAT, SUPPLY
      CHARACTER (LEN = *) FNAME, TITLE
C
C Local allocatable arrays
C
      INTEGER, ALLOCATABLE :: LSUB(:), NGP(:), NOBS(:)
      DOUBLE PRECISION, ALLOCATABLE :: GBAR(:)
C
C Locals
C
      INTEGER    KMAX, LMAX
      INTEGER    N, K, L, NCOL, NROW
      INTEGER    I, IADD1, IDF(4), IERR, IFAIL, J, JADD1, M
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NOPT, NSTART, NUMTXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 0)
      INTEGER    NDEC, NUMBLD(25), NUMPOS(15)
      INTEGER    ICOUNT
      INTEGER    N0, N1, N2
      PARAMETER (N0 = 0, N1 = 1, N2 = 2)
      DOUBLE PRECISION ONE, F100
      PARAMETER (ONE = 1.0D+00, F100 = 100.0D+00)
      DOUBLE PRECISION EPSI, F(2), FP(2), FX, GM, P, SS(4)
      DOUBLE PRECISION RTOL, G01CEF$, X02AMF$, XTOL, ZTOL, X02AJF$
      CHARACTER (LEN = 100) LINE, TEXT(30)
      CHARACTER (LEN = 13 ) BLANK13, DOT13
      PARAMETER (BLANK13 = '             ', DOT13 = '   ...       ')  
      CHARACTER (LEN = 8  ) BLANK8, DOT8
      PARAMETER (BLANK8 = '        ', DOT8 = '   ...  ') 
      CHARACTER (LEN = 80 ) CHOP80, TRIM80, WORD80, SYMBOL
      CHARACTER (LEN = 13 ) D13(6), SHOWLJ, SHOWRJ
      CHARACTER (LEN = 5  ) TYPE1
      CHARACTER (LEN = 1  ) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    TAB_BOT, TAB_MID, TAB_TOP
      PARAMETER (TAB_TOP = .TRUE., TAB_MID = .TRUE., TAB_BOT = .TRUE.)
      LOGICAL    ABORT, AGAIN, OK, READY
      LOGICAL    EXTRA
      EXTERNAL   E_FORMATS, SHOWLJ, SHOWRJ
      EXTERNAL   PUTFAT, PUTIFA, TBOX01, TABLE1, ANOVAD, ISITMF, CHOP80,
     +           TRIM80
      EXTERNAL   G01CEF$, G04AGF$, X02AMF$, X02AJF$
      INTRINSIC  SQRT, LOG, ASIN
      SAVE       ICOUNT, EXTRA
      DATA       ICOUNT, EXTRA / 0, .TRUE. /
      DATA       NUMBLD / 25*0 /
      DATA       NUMPOS / 15*1 /
C
C Initialise
C
      NEWDAT = .FALSE.
      IF (NMAX.LT.2 .OR. NCMAX.LT.3) RETURN
      IF (SUPPLY) THEN
         CALL ISITMF (NCOL, NROW,
     +                FNAME)
         IF (NCOL.GT.NCMAX .OR. NROW.GT.NMAX) RETURN
         NDEC = N2
         READY = .TRUE.
      ELSE
         NDEC = N1
         READY = .FALSE.
      ENDIF
      KMAX = NMAX
      LMAX = NMAX
      IERR = 0
      IF (ALLOCATED(LSUB)) DEALLOCATE(LSUB, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(NGP)) DEALLOCATE(NGP, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(NOBS)) DEALLOCATE(NOBS, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(GBAR)) DEALLOCATE(GBAR, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(LSUB(KMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(NGP(KMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(NOBS(LMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(GBAR(KMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN

      E_NUMBERS = E_FORMATS() 
       
      IF (SUPPLY) THEN
         CALL ANOVAD (K, KMAX, L, LMAX, LSUB, N, NCMAX, NIN, NOBS,
     +                NMAX,
     +                A, B, X,
     +                FNAME, TITLE,
     +                ABORT, SUPPLY)
         IF (ABORT) THEN
            DEALLOCATE(LSUB, STAT = IERR)
            DEALLOCATE(NGP, STAT = IERR)
            DEALLOCATE(NOBS, STAT = IERR)
            DEALLOCATE(GBAR, STAT = IERR)
            RETURN
         ENDIF
      ENDIF
      RTOL = 1.0D+09*X02AMF$()
      EPSI = 1.0D+01*X02AJF$()
      XTOL = ONE - EPSI
      ZTOL = ONE/RTOL
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
C
C Main menu
C
         IF (EXTRA) THEN
            TYPE1 = 'Full'
         ELSE
            TYPE1 = 'Short'
         ENDIF
         WRITE (TEXT,100) TYPE1
         NOPT = 12
         NSTART = 10
         NUMTXT = NSTART + NOPT - 1
         NUMBLD(1) = 4
         CALL TBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, NOPT,
     +                NUMPOS, NSTART, NUMTXT,
     +                TEXT,
     +                TAB_TOP, TAB_MID, TAB_BOT)
         NUMBLD(1) = 0
C
C Check if consistent or return requested
C
         IF (NDEC.GT.1 .AND. NDEC.LT.11 .AND. .NOT.READY) THEN
            CALL PUTFAT ('First input your current data')
            NDEC = N1
         ELSEIF (NDEC.EQ.1) THEN
C
C Data input
C
            IF (SUPPLY) THEN
               NEWDAT = .TRUE.
               DEALLOCATE(LSUB, STAT = IERR)
               DEALLOCATE(NGP, STAT = IERR)
               DEALLOCATE(NOBS, STAT = IERR)
               DEALLOCATE(GBAR, STAT = IERR)
               RETURN
            ENDIF
            CALL ANOVAD (K, KMAX, L, LMAX, LSUB, N, NCMAX, NIN, NOBS,
     +                   NMAX,
     +                   A, B, X,
     +                   FNAME, TITLE,
     +                   ABORT, SUPPLY)
            READY = .NOT.ABORT
            IF (READY) NDEC = 2
         ELSEIF (NDEC.LT.11) THEN
C
C Do ANOVA
C
            OK = .TRUE.
            DO I = N1, N
               IF (OK) THEN
                  Y(I) = X(I)
                  IF (NDEC.GT.2) THEN
C
C Variance stabilising transformation requested
C
                     IF (Y(I).GT.RTOL) THEN
                        IF (NDEC.EQ.3) THEN
                           Y(I) = LOG(Y(I))
                        ELSEIF (NDEC.EQ.4) THEN
                           Y(I) = SQRT(Y(I))
                        ELSEIF (NDEC.LE.7) THEN
                           FX = Y(I)/F100
                           IF (FX.LE.EPSI .OR. FX.GE.XTOL) THEN
                              CALL PUTFAT ('x out of range for % ?')
                              NDEC = N1
                              OK = .FALSE.
                           ENDIF
                           IF (OK .AND. NDEC.EQ.5) THEN
                              Y(I) = ASIN(SQRT(FX))
                           ELSEIF (OK .AND. NDEC.EQ.6) THEN
                              P = FX/(ONE - FX)
                              IF (P.LE.RTOL .OR. P.GE.ZTOL) THEN
                                 CALL PUTFAT (
     +                                'x out of range for % ?')
                                 NDEC = N1
                                 OK = .FALSE.
                              ELSEIF (OK) THEN
                                 Y(I) = LOG(P)
                              ENDIF
                           ELSEIF (OK .AND. NDEC.EQ.7) THEN
                              IFAIL = N1
                              Y(I) = G01CEF$(FX, IFAIL)
                              CALL PUTIFA (IFAIL, NF,
     +                                    'G01CEF/ANOVA4')
                              IF (IFAIL.NE.N0) OK = .FALSE.
                           ENDIF
                        ELSE
                           FX = Y(I)
                           IF (FX.LE.EPSI .OR. FX.GE.XTOL) THEN
                              CALL PUTFAT ('x out of range for p ?')
                              NDEC = N1
                              OK = .FALSE.
                           ENDIF
                           IF (OK .AND. NDEC.EQ.8) THEN
                              Y(I) = ASIN(SQRT(FX))
                           ELSEIF (OK .AND. NDEC.EQ.9) THEN
                              P = FX/(ONE - FX)
                              IF (P.LE.RTOL .OR. P.GE.ZTOL) THEN
                                 CALL PUTFAT (
     +                                'x out of range for p ?')
                                 NDEC = N1
                                 OK = .FALSE.
                              ELSEIF (OK) THEN
                                 Y(I) = LOG(P)
                              ENDIF
                           ELSEIF (OK .AND. NDEC.EQ.10) THEN
                              IFAIL = N1
                              Y(I) = G01CEF$(FX, IFAIL)
                              CALL PUTIFA (IFAIL, NF,
     +                                    'G01CEF/ANOVA4')
                              IF (IFAIL.NE.N0) OK = .FALSE.
                           ENDIF
                        ENDIF
                     ELSE
                        CALL PUTFAT (
     +                 'x-value too small for transform')
                        NDEC = N1
                        OK = .FALSE.
                     ENDIF
                  ENDIF
               ENDIF
            ENDDO
            SYMBOL = 'Transformation = x (untransformed data)'
            IF (OK) THEN
               IF (NDEC.EQ.3) THEN
                  SYMBOL = 'Transformation = log(x)'
               ELSEIF (NDEC.EQ.4) THEN
                  SYMBOL = 'Transformation = sqrt(x)'
               ELSEIF (NDEC.EQ.5) THEN
                  SYMBOL = 'Transformation = arcsin[sqrt(x/100)]'
               ELSEIF (NDEC.EQ.6) THEN
                  SYMBOL = 'Transformation = log[x/(100 - x)]'
               ELSEIF (NDEC.EQ.7) THEN
                  SYMBOL = 'Transformation = Phi_inverse(x/100)'
               ELSEIF (NDEC.EQ.8) THEN
                  SYMBOL = 'Transformation = arcsin[sqrt(x)]'
               ELSEIF (NDEC.EQ.9) THEN
                  SYMBOL = 'Transformation = log[x/(1 - x)]'
               ELSEIF (NDEC.EQ.10) THEN
                  SYMBOL = 'Transformation = Phi_inverse(x)'
               ENDIF
C
C Output the results
C
               WRITE (NF,200) BLANK
               WRITE (NF,200) '***'
               WRITE (NF,200) BLANK
               WRITE (NF,200) 'Filename and data title:'
               WORD80 = TRIM80(FNAME)
               WRITE (NF,200) WORD80
               WORD80 = CHOP80(TITLE)
               WRITE (NF,200) WORD80
               IFAIL = N1
               CALL G04AGF$(Y, N, K, LSUB, NOBS, L, NGP, GBAR, Z,
     +                      GM, SS, IDF, F, FP, IFAIL)
               CALL PUTIFA (IFAIL, NF, 'G04AGF/ANOVA4')
               IF (IFAIL.EQ.N0) THEN
                  ICOUNT = ICOUNT + N1
                  IF (E_NUMBERS) THEN
                     WRITE (TEXT,300) ICOUNT, SYMBOL,
     +                                SS(1), IDF(1), F(1), FP(1),
     +                                SS(2), IDF(2), F(2), FP(2),
     +                                SS(3), IDF(3), BLANK13, BLANK8,
     +                                SS(4), IDF(4), BLANK13, BLANK8
                     WRITE (NF,300) ICOUNT, SYMBOL,
     +                              SS(1), IDF(1), F(1), FP(1), 
     +                              SS(2), IDF(2), F(2), FP(2), 
     +                              SS(3), IDF(3), DOT13, DOT8,
     +                              SS(4), IDF(4), DOT13, DOT8 
                  ELSE
                     D13(1) = SHOWRJ(SS(1))
                     D13(2) = SHOWRJ(F(1))
                     D13(3) = SHOWRJ(SS(2))
                     D13(4) = SHOWRJ(F(2))
                     D13(5) = SHOWRJ(SS(3))
                     D13(6) = SHOWRJ(SS(4))
                     WRITE (TEXT,350) ICOUNT, SYMBOL,
     +                                D13(1), IDF(1), D13(2), FP(1),
     +                                D13(3), IDF(2), D13(4), FP(2),
     +                                D13(5), IDF(3), BLANK13, BLANK8,
     +                                D13(6), IDF(4), BLANK13, BLANK8
                     WRITE (NF,350) ICOUNT, SYMBOL,
     +                              D13(1), IDF(1), D13(2), FP(1), 
     +                              D13(3), IDF(2), D13(4), FP(2), 
     +                              D13(5), IDF(3), DOT13, DOT8,
     +                              D13(6), IDF(4), DOT13, DOT8
                  ENDIF  
                  NUMTXT = 8
                  J = 15
                  CALL TABLE1 (J, 'OPEN')
                  DO I = N1, NUMTXT
                     IF (I.EQ.2 .OR. I.EQ.4) THEN
                        J = 4
                     ELSE
                        J = 0
                     ENDIF
                     CALL TABLE1 (J, TEXT(I))
                  ENDDO
                  IF (EXTRA) THEN
                     LINE = BLANK
                     WRITE (NF,200) LINE
                     CALL TABLE1 (J, LINE)
                     WRITE (LINE,400)
                     WRITE (NF,400)
                     J = 4
                     CALL TABLE1 (J, LINE)
                     J = 0
                     JADD1 = N0
                     DO I = N1, K
                        IADD1 = N0
                        DO M = N1, LSUB(I)
                           IADD1 = IADD1 + N1
                           JADD1 = JADD1 + N1
                           IF (E_NUMBERS) THEN
                              WRITE (LINE,500) I, IADD1, Z(JADD1)
                              WRITE (NF,500) I, IADD1, Z(JADD1)
                           ELSE
                              D13(1) = SHOWLJ(Z(JADD1))
                              WRITE (LINE,550) I, IADD1, D13(1)
                              WRITE (NF,550) I, IADD1, D13(1)
                           ENDIF  
                           CALL TABLE1 (J, LINE)
                        ENDDO
                     ENDDO
                     DO I = N1, K
                        IF (E_NUMBERS) THEN
                           WRITE (LINE,600) I, GBAR(I), NGP(I)
                           WRITE (NF,600) I, GBAR(I), NGP(I)
                        ELSE
                           D13(1) = SHOWLJ(GBAR(I))
                           WRITE (LINE,650) I, D13(1), NGP(I)
                           WRITE (NF,650) I, D13(1), NGP(I)   
                        ENDIF   
                        CALL TABLE1 (J, LINE)
                     ENDDO
                     IF (E_NUMBERS) THEN
                        WRITE (LINE,700) GM, N
                        WRITE (NF,700) GM, N
                     ELSE   
                        D13(1) = SHOWLJ(GM)
                        WRITE (LINE,750) D13(1), N
                        WRITE (NF,750) D13(1), N
                     ENDIF   
                     CALL TABLE1 (J, LINE)
                  ENDIF
                  CALL TABLE1 (J, 'CLOSE')
               ENDIF
            ENDIF
            NDEC = 1
         ELSEIF (NDEC.EQ.11) THEN
            EXTRA = .NOT.EXTRA
            NDEC = 1
         ELSEIF (NDEC.EQ.NOPT) THEN
            NEWDAT = .FALSE.
            AGAIN = .FALSE.
         ENDIF
      ENDDO
C
C Deallocate
C
      DEALLOCATE(LSUB, STAT = IERR)
      DEALLOCATE(NGP, STAT = IERR)
      DEALLOCATE(NOBS, STAT = IERR)
      DEALLOCATE(GBAR, STAT = IERR)
C
C Format statements
C
  100 FORMAT (
     + 'Groups and subgroups ANOVA'
     +/
     +/'Column 1 must have group numbers as ascending consecutive'
     +/'integers, column 2 must have subgroup numbers as ascending'
     +/'consecutive integers, and column 3 must be observations.'
     +/'Use data untransformed and only use the variance stabilisation'
     +/'if you have good reasons to do so, and know what you are doing.'
     +/'Note: log is to base e and x can be a percentage or proportion.'
     +/
     +/'Input Groups/Subgroups ANOVA data'
     +/'ANOVA [on x (data untransformed)]'
     +/'ANOVA [on log(x))]'
     +/'ANOVA [on sqrt(x)]'
     +/'ANOVA [on arcsin(sqrt(x/100))]`(0 < x < 100)'
     +/'ANOVA [on log(x/(100 - x))]   `(0 < x < 100)'
     +/'ANOVA [on Phi_inverse(x/100))]`(0 < x < 100)'
     +/'ANOVA [on arcsin(sqrt(x))]    `(0 < x < 1)'
     +/'ANOVA [on log(x/(1 - x))]     `(0 < x < 1)'
     +/'ANOVA [on Phi_inverse(x)]     `(0 < x < 1)'
     +/'Change output (Full/Short)    `',A
     +/'Quit                          `Exit groups and subgroups ANOVA')
  200 FORMAT (1X,A)
  300 FORMAT (
     +/' Groups/Subgroups 2-Way ANOVA:',I3
     +/1X,A
     +/' Source                 SSQ      NDOF       F          p'
     +/' Between Groups  ',1P,1X,E13.5,I6,1X,E13.5,0P,F8.4
     +/' Subgroups       ',1P,1X,E13.5,I6,1X,E13.5,0P,F8.4
     +/' Residual        ',1P,1X,E13.5,I6,1X,A13,A8,
     +/' Total           ',1P,1X,E13.5,I6,1X,A13,A8)
  350 FORMAT (
     +/' Groups/Subgroups 2-Way ANOVA:',I3
     +/1X,A
     +/' Source                   SSQ     NDOF         F       p'
     +/' Between Groups  ',1X,A13,I6,1X,A13,F8.4
     +/' Subgroups       ',1X,A13,I6,1X,A13,F8.4
     +/' Residual        ',1X,A13,I6,1X,A13,A8,
     +/' Total           ',1X,A13,I6,1X,A13,A8)     
  400 FORMAT (' Group  Subgroup        Mean')
  500 FORMAT (I6,I10,1P,2X,E13.5)
  550 FORMAT (I6,I10,6X,A)  
  600 FORMAT (' Group',I4,' mean =',1P,E13.5,' (',I4,' Observations)')
  650 FORMAT (' Group',I4,' mean =',1X,A13,' (',I4,' Observations)')
  700 FORMAT (' Grand',4X,' mean =',1P,E13.5,' (',I4,' Observations)')
  750 FORMAT (' Grand',4X,' mean =',1X,A13,' (',I4,' Observations)')
      END
C
C

