C
C
      SUBROUTINE ANOVA5 (ITYPE, IWRK, NCMAX, NF, NIN, NMAX,
     +                   A, B, X, Y, Z,
     +                   FNAME, TITLE,
     +                   NEWDAT, SUPPLY)
C
C ACTION: Factorial ANOVA
C AUTHOR: W. G. Bardsley, University of Manchester, U.K.
C         21/09/2003 derived from ANOVA4
C         25/02/2005 defined INTER before entry to g04caf$, corrected output of TABLE
C         01/04/2006 added ITYPE, NEWDAT and SUPPLY to arguments and
C                    allocated workspace
C         22/08/2021 added E_NUMBERS and E_FORMATS, etc
C         30/08/2021 improved formats 1350 and 5050 to improve spacing
C
C Note: this version is restricted to a maximum of three factors
C
C        ITYPE: (input/unchanged) as follows:
C               ITYPE = 1: 0 blocks, 2 factor
C               ITYPE = 2: k blocks, 2 factor
C               ITYPE = 3: 0 blocks, 3 factors
C               ITYPE = 1: k blocks, 3 factors
C         IWRK: workspace
C        NCMAX: (input/unchanged) dimension
C           NF: (input/unchanged) preconnected file for results
C          NIN: (input/unchanged) unconnected unit for data input
C         NMAX: (input/unchanged) dimension
C         A, B, X, Y, Z: workspaces (depending on SUPPLY)
C        FNAME: (input/output) depending on SUPPLY
C        TITLE: (input/output) depending on SUPPLY
C       NEWDAT: (output)
C       SUPPLY: (input/unchanged) as follows:
C               SUPPLY = .TRUE. then supply data
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    ITYPE, NCMAX, NF, NIN, NMAX
      INTEGER    IWRK(3*NMAX)
      DOUBLE PRECISION A(NMAX,NCMAX), B(NMAX), X(NMAX), Y(NMAX), Z(NMAX)
      CHARACTER  FNAME*(*), TITLE*(*)
      LOGICAL    NEWDAT, SUPPLY
C
C Locals
C
      INTEGER    K, L, N, NSTART, NTREAT
      INTEGER    I, IFAIL, ITEMP, J, M, NA, NB, NC
      INTEGER    L1, L2, L3
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NOPT, NUMTXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 0)
      INTEGER    NDEC, NUMBLD(30), NUMPOS(30)
      INTEGER    IRDF, INTER, ISEND, ITOTAL, MAXB, MAXF, MAXT, MTERM,
     +           NBLOCK, NFAC
      PARAMETER (IRDF = 0,
     +           MAXB = 100,   !max. no. of blocks
     +           MAXF = 10,    !max. no. of factors
     +           MAXT = 500,   !max. no. of treatment means
     +           MTERM = 500)  !max. no. of terms in ANOVA table
      INTEGER    IDF(MTERM), IMEAN(MTERM), LFAC(MAXF)
      INTEGER    ICOUNT
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12,
     +           N15
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5, N6 = 6,
     +           N7 = 7, N8 = 8, N9 = 9, N10 = 10, N11 = 11, N12 = 12,
     +           N15 = 15)
      INTEGER    NFRMT!NFRMT is the repeat edit desciptor (see format 5000)
      PARAMETER (NFRMT = 8)
      INTEGER    NGRAF
      PARAMETER (NGRAF = 100)
      INTEGER    LL1, LL2, LL3, LL4, LL5, LL6, LL7, LL8, LL9, LL10,
     +           LL11, LL12, MM1, MM2, MM3, MM4, MM5, MM6, MM7, MM8,
     +           MM9, MM10, MM11, MM12
      PARAMETER (LL1 = 1, LL2 = 2, LL3 = 3, LL4 = 4, LL5 = 1, LL6 = 2,
     +           LL7 = 3, LL8 = 4, LL9 = 1, LL10 = 2, LL11 = 3,
     +           LL12 = 4, MM1 = 5, MM2 = 8, MM3 = 11, MM4 = 14,
     +           MM5 = 6, MM6 = 9, MM7 = 12, MM8 = 15, MM9 = 7,
     +           MM10 = 10, MM11 = 13, MM12 = 16)
      INTEGER    NN(12)
      DOUBLE PRECISION ZERO, ONE, F100
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, F100 = 100.0D+00)
      DOUBLE PRECISION BMEAN(MAXB + 1), E(MAXT), SEMEAN(MTERM),
     +                 TABLE(MTERM,5), TMEAN(MAXT)
      DOUBLE PRECISION EPSI, F(MTERM), FP(MTERM), FX, P, SS(MTERM),
     +                 SSM(MTERM)
      DOUBLE PRECISION X1(NGRAF), X2(NGRAF), X3(NGRAF), X4(NGRAF),
     +                 X5(NGRAF), X6(NGRAF), X7(NGRAF), X8(NGRAF),
     +                 X9(NGRAF), X10(NGRAF), X11(NGRAF), X12(NGRAF)
      DOUBLE PRECISION Y1(NGRAF), Y2(NGRAF), Y3(NGRAF), Y4(NGRAF),
     +                 Y5(NGRAF), Y6(NGRAF), Y7(NGRAF), Y8(NGRAF),
     +                 Y9(NGRAF), Y10(NGRAF), Y11(NGRAF), Y12(NGRAF)
      DOUBLE PRECISION RTOL, G01CEF$, X02AMF$, XTOL, ZTOL, X02AJF$
      CHARACTER (LEN = 80) CHOP80, TRIM80, WORD80
      CHARACTER (LEN = 13) D13(27), SHOWLJ, SHOWRJ
      CHARACTER (LEN = 9 ) D09(8), SHOW09
      CHARACTER  LINE*100, SYMBOL*80, TEXT(30)*100, TYPE1*5
      CHARACTER  PTITLE*50, XTITLE*40, YTITLE*40
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    TAB_BOT, TAB_MID, TAB_TOP
      PARAMETER (TAB_TOP = .TRUE., TAB_MID = .TRUE., TAB_BOT = .TRUE.)
      LOGICAL    ABORT, AGAIN, DONE, OK, READY, REPEET
      LOGICAL    EXTRA
      LOGICAL    AXES, GSAVE
      PARAMETER (AXES = .TRUE., GSAVE = .TRUE.)
      EXTERNAL   E_FORMATS, SHOW09, SHOWLJ, SHOWRJ
      EXTERNAL   PUTFAT, PUTIFA, TBOX01, TABLE1, ANOVAF, LBOX02, HNPLOT,
     +           GKS001, GKS012, PUTADV, ISITMF, CHOP80, TRIM80
      EXTERNAL   G01CEF$, G04CAF$, X02AMF$, X02AJF$
      INTRINSIC  SQRT, LOG, ASIN, DBLE, NINT
      SAVE       ICOUNT, EXTRA
      DATA       ICOUNT, EXTRA / 0, .TRUE. /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / 30*1 /
C
C Initialise NEWDAT then check dat if SUPPLY = .TRUE.
C
      E_NUMBERS = E_FORMATS()
      
      NEWDAT = .FALSE.
      IF (SUPPLY) THEN
         CALL ISITMF (I, J,
     +                FNAME)
         IF (I.GT.NCMAX .OR. I.LT.N4 .OR. I.GT.N5 .OR.
     +       J.LT.N2 .OR. J.GT.NMAX) RETURN
         IF (ITYPE.LE.N2) THEN
            INTER = N2
         ELSEIF (ITYPE.LE.N4) THEN
            INTER = N3
         ENDIF
         ISEND = ITYPE
         CALL ANOVAF (ISEND, IWRK(1), N, NBLOCK, NCMAX, NFAC, NIN,
     +                IWRK(NMAX + 1), NMAX,
     +                A, X,
     +                FNAME, TITLE,
     +                ABORT, SUPPLY)
         IF (ABORT) RETURN
         DO I = N1, NFAC
            LFAC(I) = IWRK(NMAX + I)
         ENDDO
         NDEC = N2
         OK = .TRUE.
         READY = .TRUE.
      ELSE
         NDEC = N1
         OK = .FALSE.
         READY = .FALSE.
      ENDIF
C
C Initialise
C
      RTOL = 1.0D+09*X02AMF$()
      EPSI = 1.0D+01*X02AJF$()
      XTOL = ONE - EPSI
      ZTOL = ONE/RTOL
      DO I = N1, NGRAF
         X1(I) = DBLE(I)
         X2(I) = DBLE(I)
         X3(I) = DBLE(I)
         X4(I) = DBLE(I)
         X5(I) = DBLE(I)
         X6(I) = DBLE(I)
         X7(I) = DBLE(I)
         X8(I) = DBLE(I)
         X9(I) = DBLE(I)
         X10(I) = DBLE(I)
         X11(I) = DBLE(I)
         X12(I) = DBLE(I)
         Y1(I) = ZERO
         Y2(I) = ZERO
         Y3(I) = ZERO
         Y4(I) = ZERO
         Y5(I) = ZERO
         Y6(I) = ZERO
         Y7(I) = ZERO
         Y8(I) = ZERO
         Y9(I) = ZERO
         Y10(I) = ZERO
         Y11(I) = ZERO
         Y12(I) = ZERO
      ENDDO
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
C
C Main menu
C
         IF (EXTRA) THEN
            TYPE1 = 'Full'
         ELSE
            TYPE1 = 'Short'
         ENDIF
         WRITE (TEXT,100) TYPE1
         NOPT = 13
         NSTART = 10
         NUMTXT = NSTART + NOPT- 1
         NUMBLD(1) = 4
         CALL TBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, NOPT,
     +                NUMPOS, NSTART, NUMTXT,
     +                TEXT,
     +                TAB_TOP, TAB_MID, TAB_BOT)
         NUMBLD(1) = 0
C
C Check if consistent or return requested
C
         IF (NDEC.GT.1 .AND. NDEC.LT.12 .AND. .NOT.READY) THEN
            CALL PUTFAT ('First input your current data')
            NDEC = N1
         ELSEIF (NDEC.EQ.11 .AND. .NOT.OK) THEN
            CALL PUTFAT ('First analyse your current data')
            NDEC = N2
         ELSEIF (NDEC.EQ.1) THEN
C
C Data input
C
            IF (SUPPLY) THEN
               NEWDAT = .TRUE.
               RETURN
            ENDIF
            WRITE (TEXT,200)
            ISEND = 1
            NOPT = 6
            CALL LBOX02 (ICOLOR, IXL, IYL, ISEND, NOPT, NUMPOS,
     +                   TEXT)
            IF (ISEND.LE.2) THEN
               INTER = N2
             ELSEIF (ISEND.LE.4) THEN
                INTER = N3
            ELSEIF (ISEND.EQ.5) THEN
               CALL PUTFAT ('Not available ... get an upgrade')
            ENDIF
            IF (ISEND.LE.4) THEN
               CALL ANOVAF (ISEND, IWRK(1), N, NBLOCK, NCMAX, NFAC, NIN,
     +                      IWRK(NMAX + 1), NMAX,
     +                      A, X,
     +                      FNAME, TITLE,
     +                      ABORT, SUPPLY)
               DO I = N1, NFAC
                  LFAC(I) = IWRK(NMAX + I)
               ENDDO
            ELSE
               ABORT = .TRUE.
            ENDIF
            READY = .NOT.ABORT
            OK = .FALSE.
            IF (READY) NDEC = N2
         ELSEIF (NDEC.LT.11) THEN
C
C Do ANOVA
C
            OK = .TRUE.
            DO I = N1, N
               IF (OK) THEN
                  Y(I) = X(I)
                  IF (NDEC.GT.2) THEN
C
C Variance stabilising transformation requested
C
                     IF (Y(I).GT.RTOL) THEN
                        IF (NDEC.EQ.3) THEN
                           Y(I) = LOG(Y(I))
                        ELSEIF (NDEC.EQ.4) THEN
                           Y(I) = SQRT(Y(I))
                        ELSEIF (NDEC.LE.7) THEN
                           FX = Y(I)/F100
                           IF (FX.LE.EPSI .OR. FX.GE.XTOL) THEN
                              CALL PUTFAT ('x out of range for % ?')
                              NDEC = N1
                              OK = .FALSE.
                           ENDIF
                           IF (OK .AND. NDEC.EQ.5) THEN
                              Y(I) = ASIN(SQRT(FX))
                           ELSEIF (OK .AND. NDEC.EQ.6) THEN
                              P = FX/(ONE - FX)
                              IF (P.LE.RTOL .OR. P.GE.ZTOL) THEN
                                 CALL PUTFAT (
     +                                'x out of range for % ?')
                                 NDEC = N1
                                 OK = .FALSE.
                              ELSEIF (OK) THEN
                                 Y(I) = LOG(P)
                              ENDIF
                           ELSEIF (OK .AND. NDEC.EQ.7) THEN
                              IFAIL = N1
                              Y(I) = G01CEF$(FX, IFAIL)
                              CALL PUTIFA (IFAIL, NF,
     +                                    'G01CEF/ANOVA4')
                              IF (IFAIL.NE.N0) OK = .FALSE.
                           ENDIF
                        ELSE
                           FX = Y(I)
                           IF (FX.LE.EPSI .OR. FX.GE.XTOL) THEN
                              CALL PUTFAT ('x out of range for p ?')
                              NDEC = N1
                              OK = .FALSE.
                           ENDIF
                           IF (OK .AND. NDEC.EQ.8) THEN
                              Y(I) = ASIN(SQRT(FX))
                           ELSEIF (OK .AND. NDEC.EQ.9) THEN
                              P = FX/(ONE - FX)
                              IF (P.LE.RTOL .OR. P.GE.ZTOL) THEN
                                 CALL PUTFAT (
     +                                'x out of range for p ?')
                                 NDEC = N1
                                 OK = .FALSE.
                              ELSEIF (OK) THEN
                                 Y(I) = LOG(P)
                              ENDIF
                           ELSEIF (OK .AND. NDEC.EQ.10) THEN
                              IFAIL = N1
                              Y(I) = G01CEF$(FX, IFAIL)
                              CALL PUTIFA (IFAIL, NF,
     +                                    'G01CEF/ANOVA4')
                              IF (IFAIL.NE.N0) OK = .FALSE.
                           ENDIF
                        ENDIF
                     ELSE
                        CALL PUTFAT (
     +                 'x-value too small for transform')
                        NDEC = N1
                        OK = .FALSE.
                     ENDIF
                  ENDIF
               ENDIF
            ENDDO
            SYMBOL = 'Transformation = x (untransformed data)'
            IF (OK) THEN
               IF (NDEC.EQ.3) THEN
                  SYMBOL = 'Transformation = log(x)'
               ELSEIF (NDEC.EQ.4) THEN
                  SYMBOL = 'Transformation = sqrt(x)'
               ELSEIF (NDEC.EQ.5) THEN
                  SYMBOL = 'Transformation = arcsin[sqrt(x/100)]'
               ELSEIF (NDEC.EQ.6) THEN
                  SYMBOL = 'Transformation = log[x/(100 - x)]'
               ELSEIF (NDEC.EQ.7) THEN
                  SYMBOL = 'Transformation = Phi_inverse(x/100)'
               ELSEIF (NDEC.EQ.8) THEN
                  SYMBOL = 'Transformation = arcsin[sqrt(x)]'
               ELSEIF (NDEC.EQ.9) THEN
                  SYMBOL = 'Transformation = log[x/(1 - x)]'
               ELSEIF (NDEC.EQ.10) THEN
                  SYMBOL = 'Transformation = Phi_inverse(x)'
               ENDIF
C
C Output the results
C
               WRITE (NF,'(1X,A)') '....................'
               WRITE (NF,'(1X,A)') BLANK
               WRITE (NF,'(1X,A)') 'Filename and data title:'
               WORD80 = TRIM80(FNAME)
               WRITE (NF,'(A)') WORD80
               WORD80 = CHOP80(TITLE)
               WRITE (NF,'(A)') WORD80
               OK = .FALSE.
               INTER = NFAC
               IFAIL = N1
               CALL G04CAF$(N, Y, NFAC, LFAC, NBLOCK, INTER, IRDF,
     +                      MTERM, TABLE, ITOTAL, TMEAN, MAXT, E, IMEAN,
     +                      SEMEAN, BMEAN, Z, IWRK, IFAIL)
               CALL PUTIFA (IFAIL, NF, 'G04CAF/ANOVA5')
               IF (IFAIL.EQ.N0) THEN
                  OK = .TRUE.
                  DONE = .FALSE.
                  NA = LFAC(1)
                  NB = LFAC(2)
                  IF (NFAC.GT.N2) THEN
                     NC = LFAC(3)
                  ELSE
                     NC = N0
                  ENDIF
                  DO I = N1, N
                     B(I) = Y(I) - Z(I)
                  ENDDO
                  DO I = N1, ITOTAL
                     IDF(I) = NINT(TABLE(I,1))
                     SS(I) = TABLE(I,2)
                     SSM(I) = TABLE(I,3)
                     F(I) = TABLE(I,4)
                     FP(I) = TABLE(I,5)
                  ENDDO
                  ICOUNT = ICOUNT + N1
                  IF (NFAC.EQ.2) THEN
                     IF (E_NUMBERS) THEN
                        WRITE (TEXT,300) ICOUNT, SYMBOL,
     +                                   SS(1), IDF(1), SSM(1), F(1),
     +                                   FP(1),
     +                                   SS(2), IDF(2), SSM(2), F(2), 
     +                                   FP(2),
     +                                   SS(3), IDF(3), SSM(3), F(3),
     +                                   FP(3),
     +                                   SS(4), IDF(4), SSM(4), F(4), 
     +                                   FP(4),
     +                                   SS(5), IDF(5), SSM(5),
     +                                   SS(6), IDF(6)
                        WRITE (NF,300) ICOUNT, SYMBOL,
     +                                 SS(1), IDF(1), SSM(1), F(1), 
     +                                 FP(1),
     +                                 SS(2), IDF(2), SSM(2), F(2),
     +                                 FP(2),
     +                                 SS(3), IDF(3), SSM(3), F(3),
     +                                 FP(3),
     +                                 SS(4), IDF(4), SSM(4), F(4),
     +                                 FP(4),
     +                                 SS(5), IDF(5), SSM(5),
     +                                 SS(6), IDF(6)
                     ELSE
                        D13(1) = SHOWRJ(SS(1))
                        D13(2) = SHOWRJ(SSM(1)) 
                        D13(3) = SHOWRJ(F(1))
                        D13(4) = SHOWRJ(SS(2))
                        D13(5) = SHOWRJ(SSM(2)) 
                        D13(6) = SHOWRJ(F(2))
                        D13(7) = SHOWRJ(SS(3))
                        D13(8) = SHOWRJ(SSM(3)) 
                        D13(9) = SHOWRJ(F(3))
                        D13(10) = SHOWRJ(SS(4))
                        D13(11) = SHOWRJ(SSM(4)) 
                        D13(12) = SHOWRJ(F(4)) 
                        D13(13) = SHOWRJ(SS(5))
                        D13(14) = SHOWRJ(SSM(5))
                        D13(15) = SHOWRJ(SS(6))                       
                        WRITE (TEXT,350) ICOUNT, SYMBOL,
     +                                   D13(1), IDF(1), D13(2), D13(3),
     +                                   FP(1),
     +                                   D13(4), IDF(2), D13(5), D13(6), 
     +                                   FP(2),
     +                                   D13(7), IDF(3), D13(8), D13(9),
     +                                   FP(3),
     +                                   D13(10), IDF(4), D13(11),
     +                                   D13(12), FP(4),
     +                                   D13(13), IDF(5), D13(14),
     +                                   D13(15), IDF(6)
                        WRITE (NF,350) ICOUNT, SYMBOL,
     +                                  D13(1), IDF(1), D13(2), D13(3),
     +                                  FP(1),
     +                                  D13(4), IDF(2), D13(5), D13(6), 
     +                                  FP(2),
     +                                  D13(7), IDF(3), D13(8), D13(9),
     +                                  FP(3),
     +                                  D13(10), IDF(4), D13(11),
     +                                  D13(12), FP(4),
     +                                  D13(13), IDF(5), D13(14),
     +                                  D13(15), IDF(6)                        
                     ENDIF  
                     NUMTXT = 10
                     J = N15
                     CALL TABLE1 (J, 'OPEN')
                     DO I = N1, NUMTXT
                        IF (I.EQ.2 .OR. I.EQ.4) THEN
                           J = N4
                        ELSE
                           J = N0
                        ENDIF
                        CALL TABLE1 (J, TEXT(I))
                     ENDDO
                  ELSEIF (NFAC.EQ.3) THEN
                     IF (E_NUMBERS) THEN
                        WRITE (TEXT,400) ICOUNT, SYMBOL,
     +                                   SS(1), IDF(1), SSM(1), F(1),
     +                                   FP(1),
     +                                   SS(2), IDF(2), SSM(2), F(2),
     +                                   FP(2),
     +                                   SS(3), IDF(3), SSM(3), F(3),
     +                                   FP(3),
     +                                   SS(4), IDF(4), SSM(4), F(4), 
     +                                   FP(4),
     +                                   SS(5), IDF(5), SSM(5), F(5),
     +                                   FP(5),
     +                                   SS(6), IDF(6), SSM(6), F(6),
     +                                   FP(6),
     +                                   SS(7), IDF(7), SSM(7), F(7), 
     +                                   FP(7),
     +                                   SS(8), IDF(8), SSM(8), F(8),
     +                                   FP(8),
     +                                   SS(9), IDF(9), SSM(9),
     +                                   SS(10), IDF(10)
                        WRITE (NF,400) ICOUNT, SYMBOL,
     +                                   SS(1), IDF(1), SSM(1), F(1),
     +                                   FP(1),
     +                                   SS(2), IDF(2), SSM(2), F(2),
     +                                   FP(2),
     +                                   SS(3), IDF(3), SSM(3), F(3),
     +                                   FP(3),
     +                                   SS(4), IDF(4), SSM(4), F(4), 
     +                                   FP(4),
     +                                   SS(5), IDF(5), SSM(5), F(5),
     +                                   FP(5),
     +                                   SS(6), IDF(6), SSM(6), F(6),
     +                                   FP(6),
     +                                   SS(7), IDF(7), SSM(7), F(7), 
     +                                   FP(7),
     +                                   SS(8), IDF(8), SSM(8), F(8),
     +                                   FP(8),
     +                                   SS(9), IDF(9), SSM(9),
     +                                   SS(10), IDF(10)
                     ELSE
                        D13(1) = SHOWRJ(SS(1))
                        D13(2) = SHOWRJ(SSM(1)) 
                        D13(3) = SHOWRJ(F(1))
                        D13(4) = SHOWRJ(SS(2))
                        D13(5) = SHOWRJ(SSM(2)) 
                        D13(6) = SHOWRJ(F(2))
                        D13(7) = SHOWRJ(SS(3))
                        D13(8) = SHOWRJ(SSM(3)) 
                        D13(9) = SHOWRJ(F(3))
                        D13(10) = SHOWRJ(SS(4))
                        D13(11) = SHOWRJ(SSM(4)) 
                        D13(12) = SHOWRJ(F(4)) 
                        D13(13) = SHOWRJ(SS(5))
                        D13(14) = SHOWRJ(SSM(5))
                        D13(15) = SHOWRJ(F(5))
                        D13(16) = SHOWRJ(SS(6))
                        D13(17) = SHOWRJ(SSM(6))
                        D13(18) = SHOWRJ(F(6))
                        D13(19) = SHOWRJ(SS(7))
                        D13(20) = SHOWRJ(SSM(7))
                        D13(21) = SHOWRJ(F(7))
                        D13(22) = SHOWRJ(SS(8))
                        D13(23) = SHOWRJ(SSM(8))
                        D13(24) = SHOWRJ(F(8))
                        D13(25) = SHOWRJ(SS(9))
                        D13(26) = SHOWRJ(SSM(9))
                        D13(27) = SHOWRJ(SS(10))
                        WRITE (TEXT,450) ICOUNT, SYMBOL,
     +                                   D13(1), IDF(1), D13(2), 
     +                                   D13(3), FP(1),
     +                                   D13(4), IDF(2), D13(5),
     +                                   D13(6), FP(2),
     +                                   D13(7), IDF(3), D13(8),
     +                                   D13(9), FP(3),
     +                                   D13(10), IDF(4), D13(11),
     +                                   D13(12), FP(4),
     +                                   D13(13), IDF(5), D13(14),
     +                                   D13(15), FP(5),
     +                                   D13(16), IDF(6), D13(17),
     +                                   D13(18), FP(6),
     +                                   D13(19), IDF(7), D13(20),
     +                                   D13(21), FP(7),
     +                                   D13(22), IDF(8), D13(23),
     +                                   D13(24), FP(8),
     +                                   D13(25), IDF(9), D13(26),
     +                                   D13(27), IDF(10)
                         WRITE (NF,450) ICOUNT, SYMBOL,
     +                                   D13(1), IDF(1), D13(2), 
     +                                   D13(3), FP(1),
     +                                   D13(4), IDF(2), D13(5),
     +                                   D13(6), FP(2),
     +                                   D13(7), IDF(3), D13(8),
     +                                   D13(9), FP(3),
     +                                   D13(10), IDF(4), D13(11),
     +                                   D13(12), FP(4),
     +                                   D13(13), IDF(5), D13(14),
     +                                   D13(15), FP(5),
     +                                   D13(16), IDF(6), D13(17),
     +                                   D13(18), FP(6),
     +                                   D13(19), IDF(7), D13(20),
     +                                   D13(21), FP(7),
     +                                   D13(22), IDF(8), D13(23),
     +                                   D13(24), FP(8),
     +                                   D13(25), IDF(9), D13(26),
     +                                   D13(27), IDF(10)                         
                     ENDIF   
                     NUMTXT = 14
                     J = N15
                     CALL TABLE1 (J, 'OPEN')
                     DO I = N1, NUMTXT
                        IF (I.EQ.2 .OR. I.EQ.4) THEN
                           J = N4
                        ELSE
                           J = N0
                        ENDIF
                        CALL TABLE1 (J, TEXT(I))
                     ENDDO
                  ENDIF
C
C Extra details may be required
C
                  IF (EXTRA) THEN
                     IF (NFAC.EQ.2) THEN
                        NTREAT = N3
                     ELSEIF (NFAC.EQ.3) THEN
                        NTREAT = N7
                     ENDIF
                     LINE = BLANK
                     WRITE (NF,'(A)') LINE
                     CALL TABLE1 (J, LINE)
                     WRITE (LINE,500)
                     WRITE (NF,500)
                     J = N4
                     CALL TABLE1 (J, LINE)
                     IF (E_NUMBERS) THEN
                        WRITE (LINE,600) BMEAN(1)
                        WRITE (NF,600) BMEAN(1)
                     ELSE
                        D13(1) = SHOWLJ(BMEAN(1))
                        WRITE (LINE,650) D13(1)
                        WRITE (NF,650) D13(1)
                     ENDIF      
                     J = N0
                     CALL TABLE1 (J, LINE)
                     IF (NBLOCK.GT.N1) THEN
                        WRITE (LINE,700)
                        WRITE (NF,700)
                        J = N4
                        CALL TABLE1 (J, LINE)
                        J = N0
                        K = N2
                        L = NBLOCK + N1
                        L2 = K
                        L3 = L2
                        DO M = K, L
                           L3 = L3 + N1
                           IF (L3 - L2 + N1.EQ.NFRMT .OR. L3.EQ.L) THEN
                              IF (E_NUMBERS) THEN
                                 WRITE (LINE,5000)
     +                                 (BMEAN(L1), L1 = L2, L3)
                                 WRITE (NF,'(A)') LINE
                              ELSE
                                 ITEMP = 0
                                 DO L1 = L2, L3
                                    ITEMP = ITEMP + 1
                                    D09(ITEMP) = SHOW09(BMEAN(L1))
                                 ENDDO
                                 WRITE (LINE,5050) 
     +                          (D09(ITEMP), ITEMP = 1, L3 - L2 + 1)
                                 WRITE (NF,'(A)') LINE
                              ENDIF  
                              CALL TABLE1 (J, LINE)
                              L2 = L3 + N1
                           ENDIF
                        ENDDO
                     ENDIF
                     WRITE (LINE,800)
                     WRITE (NF,800)
                     J = 4
                     CALL TABLE1 (J, LINE)
                     K = N1
                     DO I = N1, NTREAT
                        J = 1
                        WRITE (LINE,900) 'Effect', I
                        WRITE (NF,900) 'Effect', I
                        CALL TABLE1 (J, LINE)
                        J = N0
                        L = IMEAN(I)
                        L2 = K
                        L3 = L2
                        DO M = K, L
                           L3 = L3 + N1
                           IF (L3 - L2 + N1.EQ.NFRMT .OR. L3.EQ.L) THEN
                              IF (E_NUMBERS) THEN
                                 WRITE (LINE,5000)
     +                                 (TMEAN(L1), L1 = L2, L3)
                                 WRITE (NF,'(A)') LINE
                              ELSE
                                 ITEMP = 0
                                 DO L1 = L2, L3
                                    ITEMP = ITEMP + 1
                                    D09(ITEMP) = SHOW09(TMEAN(L1))
                                 ENDDO
                                 WRITE (LINE,5050) 
     +                          (D09(ITEMP), ITEMP = 1, L3 - L2 + 1) 
                                 WRITE (NF,'(A)') LINE
                              ENDIF  
                              CALL TABLE1 (J, LINE)
                              L2 = L3 + N1
                           ENDIF
                        ENDDO
                        K = L + N1
                        IF (E_NUMBERS) THEN
                           WRITE (LINE,1000) SEMEAN(I)
                           WRITE (NF,1000) SEMEAN(I)
                        ELSE
                           D13(1) = SHOWLJ(SEMEAN(I))
                           WRITE (LINE,1050) D13(1)
                           WRITE (NF,1050) D13(1)
                        ENDIF  
                        CALL TABLE1 (J, LINE)
                     ENDDO
                  ENDIF
                  CALL TABLE1 (J, 'CLOSE')
               ENDIF
            ENDIF
            NDEC = 1
         ELSEIF (NDEC.EQ.11) THEN
C
C Goodness of fit options
C
            REPEET = .TRUE.
            DO WHILE (REPEET)
               WRITE (TEXT,1100)
               NOPT = 7
               ISEND = NOPT
               CALL LBOX02 (ICOLOR, IXL, IYL, ISEND, NOPT, NUMPOS,
     +                      TEXT)
               IF (ISEND.EQ.1) THEN
C
C Table of residuals
C
                  J = N15
                  CALL TABLE1 (J, 'OPEN')
                  WRITE (LINE,1200)
                  J = N4
                  CALL TABLE1 (J, LINE)
                  J = N0
                  DO I = N1, N
                     IF (E_NUMBERS) THEN
                        WRITE (LINE,1300) I, Y(I), B(I), Z(I)
                     ELSE
                        D09(1) = SHOW09(Y(I))
                        D09(2) = SHOW09(B(I))
                        D09(3) = SHOW09(Z(I))
                        WRITE (LINE,1350) I, D09(1), D09(2), D09(3)
                     ENDIF      
                     CALL TABLE1 (J, LINE)
                  ENDDO
                  CALL TABLE1 (J, 'CLOSE')
               ELSEIF (ISEND.EQ.2) THEN
C
C File residuals
C
                  IF (.NOT.DONE) THEN
                     DONE = .TRUE.
                     WRITE (NF,1200)
                     DO I = N1, N
                        IF (E_NUMBERS) THEN
                           WRITE (NF,1300) I, Y(I), B(I), Z(I)
                        ELSE
                           D09(1) = SHOW09(Y(I))
                           D09(2) = SHOW09(B(I))
                           D09(3) = SHOW09(Z(I))
                           WRITE (NF,1350) I, D09(1), D09(2), D09(3)
                        ENDIF  
                     ENDDO
                     WRITE (LINE,1400)
                  ELSE
                     WRITE (LINE,1500)
                  ENDIF
                  CALL PUTADV (LINE)
               ELSEIF (ISEND.EQ.3) THEN
C
C Plot residuals aginst best fit
C
                  WRITE (PTITLE,1600)
                  WRITE (XTITLE,1700)
                  WRITE (YTITLE,1800)
                  CALL GKS001 (N0, N4, N,
     +                         B, Z,
     +                         PTITLE, XTITLE, YTITLE)
               ELSEIF (ISEND.LE.5) THEN
C
C Half normal and normal residuals plots
C
                  ISEND = ISEND - N3
                  CALL HNPLOT (ISEND, N, Z)
               ELSEIF (ISEND.EQ.6) THEN
C
C Marginal plots
C
                  IF (NC.GT.N0 .OR. NA.GT.NGRAF .OR. NB.GT.N12) THEN
                     WRITE (LINE,1900)
                     CALL PUTFAT (LINE)
                  ELSEIF (NFAC.EQ.N2) THEN
C
C Assign NN
C
                     DO I = N1, NB
                        NN(I) = NA
                     ENDDO
                     IF (NB.LT.N12) THEN
                        DO I = NB + N1, N12
                           NN(I) = N0
                        ENDDO
                     ENDIF
C
C Assign Y1, etc.
C
                     J = NA + NB + N1
                     DO I = N1, NA
                        Y1(I) = TMEAN(J)
                        Y2(I) = TMEAN(J + N1)
                        J = J + NB
                     ENDDO
                     IF (NB.GT.N2) THEN
                        J = NA + NB + N3
                        DO I = N1, NA
                           Y3(I) = TMEAN(J)
                           J = J + NB
                        ENDDO
                     ENDIF
                     IF (NB.GT.N3) THEN
                        J = NA + NB + N4
                        DO I = N1, NA
                           Y4(I) = TMEAN(J)
                           J = J + NB
                        ENDDO
                     ENDIF
                     IF (NB.GT.N4) THEN
                        J = NA + NB + N5
                        DO I = N1, NA
                           Y5(I) = TMEAN(J)
                           J = J + NB
                        ENDDO
                     ENDIF
                     IF (NB.GT.N5) THEN
                        J = NA + NB + N6
                        DO I = N1, NA
                           Y6(I) = TMEAN(J)
                           J = J + NB
                        ENDDO
                     ENDIF
                     IF (NB.GT.N6) THEN
                        J = NA + NB + N7
                        DO I = N1, NA
                           Y7(I) = TMEAN(J)
                           J = J + NB
                        ENDDO
                     ENDIF
                     IF (NB.GT.N7) THEN
                        J = NA + NB + N8
                        DO I = N1, NA
                           Y8(I) = TMEAN(J)
                           J = J + NB
                        ENDDO
                     ENDIF
                     IF (NB.GT.N8) THEN
                        J = NA + NB + N9
                        DO I = N1, NA
                           Y9(I) = TMEAN(J)
                           J = J + NB
                        ENDDO
                     ENDIF
                     IF (NB.GT.N9) THEN
                        J = NA + NB + N10
                        DO I = N1, NA
                           Y10(I) = TMEAN(J)
                           J = J + NB
                        ENDDO
                     ENDIF
                     IF (NB.GT.N10) THEN
                        J = NA + NB + N11
                        DO I = N1, NA
                           Y11(I) = TMEAN(J)
                           J = J + NB
                        ENDDO
                     ENDIF
                     IF (NB.GT.N11) THEN
                        J = NA + NB + N12
                        DO I = N1, NA
                           Y12(I) = TMEAN(J)
                           J = J + NB
                        ENDDO
                     ENDIF
                     WRITE (PTITLE,2000) 'A','B'
                     WRITE (XTITLE,2100) 'A'
                     WRITE (YTITLE,2200)
                     CALL GKS012 (LL1, LL2, LL3, LL4, LL5, LL6, LL7,
     +                            LL8, LL9, LL10, LL11, LL12,
     +                            MM1, MM2, MM3, MM4, MM5, MM6, MM7,
     +                            MM8, MM9, MM10, MM11, MM12,
     +                            NN(1), NN(2), NN(3), NN(4), NN(5),
     +                            NN(6), NN(7), NN(8), NN(9), NN(10),
     +                            NN(11), NN(12),
     +                            X1, X2, X3, X4, X5, X6, X7, X8, X9,
     +                            X10, X11, X12,
     +                            Y1, Y2, Y3, Y4, Y5, Y6, Y7, Y8, Y9,
     +                            Y10, Y11, Y12,
     +                            PTITLE, XTITLE, YTITLE,
     +                            AXES, GSAVE)
                  ENDIF
               ELSE
                  REPEET = .FALSE.
               ENDIF
            ENDDO
            NDEC = 1
         ELSEIF (NDEC.EQ.12) THEN
            EXTRA = .NOT.EXTRA
            NDEC = 1
         ELSEIF (NDEC.EQ.NOPT) THEN
            NEWDAT = .FALSE.
            AGAIN = .FALSE.
         ENDIF
      ENDDO
C
C Format statements
C
  100 FORMAT (
     + 'Factorial ANOVA'
     +/
     +/'Column 1 must have block numbers as nondecreasing integers,'
     +/'column 2 must have levels of A as nondecreasing integers,'
     +/'etc. and finally the last column must be observations.'
     +/'Use data untransformed and only use the variance stabilisation'
     +/'if you have good reasons to do so, and know what you are doing.'
     +/'Note: log is to base e and x can be a percentage or proportion.'
     +/
     +/'Input factorial ANOVA data'
     +/'ANOVA [on x (data untransformed)]'
     +/'ANOVA [on log(x))]'
     +/'ANOVA [on sqrt(x)]'
     +/'ANOVA [on arcsin(sqrt(x/100))]`(0 < x < 100)'
     +/'ANOVA [on log(x/(100 - x))]   `(0 < x < 100)'
     +/'ANOVA [on Phi_inverse(x/100))]`(0 < x < 100)'
     +/'ANOVA [on arcsin(sqrt(x))]    `(0 < x < 1)'
     +/'ANOVA [on log(x/(1 - x))]     `(0 < x < 1)'
     +/'ANOVA [on Phi_inverse(x)]     `(0 < x < 1)'
     +/'Analyse residuals/marginals   `Goodness of fit'
     +/'Change output (Full/Short)    `',A
     +/'Quit                          `Exit Factorial ANOVA')
  200 FORMAT (
     + '2 factors, no blocking'
     +/'2 factors, blocks >= 1'
     +/'3 factors, no blocking'
     +/'3 factors, blocks >= 1'
     +/'n factors, blocks >= 1 (NA)'
     +/'Quit ... Exit Factor options')
  300 FORMAT ( 
     +/' Factorial ANOVA:',I3
     +/1X,A
     +/' Source               SSQ      NDOF       MS            F',
     +'          p'
     +/' Blocks        ',1P,1X,E13.5,I6,2(1X,E13.5),0P,F8.4
     +/' Effect 1 (A)  ',1P,1X,E13.5,I6,2(1X,E13.5),0P,F8.4
     +/' Effect 2 (B)  ',1P,1X,E13.5,I6,2(1X,E13.5),0P,F8.4
     +/' Effect 3 (A*B)',1P,1X,E13.5,I6,2(1X,E13.5),0P,F8.4
     +/' Residual      ',1P,1X,E13.5,I6,1X,E13.5
     +/' Total         ',1P,1X,E13.5,I6)
  350 FORMAT ( 
     +/' Factorial ANOVA:',I3
     +/1X,A
     +/' Source               SSQ      NDOF       MS            F',
     +'          p'
     +/' Blocks        ',1X,A13,I6,2(1X,A13),F8.4
     +/' Effect 1 (A)  ',1X,A13,I6,2(1X,A13),F8.4
     +/' Effect 2 (B)  ',1X,A13,I6,2(1X,A13),F8.4
     +/' Effect 3 (A*B)',1X,A13,I6,2(1X,A13),F8.4
     +/' Residual      ',1X,A13,I6,1X,A13
     +/' Total         ',1X,A13,I6)     
  400 FORMAT (
     +/' Factorial ANOVA:',I3
     +/1X,A
     +/' Source                  SSQ      NDOF     MS             F',
     +'          p'
     +/' Blocks          ',1P,1X,E13.5,I6,2(1X,E13.5),0P,F8.4
     +/' Effect 1 (A)    ',1P,1X,E13.5,I6,2(1X,E13.5),0P,F8.4
     +/' Effect 2 (B)    ',1P,1X,E13.5,I6,2(1X,E13.5),0P,F8.4
     +/' Effect 3 (C)    ',1P,1X,E13.5,I6,2(1X,E13.5),0P,F8.4
     +/' Effect 4 (A*B)  ',1P,1X,E13.5,I6,2(1X,E13.5),0P,F8.4
     +/' Effect 5 (A*C)  ',1P,1X,E13.5,I6,2(1X,E13.5),0P,F8.4
     +/' Effect 6 (B*C)  ',1P,1X,E13.5,I6,2(1X,E13.5),0P,F8.4
     +/' Effect 7 (A*B*C)',1P,1X,E13.5,I6,2(1X,E13.5),0P,F8.4
     +/' Residual        ',1P,1X,E13.5,I6,1X,E13.5
     +/' Total           ',1P,1X,E13.5,I6)
  450 FORMAT (
     +/' Factorial ANOVA:',I3
     +/1X,A
     +/' Source                  SSQ      NDOF       MS             F',
     +'        p'
     +/' Blocks          ',1X,A13,I6,2(1X,A13),F8.4
     +/' Effect 1 (A)    ',1X,A13,I6,2(1X,A13),F8.4
     +/' Effect 2 (B)    ',1X,A13,I6,2(1X,A13),F8.4
     +/' Effect 3 (C)    ',1X,A13,I6,2(1X,A13),F8.4
     +/' Effect 4 (A*B)  ',1X,A13,I6,2(1X,A13),F8.4
     +/' Effect 5 (A*C)  ',1X,A13,I6,2(1X,A13),F8.4
     +/' Effect 6 (B*C)  ',1X,A13,I6,2(1X,A13),F8.4
     +/' Effect 7 (A*B*C)',1X,A13,I6,2(1X,A13),F8.4
     +/' Residual        ',1X,A13,I6,1X,A13
     +/' Total           ',1X,A13,I6)     
  500 FORMAT (1X,'Overall mean')
  600 FORMAT (1P,E13.5)
  650 FORMAT (1X,A13)
  700 FORMAT (1X,'Block means')
  800 FORMAT (1X,'Treatment means')
  900 FORMAT (1X,A,I3)
 1000 FORMAT (1X,'Standard error of difference in means =',1P,E10.3)
 1050 FORMAT (1X,'Standard error of difference in means =',1X,A)
 1100 FORMAT (
     + 'Display residuals'
     +/'File Residuals'
     +/'Plot residuals: against best fit'
     +/'Plot residuals: half normal'
     +/'Plot residuals: full normal'
     +/'Plot marginals'
     +/'Quit ... Exit residuals options')
 1200 FORMAT (' Number Observation  Prediction    Residual')
 1300 FORMAT (I7,1P,3E12.3)
 1350 FORMAT (I7,3(3X,A9))
 1400 FORMAT ('Residuals have now been written to the results file')
 1500 FORMAT ('Residuals have already been saved to the results file')
 1600 FORMAT ('Residuals against Best-Fit')
 1700 FORMAT ('Predicted Values')
 1800 FORMAT ('Residuals')
 1900 FORMAT ('Too many factors or factor levels')
 2000 FORMAT ('Marginal Plots for',1X,A,1X,'at fixed',1X,A)
 2100 FORMAT ('Levels of Factor',1X,A)
 2200 FORMAT ('Values')
 5000 FORMAT (1P,8E11.3)!NFRMT is 8 in this case
 5050 FORMAT (8(2X,A9))!NFRMT is 8 in this case
      END
C
C
