C
C
      SUBROUTINE ANOVAD (K, KMAX, L, LMAX, LSUB, N, NCMAX, NIN, NOBS,
     +                   NRMAX,
     +                   A, B, Y,
     +                   FNAME, TITLE,
     +                   ABORT, SUPPLY)
C
C ACTION: read in data for 2-way ANOVA as required for G04AGF$
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 06/07/2000
C         11/09/2003 revised
C         27/03/2006 added SUPPLY to arguments
C         11/05/2010 introduced NKLCFG to switch on/off the test file advice 
C         30/04/2011 introduced call to TFILEQ     
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    K, KMAX, L, LMAX, LSUB(KMAX), N, NCMAX, NIN,
     +           NOBS(LMAX), NRMAX
      DOUBLE PRECISION A(NRMAX,NCMAX), B(NCMAX), Y(NRMAX)
      CHARACTER  FNAME*(*), TITLE*(*)
      LOGICAL    ABORT, SUPPLY
C
C Locals
C
      INTEGER    I, ICOUNT, ITEMP, JCOUNT, JTEMP, KCOUNT, NCOL, NROW
      INTEGER    KVAL9, NKLCFG
      INTEGER    ISEND, N0, N1, N2, N3, N21
      PARAMETER (ISEND = 2, N0 = 0, N1 = 1, N2 = 2, N3 = 3, N21 = 21)
      CHARACTER  LINE*100
      LOGICAL    FIXCOL, FIXROW, LABEL
      PARAMETER (FIXCOL = .TRUE., FIXROW = .FALSE., LABEL = .TRUE.)
      EXTERNAL   MATTIN, PUTFAT, VU2CHK, ISITMF
      EXTERNAL   NKLCFG, TFILEQ
      INTRINSIC  NINT
C
C Initialise
C
       ABORT = .TRUE.
       L = N0
       N = N0
C
C Read in the data
C
      IF (SUPPLY) THEN
         CALL ISITMF (NCOL, NROW,
     +                FNAME)
      ELSE
         KVAL9 = NKLCFG(N21)
         IF (KVAL9.EQ.N1) THEN
            WRITE (LINE,100)
            CALL TFILEQ (LINE)
         ENDIF   
         CLOSE (UNIT = NIN)
         NCOL = N3
         CALL MATTIN (ISEND, NCMAX, NCOL, NIN, NRMAX, NROW,
     +                A, B,
     +                FNAME, TITLE,
     +                ABORT, FIXCOL, FIXROW, LABEL)
         CLOSE (UNIT = NIN)
         IF (ABORT) RETURN
      ENDIF
      IF (NROW.LT.2 .OR. NCOL.NE.3) THEN
         ABORT = .TRUE.
         WRITE (LINE,200)
         CALL PUTFAT (LINE)
         CALL VU2CHK (FNAME)
         RETURN
      ENDIF
C
C Check A(1,1) and A(1,2)
C
      ITEMP = NINT(A(N1,N1))
      JTEMP = NINT(A(N1,N2))
      IF (ITEMP.NE.N1 .OR. JTEMP.NE.N1) THEN
         ABORT = .TRUE.
         WRITE (LINE,300)
         CALL PUTFAT (LINE)
         CALL VU2CHK (FNAME)
         RETURN
      ENDIF
C
C Assign N, check column 1 and 2 and calculate K
C
      N = NROW
      K = N1
      DO I = N2, NROW
         ITEMP = NINT(A(I,N1))
         JTEMP = NINT(A(I,N2))
         IF (ITEMP.LT.K .OR. ITEMP.GT.K + N1) THEN
            ABORT = .TRUE.
            WRITE (LINE,400) I + N2
            CALL PUTFAT (LINE)
            CALL VU2CHK (FNAME)
            RETURN
         ELSEIF (ITEMP.EQ.K + N1) THEN
            IF (K.EQ.KMAX) THEN
               ABORT = .TRUE.
               WRITE (LINE,500) I + N2
               CALL PUTFAT (LINE)
               CALL VU2CHK (FNAME)
               RETURN
            ENDIF
            K = K + N1
         ENDIF
         IF (JTEMP.LE.N0) THEN
            ABORT = .TRUE.
            WRITE (LINE,600) I + N2
            CALL PUTFAT (LINE)
            CALL VU2CHK (FNAME)
            RETURN
         ENDIF
      ENDDO
C
C Check column 2  as follows:
C ICOUNT = 1, 2, 3, etc = the group
C JCOUNT = 1, 2, 3, etc = the subgroup
C KCOUNT = 1, 2, 3, etc = the running group/subgroup
C
      DO I = N1, K
         LSUB(I) = N0
      ENDDO
      ICOUNT = N1
      JCOUNT = N1
      KCOUNT = N1
      L = N1
      LSUB(ICOUNT) = N1
      NOBS(KCOUNT) = N0
      DO I = N1, NROW
         ITEMP = NINT(A(I,N1))
         JTEMP = NINT(A(I,N2))
         IF (ITEMP.GT.ICOUNT) THEN
C
C Start a new group
C
            ICOUNT = ICOUNT + N1
            IF (JTEMP.NE.N1) THEN
               ABORT = .TRUE.
               WRITE (LINE,700) I + N2
               CALL PUTFAT (LINE)
               CALL VU2CHK (FNAME)
               RETURN
            ENDIF
            JCOUNT = N1
            KCOUNT = KCOUNT + N1
            IF (L.EQ.LMAX) THEN
               ABORT = .TRUE.
               WRITE (LINE,800) I + N2
               CALL PUTFAT (LINE)
               CALL VU2CHK (FNAME)
               RETURN
            ELSE
               L = L + N1
            ENDIF
            LSUB(ICOUNT) = N1
            NOBS(KCOUNT) = N0
         ENDIF
         IF (JTEMP.LT.JCOUNT .OR. JTEMP.GT.JCOUNT + N1) THEN
C
C Limits exceeded
C
            ABORT = .TRUE.
            WRITE (LINE,600) I + N2
            CALL PUTFAT (LINE)
            CALL VU2CHK (FNAME)
            RETURN
         ELSEIF (JTEMP.EQ.JCOUNT) THEN
C
C Continue with the same subgroup
C
            NOBS(KCOUNT) = NOBS(KCOUNT) + N1
         ELSE
C
C Start a new subgroup
C
            JCOUNT = JCOUNT + N1
            KCOUNT = KCOUNT + N1
            IF (L.EQ.LMAX) THEN
               ABORT = .TRUE.
               WRITE (LINE,800) I + N2
               CALL PUTFAT (LINE)
               CALL VU2CHK (FNAME)
               RETURN
            ELSE
               L = L + N1
            ENDIF
            LSUB(ICOUNT) = LSUB(ICOUNT) + N1
            NOBS(KCOUNT) = N1
         ENDIF
         Y(I) = A(I,N3)
      ENDDO
C
C Success so set ABORT = .FALSE.
C
      ABORT = .FALSE.
C
C Format statements
C
  100 FORMAT (
     +'Now input a data file formatted exactly like ANOVA4.TF1')
  200 FORMAT (
     +'Insufficient or inconsistent data')
  300 FORMAT (
     +'Error at line 3: A(1,1) and A(1,2) must be 1 (see ANOVA4.TF1)')
  400 FORMAT (
     +'Error at line',I6,': A(i,1) out of order (see ANOVA4.TF1)')
  500 FORMAT (
     +'Error at line',I6,': KMAX exceeded ... too many groups')
  600 FORMAT (
     +'Error at line',I6,': A(i,2) must be > 0 (see ANOVA4.TF1)')
  700 FORMAT (
     +'Error at line',I6,': A(i,2) out of range (see ANOVA4.TF1)')
  800 FORMAT (
     +'Error at line',I6,': LMAX exceeded ... too many subgroups')
      END
C
C
