C
C
      SUBROUTINE ANOVAF (ISEND, IWRK, N, NBLOCK, NCMAX, NFAC, NIN,
     +                   NREPS, NRMAX,
     +                   A, Y,
     +                   FNAME, TITLE,
     +                   ABORT, SUPPLY)
C
C ACTION: read in data for two/three factor ANOVA
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 16/09/2003
C         16/09/2003 derived from ANOVAD
C         27/03/2006 added SUPPLY to arguments
C         11/05/2010 introduced NKLCFG to switch on/off the test file advice 
C         30/04/2011 introduced call to TFILEQ
C
C  ISEND: (input/unchanged) as follows:
C          ISEND = 1: 2 factors, no blocks (unchanged)
C          ISEND = 2: 2 factors, blocks (unchanged)
C          ISEND = 3: 3 factors, no blocks (unchanged)
C          ISEND = 4: 3 factors, blocks (unchanged)
C          ISEND = 5: Not yet implemented
C   IWRK: workspace
C      N: (output) no. data points
C NBLOCK: (output) no. blocks
C  NCMAX: (input/unchanged) dimension
c   NFAC: (output) no. factors
C    NIN: (input/unchanged) unconnected input unit
C  NREPS: (output) no. replicates then finally number of levels
C  NRMAX: (input/unchanged) dimension
C      A: (input/output) data matrix (depending on SUPPLY)
C      Y: (output) data ready for analysis
C  FNAME: (input/output) file name (depending on SUPPLY)
C  TITLE: (input/output) title (depending on SUPPLY)
C  ABORT: (output) error flag
C SUPPLY: (input/unchanged) as follows:
C         SUPPLY = .TRUE. then supply data, filename, and title
C                   o/w read in data
C
C-------------------------
C
C     NA: no. A levels
C     NB: no. B levels
C     NC: no. C levels
C     ND: no. D levels
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    NCMAX, NRMAX
      INTEGER    IWRK(NRMAX), NREPS(NRMAX)
      INTEGER    ISEND, N, NBLOCK, NFAC, NIN
      DOUBLE PRECISION A(NRMAX,NCMAX), Y(NRMAX)
      CHARACTER  FNAME*(*), TITLE*(*)
      LOGICAL    ABORT, SUPPLY
C
C Locals
C
      INTEGER    NA, NB, NC, ND
      INTEGER    KREPS, KTYPE, NCOL, NERR, NLINE, NMAX, NMIN,
     +           NROW, NTYPE
      INTEGER    ITEMP, JTEMP
      INTEGER    I, J, K, L, M
      INTEGER    KVAL9, NKLCFG
      INTEGER    JSEND, N0, N1, N2, N3, N4, N5, N21, NBIG
      PARAMETER (JSEND = 2, N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4,
     +           N5 = 5, N21 = 21, NBIG = 20)
      DOUBLE PRECISION XMAX, XMIN, XTEMP
      CHARACTER  LINE*100
      LOGICAL    FIXCOL, FIXROW, LABEL
      PARAMETER (FIXROW = .FALSE., LABEL = .TRUE.)
      EXTERNAL   MATTIN, PUTFAT, VECERR, VECORD, VU2CHK, ISITMF
      EXTERNAL   NKLCFG, TFILEQ
      INTRINSIC  NINT
C
C Initialise
C
       ABORT = .TRUE.
       N = N0
       NFAC = N0
       NA = N0
       NB = N0
       NBLOCK = N0
       NC = N0
       ND = N0
       DO I = N1, NRMAX
          NREPS(I) = N0
       ENDDO
       IF (.NOT.SUPPLY) THEN
C
C Read in the data
C
          IF (ISEND.EQ.N1) THEN
             FIXCOL = .TRUE.
             NCOL = N4
             NFAC = N2
             WRITE (LINE,100) 'anova5.tf1'
          ELSEIF (ISEND.EQ.N2) THEN
             FIXCOL = .TRUE.
             NCOL = N4
             NFAC = N2
             WRITE (LINE,100) 'anova5.tf2'
          ELSEIF (ISEND.EQ.N3) THEN
             FIXCOL = .TRUE.
             NCOL = N5
             NFAC = N3
             WRITE (LINE,100) 'anova5.tf3'
          ELSEIF (ISEND.EQ.N4) THEN
             FIXCOL = .TRUE.
             NCOL = N5
             NFAC = N3
             WRITE (LINE,100) 'anova5.tf4'
          ELSEIF (ISEND.EQ.N5) THEN
             FIXCOL = .FALSE.
             WRITE (LINE,100) 'anova5.tf5'
          ELSE
             WRITE (LINE,200)
             CALL PUTFAT (LINE)
             RETURN
          ENDIF
          KVAL9 = NKLCFG(N21)
          IF (KVAL9.EQ.N1) CALL TFILEQ (LINE)
          CLOSE (UNIT = NIN)
          CALL MATTIN (JSEND, NCMAX, NCOL, NIN, NRMAX, NROW,
     +                 A, Y,
     +                 FNAME, TITLE,
     +                 ABORT, FIXCOL, FIXROW, LABEL)
          CLOSE (UNIT = NIN)
          IF (ABORT) RETURN
       ELSE
C
C Check data supplied
C
          CALL ISITMF (NCOL, NROW,
     +                 FNAME)
          IF (NROW.LT.N2 .OR. NCOL.LT.N4 .OR. NCOL.GT.N5) THEN
             NCOL = N0
             NROW = N0
          ELSEIF (ISEND.EQ.N1) THEN
             IF (NCOL.NE.N4) THEN
                NCOL = N0
             ELSE
                NFAC = N2
             ENDIF
          ELSEIF (ISEND.EQ.N2) THEN
             IF (NCOL.NE.N4) THEN
                NCOL = N0
             ELSE
                NFAC = N2
             ENDIF
          ELSEIF (ISEND.EQ.N3) THEN
             IF (NCOL.NE.N5) THEN
                NCOL = N0
             ELSE
                NFAC = N3
             ENDIF
          ELSEIF (ISEND.EQ.N4) THEN
             IF (NCOL.NE.N5) THEN
                NCOL = N0
             ELSE
                NFAC = N3
             ENDIF
          ELSEIF (ISEND.EQ.N5) THEN
             IF (NCOL.LE.N5) NCOL = N0
          ELSE
             WRITE (LINE,200)
             CALL PUTFAT (LINE)
             RETURN
          ENDIF
      ENDIF
      IF (NROW.LT.N2 .OR. NCOL.LT.N4 .OR. NCOL.GT.N5) THEN
         ABORT = .TRUE.
         WRITE (LINE,300)
         CALL PUTFAT (LINE)
         CALL VU2CHK (FNAME)
         RETURN
      ENDIF
C
C Check A(1,1) to A(1,NCOL - 1)
C
      DO I = N1, NCOL - N1
         ITEMP = NINT(A(N1,I))
         IF (ITEMP.NE.N1) THEN
            ABORT = .TRUE.
            WRITE (LINE,400) N1, I
            CALL PUTFAT (LINE)
            CALL VU2CHK (FNAME)
            RETURN
         ENDIF
      ENDDO
C
C Assign N and check column 1 ... this version limited to NRMAX blocks
C
      N = NROW
      NMIN = N1
      IF (ISEND.EQ.N1 .OR. ISEND.EQ.N3) THEN
         NMAX = N1
      ELSE
         NMAX = NRMAX
      ENDIF
      DO I = N1, N
         IWRK(I) = NINT(A(I,N1))
      ENDDO
      CALL VECORD (IWRK, N, NERR, NLINE, NMAX, NMIN, NREPS, NTYPE)
      NCOL = N1
      NROW = NLINE
      CALL VECERR (NCOL, NERR, NMAX, NMIN, NROW,
     +             FNAME,
     +             ABORT)
      IF (ABORT) RETURN
      IF (ISEND.EQ.N1 .OR. ISEND.EQ.N3) THEN
         NBLOCK = N1
         KTYPE = N
      ELSE
         IF (NTYPE.GT.N1) THEN
            DO I = N2, NTYPE
               IF (NREPS(I).NE.NREPS(I - N1)) THEN
                  WRITE (LINE,500)
                  CALL PUTFAT (LINE)
                  CALL VU2CHK (FNAME)
                  RETURN
               ENDIF
            ENDDO
         ENDIF
         NBLOCK = NTYPE
      ENDIF
C
C Calculate NA, NB, NC, ND, etc. ... this version limited to NBIG factor levels
C
      DO J = N2, NFAC + N1
         XMAX = A(N1,J)
         XMIN = XMAX
         DO I = N2, N
            XTEMP = A(I,J)
            IF (XTEMP.LT.XMIN) XMIN = XTEMP
            IF (XTEMP.GT.XMAX) XMAX = XTEMP
         ENDDO
         ITEMP = NINT(XMIN)
         JTEMP = NINT(XMAX)
         IF (ITEMP.NE.N1 .OR. JTEMP.LT.N2 .OR. JTEMP.GT.NBIG) THEN
            WRITE (LINE,600) J, NBIG
            CALL PUTFAT (LINE)
            CALL VU2CHK (FNAME)
            RETURN
         ENDIF
         IF (J.EQ.N2) THEN
            NA = JTEMP
         ELSEIF (J.EQ.N3) THEN
            NB = JTEMP
         ELSEIF (J.EQ.N4) THEN
            NC = JTEMP
         ELSEIF (J.EQ.N4) THEN
            ND = JTEMP
         ENDIF
      ENDDO
C
C Calculate KREPS = no. replicates per cell and check for consistency
C
      J = 1
      IF (NFAC.EQ.N2) THEN
         I = NA*NB*NBLOCK
         KREPS = N/I
         J = N - KREPS*NA*NB*NBLOCK
      ELSEIF (NFAC.EQ.N3) THEN
         I = NA*NB*NC*NBLOCK
         KREPS = N/I
         J = N - KREPS*NA*NB*NC*NBLOCK
      ELSEIF (NFAC.EQ.N4) THEN
         I = NA*NB*NC*ND*NBLOCK
         KREPS = N/I
         J = N - KREPS*NA*NB*NC*ND*NBLOCK
      ENDIF
      IF (J.NE.N0) THEN
         WRITE (LINE,700)
         CALL PUTFAT (LINE)
         CALL VU2CHK (FNAME)
         RETURN
      ENDIF
C
C Check column 2 where KTYPE = length of each SUB-block
C
      KTYPE = N/NBLOCK
      K = N1 - KTYPE
      L = N0
      DO I = N1, NBLOCK
         K = K + KTYPE
         L = L + KTYPE
         M = N0
         DO J = K, L
            M = M + N1
            IWRK(M) = NINT(A(J,N2))
         ENDDO
         NMAX = NBIG
         NMIN = N1
         CALL VECORD (IWRK, KTYPE, NERR, NLINE, NMAX, NMIN, NREPS,
     +                NTYPE)
         NCOL = N2
         NROW = NLINE + (I - N1)*KTYPE
         CALL VECERR (NCOL, NERR, NMAX, NMIN, NROW,
     +                FNAME,
     +                ABORT)
         IF (ABORT) RETURN
         DO J = N2, NTYPE
            IF (NREPS(J).NE.NREPS(J - N1)) THEN
               WRITE (LINE,800) N2
               CALL PUTFAT (LINE)
               CALL VU2CHK (FNAME)
               RETURN
            ENDIF
         ENDDO
      ENDDO
C
C Check column 3 after defining KTYPE = no. per level of A
C
      KTYPE = N/(NA*NBLOCK)
      K = N1 - KTYPE
      L = N0
      DO I = N1, NA*NBLOCK
         K = K + KTYPE
         L = L + KTYPE
         M = N0
         DO J = K, L
            M = M + N1
            IWRK(M) = NINT(A(J,N3))
         ENDDO
         NMAX = NBIG
         NMIN = N1
         CALL VECORD (IWRK, KTYPE, NERR, NLINE, NMAX, NMIN, NREPS,
     +                NTYPE)
         NCOL = N3
         NROW = NLINE + (I - N1)*KTYPE
         CALL VECERR (NCOL, NERR, NMAX, NMIN, NROW,
     +                FNAME,
     +                ABORT)
         IF (ABORT) RETURN
         DO J = N2, NTYPE
            IF (NREPS(J).NE.NREPS(J - N1)) THEN
               WRITE (LINE,800) N3
               CALL PUTFAT (LINE)
               CALL VU2CHK (FNAME)
               RETURN
            ENDIF
         ENDDO
      ENDDO
C
C Check column 4 after defining KTYPE = no. per level of A and B
C
      IF (NFAC.GT.N2) THEN
         KTYPE = N/(NA*NB*NBLOCK)
         K = N1 - KTYPE
         L = N0
         DO I = N1, NA*NB*NBLOCK
            K = K + KTYPE
            L = L + KTYPE
            M = N0
            DO J = K, L
               M = M + N1
               IWRK(M) = NINT(A(J,N4))
            ENDDO
            NMAX = NBIG
            NMIN = N1
            CALL VECORD (IWRK, KTYPE, NERR, NLINE, NMAX, NMIN, NREPS,
     +                   NTYPE)
            NCOL = N4
            NROW = NLINE + (I - N1)*KTYPE
            CALL VECERR (NCOL, NERR, NMAX, NMIN, NROW,
     +                   FNAME,
     +                   ABORT)
            IF (ABORT) RETURN
            DO J = N2, NTYPE
               IF (NREPS(J).NE.NREPS(J - N1)) THEN
                  WRITE (LINE,800) N4
                  CALL PUTFAT (LINE)
                  CALL VU2CHK (FNAME)
                  RETURN
               ENDIF
            ENDDO
         ENDDO
      ENDIF
C
C Success so set ABORT = .FALSE. and return levels in NREPS and fill in Y
C
      ABORT = .FALSE.
      NREPS(1) = NA
      NREPS(2) = NB
      NREPS(3) = NC
      NREPS(4) = ND
      NCOL = NFAC + N2
      DO I = N1, N
         Y(I) = A(I,NCOL)
      ENDDO
C
C Format statements
C
  100 FORMAT ('Now input a data file formatted exactly like',1X,A)
  200 FORMAT ('ISEND out of range in call to ANOVAF')
  300 FORMAT (
     +'Insufficient data or too many factors requested')
  400 FORMAT (
     +'Error at row,',I5,' column',I3,' (see anova5.tf1)')
  500 FORMAT (
     +'All blocks must be the same size (see anova5.tf2)')
  600 FORMAT (
     +'Error in column',I2,': min < 1, out of order, max < 2 or >',I3)
  700 FORMAT (
     +'Must have the same number of replicates per cell')
  800 FORMAT (
     +'Replicates per cell not all equal in column',I3)
      END
C
C
