C
C
      SUBROUTINE ARRPAR (ISEND, INDEXX, ITIME, NRMAX, NPAR,
     +                   COV, PAR, W)
C
C ACTION: Arrange parameters from mmfit, hlfit and exfit in increasing order
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 16/06/2001
C         16/10/2007 added INTENTS
C
C         ISEND = 1: MMFIT
C         ISEND = 2: HLFIT
C         ISEND = 3: EXFIT models 1 or 2
C         INDEXX: returns with sorting index
C         ITIME: model order
C         NRMAX: leading dimension of COV
C         NPAR: no. parameters
C         COV: covariance matrix...lower triangle supplied but returned
C              as fully permuted covariance matrix
C         PAR: parameters returned in sorted order
C         W: workspace
C
C         The sorting order is on parameters 1 to ITIME which carries
C         parameters ITIME + 1 to 2*ITIME along in natural order. If a
C         constant is supplied (NPAR = 2*ITIME + 1) it is not swapped.
C         The idea is to arrange the output from MMFIT, HLFIT and EXFIT
C         into increasing order of amplitude parameters.
C
      IMPLICIT  NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NRMAX, NPAR
      INTEGER,          INTENT (IN)    :: ISEND, ITIME
      INTEGER,          INTENT (OUT)   :: INDEXX(NPAR)
      DOUBLE PRECISION, INTENT (INOUT) :: COV(NRMAX,NPAR), PAR(NPAR),
     +                                    W(2*ITIME)
C
C Locals
C      
      INTEGER   I, J, K, L
      LOGICAL   OK
      EXTERNAL  INDX2A, PUTFAT
      INTRINSIC MAX, MIN
C
C Initialise INDEXX
C      
      IF (NPAR.GT.0) THEN
         DO I = 1, NPAR
            INDEXX(I) = I
         ENDDO
      ENDIF      
C
C Check
C
       IF (NPAR.LT.2 .OR. ITIME.LT.1) THEN
           CALL PUTFAT ('NPAR or ITIME out of range in call to ARRPAR')
           RETURN
       ENDIF
       IF (ISEND.EQ.1) THEN
C
C MMFIT
C
          IF (NPAR.NE.2*ITIME) THEN
             CALL PUTFAT ('NPAR.NE.2*ITIME in call to ARRPAR')
             RETURN
          ENDIF
       ELSEIF (ISEND.EQ.2 .OR. ISEND.EQ.3) THEN
C
C HLFIT or EXFIT for standard models
C
          IF (NPAR.LT.2*ITIME .OR. NPAR.GT.2*ITIME + 1) THEN
             CALL PUTFAT (
     +       'NPAR and ITIME inconsistent in call to ARRPAR')
             RETURN
          ENDIF
       ELSE
          CALL PUTFAT ('ISEND out of range in call to ARRPAR')
          RETURN
       ENDIF
C
C No action if ITIME = 1
C
      IF (ITIME.EQ.1) RETURN
C
C Get the index to parameters 1 to ITIME
C
      CALL INDX2A (INDEXX, ITIME,
     +             PAR)
      OK = .TRUE.
      I = 0
      DO WHILE (OK .AND. I.LT.ITIME)
         I = I + 1
         IF (INDEXX(I).NE.I) OK = .FALSE.
      ENDDO
C
C If the parameters are in order no action is required
C
      IF (OK) RETURN
C
C Assign the rest of INDEXX but not INDEXX(NPAR) if NPAR > 2*ITIME
C
      DO I = 1, ITIME
         J = ITIME + I
         INDEXX(J) = ITIME + INDEXX(I)
      ENDDO
C
C Permute parameters 1 to 2*ITIME
C
      DO I = 1, 2*ITIME
         J = INDEXX(I)
         W(I) = PAR(J)
      ENDDO
      DO I = 1, 2*ITIME
         PAR(I) = W(I)
      ENDDO
C
C Permute the variances
C
      DO I = 1, 2*ITIME
         J = INDEXX(I)
         W(I) = COV(J,J)
      ENDDO
      DO I = 1, 2*ITIME
         COV(I,I) = W(I)
      ENDDO
C
C Copy the permuted lower triangle of COV to the upper triangle then overwrite
C
      DO I = 2, NPAR
         DO J = 1, I - 1
            K = MAX(INDEXX(I), INDEXX(J))
            L = MIN(INDEXX(I), INDEXX(J))
            COV(J,I) = COV(K,L)
         ENDDO
      ENDDO
      DO I = 2, NPAR
         DO J = 1, I - 1
            COV(I,J) = COV(J,I)
         ENDDO
      ENDDO
      END
C
C
