C
C
      SUBROUTINE AXEQB1 (NCMAX, NCOL, NIN, NF, NRMAX, NROW, NWORK,
     +                   A, B, C, T,
     +                   TITLE, TITLE1,
     +                   ABORT, DISPLY, FILE, SUPPLY)
C
C ACTION : Solve Ax = b where A is square and non-singular
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 17/7/96
C          07/02/2001 added CHOP80
C          16/01/2006 C now dimensioned C(NRMAX,*) as only column 1 is used
C          03/11/2021 added E_NUMBERS, E_FORMATS, etc. 
C
C ADVICE : If successful then on exit ABORT = .FALSE.,
C
C          METHOD 1: Straight call
C          =========
C          The routine is silent if SUPPLY is .TRUE. and both DISPLY
C          and FILE are .FALSE.
C          Then A is supplied with a column vector T and the solution is
C          returned in C(i,1) if ABORT = .FALSE.  B is the LU on exit.
C
C          METHOD 2: interactive
C          =========
C          A and T need not be set at all but on return A and T will be set
C          and B will be LU while C(i,1) will be the latest solution
C
C          NCMAX = column dimension
C          NCOL = actual no. columns
C          NIN = input unit
C          NF = output unit
C          NRMAX = row dimension
C          NROW = actual no. rows
C          NWORK = workspace
C          A = matrix supplied
C          B = LU factorisation
C          C = right hand side (column 1 only)
C          T = solution (if successful)
C          ABORT = failure ?
C          DISPLY = table to screen ?
C          FILE = output to file ?
C          SUPPLY = provide data ?
C
      IMPLICIT   NONE
      INTEGER    NCMAX, NCOL, NIN, NF, NRMAX, NROW, NWORK(NRMAX)
      INTEGER    NCOL1, NRMAX1, NROW1
      INTEGER    I, ICOLOR, IFAIL, J
      INTEGER    N0, N1, N2, N3, N4, N15
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N15 = 15)
      INTEGER    IX, IY, NUMDEC, NUMOPT
      PARAMETER (IX = 4, IY = 4, NUMOPT = 3)
      INTEGER    NUMPOS(NUMOPT)
      DOUBLE PRECISION A(NRMAX,NCMAX), B(NRMAX,NCMAX), C(NRMAX,*),
     +                 T(NRMAX)
      CHARACTER  TITLE*(*), TITLE1*(*)
      CHARACTER (LEN = 13) D13(2), SHOWRJ 
      CHARACTER  CHOP80*80, FNAME*1024, LINE*100, TEXT(NUMOPT)*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      CHARACTER  TRANS*1
      PARAMETER (TRANS = 'N')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ABORT, DISPLY, FILE, SUPPLY
      LOGICAL    FIXCOL, FIXROW, LABEL
      PARAMETER (FIXCOL = .FALSE., FIXROW = .FALSE., LABEL = .TRUE.)
      LOGICAL    FIXNPT, READY
      PARAMETER (FIXNPT = .TRUE.)
      EXTERNAL   E_FORMATS, SHOWRJ
      EXTERNAL   F07ADF$, F07AEF$
      EXTERNAL   MATTIN, TABLE1, PUTIFA, PUTFAT, PUTADV, VEC1IN, LBOX02,
     +           CHOP80
      DATA       NUMPOS / NUMOPT*1 /
      ABORT = .TRUE.
C
C Branch point to read in a new A
C
   20 CONTINUE
      IF (.NOT.SUPPLY) THEN
C
C Read in the matrix if .NOT.SUPPLY
C
         CALL PUTADV (
     +  'Now input the required square nonsingular matrix A')
         I = N0
         CLOSE (UNIT = NIN)
         CALL MATTIN (I, NCMAX, NCOL, NIN, NRMAX, NROW, A, T, FNAME,
     +                TITLE, ABORT, FIXCOL, FIXROW, LABEL)
         CLOSE (UNIT = NIN)
         IF (ABORT) THEN
            READY = .FALSE.
            GOTO 60
         ELSE
            READY = .TRUE.
         ENDIF
      ENDIF
C
C Check the dimensions
C
      IF (NCOL.LT.N2 .OR. NROW.LT.N2) THEN
         IF (DISPLY) CALL PUTFAT (
     +   'Not a matrix ... Must have m, n > 1')
         READY = .FALSE.
         ABORT = .TRUE.
         GOTO 60
      ENDIF
      IF (NCOL.NE.NROW) THEN
         IF (DISPLY) CALL PUTADV (
     +'Matrix is not square ... No solution for Ax = b')
         READY = .FALSE.
         ABORT = .TRUE.
         GOTO 60
      ENDIF
C
C First copy A into B since matrices are overwritten
C
         DO I = N1, NCOL
            DO J = N1, NROW
               B(J,I) = A(J,I)
            ENDDO
         ENDDO
C
C The LU factorisation
C
      NCOL1 = NCOL
      NRMAX1 = NRMAX
      NROW1 = NROW
      IFAIL = N1
      CALL F07ADF$(NROW1, NCOL1, B, NRMAX1, NWORK, IFAIL)
      IF (IFAIL.EQ.N0) THEN
         READY = .TRUE.
         ABORT = .FALSE.
      ELSE
         IF (DISPLY) THEN
            CALL PUTIFA (IFAIL, NF, 'F07ADF/AXEQB1')
            CALL PUTFAT ('LU factorisation has failed')
         ENDIF
         READY = .FALSE.
         ABORT = .TRUE.
         GOTO 60
      ENDIF
      E_NUMBERS = E_FORMATS()
C
C Branch point to read in a new rhs vector
C
   40 CONTINUE
      IF (.NOT.SUPPLY) THEN
C
C Read in the vector if .NOT.SUPPLY
C
         CALL PUTADV ('Now input the required vector b')
         I = N0
         CLOSE (UNIT = NIN)
         CALL VEC1IN (I, NIN, NRMAX, NROW, T, FNAME, TITLE1,
     +                ABORT, FIXNPT, LABEL)
         CLOSE (UNIT = NIN)
         IF (ABORT) GOTO 60
      ENDIF
      IF (NROW.NE.NROW1) THEN
         ABORT = .TRUE.
         GOTO 60
      ENDIF
C
C Find the solution to Ax = b
C
      IF (NCOL.EQ.NROW) THEN
C
C First copy the vector into C
C
         NRMAX1 = NRMAX
         DO I = N1, NROW1
            C(I,N1) = T(I)
         ENDDO
         IFAIL = N1
         CALL F07AEF$(TRANS, NROW1, N1, B, NRMAX1, NWORK, C, NRMAX1,
     +                IFAIL)
         CALL PUTIFA (IFAIL, NF, 'F07AEF/AXEQB1')
         IF (DISPLY) THEN
            ICOLOR = N15
            CALL TABLE1 (ICOLOR, 'OPEN')
            ICOLOR = N4
            WRITE (LINE,100)
            CALL TABLE1 (ICOLOR, LINE)
            WRITE (LINE,'(1X,A)') CHOP80(TITLE)
            CALL TABLE1 (ICOLOR, LINE)
            WRITE (LINE,200)
            CALL TABLE1 (ICOLOR, LINE)
            WRITE (LINE,'(1X,A)') CHOP80(TITLE1)
            CALL TABLE1 (ICOLOR, LINE)
            WRITE (LINE,300)
            CALL TABLE1 (ICOLOR, LINE)
            ICOLOR = N0
            DO I = N1, NROW1
               IF (E_NUMBERS) THEN
                  WRITE (LINE,400) T(I), C(I,N1)
               ELSE
                  D13(1) = SHOWRJ(T(I))
                  D13(2) = SHOWRJ(C(I,N1))
                  WRITE (LINE,450) D13(1), D13(2)   
               ENDIF 
               CALL TABLE1 (ICOLOR, LINE)
            ENDDO
            CALL TABLE1 (ICOLOR, 'CLOSE')
         ENDIF
         IF (FILE) THEN
            WRITE (NF,'(A)') BLANK
            WRITE (NF,100)
            WRITE (NF,'(1X,A)') TITLE
            WRITE (NF,200)
            WRITE (NF,'(1X,A)') TITLE1
            WRITE (NF,300)
            DO I = N1, NROW1
               IF (E_NUMBERS) THEN
                  WRITE (NF,400) T(I), C(I,N1)
               ELSE
                  D13(1) = SHOWRJ(T(I))
                  D13(2) = SHOWRJ(C(I,N1))
                  WRITE (NF,450) D13(1), D13(2)
               ENDIF  
            ENDDO
         ENDIF
      ENDIF
C
C Branch point for next decisions or return
C
   60 CONTINUE
      IF (.NOT.SUPPLY) THEN
         WRITE (TEXT,500)
         NUMDEC = N1
         ICOLOR = N3
         CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS, TEXT)
         IF (NUMDEC.EQ.N1) THEN
            GOTO 20
         ELSEIF (NUMDEC.EQ.N2) THEN
            IF (READY) THEN
               GOTO 40
            ELSE
               CALL PUTFAT ('First supply a square nonsingular A')
               GOTO 20
            ENDIF
         ENDIF
      ENDIF
  100 FORMAT (' Solution to Ax = b where the square matrix A is:')
  200 FORMAT (' and the vector b is:')
  300 FORMAT (' RHS vector (b)   Solution (x)')
  400 FORMAT (1P,2E15.7)
  450 FORMAT (2(2X,A13))
  500 FORMAT ('Input new matrix-A/vector-b'
     +/'Same A but new RHS vector-b'
     +/'Quit ... Exit Data-input options')
      END
C
C
