C
C
      SUBROUTINE AXEQB2 (IRANK, LWORK, NCMAX, NCOL, NIN, NF, NRMAX,
     +                   NROW,
     +                   A, B, C, S, T, WORK,
     +                   TITLE, TITLE1,
     +                   ABORT, DISPLY, FILE, SUPPLY)
C
C ACTION : Solve Ax = b where A is overdetermined
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          Derived from AXEQB1 6/8/97
C          17/03/1999 Added OBJFUN
C          07/02/2001 added CHOP80
C          16/01/2006 C now dimensioned C(NRMAX,*) as only column1 used 
C          20/05/2007 replaced DGELSS by F08KAF$ 
C          03/11/2021 added E_NUMBERS and E_FORMATS, etc.
C
C ADVICE : If successful then on exit ABORT = .FALSE.,
C
C          METHOD 1: Straight call
C          =========
C          The routine is silent if SUPPLY is .TRUE. and both DISPLY
C          and FILE are .FALSE.
C          Then A is supplied with a column vector T and the solution is
C          returned in C(i,1) if ABORT = .FALSE.
C
C          METHOD 2: interactive
C          =========
C          A and T need not be set at all but on return A and T will be set
C          C(i,1) will be the latest solution and S will be from the SVD
C
C          IRANK = rank of A
C          LWORK = workspace dimension
C                 (>3*min(m,n) + max(2*min(m,n),max(m,n),nrhs)
C          NCMAX = column dimension
C          NCOL = actual no. columns
C          NIN = input unit
C          NF = output unit
C          NRMAX = row dimension
C          NROW = actual no. rows
C          A = matrix supplied
C          B = copy for internal use
C          C = right hand side (column 1 only)
C          S = SVD
C          T = vector then solution (if successful)
C          WORK(LWORK)
C          ABORT = failure ?
C          DISPLY = table to screen ?
C          FILE = output to file ?
C          SUPPLY = provide data ?
C
      IMPLICIT   NONE
      INTEGER    IRANK, LWORK, NCMAX, NCOL, NIN, NF, NRMAX, NROW
      INTEGER    I, ICOLOR, IFAIL, J
      INTEGER    N0, N1, N2, N3, N4, N15
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N15 = 15)
      INTEGER    IX, IY, NUMDEC, NUMOPT
      PARAMETER (IX = 4, IY = 4, NUMOPT = 3)
      INTEGER    NRHS, LDB, LDC
      PARAMETER (NRHS = 1)
      INTEGER    NUMPOS(NUMOPT)
      DOUBLE PRECISION A(NRMAX,NCMAX), B(NRMAX,NCMAX), C(NRMAX,*),
     +                 S(NCMAX), T(NRMAX), WORK(LWORK)
      DOUBLE PRECISION OBJFUN, RCOND, RCOND1, RESID, VALUE, ZERO
      PARAMETER (RCOND1 = - 1.0D+00, ZERO = 0.0D+00)
      CHARACTER (LEN = 13) D13, SHOWRJ, SHOWLJ
      CHARACTER  TITLE*(*), TITLE1*(*)
      CHARACTER  CHOP80*80, FNAME*1024, LINE*100, TEXT(NUMOPT)*100
      CHARACTER (LEN = 12) FORM12, WORD12 
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ABORT, DISPLY, FILE, SUPPLY
      LOGICAL    FIXCOL, FIXROW, LABEL
      PARAMETER (FIXCOL = .FALSE., FIXROW = .FALSE., LABEL = .TRUE.)
      LOGICAL    FIXNPT, READY
      PARAMETER (FIXNPT = .TRUE.)
      EXTERNAL   E_FORMATS, SHOWLJ, SHOWRJ
      EXTERNAL   F08KAF$
      EXTERNAL   MATTIN, TABLE1, PUTIFA, PUTFAT, PUTADV, VEC1IN, LBOX02,
     +           CHOP80, FORM12
      DATA       NUMPOS / NUMOPT*1 /
      ABORT = .TRUE.
C
C Branch point to read in a new A
C
   20 CONTINUE
      IF (.NOT.SUPPLY) THEN
C
C Read in the matrix if .NOT.SUPPLY
C
         CALL PUTADV (
     +  'Now input the required overdetermined matrix A')
         I = N0
         CLOSE (UNIT = NIN)
         CALL MATTIN (I, NCMAX, NCOL, NIN, NRMAX, NROW, A, T, FNAME,
     +                TITLE, ABORT, FIXCOL, FIXROW, LABEL)
         CLOSE (UNIT = NIN)
         IF (ABORT) THEN
            READY = .FALSE.
            GOTO 60
         ELSE
            READY = .TRUE.
         ENDIF
      ENDIF
C
C Check the dimensions
C
      IF (NCOL.LT.N1 .OR. NROW.LT.N2) THEN
         IF (DISPLY) CALL PUTFAT (
     +   'Not a matrix ... Must have m, n > 1')
         READY = .FALSE.
         ABORT = .TRUE.
         GOTO 60
      ENDIF
      IF (NCOL.GT.NROW) THEN
         IF (DISPLY) CALL PUTADV (
     +'Matrix is not overdetermined ... No solution for Ax = b')
         READY = .FALSE.
         ABORT = .TRUE.
         GOTO 60
      ENDIF
C
C Branch point to read in a new rhs vector
C
      E_NUMBERS = E_FORMATS()
   40 CONTINUE
      IF (.NOT.SUPPLY) THEN
C
C Read in the vector if .NOT.SUPPLY
C
         CALL PUTADV ('Now input the required vector b')
         I = N0
         CLOSE (UNIT = NIN)
         CALL VEC1IN (I, NIN, NRMAX, NROW, T, FNAME, TITLE1,
     +                ABORT, FIXNPT, LABEL)
         CLOSE (UNIT = NIN)
         IF (ABORT) GOTO 60
      ENDIF
C
C Find the solution to Ax = b
C
      IF (NCOL.LE.NROW) THEN
C
C First copy A into B since matrices are overwritten
C
         DO I = N1, NCOL
            DO J = N1, NROW
               B(J,I) = A(J,I)
            ENDDO
         ENDDO
C
C Now copy the vector T into C (all nrow items)
C
         DO I = N1, NROW
            C(I,N1) = T(I)
         ENDDO
         LDB = NRMAX
         LDC = NRMAX
         RCOND = RCOND1
         CALL F08KAF$(NROW, NCOL, NRHS, B, LDB, C, LDC, S, RCOND, IRANK,
     +                WORK, LWORK, IFAIL)
         WORD12 = FORM12(IRANK)
C
C The first NCOL items of C are now the solution
C
         CALL PUTIFA (IFAIL, NF, 'DGELSS/AXEQB2')
         IF (DISPLY .OR. FILE) THEN
C
C Calculate the objective function
C
            OBJFUN = ZERO
            DO I = N1, NROW
               VALUE = ZERO
               DO J = N1, NCOL
                  VALUE = VALUE + A(I,J)*C(J,N1)
               ENDDO
               RESID = VALUE - T(I)
               OBJFUN = OBJFUN + RESID*RESID
            ENDDO
         ENDIF
         IF (DISPLY) THEN
            IF (IRANK.NE.NCOL) CALL PUTADV (
     +      'Note that (from SVD) A is of reduced rank')
            ICOLOR = N15
            CALL TABLE1 (ICOLOR, 'OPEN')
            ICOLOR = N4
            WRITE (LINE,100)
            CALL TABLE1 (ICOLOR, LINE)
            WRITE (LINE,'(1X,A)') CHOP80(TITLE)
            CALL TABLE1 (ICOLOR, LINE)
            WRITE (LINE,200)
            CALL TABLE1 (ICOLOR, LINE)
            WRITE (LINE,'(1X,A)') CHOP80(TITLE1)
            CALL TABLE1 (ICOLOR, LINE)
            WRITE (LINE,300)
            CALL TABLE1 (ICOLOR, LINE)
            ICOLOR = N0
            DO I = N1, NCOL
               IF (E_NUMBERS) THEN
                  WRITE (LINE,400) C(I,N1)
               ELSE
                  D13 = SHOWRJ(C(I,N1))
                  WRITE (LINE,450) D13
               ENDIF   
               CALL TABLE1 (ICOLOR, LINE)
            ENDDO
            WRITE (LINE,500) WORD12
            ICOLOR = N4
            CALL TABLE1 (ICOLOR, LINE)
            IF (E_NUMBERS) THEN
               WRITE (LINE,600) OBJFUN
            ELSE
               D13 = SHOWLJ(OBJFUN) 
               WRITE (LINE,650) D13
            ENDIF  
            CALL TABLE1 (ICOLOR, LINE)
            CALL TABLE1 (ICOLOR, 'CLOSE')
         ENDIF
         IF (FILE) THEN
            WRITE (NF,'(A)') BLANK
            WRITE (NF,100)
            WRITE (NF,'(1X,A)') TITLE
            WRITE (NF,200)
            WRITE (NF,'(1X,A)') TITLE1
            WRITE (NF,300)
            DO I = N1, NCOL
               IF (E_NUMBERS) THEN
                  WRITE (NF,400) C(I,N1)
               ELSE
                  D13 = SHOWRJ(C(I,N1))
                  WRITE (NF,450) D13   
               ENDIF  
            ENDDO
            WRITE (NF,500) WORD12
            IF (E_NUMBERS) THEN
               WRITE (NF,600) OBJFUN
            ELSE
               D13 = SHOWLJ(OBJFUN)
               WRITE (NF,650) D13 
            ENDIF  
         ENDIF
      ENDIF
C
C Branch point for next decisions or return
C
   60 CONTINUE
      IF (.NOT.SUPPLY) THEN
         WRITE (TEXT,700)
         NUMDEC = N1
         ICOLOR = N3
         CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS, TEXT)
         IF (NUMDEC.EQ.N1) THEN
            GOTO 20
         ELSEIF (NUMDEC.EQ.N2) THEN
            IF (READY) THEN
               GOTO 40
            ELSE
               CALL PUTFAT ('First supply an overdetermined A')
               GOTO 20
            ENDIF
         ENDIF
      ENDIF
  100 FORMAT (' L2 norm solution to Ax = b: overdetermined A is:')
  200 FORMAT (' and the vector b is:')
  300 FORMAT ('     Solution (x)')
  400 FORMAT (1P,E18.7)
  450 FORMAT (4X,A13)
  500 FORMAT ('The rank of A (from SVD) =',1X,A)
  600 FORMAT ('L2-norm objective function =',1P,E14.7)
  650 FORMAT ('L2-norm objective function =',1X,A13)
  700 FORMAT ('Input new matrix-A/vector-b'
     +/'Same A but new RHS vector-b'
     +/'Quit ... Exit data-input options')
      END
C
C
