C
C
      SUBROUTINE AXEQB3 (INDX, IW, NCMAX, NCOL, NIN, NF, NRMAX, NROW,
     +                   A, B, EL1N, W, X,
     +                   TITLE, TITLE1,
     +                   ABORT, DISPLY, FILE, SUPPLY)
C
C ACTION : Solve Ax = b in the L1-norm where A is overdetermined
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          Derived from AXEQB2 16/3/99
C          07/02/2001 added CHOP80
C          16/01/2006 moved E to allocatable workspace
C          27/09/2012 replaced call to G05CCF$ by call to RSEEDS
C          03/11/2021 added E_NUMBERS and E_FORMATS, etc.
C
C ADVICE : If successful then on exit ABORT = .FALSE.,
C
C          METHOD 1: Straight call
C          =========
C          The routine is silent if SUPPLY is .TRUE. and both DISPLY
C          and FILE are .FALSE.
C          Then A is supplied with a column vector B and the solution is
C          returned in X if ABORT = .FALSE.
C
C          METHOD 2: interactive
C          =========
C          A and B need not be set at all but on return A and B will be set
C          X will be the latest solution
C
C          IW = workspace dimension (m = no. eqns, n = no. unknowns)
C               >3*m + 5n + n^2 + (n+1)(n+2)/2
C          NCMAX = column dimension
C          NCOL = actual no. columns
C          NIN = input unit
C          NF = output unit
C          NRMAX = row dimension
C          NROW = actual no. rows
C          A = matrix supplied
C          B = RHS
C          E = workspace
C          EL1N = L1 norm
C          X = solution (if successful)
C          W(IW)
C          ABORT = failure ?
C          DISPLY = table to screen ?
C          FILE = output to file ?
C          SUPPLY = provide data ?
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    IW, NCMAX, NCOL, NIN, NF, NRMAX, NROW
      INTEGER    INDX(NRMAX)
      DOUBLE PRECISION A(NRMAX,NCMAX), B(NRMAX), EL1N, X(NCMAX), W(IW)
      CHARACTER  TITLE*(*), TITLE1*(*)
      LOGICAL    ABORT, DISPLY, FILE, SUPPLY
C
C Local allocatable workspace
C
      DOUBLE PRECISION, ALLOCATABLE :: E(:,:)
C
C Locals
C
      INTEGER    I, ICOLOR, IFAIL, J
      INTEGER    N0, N1, N2, N3, N4, N15
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N15 = 15)
      INTEGER    ISEND, IX, IY, NUMDEC, NUMOPT
      PARAMETER (ISEND = 0, IX = 4, IY = 4, NUMOPT = 5)
      INTEGER    NUMPOS(NUMOPT)
      INTEGER    IE, IERR, IPRINT, JSEED, K, KTYPE, M, MPL, MXS, N
      DOUBLE PRECISION ZERO, ONE, XMAX, XMIN
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, XMAX = 100.0D+00,
     +           XMIN = - XMAX)
      DOUBLE PRECISION G05DAF$
      CHARACTER (LEN = 13) D13, SHOWLJ, SHOWRJ
      CHARACTER  CHOP80*80, FNAME*1024, LINE*100, TEXT(NUMOPT)*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    FIXCOL, FIXROW, LABEL
      PARAMETER (FIXCOL = .FALSE., FIXROW = .FALSE., LABEL = .TRUE.)
      LOGICAL    FIXNPT, READY
      PARAMETER (FIXNPT = .TRUE.)
      EXTERNAL   E_FORMATS, SHOWLJ, SHOWRJ
      EXTERNAL   E02GBF$, G05DAF$, RSEEDS
      EXTERNAL   MONIT1
      EXTERNAL   MATTIN, TABLE1, PUTIFA, PUTFAT, PUTADV, VEC1IN, LBOX02,
     +           CHOP80
      DATA       NUMPOS / NUMOPT*1 /
      ABORT = .TRUE.
C
C Allocate workspace
C
      IERR = 0
      IF (ALLOCATED(E)) DEALLOCATE(E, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(E(NCMAX,NRMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Branch point to read in a new A
C
   20 CONTINUE
      IF (.NOT.SUPPLY) THEN
C
C Read in the matrix if .NOT.SUPPLY
C
         CALL PUTADV (
     +  'Now input the required overdetermined matrix A')
         I = N0
         CLOSE (UNIT = NIN)
         CALL MATTIN (I, NCMAX, NCOL, NIN, NRMAX, NROW, A, B, FNAME,
     +                TITLE, ABORT, FIXCOL, FIXROW, LABEL)
         CLOSE (UNIT = NIN)
         IF (ABORT) THEN
            READY = .FALSE.
            GOTO 60
         ELSE
            READY = .TRUE.
         ENDIF
      ENDIF
C
C Check the dimensions
C
      IF (NCOL.LT.N1 .OR. NROW.LT.N2) THEN
         IF (DISPLY) CALL PUTFAT (
     +   'Not a matrix ... Must have m, n > 1')
         READY = .FALSE.
         ABORT = .TRUE.
         GOTO 60
      ENDIF
      IF (NCOL.GT.NROW) THEN
         IF (DISPLY) CALL PUTADV (
     +'Matrix is not overdetermined ... No solution for Ax = b')
         READY = .FALSE.
         ABORT = .TRUE.
         GOTO 60
      ENDIF
C
C Branch point to read in a new rhs vector
C
      E_NUMBERS = E_FORMATS()
   40 CONTINUE
      IF (.NOT.SUPPLY) THEN
C
C Read in the vector if .NOT.SUPPLY
C
         CALL PUTADV ('Now input the required vector b')
         I = N0
         CLOSE (UNIT = NIN)
         CALL VEC1IN (I, NIN, NRMAX, NROW, B, FNAME, TITLE1,
     +                ABORT, FIXNPT, LABEL)
         CLOSE (UNIT = NIN)
         IF (ABORT) GOTO 60
      ENDIF
C
C Starting estimates
C
      WRITE (TEXT,100)
      NUMDEC = N2
      ICOLOR = N3
      CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS, TEXT)
      IF (NUMDEC.EQ.1) THEN
         DO I = N1, NCOL
            X(I) = - ONE
         ENDDO
      ELSEIF (NUMDEC.EQ.2) THEN
         DO I = N1, NCOL
            X(I) = ZERO
         ENDDO
      ELSEIF (NUMDEC.EQ.3) THEN
         DO I = N1, NCOL
            X(I) =  ONE
         ENDDO
      ELSEIF (NUMDEC.EQ.4) THEN
         CALL PUTADV ('Now input the required starting vector X')
         I = N0
         CLOSE (UNIT = NIN)
         CALL VEC1IN (I, NIN, NCOL, NCOL, X, FNAME, TITLE1,
     +                ABORT, FIXNPT, LABEL)
         CLOSE (UNIT = NIN)
         IF (ABORT) GOTO 60
      ELSE
         CALL RSEEDS (ISEND, JSEED, KTYPE)
         DO I = N1, NCOL
            X(I) = G05DAF$(XMIN, XMAX)
         ENDDO
      ENDIF
C
C Find the solution to Ax = b
C
      IF (NCOL.LE.NROW) THEN
C
C First copy A into E
C
         DO I = N1, NCOL
            DO J = N1, NROW
               E(I,J) = A(J,I)
            ENDDO
         ENDDO
C
C Call E02GBF
C
         M = NROW
         N = NCOL
         MPL = M
         IE = NCMAX
         MXS = 20*N
         IPRINT = 0
         IFAIL = 1
         CALL E02GBF$(M, N, MPL, E, IE, B, X, MXS, MONIT1, IPRINT, K,
     +                EL1N, INDX, W, IW, IFAIL)
C
C X is now the solution
C
         CALL PUTIFA (IFAIL, NF, 'E02GBF/AXEQB3')
         IF (DISPLY) THEN
            ICOLOR = N15
            CALL TABLE1 (ICOLOR, 'OPEN')
            ICOLOR = N4
            WRITE (LINE,200)
            CALL TABLE1 (ICOLOR, LINE)
            WRITE (LINE,'(1X,A)') CHOP80(TITLE)
            CALL TABLE1 (ICOLOR, LINE)
            WRITE (LINE,300)
            CALL TABLE1 (ICOLOR, LINE)
            WRITE (LINE,'(1X,A)') CHOP80(TITLE1)
            CALL TABLE1 (ICOLOR, LINE)
            WRITE (LINE,400)
            CALL TABLE1 (ICOLOR, LINE)
            ICOLOR = N0
            DO I = N1, NCOL
               IF (E_NUMBERS) THEN
                  WRITE (LINE,500) X(I)
               ELSE
                  D13 = SHOWRJ(X(I))
                  WRITE (LINE,550) D13
               ENDIF  
               CALL TABLE1 (ICOLOR, LINE)
            ENDDO
            IF (E_NUMBERS) THEN
               WRITE (LINE,600) EL1N
            ELSE
               D13 = SHOWLJ(EL1N)
               WRITE (LINE,650) D13
            ENDIF 
            ICOLOR = N4
            CALL TABLE1 (ICOLOR, LINE)
            CALL TABLE1 (ICOLOR, 'CLOSE')
         ENDIF
         IF (FILE) THEN
            WRITE (NF,'(A)') BLANK
            WRITE (NF,200)
            WRITE (NF,'(1X,A)') TITLE
            WRITE (NF,300)
            WRITE (NF,'(1X,A)') TITLE1
            WRITE (NF,400)
            DO I = N1, NCOL
               IF (E_NUMBERS) THEN
                  WRITE (NF,500) X(I)
               ELSE
                  D13 = SHOWRJ(X(I))
                  WRITE (NF,550) D13 
               ENDIF  
            ENDDO
            IF (E_NUMBERS) THEN
               WRITE (NF,600) EL1N
            ELSE
               D13 = SHOWLJ(EL1N)
               WRITE (NF,650) D13
            ENDIF  
         ENDIF
      ENDIF
C
C Branch point for next decisions or return
C
   60 CONTINUE
      IF (.NOT.SUPPLY) THEN
         WRITE (TEXT,700)
         NUMDEC = N1
         ICOLOR = N3
         CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, N3, NUMPOS, TEXT)
         IF (NUMDEC.EQ.N1) THEN
            GOTO 20
         ELSEIF (NUMDEC.EQ.N2) THEN
            IF (READY) THEN
               GOTO 40
            ELSE
               CALL PUTFAT ('First supply an overdetermined A')
               GOTO 20
            ENDIF
         ENDIF
      ENDIF
C
C Deallocate workspace
C
      DEALLOCATE(E, STAT = IERR)
C
C Format statements
C
  100 FORMAT (
     + 'start at all x = -1'
     +/'start at all x = 0'
     +/'start at all x = 1'
     +/'input start values'
     +/'random U(-100,100)')
  200 FORMAT (' L1 norm solution to Ax = b: overdetermined A is:')
  300 FORMAT (' and the vector b is:')
  400 FORMAT ('      Solution (x)')
  500 FORMAT (1P,E18.7)
  550 FORMAT (5X,A13)
  600 FORMAT ('L1-norm objective function =',1P,E14.7)
  650 FORMAT ('L1-norm objective function =',1X,A)
  700 FORMAT ('Input new matrix-A/vector-b'
     +/'Same A but new RHS vector-b'
     +/'Quit ... Exit data-input options')
      END
C
C
CFTN95$OPTIONS (SILENT)
      SUBROUTINE MONIT1 (N, X, NITER, K, EL1IN)
C
C Monitoring subroutine: unused in this version
C
      IMPLICIT NONE
      INTEGER  K, N, NITER
      DOUBLE PRECISION EL1IN, X(N)
      IF (K.LT.0 .OR. NITER.LT.0 .OR.
     +    X(1).LT.0.0D+00 .OR. EL1IN.LT.0.0D+00) RETURN      
      END
C
C

