C
C
      SUBROUTINE AXEQB4 (IRANK, ITER, NCMAX, NCOL, NIN, NF, NRMAX, NROW,
     +                   A, B, RESID, RESMAX, X,
     +                   TITLE, TITLE1,
     +                   ABORT, DISPLY, FILE, SUPPLY)
C
C ACTION : Solve Ax = b in the L_infinity-norm where A is overdetermined
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          Derived from AXEQB3 24/3/99
C          07/02/2001 added CHOP80
C          16/01/2006 moved E to allocatable
C          03/11/2021 defined NDIM = NCOL + 3, MDIM = NROW + 1 to be consistent with CHEB
C                     and also added E_NUMBERS and E_FORMATS, etc.
C
C ADVICE : If successful then on exit ABORT = .FALSE.,
C
C          METHOD 1: Straight call
C          =========
C          The routine is silent if SUPPLY is .TRUE. and both DISPLY
C          and FILE are .FALSE.
C          Then A is supplied with a column vector B and the solution is
C          returned in X if ABORT = .FALSE.
C
C          METHOD 2: interactive
C          =========
C          A and B need not be set at all but on return A and B will be set
C          X will be the latest solution
C
C          IRANK = rank
C          ITER = iterations
C          NCMAX = column dimension
C          NCOL = actual no. columns
C          NIN = input unit
C          NF = output unit
C          NRMAX = row dimension
C          NROW = actual no. rows
C          A = matrix supplied (unchanged)
C          B = RHS (unchanged)
C          E = A-transpose (gets overwritten)
C          RESID = residuals
C          RESMAX = L_infinity norm (largest residual)
C          X = solution (if successful)
C          ABORT = failure ?
C          DISPLY = table to screen ?
C          FILE = output to file ?
C          SUPPLY = provide data ?
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    IRANK, ITER, NCMAX, NCOL, NIN, NF, NRMAX, NROW
      DOUBLE PRECISION A(NRMAX,NCMAX), B(NRMAX), RESID(NRMAX), RESMAX,
     +                 X(NCMAX)
      CHARACTER  TITLE*(*), TITLE1*(*)
      LOGICAL    ABORT, DISPLY, FILE, SUPPLY
C
C Local allocatable arrays
C
      DOUBLE PRECISION, ALLOCATABLE :: E(:,:)
C
C Locals
C
      INTEGER    I, ICOLOR, IERR, IFAIL, J, M, MDIM, N, NDIM
      INTEGER    N0, N1, N2, N3, N4, N15
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N15 = 15)
      INTEGER    IX, IY, NUMDEC, NUMOPT
      PARAMETER (IX = 4, IY = 4, NUMOPT = 5)
      INTEGER    NUMPOS(NUMOPT)
      DOUBLE PRECISION RELERR, TOL
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER (LEN = 13) D13, SHOWLJ, SHOWRJ
      CHARACTER  CHOP80*80, FNAME*1024, LINE*100, TEXT(NUMOPT)*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    FIXCOL, FIXROW, LABEL
      PARAMETER (FIXCOL = .FALSE., FIXROW = .FALSE., LABEL = .TRUE.)
      LOGICAL    FIXNPT, READY
      PARAMETER (FIXNPT = .TRUE.)
      EXTERNAL   E_FORMATS, SHOWLJ, SHOWRJ
      EXTERNAL   E02GCF$
      EXTERNAL   MATTIN, TABLE1, PUTIFA, PUTFAT, PUTADV, VEC1IN, LBOX02,
     +           CHOP80
      DATA       NUMPOS / NUMOPT*1 /
      ABORT = .TRUE.

C
C Branch point to read in a new A
C
   20 CONTINUE
      IF (.NOT.SUPPLY) THEN
C
C Read in the matrix if .NOT.SUPPLY
C
         CALL PUTADV (
     +  'Now input the required overdetermined matrix A')
         I = N0
         CLOSE (UNIT = NIN)
         CALL MATTIN (I, NCMAX, NCOL, NIN, NRMAX, NROW, A, B, FNAME,
     +                TITLE, ABORT, FIXCOL, FIXROW, LABEL)
         CLOSE (UNIT = NIN)
         IF (ABORT) THEN
            READY = .FALSE.
            GOTO 60
         ELSE
            READY = .TRUE.
         ENDIF
      ENDIF
C
C Check the dimensions
C
      IF (NCOL.LT.N1 .OR. NROW.LT.N2) THEN
         IF (DISPLY) CALL PUTFAT (
     +   'Not a matrix ... Must have m, n > 1')
         READY = .FALSE.
         ABORT = .TRUE.
         GOTO 60
      ENDIF
      IF (NCOL.GT.NROW) THEN
         IF (DISPLY) CALL PUTADV (
     +'Matrix is not overdetermined ... No solution for Ax = b')
         READY = .FALSE.
         ABORT = .TRUE.
         GOTO 60
      ENDIF
C
C Branch point to read in a new rhs vector
C
      E_NUMBERS = E_FORMATS()
   40 CONTINUE
      
      IF (.NOT.SUPPLY) THEN
C
C Read in the vector if .NOT.SUPPLY
C
         CALL PUTADV ('Now input the required vector b')
         I = N0
         CLOSE (UNIT = NIN)
         CALL VEC1IN (I, NIN, NRMAX, NROW, B, FNAME, TITLE1,
     +                ABORT, FIXNPT, LABEL)
         CLOSE (UNIT = NIN)
         IF (ABORT) GOTO 60
      ENDIF
C
C Find the solution to Ax = b
C
      IF (NCOL.LE.NROW) THEN
C
C Allocate workspace
C
      IERR = 0
      IF (ALLOCATED(E)) DEALLOCATE(E, STAT = IERR)
      IF (IERR.NE.0) RETURN
      NDIM = NCOL + 3
      MDIM = NROW + 1  
      ALLOCATE(E(NDIM,MDIM), STAT = IERR)
      IF (IERR.NE.0) RETURN  
C
C First copy A into E and B into RESID
C
         DO I = N1, NCOL
            DO J = N1, NROW
               E(I,J) = A(J,I)
            ENDDO
         ENDDO
         DO I = 1, NROW
            RESID(I) = B(I)
         ENDDO
C
C Call E02GCF
C
         RELERR = ZERO
         TOL = ZERO
         M = NROW
         N = NCOL
         IFAIL = 1
         CALL E02GCF$(M, N, MDIM, NDIM, E, RESID, TOL, RELERR, X,
     +                RESMAX, IRANK, ITER, IFAIL)
C
C X is now the solution
C
         CALL PUTIFA (IFAIL, NF, 'E02GCF/AXEQB4')
         IF (DISPLY) THEN
            ICOLOR = N15
            CALL TABLE1 (ICOLOR, 'OPEN')
            ICOLOR = N4
            WRITE (LINE,100)
            CALL TABLE1 (ICOLOR, LINE)
            WRITE (LINE,'(1X,A)') CHOP80(TITLE)
            CALL TABLE1 (ICOLOR, LINE)
            WRITE (LINE,200)
            CALL TABLE1 (ICOLOR, LINE)
            WRITE (LINE,'(1X,A)') CHOP80(TITLE1)
            CALL TABLE1 (ICOLOR, LINE)
            WRITE (LINE,300)
            CALL TABLE1 (ICOLOR, LINE)
            ICOLOR = N0
            DO I = N1, NCOL
               IF (E_NUMBERS) THEN
                  WRITE (LINE,400) X(I)
               ELSE
                  D13 = SHOWRJ(X(I))
                  WRITE (LINE,450) D13  
               ENDIF  
               CALL TABLE1 (ICOLOR, LINE)
            ENDDO
            IF (E_NUMBERS) THEN
               WRITE (LINE,500) RESMAX
            ELSE
               D13 = SHOWLJ(RESMAX)
               WRITE (LINE,550) D13
            ENDIF 
            ICOLOR = N4
            CALL TABLE1 (ICOLOR, LINE)
            CALL TABLE1 (ICOLOR, 'CLOSE')
         ENDIF
         IF (FILE) THEN
            WRITE (NF,'(A)') BLANK
            WRITE (NF,100)
            WRITE (NF,'(1X,A)') TITLE
            WRITE (NF,200)
            WRITE (NF,'(1X,A)') TITLE1
            WRITE (NF,300)
            DO I = N1, NCOL
               IF (E_NUMBERS) THEN
                  WRITE (NF,400) X(I)
               ELSE
                  D13 = SHOWRJ(X(I)) 
                  WRITE (NF,450) D13 
               ENDIF  
            ENDDO
            IF (E_NUMBERS) THEN
               WRITE (NF,500) RESMAX
            ELSE
               D13 = SHOWLJ(RESMAX)
               WRITE (NF,550) D13  
            ENDIF 
         ENDIF
      ENDIF
C
C Branch point for next decisions or return
C
   60 CONTINUE
      IF (.NOT.SUPPLY) THEN
         WRITE (TEXT,600)
         NUMDEC = N1
         ICOLOR = N3
         CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, N3, NUMPOS, TEXT)
         IF (NUMDEC.EQ.N1) THEN
            GOTO 20
         ELSEIF (NUMDEC.EQ.N2) THEN
            IF (READY) THEN
               GOTO 40
            ELSE
               CALL PUTFAT ('First supply an overdetermined A')
               GOTO 20
            ENDIF
         ENDIF
      ENDIF
C
C Deallocate workspace
C
      DEALLOCATE(E, STAT = IERR)
C
C Format statements
C
  100 FORMAT (
     +' L_infinity norm solution to Ax = b; overdetermined A is:')
  200 FORMAT (' and the vector b is:')
  300 FORMAT ('      Solution (x)')  
  400 FORMAT (1P,E18.7)
  450 FORMAT (5X,A13)
  500 FORMAT ('L_infinity norm objective function =',1P,E14.7)
  550 FORMAT ('L_infinity norm objective function =',1X,A)
  600 FORMAT ('Input new matrix-A/vector-b'
     +/'Same A but new RHS vector-b'
     +/'Quit ... Exit data-input options')
      END
C
C
