C
C
      SUBROUTINE BDTEST (ICOUNT, IX, NN, NMAX, NOUT, NTOP,
     +                   E, EBINS, O, OBINS, PP, X,
     +                   TITLE,
     +                   SUPPLY)
C
C ACTION : Chi-square tests for binomial distribution on X values
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          09/04/2000 Extensive editing to calculate confidence limits
C          24/09/2007 derived from TESTBN of program BINOMIAL
C          21/07/2022 added E_BINS and E_FORMATS, etc.
C
C Note: if SUPPLY = .TRUE. then NMAX = sample size
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NN, NOUT, NMAX, NTOP
      INTEGER,             INTENT (OUT)   :: ICOUNT(0:NTOP), IX(NMAX)
      DOUBLE PRECISION,    INTENT (IN)    :: PP
      DOUBLE PRECISION,    INTENT (INOUT) :: X(NMAX)
      DOUBLE PRECISION,    INTENT (OUT)   :: E(NTOP + 1),
     +                                       EBINS(NTOP + 1),
     +                                       O(NTOP + 1),
     +                                       OBINS(NTOP + 1) 
      CHARACTER (LEN = *), INTENT (INOUT) :: TITLE
      LOGICAL,             INTENT (IN)    :: SUPPLY
C 
C Locals
C      
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N10, N20
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           N6 = 6, N7 = 7, N10 = 10, N20 = 20)
      INTEGER    I, IFAIL, J, K, KX, L, N, NBINS, NDOF, NMIN
      INTEGER    NDEC, NPLUS1, NUM
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NSTART, NUMOPT, NUMTXT
      PARAMETER (ICOLOR = 9)
      INTEGER    NUMBLD(20), NUMPOS(3)
      DOUBLE PRECISION ZERO, HALF, ONE, PMIN, PMAX
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00,
     +           PMIN = 0.001D+00, PMAX = ONE - PMIN)
      DOUBLE PRECISION CLEVEL
      PARAMETER (CLEVEL = 0.95D+00)
      DOUBLE PRECISION P, PFIX, PHAT, Q, QFIX, QHAT, RN
      DOUBLE PRECISION XBAR, XSIG, XVAR, YBAR, YSIG, YVAR
      DOUBLE PRECISION RNUM
      DOUBLE PRECISION CHISQ, PGCHI, PH95, PL95, P95, P99
      DOUBLE PRECISION PDF_BINOMIAL
      CHARACTER (LEN = 13) D13(9), SHOWLJ
      CHARACTER (LEN = 12) I12(2), FORM12
      CHARACTER  FNAME1*1024, RESUL*22, WORD8*8, WORD15*15
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER  CTEMP(15)*100
      CHARACTER  TITLES(7)*45
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ABORT, FIXNPT, LABEL, USEHAT
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   PDF_BINOMIAL
      EXTERNAL   PUTADV, VEC1IN, NXSORT, NXXBAR, EOBINS, CHISQD, TABLE1,
     +           LBOX01, PATCH1, GETJGE, PUTIFA, GETDM1, TRIML1
      EXTERNAL   OEBINS
      EXTERNAL   G07AAF$
      INTRINSIC  DBLE, NINT, SQRT
      DATA NUMBLD / 20*0 /
      DATA NUMPOS / 3*1 /
      E_NUMBERS = E_FORMATS()
C
C Copy NN and PP into N and P so NN and PP are unchanged
C      
      N = NN
      P = PP
C
C Adjust N and p if out of range then define Q
C      
      IF (N.LT.N1 .OR. N.GE.NTOP) N = N10  
      IF (P.LT.PMIN .OR. P.GT.PMAX) P = HALF  
      Q = ONE - P 
C
C Save fixed values
C      
      PFIX = P
      QFIX = Q      
C
C Define L = NMAX or read in data
C
      IF (SUPPLY) THEN
C
C Set L = NMAX = number of observations
C        
         L = NMAX
      ELSE
C
C Read in data, check, transform to integers then put into order
C        
         I = N3
         J = N3
         K = NMAX
         FIXNPT = .FALSE.
         LABEL = .TRUE.
         CALL VEC1IN (I, J, K, L,
     +                X,
     +                FNAME1, TITLE,
     +                ABORT, FIXNPT, LABEL)
         CLOSE (UNIT = J)
         IF (ABORT) RETURN
      ENDIF        
      IF (L.LT.N10) THEN
         CALL PUTADV ('Sample size to small for a chi-square test')
         RETURN
      ELSEIF (L.LT.N20) THEN
         CALL PUTADV ('Sample size is rather small for a chi-sq. test')
      ENDIF
C
C Check N supplied
C     
      CALL GETJGE (N, N1,
     +'binomial parameter N to use for this test (N > 0)')
      IF (N.GT.NTOP) THEN
         CALL PUTADV ('Current N value too large for this option')
         RETURN
      ENDIF
C
C Check that data are consistent 
C      
      RN = DBLE(N)
      NUM = L
      RNUM = DBLE(NUM)
      DO I = N1, NUM
        IF (X(I).LT.ZERO .OR. X(I).GT.RN) THEN
           WRITE (LINE,100) I
           CALL PUTADV (LINE)
           RETURN
        ENDIF
      ENDDO
C
C Put the data into increasing order
C      
      CALL NXSORT (NUM,
     +             X)
      KX = N0
      DO I = N1, NUM
         IX(I) = NINT(X(I))
         X(I) = DBLE(IX(I))
         KX = KX + IX(I)
      ENDDO
      DO I = N0, N
         ICOUNT(I) = N0
      ENDDO
      DO I = N1, NUM
         J = IX(I)
         ICOUNT(J) = ICOUNT(J) + N1
      ENDDO
C
C Calculate sample mean and standard deviation
C
      CALL NXXBAR (NUM,
     +             X, XBAR, XVAR)
      PHAT = XBAR/RN
      QHAT = ONE - PHAT
      IF (PHAT.LT.ZERO) PHAT = ZERO
      IF (PHAT.GT.ONE) PHAT = ONE
      IF (QHAT.LT.ZERO) QHAT = ZERO
      IF (QHAT.GT.ONE) QHAT = ONE
      XSIG = SQRT(XVAR)
      YBAR = PFIX*RN
      YVAR = PFIX*QFIX*RN
      YSIG = SQRT(YVAR)
      IFAIL = 0
      CALL G07AAF$(N*NUM, KX, CLEVEL, PL95, PH95, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G07AAF/TESTBN')
C
C Decide whether to use PHAT or P from option 1
C
      WRITE (WORD8,'(I8)') N
      CALL TRIML1 (WORD8)
      WRITE (TEXT,200) WORD8, PFIX, PHAT 
      IXL = N4
      IYL = N4
      LSHADE = N1
      NUMBLD(1) = N1
      NDEC = N2
      NUMOPT = N3
      NSTART = N3
      NUMTXT = N5
      CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, NUMOPT,
     +             NUMPOS, NSTART, NUMTXT,
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      NUMBLD(1) = N0
      IF (NDEC.EQ.N1) THEN
         USEHAT = .FALSE.
         P = PFIX
         Q = QFIX
      ELSEIF (NDEC.EQ.N2) THEN
         USEHAT = .TRUE.
         P = PHAT
         Q = QHAT
      ELSE   
         USEHAT = .FALSE. 
         CALL GETDM1 (PMIN, P, PMAX,
     +'binomial p value to be fixed for this test (0 < p < 1)')
         Q = ONE - P   
         PFIX = P
         QFIX = Q   
      ENDIF
C
C Minimal bin size (by NMIN < 0) then prepare data for chi-square test
C
      NPLUS1 = N + N1
      DO I = N1, NPLUS1
         J = I - N1
         E(I) = RNUM*PDF_BINOMIAL (J, N, NOUT,
     +                             P)
         O(I) = DBLE(ICOUNT(J))
      ENDDO
      NMIN = - N1
      CALL EOBINS (NPLUS1, NBINS, NMIN, 
     +             E, EBINS, O, OBINS)
C
C Fix degrees of freedom
C
      NDOF = NBINS - N1
      IF (USEHAT) NDOF = NDOF - N1
      IF (NDOF.LE.N0) THEN
         IF (E_NUMBERS) THEN
            WRITE (TEXT,300) PHAT, PL95, PH95, XBAR, XVAR
            WRITE (NOUT,300) PHAT, PL95, PH95, XBAR, XVAR
         ELSE
            D13(1) = SHOWLJ(XBAR)
            D13(2) = SHOWLJ(XVAR)  
            WRITE (TEXT,350) PHAT, PL95, PH95, D13(1), D13(2)
            WRITE (NOUT,350) PHAT, PL95, PH95, D13(1), D13(2)
         ENDIF  
         IXL = N4
         IYL = N4
         LSHADE = N0
         NUMTXT = N7
         NUMBLD(NUMTXT) = N1
         CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMTXT,
     +                TEXT,
     +                BORDER)
         RETURN
      ENDIF
C
C Chi-square test
C
      CALL CHISQD (NBINS, NDOF, NOUT,
     +             CHISQ, EBINS, OBINS, PGCHI, P95, P99)
      IF (PGCHI.GE.0.05D+00) THEN
         RESUL = 'Consider accepting H0'
      ELSEIF (PGCHI.GE.0.01D+00) THEN
         RESUL = 'Reject H0 at 5% level'
      ELSE
         RESUL = 'Reject H0 at 1% level'
      ENDIF
C
C Output results
C
      WRITE (CTEMP,400) WORD8, TITLE
      WRITE (NOUT,400) WORD8, TITLE
      DO I = N1, N4
         TEXT(I) = CTEMP(I + N1)
      ENDDO
      IF (USEHAT) THEN
         WRITE (TEXT(5),500)
         WRITE (NOUT,500)
      ELSE
         WRITE (TEXT(5),600) PFIX
         WRITE (NOUT,600) PFIX
      ENDIF
      IF (E_NUMBERS) THEN 
         WRITE (CTEMP,700) PHAT, PL95, PH95, XBAR, XVAR, XSIG, YBAR,
     +                     YVAR, YSIG, NBINS, NDOF, CHISQ, PGCHI, RESUL,
     +                     P95, P99
         WRITE (NOUT,700) PHAT, PL95, PH95, XBAR, XVAR, XSIG, YBAR,
     +                    YVAR, YSIG, NBINS, NDOF, CHISQ, PGCHI, RESUL,
     +                    P95, P99
      ELSE
         D13(1) = SHOWLJ(XBAR)
         D13(2) = SHOWLJ(XVAR)
         D13(3) = SHOWLJ(XSIG)
         D13(4) = SHOWLJ(YBAR)
         D13(5) = SHOWLJ(YVAR)
         D13(6) = SHOWLJ(YSIG)
         D13(7) = SHOWLJ(CHISQ)
         D13(8) = SHOWLJ(P95)
         D13(9) = SHOWLJ(P99)
         I12(1) = FORM12(NBINS)
         I12(2) = FORM12(NDOF)
         WRITE (CTEMP,750) PHAT, PL95, PH95, D13(1), D13(2), D13(3),
     +                     D13(4), D13(5), D13(6), I12(1), I12(2),
     +                     D13(7), PGCHI, RESUL, D13(8), D13(9)
         WRITE (NOUT,750) PHAT, PL95, PH95, D13(1), D13(2), D13(3),
     +                    D13(4), D13(5), D13(6), I12(1), I12(2),
     +                    D13(7), PGCHI, RESUL, D13(8), D13(9)
      ENDIF   
      DO I = N6, N20
         TEXT(I) = CTEMP(I - N5)
      ENDDO
      J = 15
      CALL TABLE1 (J, 'OPEN')
      DO I = N1, N20
         IF (I.EQ.N1) THEN
            J = N4
         ELSEIF (I.EQ.N4) THEN
           J = N1
         ELSE     
            J = N0
         ENDIF   
         CALL TABLE1 (J, TEXT(I)) 
      ENDDO
      CALL TABLE1 (J, 'CLOSE')   
C
C Tables and graphs output if required
C
      I12(1) = FORM12(N)
      D13(1) = SHOWLJ(P)
      WRITE (WORD15,800) TRIM(I12(1)), TRIM(D13(1))
      CALL TRIML1 (WORD15)
      WRITE (TITLES,900) WORD15, WORD15
      CALL OEBINS (IX, NPLUS1, NBINS, NOUT, NUM,
     +             E, EBINS, O, OBINS,
     +             TITLES)
C
C Format statements
C      
  100 FORMAT ('X < 0 or X > N ... Check value number',I4)
  200 FORMAT (
     + 'Choose which p to use to test for:'
     +/'H0: X is distributed b(N,p), N =',1X,A
     +/'Use current value p-fixed =',F7.4
     +/'Use sample estimate p-hat =',F7.4
     +/'Input/use a new p-fixed value')
  300 FORMAT (
     +/'Sample estimate for p (p-hat) =',F10.4
     +/'Lower 95% confidence limit    =',F10.4
     +/'Upper 95% confidence limit    =',F10.4
     +/'Mean of x values supplied     =',1P,E10.3
     +/'Variance of x values supplied =',1P,E10.3
     +/'Sample size too small for meaningful chi-square test')
  350 FORMAT (
     +/'Sample estimate for p (p-hat) =',F7.4
     +/'Lower 95% confidence limit    =',F7.4
     +/'Upper 95% confidence limit    =',F7.4
     +/'Mean of x values supplied     =',1X,A
     +/'Variance of x values supplied =',1X,A
     +/'Sample size too small for meaningful chi-square test')     
  400 FORMAT (
     +/'Chi-square test for b(N,p) with N =',1X,A
     +/
     +/'H0: binomial distribution for the data:'
     +/A)
  500 FORMAT ('Sample estimate p-hat used in chi-square test')
  600 FORMAT ('p-fixed =',F7.4,1X,'used in chi-square test')
  700 FORMAT (
     + 'Sample estimate for p (p-hat)    =',F7.4
     +/'Lower 95% confidence limit       =',F7.4
     +/'Upper 95% confidence limit       =',F7.4
     +/'Mean of x-values                 =',1P,E10.3
     +/'Variance of x-values             =',   E10.3
     +/'Standard deviation of x-values   =',   E10.3
     +/'Mean predicted using p-fixed     =',   E10.3
     +/'Variance predicted using p-fixed =',   E10.3
     +/'Standard deviation using p-fixed =',   E10.3
     +/'Number of partitions (bins) used =',I6
     +/'Number of degrees of freedom     =',I6
     +/'Chi-square test statistic C      =',1P,E10.3
     +/'p = P(chi-square >= C)           =',0P,F7.4,5X,A21
     +/'Upper tail 5% critical point     =',1P,E10.3
     +/'Upper tail 1% critical point     =',   E10.3)
  750 FORMAT (
     + 'Sample estimate for p (p-hat)    =',F7.4
     +/'Lower 95% confidence limit       =',F7.4
     +/'Upper 95% confidence limit       =',F7.4
     +/'Mean of x-values                 =',1X,A
     +/'Variance of x-values             =',1X,A
     +/'Standard deviation of x-values   =',1X,A
     +/'Mean predicted using p-fixed     =',1X,A
     +/'Variance predicted using p-fixed =',1X,A
     +/'Standard deviation using p-fixed =',1X,A
     +/'Number of partitions (bins) used =',1X,A
     +/'Number of degrees of freedom     =',1X,A
     +/'Chi-square test statistic C      =',1X,A
     +/'p = P(chi-square >= C)           =',0P,F7.4,5X,A21
     +/'Upper tail 5% critical point     =',1X,A
     +/'Upper tail 1% critical point     =',1X,A)   
  800 FORMAT (A,',',A,')')   
  900 FORMAT (
     + 'Chi-sq. bins assuming b(',A     
     +/'Bin number'
     +/'O/E Frequencies'
     +/' '
     +/'Sample and pmf assuming b(',A
     +/'X-values'
     +/'O/E Frequencies')
      END
C
C