C
C
      SUBROUTINE BINOMP (K)
C
C ACTION : Calculate binomial probabilities using incomplete beta function
C NAG    : G01BDF
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          26/4/97 WIN32 version
C          08/08/99 Edited and transferred from RSTEST to SIMFIT.DLL
C          27/09/2002 replaced patch1 by table1
C          Date of this version 27/09/2002
C
C
      INTEGER    K
      INTEGER    I, ICOUNT, IFAIL, M, N, NADDM
      INTEGER    ICOLOR, NUMTXT
      INTEGER    N0, N1, N5, N7, N11
      PARAMETER (N0 = 0, N1 = 1, N5 = 5, N7 = 7, N11 = 11)
      DOUBLE PRECISION PEQK, PGTK, PLEK
      DOUBLE PRECISION P(5), PBIG, PSMALL, P2TAIL
      DOUBLE PRECISION ZERO, HALF, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00)
      CHARACTER (LEN = 100) TEXT(30), TEXT7(7)
      CHARACTER (LEN = 23 ) SYMBOL
      CHARACTER (LEN = 8  ) AM, AN, AMPN
      CHARACTER (LEN = 1  ) BLANK
      PARAMETER (BLANK = ' ')
      EXTERNAL   GETJGE, PUTWAR, PUTIFA, PLEVEL, MIDDLE, TABLE1, TRIML1
      EXTERNAL   G01BJF$
      INTRINSIC  MIN
      SAVE       ICOUNT, M, N
      DATA       ICOUNT, M, N / 0, 5, 5 /
      CALL GETJGE (M, N0, 'Number of positive signs (m >= 0))')
      CALL GETJGE (N, N0, 'Number of negative signs (n >= 0))')
      NADDM = M + N
      WRITE (AM,'(I8)') M
      WRITE (AN,'(I8)') N
      WRITE (AMPN,'(I8)') NADDM
      CALL TRIML1 (AM)
      CALL TRIML1 (AN)
      CALL TRIML1 (AMPN)
      IF (NADDM.LE.N5) CALL PUTWAR (
     +   'At least 6 signs needed for a meaningful sign test')
      ICOUNT = ICOUNT + N1
      WRITE (TEXT7,100) ICOUNT, HALF, AM, AN, AMPN
      TEXT7(3) = BLANK
      WRITE (K,'(A)') BLANK
      WRITE (K,'(A)') '***'
      WRITE (K,100) ICOUNT, HALF, AM, AN, AMPN
      IFAIL = N1
      IF (M.EQ.N0) THEN
         CALL G01BJF$(NADDM, HALF, M, PLEK, PGTK, PEQK, IFAIL)
         CALL PUTIFA (IFAIL, K, 'G01BJF/BINOMP')
         PSMALL = PEQK
         PBIG = PGTK
         P2TAIL = TWO*PSMALL
         CALL MIDDLE (ZERO, PSMALL, ONE)
         CALL MIDDLE (ZERO, PBIG, ONE)
         CALL MIDDLE (ZERO, P2TAIL, ONE)
         CALL PLEVEL (P2TAIL, SYMBOL)
         WRITE (TEXT,200) PSMALL, PBIG, PSMALL, PBIG,
     +                    P2TAIL, SYMBOL
         WRITE (K,200) PSMALL, PBIG, PSMALL, PBIG,
     +                 P2TAIL, SYMBOL
         NUMTXT = N5
      ELSEIF (N.EQ.N0) THEN
         CALL G01BJF$(NADDM, HALF, N, PLEK, PGTK, PEQK, IFAIL)
         CALL PUTIFA (IFAIL, K, 'G01BJF/BINOMP')
         PSMALL = PEQK
         PBIG = PGTK
         P2TAIL = TWO*PSMALL
         CALL MIDDLE (ZERO, PSMALL, ONE)
         CALL MIDDLE (ZERO, PBIG, ONE)
         CALL MIDDLE (ZERO, P2TAIL, ONE)
         CALL PLEVEL (P2TAIL, SYMBOL)
         WRITE (TEXT,300) PSMALL, PBIG, PSMALL, PBIG,
     +                    P2TAIL, SYMBOL
         WRITE (K,300) PSMALL, PBIG, PSMALL, PBIG,
     +                 P2TAIL, SYMBOL
         NUMTXT = N5
      ELSE
         CALL G01BJF$(NADDM, HALF, M, PLEK, PGTK, PEQK, IFAIL)
         CALL PUTIFA (IFAIL, K, 'G01BJF/BINOMP')
         P(1) = PLEK - PEQK
         P(2) = PGTK
         P(3) = PEQK
         P(4) = PEQK + PGTK
         P(5) = PLEK
         DO I = N1, N5
            CALL MIDDLE (ZERO, P(I), ONE)
         ENDDO
         P2TAIL = TWO*MIN(P(4), P(5))
         CALL MIDDLE (ZERO, P2TAIL, ONE)
         CALL PLEVEL (P2TAIL, SYMBOL)
         WRITE (TEXT,400) P(3), P(2), P(1), P(4), P(5),
     +                    P(3), P(2), P(1), P(4), P(5),
     +                    P2TAIL, SYMBOL
         WRITE (K,400) P(3), P(2), P(1), P(4), P(5),
     +                 P(3), P(2), P(1), P(4), P(5),
     +                 P2TAIL, SYMBOL
         NUMTXT = N11
      ENDIF
      NUMTXT = NUMTXT + N7
      DO I = NUMTXT, N7 + N1, - N1
         TEXT(I) = TEXT(I - N7)
      ENDDO
      DO I = N1, N7
         TEXT(I) = TEXT7(I)
      ENDDO   
      ICOLOR = 15
      CALL TABLE1 (ICOLOR, 'OPEN')
      DO I = 1, NUMTXT
         IF (I.EQ.2) THEN
            ICOLOR = 4
         ELSE
            ICOLOR = 0
         ENDIF
         CALL TABLE1 (ICOLOR, TEXT(I))
      ENDDO
      CALL TABLE1 (ICOLOR, 'CLOSE')
C
C Format statements
C      
  100 FORMAT (/1X,'Sign test analysis',I4
     +        /1X,'----------------------'
     +       /1X,'H0: Population p-value  =',F9.6
     +       /1X,'m (number of +ve signs) =',1X,A
     +       /1X,'n (number of -ve signs) =',1X,A
     +       /1X,'m + n                   =',1X,A)
  200 FORMAT (1X,'P( +ve equals m )       =',F9.6
     +       /1X,'P( +ve > m )            =',F9.6
     +       /1X,'P( -ve equals n )       =',F9.6
     +       /1X,'P( -ve < n )            =',F9.6
     +       /1X,'2-tail probability      =',F9.6,4X,A/)
  300 FORMAT (1X,'P( +ve equals m )       =',F9.6
     +       /1X,'P( +ve < m )            =',F9.6
     +       /1X,'P( -ve equals n )       =',F9.6
     +       /1X,'P( -ve > n )            =',F9.6
     +       /1X,'2-tail probability      =',F9.6,4X,A/)
  400 FORMAT (1X,'P( +ve equals m )       =',F9.6
     +       /1X,'P( +ve >  m )           =',F9.6
     +       /1X,'P( +ve <  m )           =',F9.6
     +       /1X,'P( +ve >= m )           =',F9.6
     +       /1X,'P( +ve =< m )           =',F9.6
     +       /1X,'P( -ve equals  n )      =',F9.6
     +       /1X,'P( -ve <  n )           =',F9.6
     +       /1X,'P( -ve >  n )           =',F9.6
     +       /1X,'P( -ve =< n )           =',F9.6
     +       /1X,'P( -ve >= n )           =',F9.6
     +       /1X,'2-tail probability      =',F9.6,4X,A/)
      END
C
C
