C
C
      SUBROUTINE BINOMT (NOUT)
C
C ACTION : Calculate binomial probabilities using incomplete beta function
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          Derived from BINOMP 04/01/2003
C
C
      INTEGER    NOUT
      INTEGER    I, ICOUNT, IFAIL, K, L, N
      INTEGER    ICOLOR
      INTEGER    N0, N1, N5
      PARAMETER (N0 = 0, N1 = 1, N5 = 5)
      DOUBLE PRECISION PEQK, PGTK, PLEK
      DOUBLE PRECISION PEQL, PGTL, PLEL
      DOUBLE PRECISION BINOMP, P(5), PBIG, PSMALL, P2TAIL, Q(5)
      DOUBLE PRECISION CLEVEL, PHAT, PL, PU
      DOUBLE PRECISION ZERO, HALF, ONE
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00)
      DOUBLE PRECISION EPSI, PNT95
      PARAMETER (EPSI = 1.0D-06, PNT95 = 0.95D+00)
      CHARACTER (LEN = 12) I12(3), FORM12 
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      CHARACTER  SYMBOL*23
      CHARACTER  TEXT(30)*100
      EXTERNAL   FORM12 
      EXTERNAL   GETJGE, PUTIFA, PLEVEL, MIDDLE, TABLE1, GETDM1
      EXTERNAL   G01BJF$, G07AAF$
      INTRINSIC  MAX, MIN
      SAVE       ICOUNT, K, N, BINOMP
      DATA       ICOUNT, K, N, BINOMP / 0, 5, 10, HALF /
      CALL GETJGE (K, N0, 'Number of successes (K >= 0))')
      IFAIL = MAX(N1,K)
      CALL GETJGE (N, IFAIL, 'Number of Bernuolli trials (N >= K))')
      L = N - K
      PSMALL = EPSI
      PBIG = ONE - EPSI
      CALL GETDM1 (PSMALL, BINOMP, PBIG, 'Theoretical binomial p value')
      IFAIL = N1
      CALL G01BJF$(N, BINOMP, K, PLEK, PGTK, PEQK, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01BJF/BINOMT')
      IF (IFAIL.EQ.N0) THEN
         P(1) = PGTK
         P(2) = PLEK - PEQK
         P(3) = PEQK
         P(4) = PEQK + PGTK
         P(5) = PLEK
         DO I = N1, N5
            CALL MIDDLE (ZERO, P(I), ONE)
         ENDDO
         CALL G01BJF$(N, BINOMP, L, PLEL, PGTL, PEQL, IFAIL)
         CALL PUTIFA (IFAIL, NOUT, 'G01BJF/BINOMT')
         IF (IFAIL.EQ.N0) THEN
            CLEVEL = PNT95
            CALL G07AAF$(N, K, CLEVEL, PL, PU, IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G07AAF/BINOMT')
            IF (IFAIL.EQ.N0) THEN
               ICOUNT = ICOUNT + N1
               PHAT = DBLE(K)/DBLE(N)
               Q(1) = PGTL
               Q(2) = PLEL - PEQL
               Q(3) = PEQL
               Q(4) = PEQL + PGTL
               Q(5) = PLEL
               DO I = N1, N5
                  CALL MIDDLE (ZERO, Q(I), ONE)
               ENDDO
               P2TAIL = MIN(P(4),P(5)) + MIN(Q(4),Q(5))
               CALL MIDDLE (ZERO, P2TAIL, ONE)
               CALL PLEVEL (P2TAIL, SYMBOL)
               I12(1) = FORM12(K)
               I12(2) = FORM12(N)
               I12(3) = FORM12(L)               
               WRITE (TEXT,100) ICOUNT, BINOMP, I12(1), I12(2), I12(3),
     +                          BINOMP, PHAT, PL, PU,
     +                          P(1), P(2), P(3), P(4), P(5),
     +                          Q(1), Q(2), Q(3), Q(4), Q(5),
     +                          P2TAIL, SYMBOL
               WRITE (NOUT,'(A)') BLANK
               WRITE (NOUT,'(A)') '***'
               WRITE (NOUT,'(A)') BLANK
              
               WRITE (NOUT,100) ICOUNT, BINOMP, I12(1), I12(2), I12(3),
     +                          BINOMP, PHAT, PL, PU,
     +                          P(1), P(2), P(3), P(4), P(5),
     +                          Q(1), Q(2), Q(3), Q(4), Q(5),
     +                          P2TAIL, SYMBOL
               ICOLOR = 15
               CALL TABLE1 (ICOLOR, 'OPEN')
               DO I = 1, 20
                  IF (I.EQ.1) THEN
                     ICOLOR = 4
                  ELSEIF (I.EQ.2) THEN 
                     ICOLOR = 0
                     TEXT(2) = BLANK
                  ENDIF
                  CALL TABLE1 (ICOLOR, TEXT(I))
               ENDDO
               CALL TABLE1 (ICOLOR, 'CLOSE')
            ENDIF
         ENDIF
      ENDIF
C
C Format statement
C      
  100 FORMAT (
     + 1X,'Binomial test analysis',I4
     +/1X,'--------------------------'
     +/1X,'H0: Population p-value =',F9.6,' input by user'
     +/1X,'Number of successes K  =',1X,A
     +/1X,'Number of trials N     =',1X,A
     +/1X,'L (i.e. N - K)         =',1X,A
     +/1X,'p-theory input by user =',F9.6
     +/1X,'p-estimate from sample =',F9.6
     +/1X,'95% confidence limits  =',F9.6,',',F8.6
     +/1X,'P( X >  K )            =',F9.6
     +/1X,'P( X <  K )            =',F9.6
     +/1X,'P( X equals K )        =',F9.6
     +/1X,'P( X >= K )            =',F9.6
     +/1X,'P( X =< K )            =',F9.6
     +/1X,'P( X >  L )            =',F9.6
     +/1X,'P( X <  L )            =',F9.6
     +/1X,'P( X equals L)         =',F9.6
     +/1X,'P( X >= L )            =',F9.6
     +/1X,'P( X =< L )            =',F9.6
     +/1X,'2-tail probability     =',F9.6,4X,A)
      END
C
C
