
c
c
      subroutine biplot (lwork, ncmax, ncol, ndmax, nin, nout, nrmax,
     +                   nrow,
     +                   d, r, work, y,
     +                   fname, title,
     +                   newdat, supply)
c
c action: biplot
c author: w.g.bardsley, university of manchester, u.k., 26/08/2006
c         07/11/2006 rearranged menu and added intents 
c         19/12/2007 defined nword = nwmax = max(nrmax + ncmax, 2000)
c         06/07/2009 edited format 200 
c                              
c         lwork: (input/unchanged) should be >= 64*(ncmax + nrmax)
c         ncmax: (input/unchanged) dimension          
c          ncol: supply = .true., (input) column size of y
c                supply = .false.,(output)  
c         ndmax: (input/unchanged) >= min(ncmax,ndmax)
c           nin: (input/unchanged) unconnected unit for data input
c          nout: (input/unchanged) preconnected unit for results
c         nrmax: (input/unchanged) dimension
c          nrow: supply = .true., (input) row size for y
c                supply = .false., (output) 
c             d: (output) singular values 
c             r: workspace to hold the residual matrix  
c          work: workspace
c             y: supply = .true., (input) the supplied matrix
c                supply = .false., workspace
c         fname: supply = .true., (input) contains y filename
c                supply = .false., (output) file name for data
c         title: supply = .true., (input) data title
c                supply = .false., (output) title for data
c        newdat: (output) set true if new data requested 
c        supply: (input/unchanged)
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: lwork, ncmax, ndmax, nin,
     +                                       nout, nrmax 
      integer,             intent (inout) :: ncol, nrow
      double precision,    intent (inout) :: d(ndmax), r(nrmax,ncmax),
     +                                       work(lwork), y(nrmax,ncmax)
      character (len = *), intent (inout) :: fname, title
      logical,             intent (in)    :: supply
      logical,             intent (out)   :: newdat         
c         
c
c local allocatable arrays
c                         
      character (len = 40), allocatable :: label1(:), label2(:)
c
c locals
c
      integer    i, icount, ierr, j, k, nword
      integer    irank, ncol1, nrow1, nsvd
      integer    isend, jsend, ntype, nwmax, n1, n2, n3, n4
      parameter (jsend = 2, nwmax = 2000, ntype = 3, n1 = 1, n2 = 2,
     +           n3 = 3, n4 = 4)
      integer    icolor, ix, iy, lshade, numdec, numopt, nstart, ntext,
     +           numtxt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, numopt = 12,
     +           nstart = 12, ntext = numopt + nstart - 1, numtxt = 21)
      integer    numbld(30), numpos(numopt)  
      double precision b(1)
      character (len = 12) form12, word12_ncol, word12_nrow
      character  fname1*80, title1*80, chop80*80, trim80*80
      character  line*100, text(30)*100
      character  ptitle*80, xtitle*40, ytitle*40
      character  blank*1, nodata*20, nofile*20 
      parameter (blank = ' ', nodata = 'No data', nofile = 'No file')
      character  label40*40
      parameter (label40 = '0000000000000000000000000000000000000000')
      character  no_labels*11
      parameter (no_labels = '%no_labels%')
      logical    abort, done1, done2, ok, fileit, ready, repeet 
      logical    disply, supp
      parameter (supp = .true.)
      logical    fixcol, fixrow, label
      parameter (fixcol = .false., fixrow = .false., label = .true.)
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .true.)
      external   putfat, mattin, revpro, lbox01, dsplay, patch1, isitmf,
     +           chop80, trim80, svdval, putadv, getwrd, gksvf4, gksvf8,
     +           form12
      intrinsic  min
      save       icount
      data       icount / 0 /  
      data       numbld / 30*0 /
      data       numpos / numopt*1 /
c
c initialise newdat
c      
      newdat = .false.
c
c allocate labels
c     
      nword = min(nrmax + ncmax,nwmax) 
      ierr = 0
      if (allocated(label1)) deallocate(label1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(label2)) deallocate(label2, stat = ierr)
      if (ierr.ne.0) return 
      allocate(label1(nword), stat = ierr)
      if (ierr.ne.0) return 
      allocate(label2(nword), stat = ierr)
      if (ierr.ne.0) return   
      do i = 1, nword
         label2(i) = label40
      enddo   
      if (supply) then
c
c supply = .true. so attempt to open the Y file
c         
         call isitmf (ncol1, nrow1,
     +                fname)         
         if (ncol1.ne.ncol .or. nrow1.ne.nrow) then
            write (line,100)
            call putfat (line)
            deallocate(label1, stat = ierr)
            deallocate(label2, stat = ierr)
            return
         endif
         if (ncol.lt.2 .or. nrow.lt.2) then
            write (line,200) 
            call putfat (line)
            deallocate(label1, stat = ierr)
            deallocate(label2, stat = ierr)
            return
         endif  
c
c atempt to extract row and column labels off the input file
c         
         nword = ncol + nrow
         if (nword.gt.nwmax) then
            label1(1) = no_labels
         else    
            isend = 3  
            call getwrd (isend, ncol, nin, nrow, nword,
     +                   fname, label1)            
         endif
         ready = .true.  
      else
c
c otherwise initialise
c                      
         ready = .false.
         ncol = 0
         nrow = 0     
         fname = nofile
         title = nodata
      endif                
c
c main loop
c                
      fname1 = trim80 (fname)
      title1 = chop80 (title)
      numdec = numopt - 1
      done1 = .false.
      done2 = .false.
      ok = .false.
      repeet = .true.
      do while (repeet)
         word12_nrow = form12(nrow)
         word12_ncol = form12(ncol)
         write (text,300) fname1, title1, word12_nrow, word12_ncol
         if (numdec.lt.1 .or. numdec.gt.numopt) numdec = numopt - 1
         numbld(1) = 4
         numbld(4) = 1
         numbld(7) = 1
         call lbox01 (icolor, ix, iy, lshade, numbld, numdec, numopt,
     +                numpos, nstart, ntext,
     +                text,
     +                border, flash, high)
         numbld(1) = 0
         numbld(4) = 0
         numbld(7) = 0
c
c check if ncol > 1 and nrow > 1
c
         if (ncol.gt.1 .and. nrow.gt.1) then
            abort = .false.
            ready = .true.
         else   
            fname = nofile
            title = nodata
            abort = .true.
            ready = .false.
         endif
         if (.not.ready) then
c
c warn user to read in data
c
            if (numdec.ge.2 .and.numdec.le.10) then
               numdec = 0
               write (line,400)
               call putfat (line)
            endif
         endif
         if (.not.ok) then
c
c warn user if not analysed
c
            if (numdec.ge.5 .and. numdec.le.9) then
               numdec = 2
               write (line,500)
               call putadv (line)
            endif
         endif
         if (numdec.eq.1) then
c
c numdec = 1: read in Y-data
c                
            if (supply) then
               newdat = .true.    
               deallocate(label1, stat = ierr)
               deallocate(label2, stat = ierr)
               return
            endif   
            j = jsend
            close (unit = nin)
            call mattin (j, ncmax, ncol, nin, nrmax, nrow,
     +                   y, b,
     +                   fname, title,
     +                   abort, fixcol, fixrow, label)
            close (unit = nin)  
            if (abort) then
               ncol = 0
               nrow = 0 
            elseif (ncol.lt.2 .or. nrow.lt.2 .or.
     +              ncol + nrow.gt.nwmax) then
               write (line,200) 
               call putfat (line)
               ncol = 0
               nrow = 0
               abort = .true.
            endif            
            if (abort) then
               ncol = 0
               nrow = 0  
               fname = nofile
               title = nodata
               ready = .false.
            else
               close (unit = nin)
               open (unit = nin, file = fname)
               read (nin,'(a)') title
               read (nin,*) nrow, ncol
               do i = 1, nrow
                  read (nin,*) (y(i,j), j = 1, ncol)
               enddo
               close (unit = nin)
               fname1 = trim80(fname)
               title1 = chop80(title)
               done2 = .false.   
               nword = ncol + nrow
               if (nword.gt.nwmax) then
                  label1(1) = no_labels
               else   
                  isend = 3  
                  call getwrd (isend, ncol, nin, nrow, nword,
     +                         fname, label1)            
               endif 
            endif
            ok = .false.
         elseif (numdec.ge.2 .and. numdec.le.3) then
c
c numdec = 2: silent calculation
c numdec = 3: noisy calculation
c           
            if (numdec.eq.2) then 
               disply = .false.
               fileit = .false.
            else 
               disply = .true.
               fileit = .true.
            endif
            call svdval (irank, lwork, ncmax, ncol, ndmax, nin, nout,
     +                   nrmax, nrow, nsvd,
     +                   y, d, work, 
     +                   title,  
     +                   abort, disply, fileit, supp)
            if (.not.abort .and. irank.ge.2) then  
c
c SVD successful so form the residual matrix r = y - sigma(1)*u(1)*vt(1)
c Note:  u(1) to  u(4) are in work(1)          to work(4*nrow) 
c       vt(1) to vt(4) are in work(4*nrow + 1) to work(4*(ncol + nrow))
c 
C           On successful exit for a M by N matrix WORK contains the first three
C           components of U and VT as follows:
C                               WORK(1) to WORK(M) =  U(1,1) to  U(M,1)
C                         WORK(M + 1) to WORK(2*M) =  U(1,2) to  U(M,2)
C                       WORK(2*M + 1) to WORK(3*M) =  U(1,3) to  U(M,3)
C                       WORK(3*M + 1) to WORK(4*M) =  U(1,4) to  U(M,4)
C                   WORK(4*M + 1) to WORK(4*M + N) = VT(1,1) to VT(1,N)
C             WORK(4*M + N + 1) to WORK(4*M + 2*N) = VT(2,1) to VT(2,N)
C           WORK(4*M + 2*N + 1) to WORK(4*M + 3*N) = VT(3,1) to VT(3,N)
C           WORK(4*M + 3*N + 1) to WORK(4*M + 4*N) = VT(4,1) to VT(4,N)
c            
               ok = .true.
               icount = icount + 1
               write (line,600) icount, nsvd, irank                      
               call putadv (line)
               write (nout,'(a)') blank
               write (nout,'(a)') line 
               k = 4*nrow  
               do j = 1, ncol
                  k = k + 1
                  do i = 1, nrow
                     r(i,j) = y(i,j) - d(1)*work(i)*work(k) 
                  enddo
               enddo
            else                 
               ok = .false.
               write (line,700) ncol, nrow, nsvd, irank
               call putfat (line)
            endif   
         elseif (numdec.eq.4) then
c
c numdec = 4: view data
c                             
            done1 = .true.
            write (ptitle,800)
            fileit = done1
            call dsplay (ncmax, ncol, nout, nrmax, nrow, ntype,
     +                   y,
     +                   ptitle,
     +                   fileit)
         elseif (numdec.eq.5) then
c
c numdec = 5: view residual matrix
c
            write (ptitle,900) 
            if (nrow.le.50 .and. ncol.le.20) then
               fileit = .true.
            else
               fileit = .false.
            endif
            if (done2) fileit = .false.
            call dsplay (ncmax, ncol, nout, nrmax, nrow, ntype,
     +                   r,
     +                   ptitle,
     +                   fileit)
            done2 = .true.
         elseif (numdec.eq.6) then
c
c numdec = 6: plot data bi-plot
c 
            if (irank.ge.2) then           
               ptitle = 'Data Biplot'                          
               xtitle = 'x'
               ytitle = 'y'     
               call gksvf4 (lwork, ncol, nrow, n1,
     +                      d, work, 
     +                      label1, label2,
     +                      ptitle, xtitle, ytitle)   
            else   
               write (line,1000) n2
               call putfat (line)
            endif
         elseif (numdec.eq.7) then
c
c numdec = 7: plot residual bi-plot
c                
            if (irank.ge.3) then             
               ptitle = 'Residual Biplot'                          
               xtitle = 'x'
               ytitle = 'y'     
               call gksvf4 (lwork, ncol, nrow, n2, 
     +                      d, work, 
     +                      label1, label2,
     +                      ptitle, xtitle, ytitle)   
            else              
               write (line,1000) n3
               call putfat (line)
            endif
         elseif (numdec.eq.8) then
c
c numdec = 8: triplot with data matrix
c  
              if (irank.ge.3) then           
               call gksvf8 (lwork, ncol, nin, nrow, n1,
     +                      d, work, 
     +                      label1) 
            else   
               write (line,1000) n3
               call putfat (line)
            endif
         elseif (numdec.eq.9) then
c
c numdec = 9: triplot with residual matrix
c                                    
            if (irank.ge.4) then             
               call gksvf8 (lwork, ncol, nin, nrow, n2, 
     +                      d, work, 
     +                      label1) 
            else              
               write (line,1000) n4
               call putfat (line)
            endif        
         elseif (numdec.eq.numopt - 2) then
c
c numdec = numopt - 2: results
c         
            call revpro (nout)   
         elseif (numdec.eq.numopt - 1) then
c
c numdec = numopt - 1: help
c
            write (text,2000)
            numbld(1) = 1
            call patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +                   text,
     +                   border)
            numbld(1) = 0
         elseif (numdec.eq.numopt) then
c
c numdec = numopt: quit
c             
            deallocate(label1, stat = ierr)
            deallocate(label2, stat = ierr)
            newdat = .false.         
            repeet = .false.
         endif
      enddo
c
c format statements
c                        
  100 format ('Error opening matrix data file in BIPLOT')
  200 format ('Must have m >= 2, n >= 2, and m + n =< 2000')
  300 format (
     + 'Biplots in two or three dimensions'
     +/              
     +/'File:'
     +/a
     +/
     +/'Title:'
     +/a
     +/
     +/'Number of rows =',1x,a
     +/'Number of columns =',1x,a
     +/
     +/'Data: New/Edit/Transform/View'
     +/'Calculate: No SVD details'
     +/'Calculate: Full SVD details'
     +/'View/File/Save/Print: data matrix'
     +/'View/File/Save/Print: residual matrix'
     +/'2D Biplot: using data matrix'
     +/'2D Biplot: using residual matrix'
     +/'3D Biplot: using data matrix'
     +/'3D Biplot: using residual matrix'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit biplot options')
  400 format ('First read in some data')
  500 format ('The calculation must now be done') 
  600 format ('Bi-Plot',i4,', no. singular values =',i6,', rank =',i6) 
  700 format ('Cols =',i6,', Rows =',i6,', no. SV =',i6,', rank =',i6)
  800 format ('Original Data')
  900 format ('Residual Matrix') 
 1000 format ('Must have data matrix rank >=',i2)  
 2000 format (
     + 'Creating two- or three-dimensional biplots'
     +/
     +/'Given a n by m data matrix or similar, say X, a singular value'
     +/'decomposition (SVD) leads to U, Sigma and V defined by'
     +/'                    X = U*Sigma*V^T'
     +/'which can be used to view projections of X onto subspaces.'
     +/    
     +/'1.`Data for this procedure must be as a n by m data matrix in'
     +/'  `Simfit format, i.e. as created using program Makmat or from'
     +/'  `a spreadsheet, e.g. Excel by Cut/Paste or using simft4.xls.'
     +/'1.`First create a SVD of X. If this succeeds a residual matrix'
     +/'  `R will also be calculated by subtraction, i.e. R = X - X(1)'
     +/'  `where X(1) of rank 1 is calculated using sigma(1).'
     +/'3.`If labels are appended to the file in the order rows (cases)'
     +/'  `then columns (variables) they will be used as plot labels.'
     +/'4.`Create plots from the data matrix X or residual matrix R.'
     +/'5.`Vary plot parameters until good appearance is obtained.'
     +/'6.`For biplot editing, use [Advanced] then transfer to Simplot.'
     +/'You will discover that a certain amount of practise will be'
     +/'required in order to get a good display of results and you must'
     +/'consult the reference manual for an example of how to do this.')
      end
c
c 
