C
C
      SUBROUTINE CACORR (NCMAX, NCOL, NF, NIN, NMAX, NROW, NSMALL,
     +                   A,
     +                   FNAME, FSAV, TITLE, TSAV,
     +                   NEWDAT, SUPPLY)
C
C ACTION: Canonical correlation analysis with data supplied in matrix A or
C         read interactively into matrix A
C AUTHOR: W. G. Bardsley, University of Manchester, U.K.,
C         Derived from XYCORR 22/02/2004
C         10/01/2006 moved B, C, D, W, X, Y from argument list to allocatables
C         05/03/2006 added NEWDAT and SUPPLY to argument list
C         21/10/2006 added EOFINT, and DSPLAY
C         10/11/2006 corrected several dimensions and added ALLPOS
C         24/11/2006 removed EDITOR and replaced by call to ISZEDI 
C         31/12/2007 added NO_LABELS
C         17/07/2008 added XMEAN to correct X and Y for centralising when calculating U and V
C                    and renamed the variables as U = Y, V = X. Also note that NX and NY 
C                    are now INTENT (IN), so the rank of X and Y are not returned from G03ADF
C                    and NXSAV and NYSAV are redundant but kept in for future devdlopments, while
C                    400 FORMAT now ouputs NCV = min(rank(X),rank(Y))
C         17/04/2011 edited main menu
C         26/12/2021 added E_NUMBERS and E_FORMATS, etc. Also maximum NCV now is 20 limited by len(LINE)
C                    so, if larger matrices are required, the limits imposed by len(LINE) will require 
C                    editing in several places.  See G03ADF and formats 700 and 750, etc.
C
C         NCMAX: (input/unchanged) maximum column dimension
C          NCOL: (input/output) column size
C            NF: (input/unchanged) preconnected unit for results
C           NIN: (input/unchanged) unconnected unit for file opening
C          NMAX: (input/unchanged) maximum row dimension
C          NROW: (input/output) row size
C        NSMALL: (input/unchanged) maximum dimension of library file
C        A, B, C, D, W, X, Y: workspace except that A may contain the data
C        on entry or exit as follows:
C        If the routine is called with A, NROW and NCOL defined then A may be
C        used as such. If A is changed then NROW and NCOL may be changed.
C        FNAME: (output) data file name (if new data)
C         FSAV: (input/output) library file names
C        TITLE: (output) data title (if new data)
C         TSAV: (input/output) library file titles
C       NEWDAT: (output) if .TRUE. then new data is requested
C       SUPPLY: (input/unchanged) if .TRUE. then A is supplied
C
C Note: If A is already stored then NCOL and NROW will be the dimensions on
C       entry. If A is filled during subroutine execution then it is returned
C       unchanged, i.e. A = ASAV, NCOL = NCSAV and NROW = NRSAV in SIMSTAT
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NCMAX, NF, NIN, NMAX,
     +                                       NSMALL
      INTEGER,             INTENT (INOUT) :: NCOL, NROW
      DOUBLE PRECISION,    INTENT (INOUT) :: A(NMAX,NCMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, FSAV(NSMALL), TITLE,
     +                                       TSAV(NSMALL)
      LOGICAL,             INTENT (IN)    :: SUPPLY
      LOGICAL,             INTENT (OUT)   :: NEWDAT
C
C Local allocatable arrays
C
      INTEGER,              ALLOCATABLE :: ISZ(:)
      DOUBLE PRECISION,     ALLOCATABLE :: B(:,:), C(:,:), D(:,:), W(:),
     +                                     X(:), XMEAN(:), Y(:)
      DOUBLE PRECISION,     ALLOCATABLE :: E(:,:)
      CHARACTER (LEN = 40), ALLOCATABLE :: WORDX(:)
C
C Locals
C
      INTEGER    ICMAX, NLMAX, N0, N1, N2, N3, N4, N5, N6, N7, N8, N9,
     +           N15
      PARAMETER (ICMAX = 100, NLMAX = 2000, N0 = 0, N1 = 1, N2 = 2,
     +           N3 = 3, N4 = 4, N5 = 5, N6 = 6, N7 = 7, N8 = 8, N9 = 9,
     +           N15 = 15)
      INTEGER    ISZSAV(ICMAX)
      INTEGER    I, IERR, IFAIL, J, K, KX, KXSAV, KY, KYSAV, KZ,
     +           LX, LY, MCV, NCV, NCV1, NSAV, NWMAX
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NOPT, NSTART, NUMTXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1, NOPT = 10)
      INTEGER    NUMDEC, NUMOPT
      PARAMETER (NUMOPT = 6)
      INTEGER    JSEND, NTYPE
      PARAMETER (JSEND = 1, NTYPE = 3)
      INTEGER    NDEC, NUMBLD(30), NUMPOS(NOPT)
      INTEGER    ICOUNT, ISIZE, JSIZE, NWORDS, NX, NY
      DOUBLE PRECISION DELTA, DN, ESUM, ZERO, EPSI
      PARAMETER (ZERO = 0.0D+00, EPSI = 1.0D-20)
      DOUBLE PRECISION TOL
      DOUBLE PRECISION XBAR, X2(2), X3(2), X4(2), Y2(2), Y3(2), Y4(2)
      CHARACTER (LEN = 12 ) I12(4), FORM12, WORD12_KX, WORD12_KY,
     +                     WORD12_KZ
      CHARACTER (LEN = 13 ) D13(20), SHOWRJ
      CHARACTER (LEN = 280) LINE! This dimension limits the size of the matrix that can be analysed
      CHARACTER  CIPHER*4, HEADER*(ICMAX), TEXT(30)*100, TITLE1*80
      CHARACTER  CHOP80*80, WORD80*80, xsign*1, ysign*1
      CHARACTER  PTITLE*50, XTITLE*50, YTITLE*50
      CHARACTER  AVAIL*4, BLANK*1, DOTS*3, NODATA*10, NOTAV*4
      PARAMETER (AVAIL = '    ', BLANK = ' ', DOTS = '...',
     +           NODATA = 'No data', NOTAV = '(NA)')
      CHARACTER  NO_LABELS*11
      PARAMETER (NO_LABELS = '%no_labels%')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    FILEIT, FILE1, PRINT1
      PARAMETER (FILEIT = .FALSE., FILE1 = .TRUE., PRINT1 = .TRUE.)
      LOGICAL    AXES, GSAVE
      PARAMETER (AXES = .TRUE., GSAVE = .TRUE.)
      LOGICAL    ALLPOS
      PARAMETER (ALLPOS = .FALSE.)
      LOGICAL    ABORT, AGAIN, DOIT, EQUAL, OK, READY, REPEET
      LOGICAL    NEG_X, NEG_Y
      EXTERNAL   E_FORMATS, SHOWRJ
      EXTERNAL   PUTFAT, PUTIFA, GETJM1, STATMT, LBOX01, GKS004, DSPLAY,
     +           PATCH1, CHOP80, TABLE1, PUTADV, PUTWAR, EOFINT, LISTBX,
     +           LBPLOT, LINFIT, GETWRD, REVPRO, ISZEDI, YESNO2, FORM12
      EXTERNAL   G03ADF$
      INTRINSIC  MIN, ABS, DBLE, NINT, MAX
      SAVE       NEG_X, NEG_Y
      SAVE       ICOUNT, ISZSAV, NX, NY
      DATA       NEG_X, NEG_Y / .FALSE., .FALSE. /
      DATA       ICOUNT / 0 /
      DATA       ISZSAV / ICMAX*1 /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NOPT*1 /
      DATA       NX, NY / 1, 1 /
C
C Initialise NEWDAT then check dimensions if SUPPY = .TRUE.
C
      NEWDAT = .FALSE.
      IF (SUPPLY) THEN
         IF (NCOL.LT.2 .OR. NCOL.GT.NCMAX .OR.
     +       NROW.LT.2 .OR. NROW.GT.NMAX) RETURN
      ENDIF
C
C Allocate workspaces
C
      IERR = 0
      IF (ALLOCATED(ISZ)) DEALLOCATE(ISZ, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(B)) DEALLOCATE(B, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(C)) DEALLOCATE(C, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(D)) DEALLOCATE(D, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(W)) DEALLOCATE(W, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(XMEAN)) DEALLOCATE(XMEAN, STAT = IERR)
      IF (IERR.NE.0) RETURN  
      IF (ALLOCATED(Y)) DEALLOCATE(Y, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(E)) DEALLOCATE(E, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(WORDX)) DEALLOCATE(WORDX, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(ISZ(NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(B(NMAX,NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(C(NMAX,NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(D(NMAX,NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(X(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(XMEAN(NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN  
      ALLOCATE(Y(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(E(NCMAX,6), STAT = IERR)
      IF (IERR.NE.0) RETURN
      NWORDS = MIN(NMAX + NCMAX,NLMAX)  
      ALLOCATE(WORDX(NWORDS), STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Initialise ISZ, NDEC, and WORD80
C Note that only ICMAX elements of ISZ are stored between calls
C
      IF (SUPPLY) THEN
         CALL EOFINT (ISZ, NCOL,
     +                FNAME,
     +                ABORT, ALLPOS)
         IF (ABORT) THEN
            WRITE (LINE,100)
            CALL PUTADV (LINE)
         ENDIF
         IF (NROW.GT.NLMAX) THEN
            WORDX(1) = NO_LABELS
         ELSE    
            CALL GETWRD (JSEND, NCOL, NIN, NROW, NMAX,
     +                   FNAME, WORDX)
         ENDIF
C
C Calculate XMEAN to centralise data for canonical variates
C
         DN = DBLE(NROW)
         DO J = N1, NCOL
            XBAR = ZERO
            DO I = N1, NROW
               XBAR = XBAR + A(I,J)
            ENDDO  
            XMEAN(J) = XBAR/DN
         ENDDO         
      ELSE
         TITLE = NODATA
         ABORT = .TRUE.
      ENDIF
      IF (ABORT) THEN
         DO I = N1, NCMAX
            IF (I.LE.ICMAX) THEN
               ISZ(I) = ISZSAV(I)
            ELSE
               ISZ(I) = N1
            ENDIF
         ENDDO
      ENDIF
      NDEC = NOPT - N1
      WORD80 = CHOP80(TITLE)
      READY = .FALSE.
C
C Main loop
C =========
C
      E_NUMBERS = E_FORMATS()
      DOIT = .TRUE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
         KX = N0
         KY = N0
         KZ = N0
         HEADER = BLANK
         IF (NCOL.GT.N1 .AND. NROW.GT.N1) THEN
            ISIZE = NROW
            JSIZE = NCOL
            OK = .TRUE.
            CIPHER = AVAIL
            DO I = N1, JSIZE
               IF (ISZ(I).GT.N0) THEN
                  ISZ(I) = N1
                  KX = KX + N1
                  IF (I.LE.ICMAX) HEADER(I:I) = 'x'
               ELSEIF (ISZ(I).EQ.N0) THEN
                  IF (I.LE.ICMAX) HEADER(I:I) = '0'
                  KZ = KZ + N1
               ELSE
                  ISZ(I) = - N1
                  KY = KY + N1
                  IF (I.LE.ICMAX) HEADER(I:I) = 'y'
               ENDIF
            ENDDO
            IF (JSIZE.GT.ICMAX) HEADER(ICMAX - N2:ICMAX) = DOTS
         ELSE
            OK = .FALSE.
            CIPHER = NOTAV
         ENDIF
         WORD12_KX = FORM12(KX)
         WORD12_KY = FORM12(KY)
         WORD12_KZ = FORM12(KZ)
         WRITE (TEXT,200) WORD80, HEADER, WORD12_KX, WORD12_KY,
     +                    WORD12_KZ, CIPHER
         NSTART = N8 + N5
         NUMTXT = NSTART + NOPT - N1
         NUMBLD(1) = N4
         NUMBLD(4) = N1
         NUMBLD(7) = N1
         IF (NDEC.EQ.N0) THEN
            IF (.NOT.OK) THEN
               NDEC = N1
            ELSEIF (READY) THEN
               NDEC = N2
            ELSE
               NDEC = NOPT - N1
            ENDIF
         ENDIF
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, NOPT,
     +                NUMPOS, NSTART, NUMTXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = N0
         NUMBLD(4) = N0
         NUMBLD(6) = N0
C
C Check that DATA are ready if NDEC = 2 is selected
C
         IF (NDEC.GE.N2 .AND. NDEC.LE.N7) THEN
            IF (.NOT.OK) THEN
               CALL PUTFAT ('First input your current data')
               NDEC = N0
            ELSEIF (NCOL.LT.N2 .OR. NROW.LT.N2) THEN
               CALL PUTFAT ('Must have at least 2 rows and 2 columns')
               NDEC = N0
            ELSEIF (NDEC.GE.N3 .AND. NDEC.LE.N6 .AND. .NOT.READY) THEN
               CALL PUTFAT ('First analyse the data')
               NDEC = N0
            ENDIF
         ENDIF
         IF (NDEC.EQ.N2) THEN
            IF (KX.LT.N1 .OR. KY.LT.N1) THEN
               CALL PUTFAT ('Must have no. of X > 0 and no. of Y > 0')
               NDEC = N7
            ENDIF
         ENDIF
         IF (NDEC.EQ.N1) THEN
C
C NDEC = 1: Data input
C =========
C
            IF (SUPPLY) THEN
               NEWDAT = .TRUE.
               DO I = N1, MIN(NCOL,ICMAX)
                  ISZSAV(I) = ISZ(I)
               ENDDO
               DEALLOCATE (ISZ, STAT = IERR)
               DEALLOCATE (B, STAT = IERR)
               DEALLOCATE (C, STAT = IERR)
               DEALLOCATE (D, STAT = IERR)
               DEALLOCATE (W, STAT = IERR)
               DEALLOCATE (X, STAT = IERR)
               DEALLOCATE (XMEAN, STAT = IERR)
               DEALLOCATE (Y, STAT = IERR)
               DEALLOCATE (E, STAT = IERR)
               DEALLOCATE (WORDX, STAT = IERR)
               RETURN
            ENDIF
            OK = .FALSE.
            READY = .FALSE.
            CALL STATMT (NCMAX, NCOL, NF, NIN, NMAX, NROW, NSMALL,
     +                   A, X, Y,
     +                   FNAME, FSAV, TITLE, TSAV)
            WORD80 = CHOP80(TITLE)
            IF (NCOL.GT.N1 .AND. NROW.GT.N1) THEN
               CALL EOFINT (ISZ, NCOL,
     +                      FNAME,
     +                      ABORT, ALLPOS)
               OK = .TRUE.
               IF (ABORT) THEN
                  WRITE (LINE,100)
                  CALL PUTADV (LINE)
                  NDEC = N7
               ELSE
                  NDEC = N2
               ENDIF
               IF (NROW.GT.NLMAX) THEN
                  WORDX(1) = NO_LABELS
               ELSE   
                  CALL GETWRD (JSEND, NCOL, NIN, NROW, NMAX,
     +                         FNAME, WORDX)
               ENDIF
C
C Calculate XMEAN to centralise data for canonical variates
C
               DN = DBLE(NROW)
               DO J = N1, NCOL
                  XBAR = ZERO
                  DO I = N1, NROW
                     XBAR = XBAR + A(I,J)
                  ENDDO  
                  XMEAN(J) = XBAR/DN
               ENDDO   
            ELSE
               OK = .FALSE.
               NDEC = N1
            ENDIF
         ELSEIF (NDEC.EQ.N2) THEN
C
C NDEC = 2: Analysis of data ... First read data into B 
C =========                      This is not now necessary as A is INTENT (IN) to G03ADF 
C
            ISIZE = NROW
            JSIZE = NCOL
            DO I = N1, JSIZE
               IF (ISIZE.GT.N1 .AND. ISZ(I).NE.N0) THEN
                  EQUAL = .TRUE.
                  DO J = N1, ISIZE
                     B(J,I) = A(J,I)
                     IF (EQUAL .AND. J.GT.N1) THEN
                        DELTA = ABS(B(J - N1,I) - B(J,I))
                        IF (DELTA.GT.EPSI) EQUAL = .FALSE.
                     ENDIF
                  ENDDO
                  IF (EQUAL) THEN
                     CALL PUTFAT ('Variance too small for analysis')
                     NCOL = N0
                     NROW = N0
                     ISIZE = N0
                  ENDIF
               ENDIF
               IF (ISIZE.EQ.N0) EXIT
            ENDDO
            IF (ISIZE.GT.N1 .AND. JSIZE.GT.N1) THEN
C
C Assign NWMAX
C              
                IF (KX.GE.KY) THEN
                   NWMAX = ISIZE*KX + KX + KY +
     +                     MAX(5*(KX - 1) + KX**2, ISIZE*KY)
                ELSE
                   NWMAX = ISIZE*KY + KX + KY +
     +                     MAX(5*(KY - 1) + KY**2, ISIZE*KX)
                ENDIF
C
C-------------------------------------------------------------
C Temporary code to readjust NWMAX for Simfit NAG substitute
C
                I = ISIZE*(KX + KY) + KX**2 + KY**2
                IF (NWMAX.LT.I) NWMAX = I
C-------------------------------------------------------------
C
                NWMAX = NWMAX + 1
                MCV = MIN(KX,KY)
                IFAIL = N1
                TOL = 1.0D-06
                KXSAV = KX
                KYSAV = KY
                IF (ALLOCATED(W)) DEALLOCATE(W, STAT = IERR)
                ALLOCATE(W(NWMAX), STAT = IERR)
C
C Note: KX and KY are INTENT (IN) variables now so KXSAV and KYSAV are redundant but
C       left in for possible future warnings about reduced rank cases
C                
                CALL G03ADF$('U', ISIZE, JSIZE, B, NMAX, ISZ, KX, KY,
     +                       X, E, NCMAX, NCV, C, NMAX, MCV, D, NMAX,
     +                       TOL, W, NWMAX, IFAIL)
                CALL PUTIFA (IFAIL, NF, 'G03ADF/CACORR')
                IF (IFAIL.EQ.N0) THEN
                   IF (KX.LT.KXSAV) CALL PUTWAR (
     +             'X-data are rank deficient')
                   IF (KY.LT.KYSAV) CALL PUTWAR (
     +             'Y-data are rank deficient')
                   READY = .TRUE.
                   ICOUNT = ICOUNT + N1
                   I12(1) = FORM12(KXSAV)
                   I12(2) = FORM12(KYSAV)
                   I12(3) = FORM12(KZ)
                   I12(4) = FORM12(NCV)
                   WRITE (TEXT,400) ICOUNT, WORD80, HEADER, 
     +                              TRIM(I12(1)), TRIM(I12(2)),
     +                              TRIM(I12(3)), TRIM(I12(4))
                   WRITE (NF,'(A)') BLANK
                   J = N15
                   CALL TABLE1 (J, 'OPEN')
                   DO I = N1, N9
                      IF (I.EQ.N1 .OR. I.EQ.N9) THEN
                         J = N4
                      ELSEIF (I.EQ.N4 .OR. I.EQ.N6) THEN
                         J = N1
                      ELSE
                         J = N0
                      ENDIF
                      IF (I.EQ.N3) WRITE (NF,'(A)') BLANK
                      WRITE (NF,'(A)') TEXT(I)
                      IF (I.EQ.2) THEN
                         CALL TABLE1 (J, BLANK)
                      ELSE
                         CALL TABLE1 (J, TEXT(I))
                      ENDIF
                   ENDDO
                   DO I = N1, NCV
                      IF (E_NUMBERS) THEN
                         WRITE (LINE,500) (E(I,J), J = N1, N4),
     +                                     NINT(E(I,N5)), E(I,N6)
                      ELSE
                         D13(1) = SHOWRJ(E(I,2))
                         D13(2) = SHOWRJ(E(I,4))
                         WRITE (LINE,550) E(I,1), D13(1), E(I,3),
     +                                    D13(2), NINT(E(I,N5)), E(I,N6)
                                    
                      ENDIF   
                      J = N0
                      WRITE (NF,'(A)') LINE
                      CALL TABLE1 (J, LINE)
                   ENDDO
                   IF (KX.LE.50 .AND. KY.LE.50) THEN
                       NCV1 = MIN(NCV,20) 
                       WRITE (LINE,600)
                       WRITE (NF,'(A)') LINE
                       J = N4
                       CALL TABLE1 (J,LINE)
                       J = N0
                       DO I = N1, KX
                          IF (E_NUMBERS) THEN
                             WRITE (LINE,700) (C(I,K), K = N1, NCV1)
                          ELSE
                             DO K = N1, NCV1
                                D13(K) = SHOWRJ(C(I,K))
                             ENDDO  
                             WRITE (LINE,750) (D13(K), K = N1, NCV1)
                          ENDIF
                          WRITE (NF,'(A)') LINE
                          CALL TABLE1 (J, LINE)
                       ENDDO
                       WRITE (LINE,800)
                       WRITE (NF,'(A)') LINE
                       J = N4
                       CALL TABLE1 (J, LINE)
                       J = N0
                       DO I = N1, KY
                          IF (E_NUMBERS) THEN
                             WRITE (LINE,700) (D(I,K), K = N1, NCV1)
                          ELSE
                              DO K = N1, NCV1
                                D13(K) = SHOWRJ(D(I,K))
                             ENDDO  
                             WRITE (LINE,750) (D13(K), K = N1, NCV1)   
                          ENDIF  
                          WRITE (NF,'(A)') LINE
                          CALL TABLE1 (J, LINE)
                       ENDDO
                   ENDIF
                   CALL TABLE1 (J, 'CLOSE')
                ELSE
                   READY = .FALSE.
                ENDIF
            ENDIF
            NDEC = N5
         ELSEIF (NDEC.EQ.N3) THEN
C
C NDEC = 3: loadings for X on CV
C =========
C
            WRITE (TITLE1,600)
            CALL DSPLAY (NCV, NCV, NF, NMAX, KX, NTYPE,
     +                   C,
     +                   TITLE1,
     +                   FILEIT)
         ELSEIF (NDEC.EQ.N4) THEN
C
C NDEC = 4: loadings for Y on CV
C =========
C
            WRITE (TITLE1,800)
            CALL DSPLAY (NCV, NCV, NF, NMAX, KY, NTYPE,
     +                   D,
     +                   TITLE1,
     +                   FILEIT)
         ELSEIF (NDEC.EQ.N5) THEN
C
C NDEC = 5: Scree diagram
C =========
C
            ESUM = ZERO
            DO I = N1, NCV
               X(I) = DBLE(I)
               Y(I) = E(I,2)
               ESUM = ESUM + Y(I)
            ENDDO
            ESUM = ESUM/DBLE(NCV)
            PTITLE = 'Canonical Correlation Scree Diagram'
            XTITLE = 'Number'
            YTITLE = 'Eigenvalues'
            X2(1) = X(1)
            X2(2) = X(NCV)
            Y2(1) = ESUM
            Y2(2) = ESUM
            DO I = N1, N2
               X3(I) = ZERO
               X4(I) = ZERO
               Y3(I) = ZERO
               Y4(I) = ZERO
            ENDDO
            CALL GKS004 (N1, N2, N0, N0, N5, N0, N0, N0, NCV, N2, N0,
     +                   N0,
     +                   X, X2, X3, X4,
     +                   Y, Y2, Y3, Y4,
     +                   PTITLE, XTITLE, YTITLE,
     +                   AXES, GSAVE)
            NDEC = N6
         ELSEIF (NDEC.EQ.N6) THEN
C
C NDEC = 6: plots, correlation, and regression
C =========
C
            IF (KX.LT.KXSAV) THEN
               CALL PUTWAR ('X-data are rank deficient')
            ELSEIF (KY.LT.KYSAV) THEN
               CALL PUTWAR ('Y-data are rank deficient')
            ELSEIF (NCV.GE.N1) THEN
               DO I = N1, N2
                  X2(I) = ZERO
                  X3(I) = ZERO
                  X4(I) = ZERO
                  Y2(I) = ZERO
                  Y3(I) = ZERO
                  Y4(I) = ZERO
               ENDDO
               IF (NX.GT.NCV .OR. NY.GT.NCV) THEN
                  NX = N1
                  NY = N1
                  DOIT = .TRUE.
               ENDIF
               AGAIN = .TRUE.
               DO WHILE (AGAIN)
C
C Subsidiary loop to select plot options
C
                  IF (NEG_X) THEN
                     XSIGN = '-'
                  ELSE
                     XSIGN = '+'
                  ENDIF
                  IF (NEG_Y) THEN
                     YSIGN = '-'
                  ELSE
                     YSIGN = '+'         
                  ENDIF   
                  WRITE (TEXT,300) XSIGN, NX, YSIGN, NY
                  NUMDEC = NUMOPT
                  CALL LISTBX (NUMDEC, NUMOPT,
     +                         TEXT)
                  IF (NUMDEC.EQ.1) THEN
C
C Choose v(i)
C
                     NSAV = NX
                     CALL GETJM1 (N1, NX, NCV,
     +'i for canonical x-variate v(i) to plot on horizontal x-axis')
                     IF (NX.NE.NSAV) DOIT = .TRUE.
                     CALL YESNO2 (ICOLOR, IXL, IYL,
     +                       'reverse sign, i.e. plot -x instead of x',
     +                            NEG_X) 
                     IF (NEG_X) THEN
                        IF (XSIGN.EQ.'+') DOIT =.TRUE.
                     ELSE
                        IF (XSIGN.EQ.'-') DOIT = .TRUE.
                     ENDIF                           
                  ELSEIF (NUMDEC.EQ.2) THEN
C
C Choose u(j)
C
                     NSAV = NY
                     CALL GETJM1 (N1, NY, NCV,
     +'j for canonical y-variate u(j) to plot on vertical axis')
                     IF (NY.NE.NSAV) DOIT = .TRUE.
                     CALL YESNO2 (ICOLOR, IXL, IYL,
     +                       'reverse sign, i.e. plot -y instead of y',
     +                            NEG_Y) 
                     IF (NEG_y) THEN
                        IF (YSIGN.EQ.'+') DOIT =.TRUE.
                     ELSE
                        IF (YSIGN.EQ.'-') DOIT = .TRUE.
                     ENDIF                    
                  ELSEIF (NUMDEC.LT.NUMOPT) THEN
C
C Calculate the canonical variate pair as X and Y if DOIT = .TRUE.
C
                     PTITLE = 'Canonical Correlation'
                     IF (NEG_X) THEN
                        WRITE (XTITLE,900) '-v', NX
                     ELSE   
                        WRITE (XTITLE,900) 'v', NX
                     ENDIF
                     IF (NEG_Y) THEN   
                        WRITE (YTITLE,900) '-u', NY
                     ELSE
                        WRITE (YTITLE,900) 'u', NY
                     ENDIF      
                     IF (DOIT) THEN
C
C We need to calculate U and V
C                       
                        DOIT = .FALSE.
                        DO I = N1, ISIZE
                           X(I) = ZERO
                           Y(I) = ZERO
                           LX = N0
                           LY = N0
                           DO J = N1, JSIZE
                              IF (ISZ(J).GT.N0) THEN
C
C Calculate the x-variable, i.e. V
C                                
                                 LX = LX + N1
                                 X(I) = X(I) +
     +                                  C(LX,NX)*(A(I,J) - XMEAN(J))


                              ELSEIF (ISZ(J).LT.N0) THEN
C
C Calculate the y-variable, i.e. U
C                              
                                 LY = LY + N1
                                 Y(I) = Y(I) + 
     +                                  D(LY,NY)*(A(I,J) - XMEAN(J))
                             ENDIF
                           ENDDO
                        ENDDO
C
C Reverse the signs if required
C                        
                        IF (NEG_X) THEN
                           DO I = N1, ISIZE
                              X(I) = - X(I)
                           ENDDO
                        ENDIF  
                        IF (NEG_Y) THEN
                           DO I = N1, ISIZE
                              Y(I) = - Y(I)
                           ENDDO
                        ENDIF          
                     ENDIF
                     IF (NUMDEC.EQ.3) THEN
C
C Simple plot
C
                        CALL GKS004 (N0, N0, N0, N0, N5, N0, N0, N0,
     +                               ISIZE, N0, N0, N0,
     +                               X, X2, X3, X4,
     +                               Y, Y2, Y3, Y4,
     +                               PTITLE, XTITLE, YTITLE,
     +                               AXES, GSAVE)
                     ELSEIF (NUMDEC.EQ.4) THEN
C
C Plot with labels
C
                        IF (WORDX(1).EQ.NO_LABELS) THEN
                           CALL PUTADV ('Plot is not possible')
                        ELSE   
                           CALL LBPLOT (ISIZE,
     +                                  X, Y,
     +                                  PTITLE, WORDX, XTITLE, YTITLE)
                        ENDIF
                     ELSEIF (NUMDEC.EQ.5) THEN
C
C Regression and correlation
C
                        WRITE (NF,'(A)') 'x = '//XTITLE
                        WRITE (NF,'(A)') 'y = '//YTITLE
                        CALL LINFIT (NF, ISIZE,
     +                               X, Y,
     +                               FILE1, PRINT1)
                     ENDIF
                  ELSE
                     AGAIN = .FALSE.
                  ENDIF
               ENDDO
            ELSE
               CALL PUTADV ('Plot is not possible')
            ENDIF
            NDEC = NOPT - N1
         ELSEIF (NDEC.EQ.N7) THEN
C
C NDEC = 7: Edit ISZ
C =========
C
            IF (NCOL.GT.N1) THEN   
               CALL ISZEDI (ISZ, NCOL)
               NDEC = N2
               READY = .FALSE.
            ENDIF
         ELSEIF (NDEC.EQ.NOPT - N2) THEN
C
C NDEC = NOPT - 2: Results
C ===============
C
            CALL REVPRO (NF)
            NDEC = N0
         ELSEIF (NDEC.EQ.NOPT - N1) THEN
C
C NDEC = NUMOPT - 1: Help
C ==================
C
            WRITE (TEXT,1000)
            NUMTXT = 21
            NUMBLD(1) = N1
            CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMTXT,
     +                   TEXT, BORDER)
            NUMBLD(1) = N0
            NDEC = N0
         ELSEIF (NDEC.EQ.NOPT) THEN
C
C NDEC = NUMOPT: Cancel
C ==============
C
            NEWDAT = .FALSE.
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Store ISZ then deallocate workspace
C
      DO I = N1, MIN(NCOL,ICMAX)
         ISZSAV(I) = ISZ(I)
      ENDDO
      DEALLOCATE (ISZ, STAT = IERR)
      DEALLOCATE (B, STAT = IERR)
      DEALLOCATE (C, STAT = IERR)
      DEALLOCATE (D, STAT = IERR)
      DEALLOCATE (W, STAT = IERR)
      DEALLOCATE (X, STAT = IERR)
      DEALLOCATE (XMEAN, STAT = IERR)
      DEALLOCATE (Y, STAT = IERR)
      DEALLOCATE (E, STAT = IERR)
      DEALLOCATE (WORDX, STAT = IERR)
C
C Format statements
C
  100 FORMAT (
     +'No x,y indicators were found ... consult test file g03adf.tf1')
  200 FORMAT (
     + 'Canonical correlation'
     +/
     +/'Title of current data:'
     +/A
     +/
     +/'Variables'
     +/A
     +/
     +/'Number of x =',1X,A
     +/'Number of y =',1X,A
     +/'Number unused =',1X,A
     +/
     +/'Data: New/Edit/Transform/View'
     +/'Analyse the current data',2X,A
     +/'View/Print/Save X-loadings'
     +/'View/Print/Save Y-loadings'
     +/'Plot eigenvalue scree diagram'
     +/'Plot canonical variates'
     +/'Define data columns as X or Y'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit Canonical Correlation')
  300 FORMAT (
     + 'Select i for XCV: current i in u(i) = (',A,',',I4,')'
     +/'Select j for YCV: current j in v(j) = (',A,',',I4,')'
     +/'Plot: u(i),v(j)'
     +/'Plot: u(i),v(j) and labels'
     +/'Correlate u(i),v(j)'
     +/'Quit ... Exit these options')
  400 FORMAT (
     + ' Canonical correlation analysis:',I3
     +/' ----------------------------------'
     +/' Title of current data:'
     +/1X,A
     +/' Variables:'
     +/1X,A
     +/' Number of x =',1X,A,', Number of y =',1X,A,
     +', Number unused =',1X,A
     +/' Minimum of rank of X and rank of Y =',1X,A,
     +/' Correlations   Eigenvalues  Proportions       Chi-sq.  NDOF',
     +'    p')
  500 FORMAT (F13.4,1X,1P,E13.5,0P,F13.4,1X,1P,E13.5,I6,0P,F8.4)
  550 FORMAT (F13.4,1X,A13,F13.4,1X,A13,I6,F8.4)
  600 FORMAT (' CVX: Canonical coefficients for centralised X')
  700 FORMAT (1P,20(1X,E13.5))
  750 FORMAT (1P,20(1X,A13))
  800 FORMAT (' CVY: Canonical coefficients for centralised Y')
  900 FORMAT (' Canonical Variable',1X,A,'(',I4,')')
 1000 FORMAT (
     + 'Canonical correlation analysis on two subgroups of variables'
     +/
     +/'This technique is used when variables follow a multivariate'
     +/'normal distribution, so it is not suitable for counts, n-point'
     +/'scales, proportions, or categorical variables.'
     +/
     +/'For correlation analysis you require m columns of length n'
     +/'for m variables observed in n related cases, e.g. metabolites'
     +/'A, B, C and D in the same set of 127 patients would require 4'
     +/'columns of length 127. Variables are grouped as of type X or Y,'
     +/'e.g. A and B could constitute group X, with C and D as group Y.'
     +/'You must specify which columns are the X-variables, which are'
     +/'the Y-variables and which (if any) are to be suppressed. This'
     +/'can be done from the data file trailer (see g03adf.tf1). Then'
     +/'the correlations are calculated as the square roots of the'
     +/'eigenvalues of a matrix Sigma, defined in terms of the sample'
     +/'covariance matrices S_{xx}, S_{xy}, S_{yy}, and S_{yx} as'
     +/'Sigma = (S_{yy}^{-1})S_{yx}(S_{xx}^{-1})S_{xy}.'
     +/'Chi-square statistics and scree diagrams can be used to decide'
     +/'on the number of correlations to use, and selected pairs of'
     +/'canonical variates can be plotted or analysed further.')
      END
C
C
