C
C
      DOUBLE PRECISION FUNCTION CDF_BINOMIAL (K, N, NOUT,
     +                                        P)
C
C ACTION : CDF for Binomial distribution
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 21/09/2007
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: K, N, NOUT
      DOUBLE PRECISION, INTENT (IN) :: P
C
C Locals
C      
      INTEGER    IFAIL
      DOUBLE PRECISION PLEK, PGTK, PEQK
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      EXTERNAL  G01BJF$
      EXTERNAL  PUTIFA
      IFAIL = 1
      CALL G01BJF$(N, P, K, PLEK, PGTK, PEQK, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01BJF/CDF_BINOMIAL')
      CDF_BINOMIAL = PLEK
      IF (CDF_BINOMIAL.LT.ZERO) THEN
         CDF_BINOMIAL = ZERO
      ELSEIF (CDF_BINOMIAL.GT.ONE) THEN
         CDF_BINOMIAL = ONE
      ENDIF
      END
C
C