C
C
      DOUBLE PRECISION FUNCTION CDF_CHISQUARE (NOUT,
     +                                         DBLE_N, X)
C
C ACTION: CDF for chi_square distribution
C AUTHOR: W.G.Bardsley, Universoty of Manchester, U.K., 12/09/2007
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: NOUT
      DOUBLE PRECISION, INTENT (IN) :: DBLE_N, X
C
C Locals
C      
      INTEGER    IFAIL
      DOUBLE PRECISION G01ECF$
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      EXTERNAL   G01ECF$
      EXTERNAL   PUTIFA, MIDDLE
      IF (DBLE_N.LE.ZERO .OR. X.LT.ZERO) THEN
C
C Trap bad arguments
C        
         CDF_CHISQUARE = ZERO
      ELSE   
C
C Calulate the cdf
C        
         IFAIL = 1
         CDF_CHISQUARE = G01ECF$('Lower-tail', X, DBLE_N, IFAIL)
         CALL PUTIFA (IFAIL, NOUT, 'G01ECF/CDF_CHISQUARE')
         CALL MIDDLE (ZERO, CDF_CHISQUARE, ONE)
      ENDIF   
      END
C
C