C
C
      DOUBLE PRECISION FUNCTION CDF_NORMAL (NOUT,
     +                                      X, XMU, XSIGMA)
C
C ACTION: cdf for normal distribution
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 10/08/2007
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: NOUT
      DOUBLE PRECISION, INTENT (IN) :: X, XMU, XSIGMA
C
C Locals
C      
      INTEGER    IFAIL
      DOUBLE PRECISION S15ABF$, Z
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      EXTERNAL S15ABF$
      EXTERNAL PUTIFA, MIDDLE
      IF (XSIGMA.LE.ZERO) THEN
C
C Trap for sigma too small 
C        
         CDF_NORMAL = ZERO
      ELSE
C
C Calculate cdf
C        
         Z = (X - XMU)/XSIGMA
         IFAIL = 1
         CDF_NORMAL = S15ABF$(Z, IFAIL)
         CALL PUTIFA (IFAIL, NOUT, 'S15ABF/CDF_NORMAL')
         CALL MIDDLE (ZERO, CDF_NORMAL, ONE)
      ENDIF   
      END
C
C