C
C
      DOUBLE PRECISION FUNCTION CDF_POISSON (K, NOUT,
     +                                       R)
C
C ACTION : CDF for Poisson distribution
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 21/09/2007
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: K, NOUT
      DOUBLE PRECISION, INTENT (IN) :: R
C
C Locals
C      
      INTEGER    IFAIL
      DOUBLE PRECISION PLEK, PGTK, PEQK
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      EXTERNAL  G01BKF$
      EXTERNAL  PUTIFA
      IFAIL = 1
      CALL G01BKF$(R, K, PLEK, PGTK, PEQK, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01BKF/CDF_POISSON')
      CDF_POISSON = PLEK
      IF (CDF_POISSON.LT.ZERO) THEN
         CDF_POISSON = ZERO
      ELSEIF (CDF_POISSON.GT.ONE) THEN
         CDF_POISSON = ONE
      ENDIF
      END
C
C