C
C
      DOUBLE PRECISION FUNCTION CDFFCN (NUMDEC, NUMPAR, 
     +                                  PAR, X)
C
C ACTION : Evaluate cdfs for RSTEST
C AUTHOR : W. G. Bardsley, University of manchester, U.K., 6/12/94
C          05/05/1997 win32 version
C          18/08/1998 increased TOL
C          28/08/1998 added lognormal and Weibull
C          12/02/2001 renamed as CDFFCN and introduced NUMPAR
C          20/08/2001 edited
C          10/08/2007 added INTENTS
C          18/07/2022 defined RTOL, TOL, TOL1, insteda of using X02AMF$
C 
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: NUMDEC, NUMPAR
      DOUBLE PRECISION, INTENT (IN) :: PAR(NUMPAR), X
C
C Locals
C      
      INTEGER    IFAIL, J, K
      DOUBLE PRECISION A, B, P, Q, R, RTOL, TOL, TOL1, Z
      DOUBLE PRECISION G01EAF$, S14AAF$
      DOUBLE PRECISION G01EBF$, G01ECF$, G01EDF$
      PARAMETER (RTOL = 1.0D-290, TOL = LOG(RTOL), TOL1 = -TOL) 
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER  TAIL*1
      PARAMETER (TAIL = 'L')
      EXTERNAL   MIDDLE
      EXTERNAL   G01EAF$, G01EEF$, G01BJF$, G01BKF$, S14BAF$, 
     +           S14AAF$
      EXTERNAL   G01EBF$, G01ECF$, G01EDF$
      INTRINSIC  ABS, NINT, EXP, MAX, LOG, SQRT
C
C Copy PAR into A and B and pre-assign CDFFCN
C
      A = PAR(1)
      IF (NUMDEC.LT.6 .OR. NUMDEC.GT.7) B = PAR(2)
      CDFFCN = ZERO
      IF (NUMDEC.EQ.1) THEN
C
C Uniform
C
         IF (X.LT.A .OR. X.GT.B) RETURN
         P = B - A
         Q = MAX(P, RTOL)
         CDFFCN = (X - A)/Q
      ELSEIF (NUMDEC.EQ.2) THEN
C
C Normal
C
         P = MAX(SQRT(B), RTOL)
         Z = (X - A)/P
         IFAIL = 1
         CDFFCN = G01EAF$(TAIL, Z, IFAIL)
      ELSEIF (NUMDEC.EQ.3) THEN
C
C Gamma
C
         IF (ABS(B).LE.RTOL) RETURN
         Z = X/B
         IFAIL = 1
         CALL S14BAF$(A, Z, RTOL, P, Q, IFAIL)
         Q = S14AAF$(A, IFAIL)
         CDFFCN = P/Q
      ELSEIF (NUMDEC.EQ.4) THEN
C
C Beta
C
         IF (X.LT.ZERO .OR. X.GT.ONE) RETURN
         IFAIL = 1
         CALL G01EEF$(X, A, B, TOL, P, Q, R, IFAIL)
         CDFFCN = P
      ELSEIF (NUMDEC.EQ.5) THEN
C
C Binomial
C
         J = NINT(A)
         K = NINT(X)
         IFAIL = 1
         CALL G01BJF$(J, B, K, P, Q, R, IFAIL)
         CDFFCN = P
      ELSEIF (NUMDEC.EQ.6) THEN
C
C Exponential
C
         P = - X/A
         CALL MIDDLE(TOL, P, TOL1)
         CDFFCN = ONE - EXP(P)
      ELSEIF (NUMDEC.EQ.7) THEN
C
C Poisson
C
         J = NINT(X)
         IFAIL = 1
         CALL G01BKF$(A, J, P, Q, R, IFAIL)
         CDFFCN = P
      ELSEIF (NUMDEC.EQ.8) THEN
C
C Lognormal
C
         P = MAX(SQRT(B), RTOL)
         Z = (LOG(X) - A)/P
         IFAIL = 1
         CDFFCN = G01EAF$(TAIL, Z, IFAIL)
      ELSEIF (NUMDEC.EQ.9) THEN
C
C Weibull
C
         P = - (A*X)**B
         CALL MIDDLE(TOL, P, TOL1)
         CDFFCN = ONE - EXP(P)
      ELSEIF (NUMDEC.EQ.10) THEN
C
C t distribution
C
         IFAIL = 1
         CDFFCN = G01EBF$(TAIL, X, A, IFAIL)
      ELSEIF (NUMDEC.EQ.11) THEN
C
C Chi-square distribution
C
         IFAIL = 1
         CDFFCN = G01ECF$(TAIL, X, A, IFAIL)
      ELSEIF (NUMDEC.EQ.12) THEN
C
C F distribution
C
         IFAIL = 1
         CDFFCN =  G01EDF$(TAIL, X, A, B, IFAIL)
      ENDIF
      END
C
C
