C
C
      DOUBLE PRECISION FUNCTION CDFINV_CHISQUARE (NOUT,
     +                                            DBLE_N, X)
C
C ACTION: INVERSE OF CDF for chi-square distribution
C AUTHOR: W.G.Bardsley, University of manchester, U.K., 12/09/2007
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: NOUT
      DOUBLE PRECISION, INTENT (IN) :: DBLE_N, X
C
C Locals
C      
      INTEGER    IFAIL
      DOUBLE PRECISION G01FCF$
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      EXTERNAL   G01FCF$
      EXTERNAL   PUTIFA
      IF (DBLE_N.LE.ZERO .OR. X.LT.ZERO) THEN
C
C Trap bad arguments
C        
         CDFINV_CHISQUARE = ZERO
      ELSE    
C
C Calculate
C        
         IFAIL = 1
         CDFINV_CHISQUARE = G01FCF$(X, DBLE_N, IFAIL)
         CALL PUTIFA (IFAIL, NOUT, 'G01FCF/CDFINV_CHISQUARE')
         IF (CDFINV_CHISQUARE.LT.ZERO) CDFINV_CHISQUARE = ZERO
      ENDIF     
      END
C
C