C
C
      DOUBLE PRECISION FUNCTION CDFINV_NORMAL (NOUT,
     +                                         P, XMU, XSIGMA)
C
C ACTION: Inverse of cdf
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 10/08/2007
C
      IMPLICIT NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: NOUT     
      DOUBLE PRECISION, INTENT (IN) :: P, XMU, XSIGMA
C
C Locals
C      
      INTEGER    IFAIL
      DOUBLE PRECISION G01FAF$, PCOPY, Z
      DOUBLE PRECISION PMIN, PMAX
      PARAMETER (PMIN = 1.0D-10, PMAX = 1.0D+00 - PMIN)
      EXTERNAL   G01FAF$
      EXTERNAL   PUTIFA, MIDDLE
      PCOPY = P
      CALL MIDDLE (PMIN, PCOPY, PMAX)
      IFAIL = 1
      Z = G01FAF$('Lower-tail', PCOPY, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01FAF/CDFINV_NORMAL')
      CDFINV_NORMAL = XSIGMA*Z + XMU
      END
C
C