C
C
      SUBROUTINE CDFOUT (NGRAF, NUM, NUMDEC, NUMPAR,
     +                   PAR, X, XGRAF, XSTEP, YGRAF, YSTEP,
     +                   PTITLE)
C
C ACTION : Output of CDF plot from RSTEST, etc.
C AUTHOR : W. G. Bardsley, 06/12/1994
C          X must be in increasing order
C          05/05/1997 win32 version ... added CDFFCN (indexed by NUMDEC)
C          18/08/1998 added check on range and number of points
C          05/04/2000 altered line type for best-fit
C          10/04/2000 new calculation of best-fit cdf for Binomial/Poisson
C          07/02/2001 restored two solid lines for discrete cdf
C          12/02/2001 rename CDFVAL to CDFFCN and added NUMPAR
C          22/01/2006 revised
C          14/07/2022 added INTENTS 
C
C  NGRAF: (input/unchanged) dimension of plotting workspace as follows:
C                           Discrete: 2*(X(NUM) - X(1) + 1)
C                           Continuous: CDF curve, say NGRAF = 120
C    NUM: (input/unchanged) sample size
C NUMDEC: (input/unchanged) decision on entry (the distribution number)
C NUMPAR: (input/unchanged) number of parameters in the distribution
C    PAR: (input/unchanged) the parameters of the distribution
C      X: (input/unchanged) the sample
C PTITLE: (input/unchanged) plot title
C XGRAF, XSTEP, YGRAF, YSTEP: workspaces
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN) :: NGRAF, NUM, NUMDEC, NUMPAR
      DOUBLE PRECISION, INTENT (IN) :: PAR(NUMPAR), X(NUM)
      CHARACTER,        INTENT (IN) :: PTITLE*(*)
      DOUBLE PRECISION XGRAF(NGRAF), XSTEP(2*NUM), YGRAF(NGRAF),
     +                 YSTEP(2*NUM)
C
C Locals
C
      INTEGER    L1, L2, L3, L4, M1, M2, M3, M4, N1, N2, N3, N4
      PARAMETER (L3 = 0, L4 = 0, M1 = 0, M2 = 0, M3 = 0, M4 = 0, N3 = 0,
     +           N4 = 0)
      INTEGER    J, K
      DOUBLE PRECISION X3(1), X4(1), Y3(1), Y4(1)
      DOUBLE PRECISION DELTA, RTOL, XDIFF, XTEMP, YVAL1, YVAL2
      DOUBLE PRECISION CDFFCN
      DOUBLE PRECISION X02AMF$
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER  XTITLE*17, YTITLE*26
      LOGICAL    AXES, GSAVE
      PARAMETER (AXES = .TRUE., GSAVE = .TRUE.)
      EXTERNAL   X02AMF$
      EXTERNAL   GKS004
      EXTERNAL   CDFFCN
      INTRINSIC  DBLE
      RTOL = 1.0D+09*X02AMF$()
      XDIFF = X(NUM) - X(1)
      IF (XDIFF.LE.RTOL .OR. NUM.LT.3) then
         RETURN
      ELSE
         IF (NUMDEC.EQ.5 .OR. NUMDEC.EQ.7) THEN
C
C Step function for binomial and Poisson: NGRAF = 2*(X(NUM) - X(1) + 1)
C
            L1 = 1
            L2 = 1
            XTEMP = X(1)
            K = 0
            DO J = 1, NGRAF/2
               K = K + 1
               XGRAF(K) = XTEMP
               IF (K.EQ.1) THEN
                  IF (XTEMP.LT.ONE) THEN
                     YGRAF(K) = ZERO
                  ELSE
                     YGRAF(K) = CDFFCN(NUMDEC, NUMPAR,
     +                                 PAR, XTEMP - ONE)
                  ENDIF
               ELSE
                  YGRAF(K) = YGRAF(K - 1)
               ENDIF
               K = K + 1
               XGRAF(K) = XTEMP
               YGRAF(K) = CDFFCN(NUMDEC, NUMPAR,
     +                           PAR, XGRAF(K))
               XTEMP = XTEMP + ONE
            ENDDO
         ELSE
C
C Continuous cdf for continuous distributions
C
            L1 = 2
            L2 = 1
            XGRAF(1) = X(1)
            YGRAF(1) = CDFFCN(NUMDEC, NUMPAR,
     +                        PAR, XGRAF(1))
            DELTA = (XDIFF)/(DBLE(NGRAF) - ONE)
            DO J = 2, NGRAF - 1
               XGRAF(J) = XGRAF(J - 1) + DELTA
               YGRAF(J) = CDFFCN(NUMDEC, NUMPAR,
     +                           PAR, XGRAF(J))
            ENDDO
            XGRAF(NGRAF) = X(NUM)
            YGRAF(NGRAF) = CDFFCN(NUMDEC, NUMPAR,
     +                            PAR, XGRAF(NGRAF))
         ENDIF
C
C Sample step function
C
         K = 0
         DELTA = ONE/DBLE(NUM)
         YVAL1 = ZERO
         DO J = 1, NUM
            K = K + 1
            XSTEP(K) = X(J)
            YSTEP(K) = YVAL1
            K = K + 1
            YVAL2 = YVAL1 + DELTA
            XSTEP(K) = X(J)
            YSTEP(K) = YVAL2
            YVAL1 = YVAL2
         ENDDO
C
C Plot the values
C
         N1 = NGRAF
         N2 = 2*NUM
         XTITLE = 'The sample values'
         YTITLE = 'Sample Step Function & cdf'
         CALL GKS004 (L1, L2, L3, L4,
     +                M1, M2, M3, M4,
     +                N1, N2, N3, N4,
     +                XGRAF, XSTEP, X3, X4,
     +                YGRAF, YSTEP, Y3, Y4,
     +                PTITLE, XTITLE, YTITLE,
     +                AXES, GSAVE)
      ENDIF
      END
C
C
