C
C
      SUBROUTINE CDFPDF (NCDF, NPDF, CDF, PDF, XBOT, XCDF, XPDF, XTOP,
     +                   YCDF, YPDF,
     +                   PTITLE, XTITLE, YTITLE)
C
C ACTION : Plot PDF and CDF if required between limits A and B supplied
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.4/7/92
C          11/3/93 derived from PDFCDF. Changed argument list and used GKS004
C          DBOS version ... 23/2/94
C          21/4/97 Added CDF and PDF explicitly to argument list
C          Date of this version 21/4/97
C
      IMPLICIT   NONE
      INTEGER    NCDF, NPDF
      INTEGER    L0, L1, L2, N1, N2
      PARAMETER (L0 = 0, L1 = 1, L2 = 2, N1 = 1, N2 = 2)
      INTEGER    I
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4)
      DOUBLE PRECISION CDF, PDF
      DOUBLE PRECISION XBOT, XCDF(NCDF), XPDF(NPDF), XTOP
      DOUBLE PRECISION YPDF(NPDF), YCDF(NCDF)
      DOUBLE PRECISION EPSI, ONE
      PARAMETER (EPSI = 1.0D-20, ONE = 1.0D+00)
      DOUBLE PRECISION A, B, DELTA
      CHARACTER  PTITLE*(*), XTITLE*(*), YTITLE*(*)
      LOGICAL    AXES
      PARAMETER (AXES = .TRUE.)
      LOGICAL    YES
      EXTERNAL   GETRL2, GKS004, YESNO2
      EXTERNAL   CDF, PDF
      INTRINSIC  DBLE
      YES = .FALSE.
      CALL YESNO2 (ICOLOR, IX, IY, 'Display cdf and pdf ?', YES)
      IF (YES) THEN
         CALL GETRL2 (EPSI, XBOT, A, B, XTOP,
     +   'Start-value, then stop-value for independent variable')
         DELTA = (B - A)/(DBLE(NPDF) - ONE)
         XPDF(N1) = A
         DO I = N2, NPDF - N1
            XPDF(I) = XPDF(I - N1) + DELTA
         ENDDO
         XPDF(NPDF) = B
         DO I = N1, NPDF
            YPDF(I) = PDF(XPDF(I))
         ENDDO
         DELTA = (B - A)/(DBLE(NCDF) - ONE)
         XCDF(N1) = A
         DO I = N2, NCDF - N1
            XCDF(I) = XCDF(I - N1) + DELTA
         ENDDO
         XCDF(NCDF) = B
         DO I = N1, NCDF
            YCDF(I) = CDF(XCDF(I))
         ENDDO
         CALL GKS004 (L1, L2, L0, L0, L0, L0, L0, L0,
     +                NPDF, NCDF, NCDF, NCDF,
     +                XPDF, XCDF, XCDF, XCDF, YPDF, YCDF, YCDF, YCDF,
     +                PTITLE, XTITLE, YTITLE, AXES, YES)
      ENDIF
      END
C
C
