C
C
      SUBROUTINE CHECKW (NDOF, WSSQ)
C
C ACTION : Check that WSSQ/NDOF is reasonable before/after curve-fitting
C AUTHOR : W. G. Bardsley, University of Manchester, UK, 10/6/92
C          DBOS version ... 18/2/94
C          Date of this version 26/8/97
C
      IMPLICIT   NONE
      INTEGER    NDOF
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMTXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 2, NUMTXT = 18)
      INTEGER    NUMBLD(NUMTXT)
      DOUBLE PRECISION WSSQ
      DOUBLE PRECISION OBJFUN
      DOUBLE PRECISION BIG, SMALL
      PARAMETER (BIG = 1.0D+08, SMALL = 1.0D-04)
      CHARACTER  CIPHER*22, TEXT(NUMTXT)*100
      LOGICAL    BORDER
      PARAMETER (BORDER = .FALSE.)
      EXTERNAL   PATCH1
      INTRINSIC  DBLE
      DATA       NUMBLD / NUMTXT*0 /
      IF (NDOF.LT.1) RETURN
      OBJFUN = WSSQ/DBLE(NDOF)
      IF (OBJFUN.GT.BIG .OR. OBJFUN.LT.SMALL) THEN
         IF (OBJFUN.GT.BIG) THEN
            CIPHER = 'WSSQ/NDOF is too large'
         ELSE
            CIPHER = 'WSSQ/NDOF is too small'
         ENDIF
         WRITE (TEXT,100) CIPHER, WSSQ, NDOF, OBJFUN
         NUMBLD(1) = 1
         NUMBLD(NUMTXT) = 1
         CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMTXT,
     +                TEXT, BORDER)
      ENDIF
  100 FORMAT (
     + 'WARNING: ',A/
     +/'WSSQ =',1P,E11.3
     +/'NDOF =',I7
     +/'WSSQ/NDOF =',1P,E11.3/
     +/'This program is designed to work best when WSSQ/NDOF is between'
     +/'10 and 10000 before fitting and between 0.1 and 10 after, since'
     +/'WSSQ should be chi-square(NDOF) with expectation = NDOF and the'
     +/'ratios y(i)/s(i) should be of order unity with actual data.'/
     +/'Extreme values can be due to bad starting estimates, the wrong'
     +/'model, exact data, badly chosen weights or units for y(i), etc.'
     +/'and may cause the optimisation routine to perform badly or even'
     +/'to exit without fitting, if the Hessian and gradient cannot be'
     +/'estimated and a sensible search direction calculated.'/
     +/'ADVICE: re-scale-data/check-weights/new-model/start-estimates?')
      END
C
C
