C
C
      SUBROUTINE CHFACT (NCMAX, NCOL, NIN, NF, NRMAX, NROW, NWORK,
     +                   A, W,
     +                   TITLE,
     +                   ABORT, DISPLY, FILE, SUPPLY)
C
C ACTION : Cholesky factorisation of a matrix
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 02/12/2003
C          Derived from QRFACT 02/12/2003
C          08/12/2003 revised
C          01/03/2005 replaced UTRANU by VTRANV
C          16/01/2006 moved Q and R to allocatables 
C          15/10/2006 edited and now copies A into B to avoid overwriting
C          11/05/2010 introduced NKLCFG to switch on/off the test file advice 
C          30/04/2011 introduced call to TFILEQ
C          03/11/2015 removed call to VTRANV and simplified so that Q = L as in A = L(L^T)
C                                                                   R = U as in A = (U^T)U
C
C ADVICE : If successful then on exit ABORT = .FALSE.
C          The routine is silent if SUPPLY is .TRUE. and both DISPLY
C          and FILE are .FALSE.         
C
C          NCMAX: (input/unchanged) max. column dimension 
C           NCOL: (input/output) actual no. columns (depending on SUPPLY)
C            NIN: (input/unchanged) unconnected data input unit 
C             NF: (input/unchanged) preconnected results output unit
C          NRMAX: (input/unchanged) max. row dimension 
C           NROW: (input/output) actual no. rows (SUPPLY)
C          NWORK: (input/unchanged) workspace dimension > 0 
C              A: (input/output) data matrix (depending on SUPPLY)
C              W: workspace only required for MATTIN
C          TITLE: (input/output) title (depending on SUPPLY) 
C          ABORT: (output) failure ?
C         DISPLY: (input/unchanged) table to screen ?
C           FILE: (input/unchanged) output to file ?
C         SUPPLY: (input/unchanged) provide data ? as follows
C                 SUPPLY = .TRUE. then A, NROW, NCOL, TITLE are supplied and
C                                 are unchanged
C                 SUPPLY = .FALSE. then A, NROW, NCOL, TITLE are output 
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER, INTENT (IN)                :: NCMAX, NIN, NF, NRMAX,
     +                                       NWORK
      INTEGER, INTENT (INOUT)             :: NCOL, NROW
      DOUBLE PRECISION, INTENT (INOUT)    :: A(NRMAX,NCMAX), W(NWORK)
      CHARACTER (LEN = *), INTENT (INOUT) :: TITLE
      LOGICAL, INTENT (OUT)               :: ABORT
      LOGICAL, INTENT (IN)                :: DISPLY, FILE, SUPPLY
C
C Local allocatable arrays
C
      DOUBLE PRECISION, ALLOCATABLE :: ACOPY(:,:), Q(:,:), R(:,:)
C
C Locals
C
      INTEGER    NCOL1, NROW1, NSIZE
      INTEGER    I, ICOUNT, IERR, J
      INTEGER    KVAL9, NKLCFG
      INTEGER    N0, N1, N2, N21
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N21 = 21)
      INTEGER    NTEXT1, NTYPE
      PARAMETER (NTEXT1 = 1, NTYPE = 3)
      INTEGER    NUMDEC, NUMOPT, NUMSTA, NUMTXT
      PARAMETER (NUMOPT = 7, NUMSTA = 8, NUMTXT = NUMSTA + NUMOPT - 1)
      INTEGER    NUMBLD(NUMTXT)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER (LEN = 1024) FNAME, FNAME1
      CHARACTER (LEN = 100 ) LINE, TEXT(NUMTXT)
      CHARACTER (LEN = 80  ) CHOP80, TITLE1, WORD80, TEXT1(NTEXT1)
      CHARACTER (LEN = 12  ) FORM12, WORD12
      CHARACTER (LEN = 1   ) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    ABORT1, FILE1, FILE2, FILE3, REPEET
      LOGICAL    FIXCOL, FIXROW, LABEL
      PARAMETER (FIXCOL = .FALSE., FIXROW = .FALSE., LABEL = .TRUE.)
      LOGICAL    HEADER, QTEXT, QTITLE
      PARAMETER (HEADER = .TRUE., QTEXT = .TRUE., QTITLE = .TRUE.)
      EXTERNAL   MATTIN, PUTFAT, DSPLAY, CHOP80, LSTBOX, MATOUT, FORM12, 
     +           REVPRO
      EXTERNAL   F07FDF$
      EXTERNAL   NKLCFG, TFILEQ
      SAVE       ICOUNT
      DATA       ICOUNT / 0 /
      DATA       NUMBLD / NUMTXT*0 /
C
C Read in the matrix if .NOT.SUPPLY
C           
      IF (.NOT.SUPPLY) THEN
         KVAL9 = NKLCFG(N21)
         IF (KVAL9.EQ.N1) THEN
            WRITE (LINE,100)
            CALL TFILEQ (LINE)
         ENDIF   
         I = N0
         CLOSE (UNIT = NIN)
         CALL MATTIN (I, NCMAX, NCOL, NIN, NRMAX, NROW,
     +                A, W,
     +                FNAME, TITLE,
     +                ABORT, FIXCOL, FIXROW, LABEL)
         CLOSE (UNIT = NIN)
         IF (ABORT) RETURN
      ENDIF 
C
C Initialise ABORT = .TRUE.
C
      ABORT = .TRUE.
C
C Check the dimensions and for NCOL = NROW
C
      IF (NCOL.LT.N2 .OR. NROW.LT.N2 .OR. NCOL.NE.NROW) THEN
          IF (DISPLY) THEN
             WRITE (LINE,200)
             CALL PUTFAT (LINE)
          ENDIF
          RETURN
      ENDIF
      IF (NROW.GT.NCMAX .OR. NROW.GT.NRMAX) THEN
         IF (DISPLY) THEN
            WRITE (LINE,300)
            CALL PUTFAT (LINE)
         ENDIF
         RETURN
      ENDIF
      IF (NWORK.LT.1) THEN
         IF (DISPLY) THEN
            WRITE (LINE,400)
            CALL PUTFAT (LINE)
         ENDIF
         RETURN
      ENDIF
C
C Allocate workspace 
C
      IERR = 0 
      IF (ALLOCATED(ACOPY)) DEALLOCATE(ACOPY, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(Q)) DEALLOCATE(Q, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(R)) DEALLOCATE(R, STAT = IERR)
      IF (IERR.NE.0) RETURN 
      NSIZE = NROW + 2
      ALLOCATE(ACOPY(NSIZE,NSIZE), STAT = IERR)
      IF (IERR.NE.0) RETURN 
      ALLOCATE(Q(NSIZE,NSIZE), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(R(NSIZE,NSIZE), STAT = IERR)
      IF (IERR.NE.0) RETURN
      DO J = 1, NSIZE
         DO I = 1, NSIZE
            Q(I,J) = ZERO
            R(I,J) = ZERO
         ENDDO
      ENDDO        
C
C Copy A into ACOPY, Q and R then factorise
C      
      DO I = 1, NROW
         DO J = 1, NCOL
            ACOPY(I,J) = A(I,J)
         ENDDO
      ENDDO                                  
      DO I = 1, NROW
         DO J = 1, I
            Q(I,J) = A(I,J)
         ENDDO
         DO J = I, NCOL
            R(I,J) = A(I,J)
         ENDDO   
      ENDDO
      CALL F07FDF$('L', NCOL, Q, NSIZE, I)
      IF (I.EQ.0) THEN
         CALL F07FDF$('U', NCOL, R, NSIZE, I)
         IF (I.EQ.0) ABORT = .FALSE.
      ENDIF     
      IF (ABORT) THEN
         IF (DISPLY) THEN
            WRITE (LINE,500)
            CALL PUTFAT (LINE)
         ENDIF    
         DEALLOCATE(ACOPY, STAT = IERR)       
         DEALLOCATE(Q, STAT = IERR)
         DEALLOCATE(R, STAT = IERR)
         RETURN
      ENDIF
      WORD12 = FORM12(NCOL)
      WORD80 = CHOP80(TITLE)
      ICOUNT = ICOUNT + N1
      IF (FILE) WRITE (NF,600) ICOUNT, WORD80
      IF (DISPLY) THEN
C
C Output
C
         FILE1 = FILE
         FILE2 = FILE
         FILE3 = FILE
         REPEET = .TRUE.
         DO WHILE (REPEET)
            WRITE (TEXT,700) ICOUNT, WORD80, WORD12
            NUMDEC = NUMOPT
            NUMBLD(1) = 1
            NUMBLD(4) = 1
            CALL LSTBOX (NUMBLD, NUMDEC, NUMOPT, NUMSTA, NUMTXT,
     +                   TEXT)
            NUMBLD(1) = 0
            NUMBLD(4) = 0
            IF (NUMDEC.EQ.1) THEN
C
C Display A
C
               NCOL1 = NCOL
               NROW1 = NROW
               WRITE (LINE,800)
               CALL DSPLAY (NSIZE, NCOL1, NF, NSIZE, NROW1, NTYPE,
     +                      ACOPY,
     +                      LINE,
     +                      FILE1)
               FILE1 = .FALSE.
            ELSEIF (NUMDEC.EQ.2) THEN
C
C Display Q = lower triangle as in A = L(L^T) 
C
               NCOL1 = NCOL
               NROW1 = NROW
               WRITE (LINE,900)
               CALL DSPLAY (NSIZE, NCOL1, NF, NSIZE, NROW1, NTYPE,
     +                      Q,
     +                      LINE,
     +                      FILE2)
               FILE2 = .FALSE.
C
C Display R = upper triangle as in A = (U^T)U
C
            ELSEIF (NUMDEC.EQ.3) THEN
               NCOL1 = NCOL
               NROW1 = NROW
               WRITE (LINE,1000)
               CALL DSPLAY (NSIZE, NCOL1, NF, NSIZE, NROW1, NTYPE,
     +                      R,
     +                      LINE,
     +                      FILE3)
               FILE3 = .FALSE.
            ELSEIF (NUMDEC.EQ.4) THEN
C
C Save Q As ...
C
               TITLE1 = 'Lower Cholesky triangle as in A = L(L^T)' 
               TEXT1(1) = BLANK
               CLOSE (UNIT = NIN)
               I = N1
               CALL MATOUT (I, NCOL, NIN, NSIZE, NCOL,
     +                      NTEXT1,
     +                      Q,
     +                      FNAME1, TEXT1, TITLE1,
     +                      ABORT1, HEADER, QTEXT, QTITLE)
               CLOSE (UNIT = NIN)
            ELSEIF (NUMDEC.EQ.5) THEN
C
C Save R As ...
C
               TITLE1 = 'Upper Cholesky triangle as in A = (U^T)U'
               TEXT1(1) = BLANK
               CLOSE (UNIT = NIN)
               I = N1
               CALL MATOUT (I, NCOL, NIN, NSIZE, NCOL,
     +                      NTEXT1,
     +                      R,
     +                      FNAME1, TEXT1, TITLE1,
     +                      ABORT1, HEADER, QTEXT, QTITLE)
               CLOSE (UNIT = NIN)
            ELSEIF (NUMDEC.EQ.6) THEN
C
C Review progress
C            
               CALL REVPRO (NF)   
            ELSE
               REPEET = .FALSE.
            ENDIF
         ENDDO
      ENDIF
C
C OK so set ABORT = .FALSE.
C
      ABORT = .FALSE.
C
C Deallocate workspace
C             
      DEALLOCATE(ACOPY, STAT = IERR)       
      DEALLOCATE(Q, STAT = IERR)
      DEALLOCATE(R, STAT = IERR)
C
C Format statements
C
  100 FORMAT (
     +'Now input a pos-def symmetric matrix formatted like matrix.tf3')
  200 FORMAT ('Not a matrix ... Must have m, n > 1, and m = n')
  300 FORMAT ('Matrix is too large to analyse')
  400 FORMAT ('NWORK < 1 in call to CHFACT')
  500 FORMAT ('Matrix is not positive definite')
  600 FORMAT (
     +/'The Cholesky factorisation of a matrix',I3
     +/'========================================='
     +/
     +/'Title of data:'
     +/A)
  700 FORMAT (
     + 'The Cholesky factorisation of a matrix',I3
     +/
     +/'Title of data:'
     +/A
     +/
     +/'Number of rows/columns =',1x,a
     +/
     +/'Display current matrix A'
     +/'Display lower triangle L as in A = L(L^T)'
     +/'Display upper triangle U as in A = U(U^T)'
     +/'File: Save lower triangle L As ...'
     +/'File: Save upper triangle U As ...'
     +/'Results'
     +/'Quit ... Exit Cholesky factorisation options')
  800 FORMAT ('Current positive-definite symmetric matrix')
  900 FORMAT ('Lower triangular L as in A = L(L^T)')
 1000 FORMAT ('Upper triangular U as in A = (U^T)U')
      END
C
C
