C
C
      SUBROUTINE CHISQD (N, NDOF, NOUT, CHISQ, E, O, PGCHI, P95, P99)
C
C ACTION : Perform Chi-square test
C SUPPLY : Number of observations (BINS) :- N
C          Observed values :- O(1), O(2), ..., O(N)
C          Expected values :- E(1), E(2), ..., E(N)
C          Number of degrees of freedom :- NDOF
C RETURN : Chi-square value :- CHISQ
C          P(Chi-square>=CHISQ) :- PGCHI
C          95% and 99% critical values :- P95 and P99
C ADVICE : Write NAG failures to UNIT = NOUT
C NAG    : G01ECF, G01FCF, X02AMF
C AUTHOR : W. G. Bardsley, 29/06/90
C          17/10/95 Replaced old G01 routines G01BCF and G01CCF
C                   with MARK 16 equivalents  G01ECF and G01FCF
C          Date of this version 5/4/97
C
      IMPLICIT   NONE
      INTEGER    N, NDOF, NOUT
      INTEGER    I, IFAIL
      DOUBLE PRECISION E(N), O(N)
      DOUBLE PRECISION PNT95, PNT99
      PARAMETER (PNT95 = 0.95D+00, PNT99 = 0.99D+00)
      DOUBLE PRECISION CHISQ, PGCHI, P95, P99
      DOUBLE PRECISION RTOL
      DOUBLE PRECISION G01ECF$, G01FCF$, X02AMF$
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER (LEN = 100) LINE
      EXTERNAL   PUTWAR, PUTIFA
      EXTERNAL   G01ECF$, G01FCF$, X02AMF$
      INTRINSIC  DBLE
      RTOL = 1.0D+09*X02AMF$()
      CHISQ = ZERO
      IFAIL = 0
      DO I = 1, N
         IF (E(I).GT.RTOL) THEN
            CHISQ = CHISQ + (E(I) - O(I))**2/E(I)
         ELSE
            IFAIL = IFAIL + 1
            WRITE (LINE,100) IFAIL, I
         ENDIF
      ENDDO
      IF (IFAIL.GT.0) CALL PUTWAR (LINE)
      IFAIL = 1
      PGCHI = G01ECF$('Upper', CHISQ, DBLE(NDOF), IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01ECF/CHISQD')
      IFAIL = 1
      P95 = G01FCF$(PNT95, DBLE(NDOF), IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01FCF/CHISQD')
      IFAIL = 1
      P99 = G01FCF$(PNT99, DBLE(NDOF), IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01FCF/CHISQD')
  100 FORMAT (
     +I4,' Errors like ... Expected(',I4,') too small for chi-sqd')
      END
C
C
