C
C
      SUBROUTINE CLIM95 (NIN, NOUT)
C
C ACTION : 95% confidence limits (also 90% and 99%)
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 6/9/98
C          08/08/1999 Added call to TRINOM
C          07/04/2000 Added x-bar and n to Poisson
C          03/02/2001 Added defaults to edit boxes abd revised limits
C          30/01/2003 Added call to TTEST2
C          24/12/2005 Minor editing to clarify meaning of arguments
C          22/09/2007 Now calls m_matone for trinomial contours
C          12/03/2016 Improved output formats
C          28/11/2021 Added E_NUMBERS and E_FORMATS, etc.
C
C   NIN: (input/unchanged) unconnected unit for data input
C  NOUT: (input/unchanged) preconnected unit for results
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER, INTENT (IN) :: NIN, NOUT
C
C Locals
C
      INTEGER    I, IFAIL, ILIM, ISEND, KX, N, NCOL, NUM,NROW
      INTEGER    N0, N1, N2, N3, N20, NHUGE
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N20 = 20,
     +           NHUGE = 100000000)
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NUMOPT = 10,
     +           NSTART = 3, NTEXT = NSTART + NUMOPT - 1)
      INTEGER    NUMBLD(N20), NUMPOS(NUMOPT)
      DOUBLE PRECISION EPSI, XTOL
      DOUBLE PRECISION CLEVEL, DOF, PHAT1, PHAT2, PHIGH, PLOW
      DOUBLE PRECISION CHIU95, CHIL95, ROOTN, STDERR, RNUM,
     +                 T95, VARHAT, XMH95, XML95, XMUHAT, XSIGMA, XVL95,
     +                 XVU95
      DOUBLE PRECISION DENOM, R, RL1, RL2, W
      DOUBLE PRECISION ZERO, HALF, ONE, TWO, F100
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00, F100 = 100.0D+00)
      DOUBLE PRECISION PNT005, PNT025, PNT05, PNT95, PNT975, PNT995
      PARAMETER (PNT005 = 0.005D+00, PNT025 = 0.025D+00,
     +           PNT05 = 0.05D+00, PNT95 = 0.95D+00,
     +           PNT975 = 0.975+00, PNT995 = 0.995D+00)
      DOUBLE PRECISION G01FCF$, G01FBF$
      CHARACTER (LEN = 1024) FNAME
      CHARACTER (LEN = 100 ) LINE, TEXT(30) 
      CHARACTER (LEN = 80  ) TITLE*80 
      CHARACTER (LEN = 13  ) D13(3), SHOWLJ
      CHARACTER (LEN = 12  ) FORM12, WORD12(4)
      CHARACTER (LEN = 9   ) WORD9(3)
      CHARACTER (LEN = 1   ) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    BORDER, FLASH, HIGH
      LOGICAL    REPEET
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   E_FORMATS, SHOWLJ
      EXTERNAL   LBOX01, PUTFAT, PUTIFA, REVPRO,
     +           PHAT95, GETDGE, GETD01, GETJM1, PUTTXT, PATCH1,
     +           GETDM1, GETJGE, TTEST2, M_MATONE, FORM12, METACL
      EXTERNAL   G01FCF$, G01FBF$, G07ABF$
      INTRINSIC  ABS, DBLE
      SAVE       ILIM
      SAVE       N, NUM, KX
      SAVE       PHAT1, PHAT2, R, XMUHAT, XSIGMA
      SAVE       NCOL, NROW, FNAME, TITLE
      DATA       ILIM / 95 /
      DATA       N, NUM, KX / N20, N20, N1 /
      DATA       PHAT1, PHAT2, R, XMUHAT, XSIGMA / ONE, HALF, ZERO,
     +                                             ZERO, ONE /
      DATA       NUMBLD / N20*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       NCOL, NROW / 0, 0 /
      DATA       FNAME, TITLE / BLANK, BLANK /
C
C Initialise
C
      E_NUMBERS = E_FORMATS()
      NUMBLD(1) = 1
      NUMDEC = NUMOPT - 2
      EPSI = 1.0D-06
      XTOL = 1.0D-99
      REPEET = .TRUE.
      DO WHILE (REPEET)
C
C Decide
C
         WRITE (TEXT,100) ILIM
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT, TEXT, BORDER, FLASH, HIGH)
         CLEVEL = DBLE(ILIM)/F100
         IF (NUMDEC.EQ.1) THEN
C
C Poisson
C
            CALL GETJGE (N, N1,
     +'The sample size used to calculate the sample mean (i.e. N > 0)')
            IF (N.GT.NHUGE) THEN
               CALL PUTFAT ('Too large')
            ELSE
               CALL GETDGE (PHAT1, EPSI,
     +'The Poisson parameter (i.e. the sample mean, lambda > 0)')
               IFAIL = 0
               CALL G07ABF$(N, PHAT1, CLEVEL, PLOW, PHIGH, IFAIL)
               CALL PUTIFA (IFAIL, NOUT, 'G01ABF/CLIM95')
               WORD12(1) = FORM12(N)
               IF (E_NUMBERS) THEN
                  WRITE (WORD12(2),'(1P,E12.5)') PHAT1
                  WRITE (WORD12(3),'(1P,E12.5)') PLOW
                  WRITE (WORD12(4),'(1P,E12.5)') PHIGH
                  WRITE (LINE,200) TRIM(WORD12(1)), WORD12(2), ILIM,
     +                             WORD12(3), WORD12(4)
              ELSE
                 D13(1) = SHOWLJ(PHAT1)
                 D13(2) = SHOWLJ(PLOW)
                 D13(3) = SHOWLJ(PHIGH)   
                 WRITE(LINE,250) TRIM(WORD12(1)), TRIM(D13(1)), ILIM, 
     +                           TRIM(D13(2)), TRIM(D13(3)) 
              ENDIF  
              WRITE (NOUT,'(A)') LINE
           ENDIF
        ELSEIF (NUMDEC.EQ.2) THEN
C
C Binomial
C
            CALL GETJGE (N, N1,
     +     'The number of binomial trials (i.e. N > 0)')
            IF (N.GT.NHUGE) THEN
               CALL PUTFAT ('Too large')
            ELSE
               CALL GETJM1 (N0, KX, N,
     +    'The total number of successes (i.e. X in N trials)')
               CALL PHAT95 (ILIM, KX, N, NOUT, PLOW, PHAT2, PHIGH)
               WRITE (WORD9(1),'(F9.6)') PHAT2
               WRITE (WORD9(2),'(F9.6)') PLOW
               WRITE (WORD9(3),'(F9.6)') PHIGH
               WORD12(1) = FORM12(KX)
               WORD12(2) = FORM12(N)
               WRITE (LINE,300) TRIM(WORD12(1)), TRIM(WORD12(2)),
     +                          WORD9(1), ILIM, WORD9(2), WORD9(3)
               WRITE (NOUT,300) TRIM(WORD12(1)), TRIM(WORD12(2)),
     +                          WORD9(1), ILIM, WORD9(2), WORD9(3)
            ENDIF
      ELSEIF (NUMDEC.EQ.3) THEN
C
C Normal
C
            CALL GETJGE (NUM, N2, 'The sample size (N > 1)')
            RNUM = DBLE(NUM)
            CALL GETD01 (XMUHAT, 'The sample mean')
            CALL GETDGE (XSIGMA, XTOL, 'The sample standard deviation')
            VARHAT = XSIGMA**2
            ROOTN = SQRT(RNUM)
            STDERR = XSIGMA/ROOTN
            IFAIL = 1
            DOF = RNUM - ONE
            IF (ILIM.EQ.90) THEN
               T95 = G01FBF$('Lower-tail', PNT95, DOF, IFAIL)
            ELSEIF (ILIM.EQ.95) THEN
               T95 = G01FBF$('Lower-tail', PNT975, DOF, IFAIL)
            ELSEIF (ILIM.EQ.99) THEN
               T95 = G01FBF$('Lower-tail', PNT995, DOF, IFAIL)
            ENDIF
            CALL PUTIFA (IFAIL, NOUT, 'G01FBF/CLIM95')
            XML95 = XMUHAT - T95*STDERR
            XMH95 = XMUHAT + T95*STDERR
            IFAIL = 1
            IF (ILIM.EQ.90) THEN
               CHIL95 = G01FCF$(PNT05, DOF, IFAIL)
            ELSEIF (ILIM.EQ.95) THEN
               CHIL95 = G01FCF$(PNT025, DOF, IFAIL)
            ELSEIF (ILIM.EQ.99) THEN
               CHIL95 = G01FCF$(PNT005, DOF, IFAIL)
            ENDIF
            CALL PUTIFA (IFAIL, NOUT, 'G01FCF/CLIM95')
            IFAIL = 1
            IF (ILIM.EQ.90) THEN
               CHIU95 = G01FCF$(PNT95, DOF, IFAIL)
            ELSEIF (ILIM.EQ.95) THEN
               CHIU95 = G01FCF$(PNT975, DOF, IFAIL)
            ELSEIF (ILIM.EQ.99) THEN
               CHIU95 = G01FCF$(PNT995, DOF, IFAIL)
            ENDIF
            CALL PUTIFA (IFAIL, NOUT, 'G01FCF/CLIM95')
            XVL95 = DOF*VARHAT/CHIU95
            XVU95 = DOF*VARHAT/CHIL95
            WORD12(1) = FORM12(NUM)
            IF (E_NUMBERS) THEN
               WRITE (WORD12(2),'(1P,E12.5)') XMUHAT
               WRITE (WORD12(3),'(1P,E12.5)') XML95
               WRITE (WORD12(4),'(1P,E12.5)') XMH95
               WRITE (LINE,400) TRIM(WORD12(1)), WORD12(2), ILIM,
     +                       WORD12(3), WORD12(4)
            ELSE
               D13(1) = SHOWLJ(XMUHAT)
               D13(2) = SHOWLJ(XML95)
               D13(3) = SHOWLJ(XMH95)
               WRITE (LINE,400) TRIM(WORD12(1)), TRIM(D13(1)), ILIM,
     +                          TRIM(D13(2)), TRIM(D13(3))
            ENDIF
            CALL PUTTXT (LINE)                
            WRITE(NOUT,'(A)') LINE
            
            IF (E_NUMBERS) THEN 
               WRITE (WORD12(2),'(1P,E12.5)') VARHAT
               WRITE (WORD12(3),'(1P,E12.5)') XVL95
               WRITE (WORD12(4),'(1P,E12.5)') XVU95
               WRITE (LINE,500) TRIM(WORD12(1)), WORD12(2), ILIM,
     +                          WORD12(3), WORD12(4)
            ELSE
               D13(1) = SHOWLJ(VARHAT)
               D13(2) = SHOWLJ(XVL95)
               D13(3) = SHOWLJ(XVU95)  
               WRITE (LINE,500) TRIM(WORD12(1)), TRIM(D13(1)), ILIM,
     +                          TRIM(D13(2)), TRIM(D13(3))
            ENDIF  
            WRITE (NOUT,'(A)') LINE
         ELSEIF (NUMDEC.EQ.4) THEN
C
C Correlation coefficient
C
            CALL GETJGE (NUM, N3, 'The sample size (N > 2)')
            RNUM = DBLE(NUM)
            CALL GETDM1 (- ONE, R, ONE, 'The correlation coefficient r')
            IFAIL = 1
            DOF = RNUM - TWO
            IF (ILIM.EQ.90) THEN
               T95 = G01FBF$('Lower-tail', PNT95, DOF, IFAIL)
            ELSEIF (ILIM.EQ.95) THEN
               T95 = G01FBF$('Lower-tail', PNT975, DOF, IFAIL)
            ELSEIF (ILIM.EQ.99) THEN
               T95 = G01FBF$('Lower-tail', PNT995, DOF, IFAIL)
            ENDIF
            CALL PUTIFA (IFAIL, NOUT, 'G01FBF/CLIM95')
            W = SQRT(T95**2/(T95**2 + DOF))
            DENOM = ONE - R*W
            IF (ABS(DENOM).LE.XTOL) THEN
               CALL PUTFAT ('Singular case ...  Calculation impossible')
            ELSE
               RL1 = (R - W)/DENOM
               DENOM = ONE + R*W
               IF (ABS(DENOM).LE.XTOL) THEN
                  CALL PUTFAT (
     +           'Singular case ...  Calculation impossible')
               ELSE
                  RL2 = (R + W)/DENOM
                  WORD12(1) = FORM12(NUM)
                  IF (E_NUMBERS) THEN
                     WRITE (WORD9(1),'(F9.6)') R
                     WRITE (WORD9(2),'(F9.6)') RL1
                     WRITE (WORD9(3),'(F9.6)') RL2
                     WRITE (LINE,600) TRIM(WORD12(1)), WORD9(1), ILIM, 
     +                                WORD9(2), WORD9(3)
                  ELSE 
                     D13(1) = SHOWLJ(R)
                     D13(2) = SHOWLJ(RL1)
                     D13(3) = SHOWLJ(RL2)
                     WRITE (LINE,600) TRIM(WORD12(1)), TRIM(D13(1)),
     +                                ILIM, TRIM(D13(2)), TRIM(D13(3)) 
                  ENDIF  
                  WRITE (NOUT,'(A)') LINE
               ENDIF
            ENDIF
         ELSEIF (NUMDEC.EQ.5) THEN
C
C Trinomial contours
C
            ISEND = 32
            CALL M_MATONE (ISEND, NCOL, NIN, NOUT, NROW,
     +                     FNAME, TITLE)            
         ELSEIF (NUMDEC.EQ.NUMOPT - 4) THEN
C
C Significance level
C
            ISEND = 1
            CALL METACL (ISEND, ILIM, I)
         ELSEIF (NUMDEC.EQ.NUMOPT - 3) THEN
C
C Compare two parameters
C
            CALL TTEST2 (NOUT)
         ELSEIF (NUMDEC.EQ.NUMOPT - 2) THEN
C
C Help
C
            WRITE (TEXT,1000)
            CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, N20,
     +                   TEXT,
     +                   BORDER)
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
C
C Results
C
            CALL REVPRO (NOUT)
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            REPEET = .FALSE.
         ENDIF
         IF (NUMDEC.LT.5) CALL PUTTXT (LINE)
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Options available for ',I2,'% confidence limits'
     +/
     +/'Poisson'
     +/'Binomial'
     +/'Normal'
     +/'Correlation coefficient'
     +/'Plot Trinomial Contours'
     +/'Change significance level'
     +/'Compare two parameter estimates'
     +/'Help'
     +/'Results'
     +/'Quit ... Exit confidence level options')
  200 FORMAT ('Poisson lambda: N = ',A,
     +', Estimate =',A,',',I3,'%cl = (',A,',',A,')')
  250 FORMAT ('Poisson lambda: N = ',A,
     +', Estimate =',1X,A,',',I3,'%cl = (',A,',',A,')')   
  300 FORMAT ('Binomial p: X = ',A,', N = ',A,
     +', Estimate =',A,',',I3,'%cl = (',A,',',A,')')
  400 FORMAT ('  Normal mean: N = ',A,', Estimate =',1X,A,',',
     +I3,'%cl = (',A,',',A,')')
  500 FORMAT ('     Variance: N = ',A,',',' Estimate =',1X,A,',',
     +I3,'%cl = (',A,',',A,')')
  600 FORMAT ('Correlation r: N = ',A,',',' Estimate =',1X,A,',',
     +I3,'%cl = (',A,',',A,')')
 1000 FORMAT (
     + 'Estimating parameter confidence limits'
     +/
     +/'When parameters have been estimated from samples it is often'
     +/'useful to calculate % confidence limits. This can be done by'
     +/'inverting the standard distributions (t, chi-square, F, etc)'
     +/'giving confidence intervals that are usually non-central.'
     +/
     +/'Poisson: input N and X-bar then estimate lambda (by chi-square)'
     +/
     +/'Binomial: input N and X then estimate p (by F)'
     +/
     +/'Normal: input N, X-bar and s then estimate mu (by t) and sigma'
     +/'              squared (by chi-square)'
     +/
     +/'r: input N and correlation coefficient then estimate rho (by t)'
     +/
     +/'Trinomial Contour Plots: input x, y, N (as in trinom.tf1)'
     +/
     +/'The range: this can be 90%, 95% or 99%'
     +/)
      END
C
C
