
c
c
      subroutine clust1 (iwk, ncmax, ncsav, ndmax, nin, nout, nrmax,
     +                   nrsav, nsmall,
     +                   a, d,
     +                   fname, fsav, title, tsav,
     +                   newdat, supply)
c
c action: cluster analysis by dendrogram creation
c author: w.g.bardsley, university of manchester, u.k., 10/06/2001
c         01/02/2002 added ncsav, nrsav, nsmall, fsav, title, tsav
c         28/09/2002 increased nisx from 300 to 500
c         07/10/2002 increased nisx from 500 to 1000 and introduced nvmax
c                    to dimension isx(nvmax) instead of isx(nisx)
c         17/10/2002 altered defaults for itype and type1 and added extra
c                    advice if ifail = 3 due to median or centroid
c         24/10/2002 introduced r, x, pcawts and pcatrn
c         15/04/2004 added isxedi, isxtyp, and isxvec
c         06/01/2005 added call to dendr2 and dendr3
c         17/05/2005 added call to clust4 to view/file save distance matrix
c                    and added calls to savvec
c         19/07/2005 increased nisx to 2000, rearranged call to getwrd, added
c                    savwrd and getlbl to save or replace dendrogram labels
c                    and improved the tutorial and program layout
c         11/01/2006 changed arguments b, r, s, w1, x to allocatables
c         05/03/2006 added newdat and supply to arguments list
c         26/07/2006 introduced nbig to dimension b correctly when ncmax > 2*nrmax
c         02/11/2006 introduced eofint and several other improvements
c         11/11/2006 introduced allpos in call to eofint
c         19/12/2007 made nisx = max(nrmax + ncmax, 2000) and added nwmax and
c                    plot_labels option
c         26/05/2008 suppressed calls to savvec to store d ... may be needed again
c                    if it is wished to communicate d with dmat01
c         30/06/2008 added Canberra metric
c         30/10/2009 used savvec to preserve distance matrix which is altered by g03ecf 
c         05/02/2010 added wordx and nisx in call to dendr2 and deleted nrmax and x in
c                    call to dendr1 to prevent dendr1 altering x
c         04/04/2011 added call to puterr 
c         08/02/2017 ndmax is now kind = 7
c         27/12/2021 added word9, form09, and trim
c
c           iwk: workspace
c         ncmax: (input/unchanged) column dimension
c         ncsav: (input/output) as follows:
c                ncsav =< 0 on entry or exit means no current data
c                ncsav > 0 on entry or exit means current data with ncsav columns
c         ndmax: (input/unchanged) dimension for distance matrix >= n(n - 1)/2
c           nin: (input/unchanged) unconnected unit for data input
c          nout: (input/unchanged) preconnected unit for results
c         nrmax: (input/unchanged) leading row dimension
c         nrsav: (input/output) as follows:
c                nrsav =< 0 on entry or exit means no current data
c                nrsav > 0 on entry or exit means current data with nrsav rows
c        nsmall: (input/unchanged) dimension for saved file/title names
c             a: (input/output) the current data matrix if ncsav and nrsav > 0
c        b, d, r, s, w1, x: workspaces
c        fname, fsav, title, tsav: (input/output) depending on ncsav and nrsav
c                                   fname and title are for the current data and
c                                   fsav and tsav store for data selection and are
c                                   only used for archiving and data retrieval.
c                                   They can be ignored if this routine is stand-alone
c        newdat: (output) set to .true. if new data set required
c        supply: (input/unchanged) if .true. then data matrix is supplied
c
      implicit   none
c
c arguments
c
      integer (kind = 7),  intent (in)    :: ndmax
      integer,             intent (in)    :: ncmax, nrmax, nsmall 
      integer,             intent (in)    :: nin, nout
      integer,             intent (inout) :: ncsav, nrsav
      integer,             intent (inout) :: iwk(5*nrmax)
      double precision,    intent (inout) :: a(nrmax,ncmax), d(ndmax)
      character (len = *), intent (inout) :: fname, fsav(nsmall), title,
     +                                       tsav(nsmall)
      logical,             intent (in)    :: supply 
      logical,             intent (out)   :: newdat
c
c
c local allocatable arrays
c
      integer,              allocatable :: isx(:)
      double precision,     allocatable :: b(:), r(:), s(:), w1(:),
     +                                     x(:,:), x_hook(:,:)
      character (len = 40), allocatable :: wordx(:)
c
c locals
c
      integer    i, icount, isend, j, ncol, nrow, nvar
      integer    ierr, ifail, ldx, m, method, n, nbig, nsav
      integer    nptcol, nptrow
      integer    icolor, ix, iy, lshade, numdec, nstart, ntext, numopt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1)
      integer    nlarge1, nlarge2
      parameter (nlarge1 = 1000, nlarge2 = nlarge1/4)
      integer    nisx, nvmax, nwmax, nxmin
      parameter (nvmax = 100, nwmax = 2000, nxmin = 1)
      integer    isxsav(nvmax), itype(4), numbld(30), numpos(20)
      double precision dmax, rtol, thresh
      double precision zero, one, f100
      parameter (zero = 0.0d+00, one = 1.0d+00, f100 = 100.0d+00)
      double precision x02amf$
      character (len = 9 ) word9, form09
      character  line*100, text(30)*100, text9(9)*100
      character  info(30)*100
      character  chop80*80, word80*80
      character  cipher*40, type1(4)*40
      character  dist*1, scale1*1, update*1
      character  ptitle*80, xtitle*1, ytitle*30
      parameter (xtitle = ' ')
      character  blank*1, no_labels*11, too_many*80
      parameter (blank = ' ',
     +       no_labels = '%no_labels%',
     +        too_many = 'Too many labels to plot ... maximum = 2000')
      logical    first
      logical    abort, done, ok, plot_labels, ready, repeet, weight,
     +           wtd
      logical    action, done_it, showit, simmat, store
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .true.)
      logical    ffiles, frame, next, updown
      parameter (ffiles = .true., frame = .false., updown = .true.)  
      logical    allpos
      parameter (allpos = .true.)
      external   form09
      external   lbox01, lbox02, statmt, chop80, putadv, dendr2,
     +           putifa, tutor1, dendr1, getdge, clust4, 
     +           revpro, getwrd, pcawts, pcatrn, isxedi, isxtyp, isxvec,
     +           savwrd, getlbl, eofint, waiter, savvec, puterr
      external   g03eaf$, x02amf$, g03ecf$
      intrinsic  min, max, trim
      save       ptitle, ytitle
      save       isxsav, itype
      save       dmax, thresh
      data       ptitle, ytitle / blank, blank /
      data       numbld / 30*0 /
      data       numpos / 20*1 /
      data       isxsav / nvmax*1 /
      data       itype / 1, 2, 4, 3 /
      data       dmax, thresh / zero, zero /
      data       icount / 0 /
      
c
c initialise newdat then check ncsav and nrsav if supply = .true.
c
      newdat = .false.
      if (supply) then
         if (ncsav.lt.1 .or. ncsav.gt.ncmax .or.
     +       nrsav.lt.2 .or. nrsav.gt.nrmax) return  
      else
         fname = 'No File'
         title = 'No Data'
      endif
c
c allocate workspace
c
      ierr = 0
      if (allocated(isx)) deallocate(isx, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(b)) deallocate(b, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(r)) deallocate(r, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(s)) deallocate(s, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(w1)) deallocate(w1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x_hook)) deallocate(x_hook, stat = ierr)
      if (ierr.ne.0) return        
      if (allocated(wordx)) deallocate(wordx, stat = ierr)
      if (ierr.ne.0) return
      allocate(isx(ncmax), stat = ierr)
      call puterr (ierr, 'A, CLUST1 vector isx')
      if (ierr.ne.0) return
      nbig = max(2*nrmax, ncmax)
      allocate(b(nbig), stat = ierr)
      call puterr (ierr, 'A, CLUST1 vector b')
      if (ierr.ne.0) return
      allocate(r(nrmax), stat = ierr)
      call puterr (ierr, 'A, CLUST1 vector r')
      if (ierr.ne.0) return
      allocate(s(ncmax), stat = ierr)
      call puterr (ierr, 'A, CLUST1 vector s')
      if (ierr.ne.0) return
      allocate(w1(nrmax), stat = ierr)
      call puterr (ierr, 'A, CLUST1 vector w1')
      if (ierr.ne.0) return
      allocate(x(nrmax,ncmax), stat = ierr)
      call puterr (ierr, 'A, CLUST1 matrix x')
      if (ierr.ne.0) return
      allocate(x_hook(nrmax,3), stat = ierr)
      call puterr (ierr, 'A, CLUST1 matrix x_hook')
      if (ierr.ne.0) return        
      nisx = min(nrmax + ncmax,nwmax)  
      allocate(wordx(nisx), stat = ierr)
      call puterr (ierr, 'A, CLUST1 vector wordx')
      if (ierr.ne.0) return
c
c initialise
c
      do i = 1, ncmax
         if (i.le.nvmax) then
            isx(i) = isxsav(i)
         else
            isx(i) = 1
         endif
      enddo 
      if (supply) call eofint (isx, ncsav,
     +                         fname,  
     +                         abort, allpos) 
      write (info,2000)
      if (itype(3).eq.3) then
         itype(3) = 4
         call putadv (info(1))
      endif
      write (text,100)
      type1(1) = text(itype(1))(1:40)
      write (text,200)
      type1(2) = text(itype(2))(1:40)
      write (text,300)
      type1(3) = text(itype(3))(1:40)
      write (text,400)
      type1(4) = text(itype(4))(1:40)
      rtol = 1.0d+09*x02amf$()
      ncol = ncsav
      nrow = nrsav
      nvar = 0
      nptcol = 0
      nptrow = 0
      word80 = chop80(title)
      ptitle = word80
      if (ncol.gt.0 .and. nrow.gt.1) then
c
c data supplied so initialise labels
c
         ready = .true.
         call isxvec (isx, ncol, nvar, nxmin)
         if (nrow.gt.nwmax) then
            wordx(1) = no_labels
            store = .true.
            i = 1
            call savwrd (i,
     +                   wordx,
     +                   store)           
         else    
            isend = 1
            call getwrd (isend, ncol, nin, nrow, nisx,
     +                   fname, wordx)
            store = .true.
            call savwrd (nrow,
     +                   wordx,
     +                   store)
         endif
      else
c
c no data supplied
c
         ready = .false.
         ncol = 0
         nrow = 0
         nvar = 0
      endif
      do i = 1, nrmax
         r(i) = one
      enddo
      do i = 1, ncmax
         s(i) = one
      enddo
      done_it = .false.
      done = .true.
      ok = .false.
      weight = .false.
      wtd = .false.
c
c main loop ............................................................
c
      first = .true.
      numdec = 0
      repeet = .true.
      do while (repeet)
c
c prepare main menu items
c
         if (ncol.gt.0) then
            call isxtyp (isx, ncol, nvar, nxmin,
     +                   line, 
     +                   showit)
         else
            line = blank
            showit = .false.
         endif
         if (wtd) then
            cipher = '[weights r in use]'
         else
            cipher = '[weights r not used]'
         endif
c
c set up the main menu
c
         word9 = form09(thresh)
         write (text,500) word80, line, (type1(i), i = 1, 4),
     +                    cipher, trim(word9)
         do i = 1, 8
            text9(i) = text(i + 2)
         enddo
         text9(9) = cipher
         
         nstart = 10
         numopt = 18
         ntext = numopt + nstart - 1
         if (numdec.eq.0) numdec = numopt - 1
         if (numdec.eq.1) then
            if (ready .and. .not.ok) numdec = 2
         elseif (numdec.eq.2) then
            if (.not.ready .or. ok) numdec = 1
         endif
         numbld(3) = 1
         numbld(5) = 1
         call lbox01 (icolor, ix, iy, lshade, numbld, numdec, numopt,
     +                numpos, nstart, ntext,
     +                text,
     +                border, flash, high)
         if (first .and. numdec.eq.8) then
            first = .false.
            icount = icount + 1
            write (nout,'(a)') blank
            write (nout,'(a,i3)') ' Cluster analysis and dendrograms:',
     +                            icount
            write (nout,'(a)') ' ------------------------------------' 
         endif
         numbld(3) = 0
         numbld(5) = 0
c
c check current data if analysis has been requested and set numdec = 0 on error
c
         if (numdec.eq.2) then
            ok = .false.
            if (.not.ready) then
               call putadv (info(2))
               numdec = 0
            else
               if (itype(3).eq.3) then
                  weight = .true.
               else
                  weight = .false.
               endif
               if (weight .and. nptcol.lt.ncol) then
                  weight = .false.
                  itype(3) = 4
                  type1(3) = 'Unscaled'
                  call putadv (info(3))
               endif
               if (weight) then
                  do i = 1, ncol
                     if (weight) then
                        if (isx(i).gt.0 .and. s(i).le.rtol) then
                           weight = .false.
                           itype(3) = 4
                           type1(3) = 'Unscaled'
                           call putadv (info(3))
                        endif
                     endif
                  enddo
               endif
               call isxvec (isx, ncol, nvar, nxmin)
               if (wtd .and. nptrow.lt.nrow) then
                  wtd = .false.
                  call putadv (info(4))
               endif
               if (numdec.eq.2) then
                  isend = 1
                  call pcatrn (isend, isx, itype(1), ncol, nrmax, nrow,
     +                         a, r, s, x,
     +                         abort, wtd)
                  if (abort) numdec = 0
               endif
            endif
         endif
c
c check if data are ready
c
         if (.not.ready) then
            if (numdec.ge.3 .and. numdec.le.14) then
               call putadv (info(2))
               numdec = 0
            endif
         endif
c
c check if data have been analysed
c
         if (.not.ok) then
            if (numdec.ge.8 .and. numdec.le.11) then
               call putadv (info(5))
               numdec = 0
            endif
         endif
c
c check for too many labels 
c         
         if (numdec.eq.9 .and. nrow.gt.nwmax) then
             numdec = 0
             call putadv (too_many)
         endif             
c
c The main options .....................................................
c
         if (numdec.eq.1) then
c
c numdec = 1: new data
c ===========
c
            done_it = .false.
            if (supply) then
               newdat = .true.
c
c save isxsav then deallocate workspace
c
               do i = 1, min(ncmax,nvmax)
                  isxsav(i) = isx(i)
               enddo
               deallocate(isx, stat = ierr)
               deallocate(b, stat = ierr)
               deallocate(r, stat = ierr)
               deallocate(s, stat = ierr)
               deallocate(w1, stat = ierr)
               deallocate(x, stat = ierr)
               deallocate(x_hook, stat = ierr)
               deallocate(wordx, stat = ierr)
               return
            endif
            ok = .false.
            ready = .false.
            call statmt (ncmax, ncsav, nout, nin, nrmax, nrsav, nsmall,
     +                   a, b, w1,
     +                   fname, fsav, title, tsav)
            ncol = ncsav
            nrow = nrsav
            if (ncsav.gt.0 .and. nrsav.gt.0) then
               abort = .false.
            else
               abort = .true.
            endif
            if (.not.abort .and. ncol.lt.1) then
               abort = .true.
               call putadv (info(6))
            endif
            if (.not.abort .and. nrow.lt.2) then
               abort = .true.
               call putadv (info(7))
            endif
            if (.not.abort) then
               i = (nrow*(nrow - 1))/2
               if (i.gt.ndmax) then
                  call putadv (info(8))
                  abort = .true.
               endif
            endif
            if (ncol.gt.nvmax) then
               abort = .true.
               call putadv (info(9))
            endif
            if (abort) then
c
c Failure to read in data
c
               ready = .false.
               nvar = 0
               word80 = 'No current data'
            else
c
c Success so attempt to read labels off the file then store them
c
               ready = .true.
               call isxvec (isx, ncol, nvar, nxmin)
               word80 = chop80(title)
               ptitle = word80
               if (nrow.gt.nwmax) then
                  wordx(1) = no_labels
                  store = .true.
                  i = 1
                  call savwrd (i,
     +                         wordx,
     +                         store)                  
               else   
                  isend = 1
                  call getwrd (isend, ncol, nin, nrow, nisx,
     +                         fname, wordx)
                  store = .true.
                  call savwrd (nrow,
     +                         wordx,
     +                         store)
               endif 
               call eofint (isx, ncol,
     +                      fname,                
     +                      abort, allpos)                
      
               numdec = 2
            endif
         elseif (numdec.eq.2) then
c
c numdec = 2: calculate the distance matrix
c ===========
c

            done_it = .false.
c
c step 1: define update
c ---------------------
c
            update = 'I'
c
c step 2: transform depending on itype(1)
c ---------------------------------------
c
            isend = 2
            call pcatrn (isend, isx, itype(1), ncol, nrmax, nrow,
     +                   a, r, s, x,
     +                   abort, wtd)
            if (abort) then
               ok = .false.
            else
               ok = .true.
c
c extra step to define n and only retain values for r(i) > 0
c
               if (wtd) then
                  n = 0
                  do i = 1, nrow
                     if (r(i).gt.zero) then
                        n = n + 1
                        do j = 1, ncol
                           x(n,j) = x(i,j)
                        enddo
                     endif
                  enddo
               else
                  n = nrow
               endif
            endif
c
c step 3: define dist depending on itype(2)
c -----------------------------------------
c
            i = itype(2)
            if (i.eq.1) then
               dist = 'A'
            elseif (i.eq.2) then
               dist = 'E'
            elseif (i.eq.3) then
               dist = 'S'
            elseif (i.eq.4 .or. i.eq.5) then
               dist = 'B'
            elseif (i.eq.6) then
               dist = 'C'    
            endif
c
c step 4: define scale1 depending on itype(3)
c -------------------------------------------
c
            i = itype(3)
            if (i.eq.1) then
               scale1 = 'S'
            elseif (i.eq.2) then
               scale1 = 'R'
            elseif (i.eq.3) then
               scale1 = 'G'
            else
               scale1 = 'U'
            endif
c
c step 5: call g03eaf$ only if ok and where n = ntotal
c ----------------------------------------------------
c
            if (ok) then
               if (n.gt.nlarge1) then
                  action = .true.
                  call waiter (action)
               endif    
               m = ncol
               ldx = nrmax
               ifail = 1
               call g03eaf$(update, dist, scale1, n, m, x, ldx, isx,
     +                      b, d, ifail)
              if (n.gt.nlarge1) then
                  action = .false.
                  call waiter (action)
               endif   
               if (ifail.eq.0 .and. dist.eq.'B') then
                  do i = 1, n*(n - 1)/2
                     d(i) = f100*d(i)
                  enddo  
               elseif (ifail.eq.4) then
                  call putadv (info(21))   
               endif         
            else
               ifail = 3
            endif
            if (ifail.eq.0) then
c
c success so set ok = .true. and use savvec to store the distance matrix
c
               ok = .true.
               done = .false.
               call putadv (info(10))
               store = .true.
               nsav = n*(n - 1)/2
               call savvec (nsav,
     +                      d,
     +                      store)
               numdec = 8
            else
c
c failure so set ok = .false.
c
               ok = .false.
               done = .true.
               numdec = numopt - 2
               if (ifail.ne.3)
     +         call putifa (ifail, nout, 'G03EAF/CLUST1')
               call putadv (info(11))
            endif
         elseif (numdec.eq.3) then
c
c numdec = 3: select a transformation
c ===========
c
            write (text,100)
            numdec = itype(1)
            numopt = 6
            call lbox02 (icolor, ix, iy, numdec, numopt, numpos,
     +                   text)
            if (numdec.ne.itype(1)) then
               ok = .false.
               itype(1) = numdec
               type1(1) = text(numdec)(1:40)
               numdec = 2
            else
               numdec = 1
            endif
         elseif (numdec.eq.4) then
c
c numdec = 4: select a distance measure
c ===========
c
            write (text,200)
            numdec = itype(2)
            numopt = 6
            call lbox02 (icolor, ix, iy, numdec, numopt, numpos,
     +                   text)
            if (numdec.ne.itype(2)) then
               ok = .false.
               itype(2) = numdec
               type1(2) = text(numdec)(1:40)
               numdec = 2
            else
               numdec = 1
            endif
            if (itype(2).eq.5) call putadv (info(20))
         elseif (numdec.eq.5) then
c
c numdec = 5: select a scaling
c ===========
c
            write (text,300)
            numdec = itype(3)
            numopt = 4
            call lbox02 (icolor, ix, iy, numdec, numopt, numpos,
     +                   text)
            if (numdec.ne.itype(3)) then
               ok = .false.
               itype(3) = numdec
               type1(3) = text(numdec)(1:40)
               numdec = 2
            else
               numdec = 1
            endif
            if (itype(3).eq.3) then
               call putadv (info(12))
             endif
         elseif (numdec.eq.6) then
c
c numdec = 6: select a link
c ===========
c
            write (text,400)
            numdec = itype(4)
            numopt = 6
            call lbox02 (icolor, ix, iy, numdec, numopt, numpos,
     +                   text)
            if (numdec.ne.itype(4)) then
               ok = .false.
               itype(4) = numdec
               type1(4) = text(numdec)(1:40)
               numdec = 2
            else
               numdec = 1
            endif
         elseif (numdec.eq.7) then
c
c numdec = 7: select to use/not-use weights r
c ===========
c
            numdec = 1
            numopt = 2
            text(1) = 'Unweighted for replicates'
            text(2) = 'Weighted for replicates'
            call lbox02 (icolor, ix, iy, numdec, numopt, numpos,
     +                   text)
            if (numdec.eq.1) then
               if (wtd) then
                  ok = .false.
                  wtd = .false.
                  numdec = 2
               else
                  numdec = 1
               endif
            else
               if (wtd) then
                  numdec = 2
               else
                  ok = .false.
                  wtd = .true.
                  call putadv (info(13))
               endif
            endif
         elseif (numdec.eq.8) then
c
c numdec = 8: view/file/save
c ==========================
c
            if (ok) then
               write (text,600) word80, line, (type1(i), i = 1, 4),
     +                          cipher
               if (itype(2).eq.5) then
c
c Adjust for Bray-Curtis percentage similarity
c                 
                  simmat = .true.
                  do i = 1, (n*(n - 1))/2
                     d(i) = f100 - d(i)
                  enddo
               else
                  simmat = .false.   
               endif
               call clust4 (n, nin, nout,
     +                      d,
     +                      info, text,
     +                      done, ok, simmat)
               if (itype(2).eq.5) then
c
c Restore to Bray Curtis percentage dissimilarity
c                 
                  do i = 1, (n*(n - 1))/2
                     d(i) = f100 - d(i)
                  enddo
               endif
            endif
            numdec = 9
         elseif (numdec.eq.9 .or. numdec.eq.10) then
c
c numdec = 9 or 10: select to plot a dendrogram where method = itype(4)
c =================
c
            
            if (numdec.eq.9) then
               plot_labels = .true.
            else
               plot_labels = .false.
            endif      
            if (ok)  then
               if (.not.done_it) then
                  if (n.gt.nlarge2) then
                      action = .true.
                     call waiter (action)
                  endif                     
                  method = itype(4)
                  ifail = 1
                  call g03ecf$(method, n, d, iwk(1), iwk(n), b(1),
     +                         iwk(2*n), b(n), iwk(3*n + 1), ifail)
c
c Restore D as it is changed by g03ecf
c     
                  nsav = n*(n - 1)/2
                  store = .false.
                  call savvec (nsav,
     +                         d,
     +                         store)
                  if (n.gt.nlarge2) then
                     action = .false.
                     call waiter (action)
                  endif    
                  if (ifail.eq.0) then
                     done_it = .true.
                     dmax = b(n - 1)
                     if (thresh.lt.zero) then
                        thresh = zero
                     elseif (thresh.gt.dmax) then
                        thresh = dmax
                     endif
c
c define ytitle for plotting and also (with Bray-Curtis Similarity) for gksgrf$
c                     
                     if (itype(2).eq.1) then
                        ytitle = 'Absolute Distance'
                     elseif (itype(2).eq.2) then
                        ytitle = 'Euclidean Distance'   
                     elseif (itype(2).eq.3) then
                        ytitle = 'Euclidean sqd. Distance'
                     elseif (itype(2).eq.4) then
                        ytitle = 'Bray-Curtis Dissimilarity'   
                     elseif (itype(2).eq.5) then
c
c************************************************************************
c NOTE: Do not translate 'Bray-Curtis Similarity'
c Bray-Curtis Similarity is a key word causing simplot to plot(100 - y)%
c on the Y-axis instead of y. If it is translated gksgfr$ must be edited.
c
                        ytitle = 'Bray-Curtis Similarity'
c*************************************************************************
                     else
                        ytitle = 'Canberra Distance'
                     endif
c
c Retrieve the default labels
c                 
                     if (nrow.le.nwmax) then
                        store = .false.
                        call savwrd (nrow,
     +                               wordx,
     +                               store)
                        if (wtd) then
c
c shuffle the labels if wtd = .true.
c
                           n = 0
                           do i = 1, nrow
                              if (r(i).gt.zero) then
                                 n = n + 1
                                 wordx(n) = wordx(i)
                              endif
                           enddo
                        else
                           n = nrow
                        endif
                     endif   
                  endif
               endif
               if (ok .and. done_it) then      
                  call dendr1 (iwk(1), iwk(n), iwk(2*n), n, 
     +                         b(1), thresh, 
     +                         ptitle, wordx, xtitle, ytitle,
     +                         plot_labels)
               else
                  call putifa (ifail, nout, 'G03ECF/CLUST1')
                  call putadv (info(17))
                  if (ifail.eq.3 .and.
     +               (method.eq.4 .or. method.eq.5)) then
                     call putadv (info(18))
                  endif
               endif
            endif
            numdec = 1
         elseif (numdec.eq.11) then
c
c numdec = 11: select k sub-clusters
c ============
c
            if (ok)  then
               if (.not.done_it) then
                  if (n.gt.nlarge2) then
                      action = .true.
                     call waiter (action)
                  endif                  
                  method = itype(4)
                  nsav = n*(n - 1)/2
                  store = .true.
                  call savvec (nsav,
     +                         d,
     +                         store)
                  ifail = 1
                  call g03ecf$(method, n, d, iwk(1), iwk(n), b(1),
     +                         iwk(2*n), b(n), iwk(3*n + 1), ifail)
                  nsav = n*(n - 1)/2
                  store = .false.
                  call savvec (nsav,
     +                         d,
     +                         store)
                  if (n.gt.nlarge2) then
                      action = .false.
                     call waiter (action)
                  endif                  
                  if (ifail.eq.0) then
                     done_it = .true.
                     dmax = b(n - 1)
                     if (thresh.lt.zero) then
                        thresh = zero
                     elseif (thresh.gt.dmax) then
                        thresh = dmax
                     endif
                  endif  
               endif
               if (ok .and. done_it) then    
                  call dendr2 (iwk(3*n + 1), iwk(2*n), isx, m, n, nin,
     +                         nisx, nout, nrmax,
     +                         b(1), b(n), thresh, w1, x,
     +                         text9, wordx)
               else
                  call putifa (ifail, nout, 'G03ECF/CLUST1')
                  call putadv (info(17))
                  if (ifail.eq.3 .and.
     +               (method.eq.4 .or. method.eq.5)) then
                     call putadv (info(18))
                  endif
               endif
            endif
            numdec = 1
         elseif (numdec.eq.12) then
c
c numdec = 12: threshold
c ============
c
            call getdge (thresh, zero, info(19))
            numdec = 2
         elseif (numdec.eq.13) then
c
c numdec = 13: select to suppress/restore variables
c ============
c
            call isxedi (isx, ncol, nvar, nxmin)
            ok = .false.
            numdec = 2
         elseif (numdec.eq.14) then
c
c numdec = 14: select to use a weighting vector
c ============
c
            ok = .false.
            isend = 3
            call pcawts (isend, nin, nptrow, nptcol, nrow, ncol, nrmax,
     +                   r, s, w1)
            numdec = 2
         elseif (numdec.eq.15) then
c
c numdec = 15: select to install a labels vector
c ============
c
            if (nrow.gt.nwmax) then
                numdec = 0
                call putadv (too_many)
            else             
               isend = 1
               call getlbl (isend, nrow,
     +                      wordx,
     +                      ffiles)
               store = .true.
               call savwrd (nrow,
     +                      wordx,
     +                      store)
            endif
            numdec = 9
         elseif (numdec.eq.numopt - 2) then
c
c numdec = numopt - 2: review progress
c ====================
c
             call revpro (nout)
             numdec = 2            
         elseif (numdec.eq.numopt - 1) then
c
c numdec = numopt - 1: help
c ====================
c
             write (text,700)
             ntext = 20
             numbld(1) = 1
             next = .true.
             call tutor1 (icolor, numbld, ntext,
     +                    text,
     +                    frame, next, updown)
             numbld(1) = 0
             write (text,800)
             ntext = 21
             next = .true.
             numbld(1) = 1
             numbld(9) = 1
             numbld(15) = 1
             numbld(19) = 1
             next = .true.
             call tutor1 (icolor, numbld, ntext, 
     +                    text, 
     +                    frame, next, updown)
             numbld(1) = 0
             numbld(9) = 0
             numbld(15) = 0
             numbld(19) = 0
             write (text,900)
             ntext = 22
             next = .true.
             numbld(1) = 1
             numbld(10) = 1
             numbld(20) = 1
             next = .true.
             call tutor1 (icolor, numbld, ntext, 
     +                    text,
     +                    frame, next, updown)
             numbld(1) = 0
             numbld(10) = 0
             numbld(20) = 0
             write (text,1000)
             ntext = 20
             next = .false.
             numbld(1) = 1
             next = .false.
             call tutor1 (icolor, numbld, ntext,
     +                    text,
     +                    frame, next, updown)
             numbld(1) = 0
             numdec = 2
        
         elseif (numdec.eq.numopt) then
c
c numdec = numopt: cancel
c ================
c
            newdat = .false.
            repeet = .false.
         endif
      enddo
c
c save isxsav then deallocate workspace
c
      do i = 1, min(ncmax,nvmax)
         isxsav(i) = isx(i)
      enddo
      deallocate(isx, stat = ierr)
      deallocate(b, stat = ierr)
      deallocate(r, stat = ierr)
      deallocate(s, stat = ierr)
      deallocate(w1, stat = ierr)
      deallocate(x, stat = ierr)
      deallocate(x_hook, stat = ierr)
      deallocate(wordx, stat = ierr)
c
c format statements
c
  100 format (
     + 'Untransformed'
     +/'Square root'
     +/'Fourth root'
     +/'Log(x)'
     +/'Log(1 + x)'
     +/'Normalise variables to mean=0, st.dev.=1')
  200 format (
     + 'Absolute distance (city block metric)'
     +/'Euclidean distance'
     +/'Euclidean squared distance'
     +/'Bray-Curtis dissimilarity (%)'
     +/'Bray-Curtis similarity (%)'
     +/'Canberra (0,0 omitted; 0,x = x_min/5,x)')
  300 format (
     + 'Sample standard deviations'
     +/'Ranges'
     +/'Weights provided'
     +/'Unscaled')
  400 format (
     + 'Single link (nearest neighbour)'
     +/'Complete link (furthest neighbour)'
     +/'Group average'
     +/'Centroid'
     +/'Median'
     +/'Minimum variance')
  500 format (  
     + ' Cluster analysis and dendrograms'
     +/
     +/1x,A
     +/' Variables included:'
     +/1x,A
     +/' Transformation:',1x,a
     +/' Distance:',1x,a
     +/' Scaling:',1x,a
     +/' Linkage:',1x,a
     +/'Data: New/Edit/Transform/View'
     +/'Calculate: distance matrix'
     +/'Change: transformation'
     +/'Change: distance measure'
     +/'Change: scaling'
     +/'Change: cluster link'
     +/'Change: weighting',1x,a
     +/'Distance matrix: View/File/Save As...'
     +/'Plot: dendrogram with labels'
     +/'Plot: dendrogram without labels'
     +/'Threshold: calculate subgroups'
     +/'Threshold: change cut-off value (',a,')'
     +/'Variables: suppress/restore'
     +/'Install/Edit: weighting/scaling vectors'
     +/'Install/Edit: dendrogram labels'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit cluster analysis options')
  600 format (
     + ' Title for current cluster analysis data:'
     +/1x,A
     +/' Variables included:'
     +/1x,A
     +/' Transformation =',1X,A
     +/' Distance =',1X,A
     +/' Scaling =',1X,A
     +/' Linkage =',1X,A
     +/' Weighting',1X,A
     +/' Distance matrix (strict lower triangle) is:')
  700 format (
     + 'Overview of multivariate cluster analysis and dendrograms'
     +/'It is supposed that m variables have been measured for n cases'
     +/'and the data have been formatted as a matrix file with n rows'
     +/'(n > 1) and m columns (m > 1), e.g. using program MAKMAT.'
     +/'You can select variables (columns) to include and variables to'
     +/'suppress, and you can transform by logs, square roots, etc.'
     +/'to pre-process the data matrix before doing cluster analysis.'
     +/'Several alternative distance measures are available, and each'
     +/'gives a different distance matrix (i.e. dissimilarity matrix).'
     +/'To prevent swamping of small variables by large values you can'
     +/'use automatic scaling procedures or input a scaling vector with'
     +/'m positive weights s (to use instead of standard deviations).'
     +/'Advanced users may wish to use an arbitray row weighting vector'
     +/'r, e.g. r(i) could be no. of replicates to estimate case i.'
     +/'A dendrogram can be plotted to illustrate the clusters that'
     +/'result when the calculated distance matrix is available along'
     +/'with a chosen linkage scheme to define the distances that'
     +/'are appropriate as the clusters merge. A critical clustering'
     +/'distance (i.e. dissimilarity) threshold can be plotted and case'
     +/'labels can be put at the end of data files (see cluster.tf1).')
  800 format (
     + 'Pre-analysis transformation of variables'
     +/'This is required when variables differ greatly in size so that'
     +/'large variables will dominate small. If all x-values are counts'
     +/'root(x) is useful, for moderate differences in size log(x) (or'
     +/'log(1+x) if any x = 0) can be used, while root[root(x)] finds'
     +/'use where there are very large differences between variables.'
     +/'If all variables are measurements and not categorical variables'
     +/'or counts, standardisation to (0,1) is often recommended.'
     +/'Alternative distance measures'
     +/'With measurements, Euclidean or Euclidean squared distances'
     +/'should be used, but with counts the absolute distance or scaled'
     +/'absolute distance (Bray-Curtis% or Canberra) are used. Note'
     +/'Bray-Curtis% similarity = 100 - Bray-Curtis% dissimilarity,'
     +/'while Canberra omits double 0 and sets single 0 = x_min/5.'
     +/'Scaling instead of pre-analysis transformation'
     +/'Instead of transforming, scaling can be used, and experts can'
     +/'supply a vector of standard deviations that may be more'
     +/'representative than the current sample standard deviations.'
     +/'The link functions'
     +/'The group average is often recommended, but note that all these'
     +/'alternative settings will alter the shape of the dendrogram.')
  900 format (
     + 'Installing/editing dendrogram plot labels from the main menu'
     +/'Labels can be appended to files (as with cluster.tf1), but it'
     +/'may be convenient to store the labels in files with just one'
     +/'label per line (as with labels.txt), and choose to install/edit'
     +/'labels from the main menu after each data file input. Note that'
     +/'such labels will only change as each new data set is installed,'
     +/'but labels edited interactively from the dendrogram plot are'
     +/'temporary and re-initialised each time a dendrogram is plotted.'
     +/
     +/'Plotting large dendrograms'
     +/'As the sample size increases, plots becomes systematically more'
     +/'crowded, which can be counteracted in several different ways.'
     +/'1.`The label font size can be decreased'
     +/'2.`The threshold to split labels into two rows can be altered'
     +/'3.`The PostScript option allows you to stretch the dendrogram'
     +/'  `horizontally or vertically without altering aspect ratios or'
     +/'  `line thickness, then the plot can be scrolled, or clipped to'
     +/'  `hardcopy selected stretched sections'
     +/
     +/'Setting a cut-off threshold'
     +/'A threshold can be used to select a fixed number of subgroups,'
     +/'or the number of subgroups formed up to that threshold.')
 1000 format (
     + 'Partial clustering and saving MANOVA or KMEANS type files'
     +/'If data have been assigned to K subgroups (1 < K < N) you may'
     +/'write the subgroups to file for further analysis, e.g. MANOVA,'
     +/'K-MEANS, or canonical variates for groups, etc. If you use this'
     +/'option the following information must be considered.'
     +/'1)`The file created will be a MANOVA or KMEANS type file.'
     +/'2)`For MANOVA files the first column will be the group.'
     +/'3)`For MANOVA files variables will be collected into groups.'
     +/'4)`For KMEANS files original data order will be preserved.'
     +/'5)`If an interactive transformation has been used for data'
     +/'  `then all results, displayed, plotted, or written to file'
     +/'  `will be in the transformed space.'
     +/'6)`Only active variables will be written to file, not any of'
     +/'  `the variables that may have been suppressed.'
     +/'7)`The subgroup centroids will also be appended to the file.'
     +/'8)`If you want to use the groups as a training set, then the'
     +/'  `centroids must be overwritten by any new observation to be'
     +/'  `allocated and the extra lines counter adjusted accordingly.'
     +/'9)`If any groups have no. observations < no. variables you will'
     +/'  `be warned as many MANOVA techniques will not be possible.')
 2000 format (
     + 'Weighting has been cancelled ... re-select if needed'          !1
     +/'First read in some data'                                       !2
     +/'Deficient s vector  ...  Scaling cancelled'                    !3
     +/'Deficient r vector  ...  replicate weighting cancelled'        !4
     +/'First calculate the distance matrix'                           !5
     +/'Must have at least 1 column'                                   !6
     +/'Must have at least 2 rows'                                     !7
     +/'Sample size is too large'                                      !8
     +/'Dimension exceeded: ncol > nvmax'                              !9
     +/'Distance matrix has been calculated'                           !10
     +/'Distance matrix cannot be calculated'                          !11
     +/'This requires a consistent scaling vector, s'                  !12
     +/'This requires a consistent replicates weighting vector, r'     !13
     +/'Distance matrix has been written to results file'              !14
     +/'Write (large) D-matrix to results file (usually no ?)'         !15
     +/'Write (huge) D-matrix to results file (almost certainly no ?)' !16
     +/'Dendrogram cannot be drawn ... change control parameters'      !17
     +/'Such singularities can arise with centroid and median links'   !18
     +/'Distance (i.e. dissimilarity) cut-off to select sub-clusters'  !19
     +/'Use Dissimilarity = (100 - Similarity) for setting thresholds' !20
     +/'Data value < 0, or dividing by zero has been encountered')     !21
      end
c
c

