c
c
      subroutine clust2 (inc, iwk, ncmax, ncsav, nic, nin, nout, nrmax,
     +                   nrsav, nsmall,
     +                   asav, wk,
     +                   fname, fsav, title, tsav,
     +                   newdat, supply)
c
c action: k-means cluster analysis
c author: w.g.bardsley, university of manchester, u.k., 10/06/2001
c         19/10/2002 derived from clust1
c         15/04/2004 added isxedi, isxtyp, and isxvec
c         11/07/2004 revised and added kmean3, kmean4
c         20/07/2005 added getwrd, savwrd, getlbl, wordx, nwords
c         11/01/2006 moved astart, b, cmeans, css, csw, r, s, x from
c                    arguments to allocatables
c         07/03/2006 added newdat and supply to argument list 
c         26/10/2006 extensive revision and added eofint and getval
c         11/11/2006 added allpos in call to eofint
c         19/12/2007 changed nords to max(nrmax + ncmax,2000), and added nwmax
c         10/06/2010 added call to nklcfg  
c         26/08/2010 replaced calls to kmean1 and kmean2 by call to kmean5
c         04/04/2011 added calls to puterr
c         09/02/2016 made  l1,l2, nsmax kind = 7      
c
c         inc: workspace
c         iwk: workspace
c       ncmax: (input/unchanged) column dimension
c       ncsav: (input/output) column dimension of asav
c         nic: workspace
c         nin: (input/unchanged) unconnected unit for data input
c        nout: (input/unchanged) preconnected unit for results
c       nrmax: (input/unchanged) row dimension
c       nrsav: (input/output) row dimension of asav
c      nsmall: (input/unchanged) dimension of library file
c        asav: (input/output) original data
c      astart: workspace
c           b: workspace
c      cmeans: workspace
c         css: workspace
c         csw: workspace
c           r: workspce
c           s: workspace
c          wk: workspace
c           x: workspace
c       fname: (input/output) file name
c        fsav: (input/output) library file names (if any)
c       title: (input/output) title
c        tsav: (input/output) library file titles (if any)
c      newdat: (output) .true. if new data requested
c      supply: (input/unchanged) if .true. then data matix is supplied
c
c used as follows:
c         asav   = original (saved) data in common with other routines
c         astart = master copy of starting estimates
c         b      = temporary vector for data input
c         cmeans = starting estimates then returned as result
c         r      = weights (really for replicates)
c         s      = weights (really for scaling as in x/s)
c         css    = cluster sums of squares
c         csw    = cluster sums of weights
c         x      = temporarily transformed data
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: ncmax, nin, nout, nrmax,
     +                                       nsmall 
      integer,             intent (inout) :: ncsav, nrsav
      integer,             intent (inout) :: inc(nrmax), iwk(4*nrmax),
     +                                       nic(nrmax)
      double precision,    intent (inout) :: asav(nrmax,ncmax),
     +                                       wk(3*nrmax)
      character (len = *), intent (inout) :: fname, fsav(nsmall), title,
     +                                       tsav(nsmall)
      logical,             intent (in)    :: supply
      logical,             intent (out)   :: newdat
c
c
c local allocatable arrays
c
      integer,              allocatable :: isx(:)
      double precision,     allocatable :: astart(:,:), a(:,:), b(:),
     +                                     c(:), cmeans(:,:), css(:),
     +                                     csw(:), r(:), s(:), x(:,:)
      character (len = 40), allocatable :: wordx(:)
c
c locals
c
      integer (kind = 7) l1, l2, nsmax
      integer    i, isend, icount, j, k, kcol, kmax, kmeans, krow, ncol,
     +           nrow, ntotal, nvar
      integer    ierr, ifail, itype, jtype, ktype, jcolor, nloop,
     +           nptcol, nptrow
      integer    icolor, ix, iy, lshade, numdec, nstart, ntext, numopt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, 
     +           numopt = 20)
      integer    maxit, nvmax, nwmax, nwords, nxmin
      parameter (maxit = 20, nvmax = 100, nwmax = 2000, nxmin = 1)
      integer    isxsav(nvmax), numbld(30), numpos(numopt)
      integer    ncol2, ntype, n1, n23
      parameter (ncol2 = 2, ntype = 1, n1 = 1, n23 = 23)
      integer    kval_11, nklcfg
      double precision rtol, x02amf$
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      character (len = 13) d13(2), showrj
      character (len = 12) form12, word12
      character  line*100, text(30)*100
      character  fname1*1024, title1*80
      character  chop80*80, word1*1, word80*80, word100*100
      character  ttype(7)*60, wtype(2)*60
      character  blank*1, no_labels*11, too_many*80
      parameter (blank = ' ',
     +       no_labels = '%no_labels%',      
     +        too_many = 'Too many labels to plot ... maxmimum = 2000') 
      logical    e_numbers, e_formats
      logical    abort, fileit, ok, ready1, ready2, repeet, weight, yes
      logical    done1, done2, done3, showit, store
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .true.)
      logical    fixcol, fixrow, label
      parameter (fixcol = .true., fixrow = .false., label = .true.)
      logical    ffiles, frame, next, updown
      parameter (ffiles = .true., frame = .false., updown = .true.)
      logical    curve, fxcol, fxrow, order, weigh
      parameter (curve = .false., fxcol = .true., fxrow = .true.,
     +           order = .false., weigh = .false.)
      logical    allpos
      parameter (allpos = .true.)
      logical    done, first, first1
      external   e_formats, form12, showrj
      external   lbox01, statmt, chop80, putadv, getjm1, pcawts,
     +           table1, putifa, yesno2, tutor1, revpro, pcatrn, lbox02,
     +           mattin, editor, dsplay, kmean3, kmean4, kmean5,
     +           putmes, isxedi, isxtyp, isxvec, getwrd, savwrd, getlbl,
     +           eofint, getval, absort, nklcfg, puterr
      external   g03eff$, x02amf$
      intrinsic  min, dble
      save       isxsav, first
      data       icount / 0 /
      data       numbld / 30*0 /
      data       numpos / numopt*1 /
      data       isxsav / nvmax*1 /
      data       first / .true. /
      data       ttype / 'None',
     +                   'Square root',
     +                   'Fourth root',
     +                   'log(x)',
     +                   'log(1 + x)',
     +                   'mean = 0, st.dev. = 1',
     +                   'x/s, using vector s' /
      data        wtype / 'Unweighted for replicates',
     +                    'Weighted for replicates' /
c
c initialise newdat and check if supply = .true.
c
      newdat = .false.
      if (supply) then
         if (ncsav.lt.1 .or. ncsav.gt.ncmax .or.
     +       nrsav.lt.2 .or. nrsav.gt.nrmax) return
      endif
      done = .false.
c
c inform first time user
c
      if (first) then
         kval_11 = nklcfg(n23)
         if (kval_11.eq.n1) then
            first = .false.
            ntext = 20
            write (text,100)
            call putmes (ntext, text)
         endif   
      endif
c
c allocate workspace
c
      ierr = 0
      if (allocated(isx)) deallocate(isx, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(astart)) deallocate(astart, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(a)) deallocate(a, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(b)) deallocate(b, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(c)) deallocate(c, stat = ierr)
      if (ierr.ne.0) return  
      if (allocated(cmeans)) deallocate(cmeans, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(css)) deallocate(css, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(csw)) deallocate(csw, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(r)) deallocate(r, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(s)) deallocate(s, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(wordx)) deallocate(wordx, stat = ierr)
      if (ierr.ne.0) return
      allocate(isx(ncmax), stat = ierr)
      call puterr (ierr, 'A, CLUST2 vector isx')
      if (ierr.ne.0) return
      allocate(astart(nrmax,ncmax), stat = ierr)
      call puterr (ierr, 'A, CLUST2 matrix astart')
      if (ierr.ne.0) return
      allocate(a(nrmax,ncol2), stat = ierr)
      call puterr (ierr, 'A, CLUST2 matrix a')
      if (ierr.ne.0) return
      allocate(b(nrmax), stat = ierr)
      call puterr (ierr, 'A, CLUST2 matrix b')
      if (ierr.ne.0) return
      allocate(c(nrmax), stat = ierr)
      call puterr (ierr, 'A, CLUST2 vector c')
      if (ierr.ne.0) return  
      allocate(cmeans(nrmax,ncmax), stat = ierr)
      call puterr (ierr, 'A, CLUST2 matrix cmeans')
      if (ierr.ne.0) return
      allocate(css(nrmax), stat = ierr)
      call puterr (ierr, 'A, CLUST2 vector css')
      if (ierr.ne.0) return
      allocate(csw(nrmax), stat = ierr)
      call puterr (ierr, 'A, CLUST2 vector csw')
      if (ierr.ne.0) return
      allocate(r(nrmax), stat = ierr)
      call puterr (ierr, 'A, CLUST2 vector r')
      if (ierr.ne.0) return 
        
c      nsmax = ncmax*nrmax
      l1 = nrmax
      l2 = ncmax
      nsmax = l1*l2
      
      allocate(s(nsmax), stat = ierr)
      call puterr (ierr, 'A, CLUST2 vector s')
      if (ierr.ne.0) return
      allocate(x(nrmax,ncmax), stat = ierr)
      call puterr (ierr, 'A, CLUST2 matrix x')
      if (ierr.ne.0) return
      nwords = min(nrmax + ncmax,nwmax)  
      allocate(wordx(nwords), stat = ierr)
      call puterr (ierr, 'A, CLUST2 vector wordx')
      if (ierr.ne.0) return
c
c start initialisation
c
      do i = 1, ncmax
         if (i.le.nvmax) then
            isx(i) = isxsav(i)
         else
            isx(i) = 1
         endif
      enddo
      itype = 1
      jtype = 1
      kmax = 0
      kmeans = 0
      ncol = ncsav
      nrow = nrsav
      nvar = 0
      nptcol = 0
      nptrow = 0
      word80 = chop80(title) 
      if (ncol.gt.0 .and. nrow.gt.1) then 
c                  
c ----------------------------------------------------
c start of special code for when data file is supplied
c      
         ready1 = .true.
c
c see if file supplied initialises isx(1) to isx(ncol)
c            
         call eofint (isx, ncol,
     +                fname,
     +                abort, allpos)  
         call isxvec (isx, ncol, nvar, nxmin)
c
c see if file supplied initialises plotting labels
c
         if (nrow.gt.nwmax) then
            i = 1
            wordx(1) = no_labels
            store = .true.
            call savwrd (i,
     +                   wordx,
     +                   store)
         else            
            isend = 1
            call getwrd (isend, ncol, nin, nrow, nwords,
     +                   fname, wordx)
            store = .true.
            call savwrd (nrow,
     +                   wordx,
     +                   store)
        endif  
c
c see if file supplied initialises starting clusters
c                         
         kcol = ncol      
         krow = 0
         call getval (kcol, krow, ncol, nin, nrow, nsmax,
     +                s,
     +                fname)  
         abort = .true. 
         if (krow.gt.1) then
            abort = .false.
            kmax = min(krow,nrow)
            k = 0
            do i = 1, kmax  
               do j = 1, ncol
                  k = k + 1
                  cmeans(i,j) = s(k) 
               enddo
            enddo  
         else   
                     
c
c input new starting clusters
c
            write (line,300) ncol
            call putadv (line)
            isend = 3
            close (unit = nin)
            call mattin (isend, ncol, ncol, nin, nrmax, kmax,
     +                   cmeans, b,
     +                   fname1, title1,
     +                   abort, fixcol, fixrow, label)
            close (unit = nin)
            if (.not.abort) then
               if (kmax.lt.2) then
                  abort = .true.
                  kmax = 0
                  kmeans = 0
                  call putadv (
     +'No. of clusters < 2')
               elseif (kmax.gt.nrow) then
                  abort = .true.
                  kmax = 0
                  kmeans = 0
                  call putadv (
     +'No. of clusters > no.rows')
               endif
            endif
         endif
         if (.not.abort) then
c
c store the starting clusters
c
            kmeans = kmax
            ready2 = .true.
            do j = 1, ncol
               do i = 1, kmax
                  astart(i,j) = cmeans(i,j)
               enddo
            enddo
         endif
         if (abort) then
            ready1 = .false.
            ready2 = .false.
            nvar = 0
            word80 =
     +'No current data'
            numdec = 1
         else
            call isxvec (isx, ncol, nvar, nxmin)
            word80 = chop80(title)
            numdec = 2
         endif   
c
c end of special code for when data file is supplied
c --------------------------------------------------
c 
      else
c
c no data supplied
c
         ready1 = .false.
         ready2 = .false.
         nvar = 0
      endif          
c
c final part of initialisation
c      
      do i = 1, nrmax
         r(i) = one
      enddo
      do i = 1, ncmax
         s(i) = one
      enddo
      rtol = 1.0d+09*x02amf$()
      done1 = .true.
      done2 = .true.
      done3 = .true.
      weight = .false.
      ok = .false.
      numdec = numopt - 1
c
c main loop ............................................................
c
      e_numbers = e_formats()
      first1 = .true.
      repeet = .true.
      do while (repeet)
         if (ncol.gt.0) then
            call isxtyp (isx, ncol, nvar, nxmin, 
     +                   line,
     +                   showit)
         else
            line = blank
            showit = .false.
         endif
c
c set up the main menu
c
         if (jtype.eq.1) then
            weight = .false.
         else
            weight = .true.
         endif
         word12 = form12(kmeans)
         write (text,200) word80, line, word12, ttype(itype),
     +                    wtype(jtype)
         if (numdec.eq.0) numdec = numopt - 1
         nstart = 9  
         ntext = numopt + nstart - 1   
         numbld(2) = 1
         numbld(4) = 1
         call lbox01 (icolor, ix, iy, lshade, numbld, numdec, numopt,
     +                numpos, nstart, ntext, text, border, flash, high)
         numbld(2) = 0
         numbld(4) = 0
c
c check current data if analysis has been requested
c
         if (numdec.eq.2) then
            ok = .false.
            if (.not.ready1) then
               call putadv (
     +'First read in some data')
               numdec = 0
            elseif (.not.ready2) then
               call putadv (
     +'First read in the initial clusters')
               numdec = 0
            elseif (kmeans.lt.2) then
               call putadv (
     +'First set the initial clusters')
               numdec = 0
            elseif (kmeans.gt.nrow) then
               call putadv (
     +'Too many clusters requested, K > n')
               numdec = 0
            elseif (nvar.lt.1) then
               call putadv (
     +'No current data columns to cluster')
               numdec = 0
            else
               if (weight .and. nptrow.lt.nrow) then
                  call putadv (
     +'Deficient r vector  ...  replicate weighting cancelled')
                  jtype = 1
                  weight = .false.
               endif
               if (weight) then
                  ntotal = 0
                  do i = 1, nrow
                     if (r(i).gt.zero) ntotal = ntotal + 1
                  enddo
                  if (ntotal.le.kmeans) then
                     call putadv (
     +'Insufficient active data ... replicate weighting cancelled')
                     jtype = 1
                     weight = .false.
                  endif
               endif
               if (itype.eq.7 .and. nptcol.lt.ncol) then
                  itype = 1
                  call putadv (
     +'Deficient s vector  ...  scaling cancelled')
               endif
               if (itype.eq.7) then
                  do i = 1, ncol
                     if (itype.eq.7) then
                        if (isx(i).gt.0 .and. s(i).le.rtol) itype = 1
                     endif
                  enddo
                  if (itype.eq.1) call putadv (
     +'Deficient s vector  ...  scaling cancelled')
               endif
c
c isend = 1: check if transformation is allowed
c
               isend = 1
               call pcatrn (isend, isx, itype, ncol, nrmax, nrow,
     +                      asav, r, s, x,
     +                      abort, weight)
               if (abort) numdec = 0
            endif
         endif
c
c check requests 3 to 16
c
         if (numdec.ge.3 .and. numdec.le.18) then
            if (.not.ready1) then
               call putadv (
     +'First read in some data')
               numdec = 0
            elseif (.not.ready2) then
               call putadv (
     +'First read in the initial clusters')
               numdec = 0
            endif
         endif
c
c check requests 8 to 12
c
         if (numdec.ge.8 .and. numdec.le.15 .and. .not.ok) then
            call putadv (
     +'No results to display  ...  Analyse now')
            numdec = 0
         endif
c
c The main options .....................................................
c
         if (numdec.eq.1) then
c
c numdec = 1: new data
c ===========
c
            if (supply) then
               newdat = .true.
c
c store isx then deallocate
c
               do i = 1, min(ncmax,nvmax)
                  isxsav(i) = isx(i)
               enddo
               deallocate(isx, stat = ierr)
               deallocate(astart, stat = ierr)
               deallocate(b, stat = ierr)
               deallocate(cmeans, stat = ierr)
               deallocate(css, stat = ierr)
               deallocate(csw, stat = ierr)
               deallocate(r, stat = ierr)
               deallocate(s, stat = ierr)
               deallocate(x, stat = ierr)
               deallocate(wordx, stat = ierr)
               return
            endif
            done1 = .true.
            done2 = .true.
            done3 = .true.
            ok = .false.
            ready1 = .false.
            ready2 = .false.
            close (unit = nin)
            call statmt (ncmax, ncsav, nout, nin, nrmax, nrsav, nsmall,
     +                   asav, b, wk, fname, fsav, title, tsav)
            close (unit = nin)
            ncol = ncsav
            nrow = nrsav
            if (ncsav.gt.0 .and. nrsav.gt.0) then
               abort = .false.
            else
               abort = .true.
            endif
            if (.not.abort .and. ncol.lt.1) then
               abort = .true.
               call putadv (
     +'Must have at least 1 column')
            endif
            if (.not.abort .and. nrow.lt.2) then
               abort = .true.
               call putadv (
     +'Must have at least 2 rows')
            endif
            if (.not.abort) then 
               ready1 = .true. 
c
c get labels
c
               if (nrow.gt.nwmax) then
                  i = 1
                  wordx(1) = no_labels
                  store = .true.
                  call savwrd (i,
     +                         wordx,
     +                         store)                   
               else  
                  isend = 1
                  call getwrd (isend, ncol, nin, nrow, nwords,
     +                         fname, wordx)
                  store = .true.
                  call savwrd (nrow,
     +                         wordx,
     +                         store)  
               endif
c
c get isx
c 
               call eofint (isx, ncol,
     +                      fname,
     +                      abort, allpos)  
c
c get starting clusters
c                         
               kcol = ncol      
               krow = 0
               call getval (kcol, krow, ncol, nin, nrow, nsmax,
     +                      s,
     +                      fname)  
               abort = .true. 
               if (krow.gt.1) then
                  abort = .false.
                  kmax = min(krow,nrow)
                  k = 0
                  do i = 1, kmax  
                     do j = 1, ncol
                        k = k + 1
                        cmeans(i,j) = s(k) 
                     enddo
                  enddo 
               else             
c
c input new starting clusters
c
                  ready1 = .true.
                  write (line,300) ncol
                  call putadv (line)
                  isend = 3
                  close (unit = nin)
                  call mattin (isend, ncol, ncol, nin, nrmax, kmax,
     +                         cmeans, b,
     +                         fname1, title1,
     +                         abort, fixcol, fixrow, label)
                  close (unit = nin)
                  if (.not.abort) then
                     if (kmax.lt.2) then
                        abort = .true.
                        kmax = 0
                        kmeans = 0
                        call putadv (
     +'No. of clusters < 2')
                     elseif (kmax.ge.nrow) then
                        abort = .true.
                        kmax = 0
                        kmeans = 0
                        call putadv (
     +'No. of clusters >= no.rows')
                    endif
                  endif
               endif
               if (.not.abort) then
c
c store the starting clusters
c
                  kmeans = kmax
                  ready2 = .true.
                  do j = 1, ncol
                     do i = 1, kmax
                        astart(i,j) = cmeans(i,j)
                     enddo
                  enddo
               endif
            endif
            if (abort) then
               ready1 = .false.
               ready2 = .false.
               nvar = 0
               word80 =
     +'No current data'
               numdec = 1
            else
               call isxvec (isx, ncol, nvar, nxmin)
               word80 = chop80(title)
               numdec = 2
            endif
         elseif (numdec.eq.2) then
c
c numdec = 2: calculate the clusters
c ===========
c
            if (first1) then
               first1 = .false.
               icount = icount + 1
               write (nout,'(a)') blank
               write (nout,'(a,i3)') ' K-means Cluster analysis:',icount
               write (nout,'(a)')    ' ----------------------------'
            endif     
            done1 = .true.
            done2 = .true.
            done3 = .true.
            ok = .false.
            if (ready1 .and. ready2) then
c
c isend = 2: transform asav to x
c ==========
c
               isend = 2
               call pcatrn (isend, isx, itype, ncol, nrmax, nrow,
     +                      asav, r, s, x,
     +                      abort, weight)
               if (abort) then
                  ifail = - 1
               else
c
c isend = 3: transform astart to cmeans
c ==========
c
                  isend = 3
                  call pcatrn (isend, isx, itype, ncol, nrmax, kmeans,
     +                         astart, r, s, cmeans,
     +                         abort, weight)
c
c shuffle and/or randomise cmeans
c
                  call kmean4 (isx, ncol, nrmax, kmeans, nvar,
     +                         cmeans)
                  if (weight) then
                     word1 = 'W'
                  else
                     word1 = 'U'
                  endif
c
c try to assign clusters
c
                  ifail = 1
                  call g03eff$(word1, nrow, ncol, x, nrmax, isx,
     +                         nvar, kmeans, cmeans, nrmax, r, inc,
     +                         nic, css, csw, maxit, iwk, wk, ifail)
               endif
            else
               ifail = - 1
            endif
            if (ifail.eq.0) then
c
c success so set ok = .true. and set done? to indicate not written to results
c                         
               if (weight) then 
c
c make sure groups are not assigned to unused observations
c               
                  do i = 1, nrow
                     if (r(i).le.zero) nic(i) = 0
                  enddo
               endif
               call putadv (
     +'Clusters have now been assigned')
               ok = .true.
               done1 = .false.
               done2 = .false.
               done3 = .false.
               numdec = 8
            else
c
c failure so set ok = .false.
c
               ok = .false.
               numdec = numopt - 1
               if (ifail.ne. - 1 .and. ifail.ne.4)
     +         call putifa (ifail, nout, 'G03EFF/CLUST2')
               if (ifail.eq.4 .or. ifail.eq.5) call putadv (
     +'Unsatisfactory clustering ... Try new K and/or start clusters')
c
c check for empty starting clusters
c
               j = 0
               do i = 1, kmeans
                  if (nic(i).le.0) j = j + 1
               enddo
               if (j.gt.0) then
                  j = 15
                  call table1 (j, 'OPEN')
                  j = 4
                  call table1 (j, 'Empty initial clusters')
                  j = 0
                  do i = 1, kmeans
                     if (nic(i).le.0) then
                        write (line,'(i6)') i
                        call table1 (j, line)
                     endif
                  enddo
                  call table1 (j, 'CLOSE')
               endif
            endif
         elseif (numdec.eq.3) then
c
c numdec = 3: change K
c ===========
c
            if (kmax.eq.2) then
               numdec = numopt - 1
               kmeans = 2
               call putadv (
     +'Cannot have < 2 clusters')
            else
               i = 2
               j = kmeans
               k = kmax
               if (j.gt.kmax) j = kmax
               call getjm1 (i, j, k,
     +'No. of clusters required')
               kmeans = j
               ok = .false.
               numdec = 2
            endif
         elseif (numdec.eq.4) then
c
c numdec = 4: edit the current start positions
c ===========
c
            if (ready1 .and. ready2) then
               isend = 2
               ktype = 1
               call editor (isend, ktype, ncol, nrmax, kmax,
     +                      astart,
     +                     'Starting K-means clusters',
     +                      curve, fxcol, fxrow, label, order, weigh)
               ok = .false.
               numdec = 2
            endif
         elseif (numdec.eq.5) then
c
c numdec = 5: input a new starting matrix
c ===========
c
            if (ready1 .and. ready2) then
               write (line,300) ncol
               call putadv (line)
               isend = 3
               close (unit = nin)
               call mattin (isend, ncol, ncol, nin, nrmax, k,
     +                      cmeans, b,
     +                      fname1, title1,
     +                      abort, fixcol, fixrow, label)
               close (unit = nin)
               if (.not.abort) then
                  if (k.lt.2) then
                     abort = .true.
                     call putadv (
     +'No. of clusters < 2')
                  elseif (k.gt.nrow) then
                     abort = .true.
                     call putadv (
     +'No. of clusters > no.rows')
                  endif
               endif
               if (abort) then
                  call putadv (
     +'Initial clusters restored')
                  numdec = 1
               else
                  ok = .false.
                  kmax = k
                  kmeans = kmax
                  do j = 1, ncol
                     do i = 1, kmax
                        astart(i,j) = cmeans(i,j)
                     enddo
                  enddo
                  numdec = 2
               endif
            endif
         elseif (numdec.eq.6) then
c
c numdec = 6: transform
c =====================
c
            if (ready1 .and. ready2) then
               ok = .false.
               isend = 7
               itype = 1
               call lbox02 (icolor, ix, iy, itype, isend, numpos,
     +                      ttype)
               if (itype.eq.7) call putadv (
     +'This requires a consistent scaling vector, s')
               if (itype.ne.1) call putadv (
     +'The starting centroids will also be transformed')
               numdec = 2
            endif
         elseif (numdec.eq.7) then
c
c numdec = 7: replicates weighting
c ===========
c
            if (ready1 .and. ready2) then
               ok = .false.
               isend = 2
               jtype = 1
               call lbox02 (icolor, ix, iy, jtype, isend, numpos, wtype)
               if (jtype.eq.1) then
                  weight = .false.
               else
                  call putadv (
     +'This requires a consistent replicates weighting vector, r')
                  weight = .true.
               endif
               numdec = 2
            endif
         elseif (numdec.eq.8) then
c
c numdec = 8: cluster assignments
c ===========
c
            if (ok) then
               if (done1) then
                  fileit = .false.
               elseif (nrow.le.24) then
                  fileit = .true.
               else
                  yes = .false.
                  call yesno2 (icolor, ix, iy,
     +'Also write the results to the log file (probably no)', yes)
                  fileit = yes
               endif
               if (fileit) then
                  done1 = .true.
                  write (nout,'(a)') blank
               endif
               jcolor = 15
               call table1 (jcolor, 'OPEN')
               do i = 1, 7
                  if (i.eq.2) then
                     jcolor = 4
                  elseif (i.eq.4) then
                     jcolor = 1
                  else
                     jcolor = 0
                  endif
                  call table1 (jcolor, text(i))
                  if (fileit) write (nout,'(a)') text(i)
               enddo
               write (word100,400)
               if (fileit) then 
                  write (nout,'(a)') blank
                  write (nout,'(a)') word100
               endif   
               jcolor = 4
               call table1 (jcolor, word100)
               jcolor = 0
               nloop = nrow/12
               if (nloop.eq.0) then
                  write (word100,500) (i, i = 1, nrow)
                  if (fileit) write (nout,'(a)') word100
                  call table1 (jcolor, word100)
                  write (word100,500) (inc(i), i = 1, nrow)
                  if (fileit) write (nout,'(a)') word100
                  call table1(jcolor,word100)
               else
                  j = - 11
                  do k = 1, nloop
                     j = j + 12
                     write (word100,500) (i, i = j, j + 11)
                     if (fileit) write (nout,'(a)') word100
                     call table1 (jcolor, word100)
                     write (word100,500) (inc(i), i = j, j + 11)
                     if (fileit) write (nout,'(a)') word100
                     call table1(jcolor,word100)
                  enddo
                  nloop = 12*nloop + 1
                  if (nrow.ge.nloop) then
                     write (word100,500) (i, i = nloop, nrow)
                     if (fileit) write (nout,'(a)') word100
                     call table1 (jcolor, word100)
                     write (word100,500) (inc(i), i = nloop, nrow)
                     if (fileit) write (nout,'(a)') word100
                     call table1(jcolor,word100)
                  endif
               endif
               call table1 (jcolor,'CLOSE')
               numdec = 9
            endif
         elseif (numdec.eq.9) then
c
c numdec = 8: table of clusters
c ===========
c
            if (ok) then
               if (done2) then
                  fileit = .false.
               elseif (kmeans.le.6) then
                  fileit = .true.
               else
                  yes = .false.
                  call yesno2 (icolor, ix, iy,
     +'Also write the results to the log file (probably no)', yes)
                  fileit = yes
               endif
               if (fileit) then
                  done2 = .true.
                  write (nout,'(a)') blank
               endif
               jcolor = 15
               call table1 (jcolor, 'OPEN')
               write (word100,600)
               if (fileit) write (nout,'(a)') word100
               jcolor = 4
               call table1 (jcolor, word100)
               jcolor = 0
               do i = 1, kmeans
                  if (e_numbers) then 
                     write (word100,700) i, nic(i), css(i), csw(i)
                  else
                     d13(1) = showrj(css(i))
                     d13(2) = showrj(csw(1))
                     write (word100,750) i, nic(i), d13(1), d13(2)
                  endif   
                  if (fileit) write (nout,'(a)') word100
                  call table1 (jcolor, word100)
               enddo
               call table1 (jcolor,'CLOSE')
               numdec = 10
            endif
         elseif (numdec.eq.10) then
c
c numdec = 10: final cluster centres
c ============
c
            if (ok) then
               if (done3) then
                  fileit = .false.
               elseif (kmeans.le.6 .and. nvar.le.6) then
                  fileit = .true.
               else
                  yes = .false.
                  call yesno2 (icolor, ix, iy,
     +'Also write the results to the log file (probably no)', yes)
                  fileit = yes
               endif
               if (fileit) done3 = .true.
               write (word100,800)
               ktype = 3
               call dsplay (ncmax, nvar, nout, nrmax, kmeans, ktype,
     +                      cmeans,
     +                      word100,
     +                      fileit)
               numdec = 11
            endif
         elseif (numdec.eq.11) then
c
c numdec = 11: save MANOVA type file
c ============
c
             call kmean3 (inc, isx, kmeans, nrmax, nrmax, ncol, nic,
     +                    nin, nrow, nvar, nwords,
     +                    cmeans, r, wk, x,
     +                    ttype(itype), wordx, wtype(jtype),
     +                    weight)

        elseif (numdec.eq.12) then
c
c numdec = 12: Cases/Clusters
c ============
c         
            do i = 1, nrow
               a(i,1) = dble(i)
               a(i,2) = dble(inc(i))
            enddo
            line = 'Column 1 = cases (i.e., rows), Column 2 = clusters'
            yes = .false.
            call yesno2 (icolor, ix, iy,
     +'Also write the results to the log file', yes)
            fileit = yes
            call dsplay (ncol2, ncol2, nout, nrmax, nrow, ntype,
     +                   a,
     +                   line,              
     +                   fileit)
         elseif (numdec.eq.13) then
c
c numdec = 13: Clusters/Cases
c ============
c         
              do i = 1, nrow
               b(i) = dble(inc(i))
               c(i) = dble(i)
            enddo
            call absort (nrow,
     +                   b, c)
            do i = 1, nrow
               a(i,1) = b(i)
               a(i,2) = c(i) 
            enddo               
            line = 'Column 1 = clusters, Column 2 = cases (i.e., rows)'
            yes = .false.
            call yesno2 (icolor, ix, iy,
     +'Also write the results to the log file', yes)
            fileit = yes
            call dsplay (ncol2, ncol2, nout, nrmax, nrow, ntype,
     +                   a,
     +                   line,              
     +                   fileit)


     
         elseif (numdec.eq.14) then
c
c numdec = 14: plot
c ============
c
            if (ok) then
               if (nrow.gt.nwmax .and. .not.done) then
                  done = .true.
                  call putadv (too_many)
               endif   
               if (nvar.lt.2) then
                  write (line,900)
                  call putadv (line)
               else
                  call kmean5 (inc, isx, ncol, nrmax, nrow,
     +                         x, r,
     +                         wordx,
     +                         weight)       
                  numdec = numopt - 1
               endif
            endif
         elseif (numdec.eq.15) then
c
c numdec = 15: select to suppress/restore variables
c ============
c
            call isxedi (isx, ncol, nvar, nxmin)
            ok = .false.
            numdec = 2
         elseif (numdec.eq.16) then
c
c numdec = 16: weighting vectors
c ============
c
            isend = 3
            call pcawts (isend, nin, nptrow, nptcol, nrow, ncol,
     +                   nrmax,
     +                   r, s, b)
            ok = .false.
            numdec = numopt - 1
         elseif (numdec.eq.17) then
c
c numdec = 17: get labels
c ============
c
            if (nrow.gt.nwmax) then
               call putadv (too_many)
            else   
               isend = 1
               call getlbl (isend, nrow,
     +                      wordx,
     +                      ffiles)
               store = .true.
               call savwrd (nrow,
     +                      wordx,
     +                      store)
            endif
            numdec = 13
         elseif (numdec.eq.numopt - 2) then
c
c numdec = numopt - 2: review progress
c ====================
c
             call revpro (nout)
             numdec = numopt - 1            
         elseif (numdec.eq.numopt - 1) then
c
c numdec = numopt - 1: help
c ====================
c
             write (text,1000)
             ntext = 20
             numbld(1) = 1
             numbld(10) = 1
             numbld(19) = 1
             next = .true.
             call tutor1 (icolor, numbld, ntext, text, frame, next,
     +                    updown)
             numbld(1) = 0
             numbld(10) = 0
             numbld(19) = 0
             write (text,1100)
             ntext = 22
             next = .true.
             numbld(1) = 1
             numbld(12) = 1
             next = .true.
             call tutor1 (icolor, numbld, ntext, text, frame, next,
     +                    updown)
             numbld(1) = 0
             numbld(12) = 0
             write (text,1200)
             ntext = 20
             next = .true.
             numbld(1) = 1
             next = .false.
             call tutor1 (icolor, numbld, ntext, text, frame, next,
     +                    updown)
             numbld(1) = 0
             numdec = numopt - 2
         elseif (numdec.eq.numopt) then
c
c numdec = numopt: cancel
c ================
c
            newdat = .false.
            repeet = .false.
         endif
         if (numdec.eq.0) numdec = numopt - 2
      enddo
c
c store isx then deallocate
c
      do i = 1, min(ncmax,nvmax)
         isxsav(i) = isx(i)
      enddo
      deallocate(isx, stat = ierr)
      deallocate(astart, stat = ierr)
      deallocate(a, stat = ierr)
      deallocate(b, stat = ierr)
      deallocate(c, stat = ierr)
      deallocate(cmeans, stat = ierr)
      deallocate(css, stat = ierr)
      deallocate(csw, stat = ierr)
      deallocate(r, stat = ierr)
      deallocate(s, stat = ierr)
      deallocate(x, stat = ierr)
      deallocate(wordx, stat = ierr)
c
c format statements
c
  100 format (
     + 'First time message: data format for K-means cluster analysis'
     +/
     +/'The multivariate data must be supplied as a matrix with n cases'
     +/'(rows) and m variables (columns), where n > 2 and m >= 1 and'
     +/'there are no missing values. The variables should be metric and'
     +/'if units differ greatly, so that large variables would dominate'
     +/'small ones, the data should be normalised before analysis, e.g.'
     +/'transforming so that all column means are zero and all column'
     +/'variances are equal to one.'
     +/
     +/'After reading in a data matrix, you install a starting cluster'
     +/'matrix with exactly m columns and k rows, where k < n, and you'
     +/'wish to assign the data to k clusters, or fewer. If you decide'
     +/'to transform the data interactively, the starting clusters will'
     +/'be transformed and all output will be in transformed space.'
     +/
     +/'Labels and starting clusters can be set from the data files, so'
     +/'before using your own data, browse and practise with the files:'
     +/'kmeans.tf1: multivariate data matrix (20 by 5)'
     +/'kmeans.tf2: starting cluster matrix (3 by 5)')
  200 format ( 
     + ' Title for current K-means cluster data:'
     +/,' ',A
     +/' Variables included:'
     +/,' ',A
     +/' Number of clusters:',1x,a
     +/' Additional run-time transform:',1x,a
     +/' Weighting:',1x,a
     +/
     +/'Data: New/Edit/Transform/View'
     +/'Calculate'
     +/'K: Change number of clusters'
     +/'K: Edit starting clusters'
     +/'K: New starting cluster matrix'
     +/'Method: transformation required'
     +/'Method: weighting options'
     +/'Table: cluster assignments'
     +/'Table: cluster parameters'
     +/'Table: cluster coordinates'
     +/'Save clusters to MANOVA type file'
     +/'View/Edit/Save/Print: Cases/Clusters'
     +/'View/Edit/Save/Print: Clusters/Cases'
     +/'Plot K-means clusters'
     +/'Suppress/Restore variables'
     +/'Install/Edit: weighting/scaling vectors'
     +/'Install/Edit: plot labels'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit K-means cluster analysis')
  300 format (
     +'Now input a matrix of starting estimates with',i4,' columns')
  400 format ('Cases (odd rows) and Clusters (even rows)')
  500 format (12i7)
  600 format ('Cluster   Size             WSSQ     Sum of weights')
  700 format (2i7,4x,1p,e13.5,6x,e13.5)
  750 format (2i7,4x,a13,6x,a13)
  800 format ('Final cluster centroids')
  900 format ('Requires at least two current variables')
 1000 format (
     + 'Overview of K-means cluster analysis'
     +/'It is supposed that m variables have been measured for n cases'
     +/'and the data have been formatted as a matrix file with n rows'
     +/'(n > 1) and m columns (m >= 1), e.g. using program Makmat.'
     +/'After supplying data you input a kmax by m matrix of starting'
     +/'estimates (K =< kmax < n) and the program will assign the cases'
     +/'to clusters in such a way as to minimise the sum of squares of'
     +/'distances from the cluster centroids. In so doing, new cluster'
     +/'coordinates are calculated. K can be varied interactively'
     +/'Weighting'
     +/'Advanced users can input a vector of nonnegative weights r(i)'
     +/'to weight cluster means and the sums of squares. These can be'
     +/'useful where the cases represent means of replicates and the'
     +/'numbers of replicates are not the same for all cases. However,'
     +/'r(i) can be used for arbitrary weights, e.g. setting r(i) = 0'
     +/'suppresses case(i), but only if weighting is selected. Once n'
     +/'data and k = kmax starting clusters have been assigned, you can'
     +/'edit starting clusters and change k, the number of clusters.'
     +/'Suitable test files'
     +/'kmeans.tf1 (everything), kmeans.tf2 (just starting clusters).')
 1100 format (
     + 'Pre-analysis suppression and transformation of variables'
     +/'You can select variables (columns) to include or suppress, and'
     +/'you may wish to normalise, transform to log, square roots, etc.'
     +/'to pre-process the data matrix before doing cluster analysis.'
     +/'This is required when variables differ greatly in size so that'
     +/'large variables will dominate small. If all x-values are counts'
     +/'root(x) is useful, for moderate differences in size log(x) (or'
     +/'log(1+x) if any x = 0) can be used, while root[root(x)] finds'
     +/'use where there are very large differences between variables.'
     +/'If all variables are measurements, not categorical variables or'
     +/'counts, normalising (to mean = 0, st.dev. = 1) is useful.'
     +/'Alternative starting cluster centroids'
     +/'Note that assignment of cases to the K clusters is not unique:'
     +/'the algorithm used is iterative and depends critically on the'
     +/'number of clusters requested and the centroids of the starting'
     +/'clusters. Once you have read in starting cluster data you can'
     +/'investigate the effect of changing starting clusters and K.'
     +/'Reading in new starting clusters can change the range allowed'
     +/'for K but note that 2 =< K =< kmax < n, and starting clusters'
     +/'are the first K rows of the kmax initial estimates. If you'
     +/'transform data interactively, then the starting estimates will'
     +/'be transformed and results will refer to transformed space.')
 1200 format (
     + 'Saving clusters to a Simfit MANOVA type file'
     +/'Once the data have been assigned to clusters you may wish to'
     +/'write the clusters to file for further analysis, e.g. MANOVA,'
     +/'PCA or canonical variates for the groups, etc. If you use this'
     +/'option the following information must be considered.'
     +/'1)`The file created will be a Simfit MANOVA type file.'
     +/'2)`The first column will contain the cluster group number.'
     +/'3)`The variables will be collected into the K-means groups.'
     +/'4)`Within groups the original data order will be preserved.'
     +/'5)`If an interactive transformation has been used for data (and'
     +/'  `starting centroids), then all results, displayed, plotted,'
     +/'  `or written to file will be in the transformed space.'
     +/'6)`Only active variables will be written to file, not any of'
     +/'  `the variables that may have been suppressed.'
     +/'7)`The cluster centroids will also be appended to the file.'
     +/'8)`If you want to use the groups as a training set, then the'
     +/'  `centroids must be overwritten by any new observation to be'
     +/'  `allocated and the extra lines counter adjusted accordingly.'
     +/'9)`If any groups have no. observations < no. variables you will'
     +/'  `be warned as many MANOVA techniques will not be possible.')
      end
c
c
