c
c
      subroutine clust3 (iwk, liwk, lwk, ncmax, ncsav, ndmax, nin, nout,
     +                   nrmax, nrsav, nsmall,
     +                   a, d,
     +                   fname, fsav, title, tsav,
     +                   newdat, supply)
c
c action: cluster analysis followed by metric /or non-metric scaling
c author: w.g.bardsley, university of manchester, u.k.
c         12/04/2005 derived from clust1
c         11/05/2005 added call to clust4
c         19/07/2005 added getlbl, savwrd, increased nisx to 2000 and
c                    moved call to getwrd
c         11/01/2006 moved b, r, s, wk, w1, x from arguments to allocatables
c         05/03/2006 added newdat and supply to argument list
c         21/06/2006 changed dimension of w1 to 2*nrmax and increased lwk
c         12/07/2006 noted increased size for liwk and lwk and defined lwk1 to
c                    dimension wk big enough for metric and non-metric scaling
c         27/06/2006 introduced NBIG to increase B for the case M > N
c         04/11/2006 edited and introduced eofint
c         11/11/2006 added allpos in call to eofint
c         19/12/2007 changed nisx to max(nrmax + ncmax,2000)
c         04/04/2011 added calls to puterr
c         08/02/2016 made liwk, lwk, and ndmax kind = 7, and also l1 is kind = 7 
c
c           iwk: workspace
c          liwk: (input/unchanged) dimension (>= 7*n + 2,
c                                                n(n -1)/2 + n*ndim + 5)
c           lwk: (input/unchanged) dimension (>= n + n*(n + 17)/2 - 1,
c                                                15*n*ndim,
c                                                2*n*(n - 1))
c         ncmax: (input/unchanged) column dimension
c         ncsav: (input/output) as follows:
c                ncsav =< 0 on entry or exit means no current data
c                ncsav > 0 on entry or exit means current data with ncsav columns
c         ndmax: (input/unchanged) dimension for distance matrix >= n(n - 1)/2
c           nin: (input/unchanged) unconnected unit for data input
c          nout: (input/unchanged) preconnected unit for results
c         nrmax: (input/unchanged) leading row dimension
c         nrsav: (input/output) as follows:
c                nrsav =< 0 on entry or exit means no current data
c                nrsav > 0 on entry or exit means current data with nrsav rows
c        nsmall: (input/unchanged) dimension for saved file/title names
c             a: (input/output) the current data matrix if ncsav and nrsav > 0
c        b, d, r, s, wk, w1, x: workspaces
c        fname, fsav, title, tsav: (input/output) depending on ncsav and nrsav
c                                   fname and title are for the current data and
c                                   fsav and tsav store for data selection and are
c                                   only used for archiving and data retrieval.
c                                   They can be ignored if this routine is stand-alone
c        newdat: (output) returned as .true. if new data requested
c        supply: (input/unchanged) if .true. then data matrix is supplied
c
      implicit   none
c
c arguments
c
      integer (kind = 7),  intent (in)    :: liwk, lwk, ndmax
      integer,             intent (in)    :: ncmax, nrmax, nsmall 
      integer,             intent (in)    :: nin, nout 
      integer,             intent (inout) :: ncsav, nrsav
      integer,             intent (inout) :: iwk(liwk)
      double precision,    intent (inout) :: a(nrmax,ncmax), d(ndmax)
      character (len = *), intent (inout) :: fname, fsav(nsmall), title,
     +                                       tsav(nsmall)
      logical,             intent (in)    :: supply
      logical,             intent (out)   :: newdat
c
c
c local allocatables
c
      integer,              allocatable :: isx(:)
      double precision,     allocatable :: b(:), r(:), s(:), wk(:),
     +                                     w1(:), x(:,:)
      character (len = 40), allocatable :: wordx(:)
c
c locals
c
      integer (kind = 7) l1, lwk1
      integer    i, icount, isend, j, ncol, nrow, nvar
      integer    ierr, ifail, ldx, m, n, nbig
      integer    nptcol, nptrow
      integer    icolor, ix, iy, lshade, numdec, nstart, ntext, numopt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1)
      integer    nisx, nvmax, nwmax, nxmin
      parameter (nvmax = 100, nwmax = 2000, nxmin = 1)
      integer    isxsav(nvmax), itype(4), numbld(30), numpos(20)
      double precision rtol
      double precision zero, one, f100
      parameter (zero = 0.0d+00, one = 1.0d+00, f100 = 100.0d+00)
      double precision x02amf$
      character  line*100, text(30)*100
      character  info(30)*100
      character  chop80*80, word80*80
      character  cipher*40, type1(4)*40
      character  dist*1, scale1*1, update*1
      character  blank*1, no_labels*11, too_many*80
      parameter (blank = ' ', 
     +      no_labels = '%no_labels%',
     +       too_many = 'Too many labels requested ... maxmimum = 2000')
      logical    first
      logical    abort, done, notyet, ok, ready, repeet, store,
     +           showit, simmat, weight, wtd
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .true.)
      logical    ffiles, frame, next, updown
      parameter (ffiles = .true., frame = .false., updown = .true.)
      logical    allpos
      parameter (allpos = .true.)
      external   lbox01, lbox02, statmt, chop80, putadv, putfat, cmscal,
     +           putifa, tutor1, nmscal, clust4, savwrd, getlbl,
     +           revpro, getwrd, pcawts, pcatrn, isxedi, isxtyp, isxvec,
     +           eofint, puterr 
      external   g03eaf$, x02amf$
      intrinsic  min, max
      save       isxsav, itype
      data       numbld / 30*0 /
      data       numpos / 20*1 /
      data       isxsav / nvmax*1 /
      data       itype / 1, 2, 4, 3 /
      data       icount / 0 /
c
c initialise newdat then check ncsav and nrsav if supply = .true.
c
      first = .true.
      newdat = .false.
      if (supply) then
         if (ncsav.lt.1 .or. ncsav.gt.ncmax .or.
     +       nrsav.lt.2 .or. nrsav.gt.nrmax) return
      else
         fname = 'No file'
         title = 'No data'
      endif
c
c allocate workspace
c
      ierr = 0
      if (allocated(isx)) deallocate(isx, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(b)) deallocate(b, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(r)) deallocate(r, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(s)) deallocate(s, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(w1)) deallocate(w1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(wk)) deallocate(wk, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(wordx)) deallocate(wordx, stat = ierr)
      if (ierr.ne.0) return
      allocate(isx(ncmax), stat = ierr)
      call puterr (ierr, 'A, CLUST3 vector isx')
      if (ierr.ne.0) return
      nbig = max(ncmax, nrmax)
      allocate(b(nbig), stat = ierr)
      call puterr (ierr, 'A, CLUST3 vector b')
      if (ierr.ne.0) return
      allocate(r(nrmax), stat = ierr)
      call puterr (ierr, 'A, CLUST3 vector r')
      if (ierr.ne.0) return
      allocate(s(ncmax), stat = ierr)
      call puterr (ierr, 'A, CLUST3 vector s')
      if (ierr.ne.0) return
c      lwk1 = max(lwk,
c     +           2*nrmax*(nrmax - 1),
c     +           45*nrmax,
c     +           nrmax + nrmax*(nrmax + 17)/2 - 1)
      l1 = nrmax 
      lwk1 = max(lwk,
     +           2*l1*(l1 - 1),
     +           45*l1,
     +           l1 + l1*(l1 + 17)/2 - 1) 
      allocate(w1(lwk1), stat = ierr)
      call puterr (ierr, 'A, CLUST3 vector w1')
      if (ierr.ne.0) return
      allocate(wk(lwk1), stat = ierr)
      call puterr (ierr, 'A, CLUST3 vector wk')
      if (ierr.ne.0) return
      allocate(x(nrmax,ncmax), stat = ierr)
      call puterr (ierr, 'A, CLUST3 matrix x')
      if (ierr.ne.0) return
      nisx = min(nrmax + ncmax,nwmax)  
      allocate(wordx(nisx), stat = ierr)
      call puterr (ierr, 'A, CLUST3 vector wordx')
      if (ierr.ne.0) return
c
c initialise
c
      do i = 1, ncmax
         if (i.le.nvmax) then
            isx(i) = isxsav(i)
         else
            isx(i) = 1
         endif
      enddo 
      write (info,1000)
      if (itype(3).eq.3) then
         itype(3) = 4
         call putadv (info(1))
      endif
      write (text,100)
      type1(1) = text(itype(1))(1:40)
      write (text,200)
      type1(2) = text(itype(2))(1:40)
      write (text,300)
      type1(3) = text(itype(3))(1:40)
      write (text,400)
      type1(4) = text(itype(4))(1:40)
      rtol = 1.0d+09*x02amf$()
      ncol = ncsav
      nrow = nrsav
      nvar = 0
      nptcol = 0
      nptrow = 0
      word80 = chop80(title)
      if (ncol.gt.0 .and. nrow.gt.1) then
c
c data supplied so initialise labels
c
         ready = .true.  
         call eofint (isx, ncsav,
     +                fname,
     +                abort, allpos) 
         call isxvec (isx, ncol, nvar, nxmin)
         if (nrow.gt.nwmax) then
            wordx(1) = no_labels
            i = 1
            store = .true.
            call savwrd (i,
     +                   wordx,
     +                   store)             
         else   
            isend = 1
            call getwrd (isend, ncol, nin, nrow, nisx,
     +                   fname, wordx)
            store = .true.
            call savwrd (nrow,
     +                   wordx,
     +                   store)
         endif
      else
c
c no data supplied
c
         ready = .false.
         ncol = 0
         nrow = 0
         nvar = 0
      endif
      do i = 1, nrmax
         r(i) = one
      enddo
      do i = 1, ncmax
         s(i) = one
      enddo
      done = .true.
      notyet = .false.
      ok = .false.
      weight = .false.
      wtd = .false.
c
c main loop ............................................................
c
       
      numdec = 0
      repeet = .true.
      do while (repeet)
         if (ncol.gt.0) then
            call isxtyp (isx, ncol, nvar, nxmin, 
     +                   line,
     +                   showit)
         else
            line = blank
            showit = .false.
         endif
         if (wtd) then
            cipher = '[weights R in use]'
         else
            cipher = '[weights R not used]'
         endif
         if (.not.ready) then
            word80 = 'No data'
            ok = .false.
            notyet = .true.
         endif
c
c set up the main menu
c
         write (text,500) word80, line, (type1(i), i = 1, 4), cipher
         nstart = 10
         numopt = 16
         ntext = nstart + numopt - 1
         if (numdec.eq.0) numdec = numopt - 1
         if (numdec.eq.1) then
            if (ready .and. .not.ok) numdec = 2
         elseif (numdec.eq.2) then
            if (.not.ready .or. ok) numdec = 1
         endif
         numbld(2) = 1
         numbld(4) = 1
         call lbox01 (icolor, ix, iy, lshade, numbld, numdec, numopt,
     +                numpos, nstart, ntext, 
     +                text,
     +                border, flash, high)
         if (first .and. numdec.eq.2) then
            first = .false. 
            icount = icount + 1
            write (nout,50) icount
         endif  
         numbld(2) = 0
         numbld(4) = 0
c
c check current data if analysis has been requested and set numdec = 0 on error
c
         if (numdec.eq.2) then
            ok = .false.
            if (.not.ready) then
               call putfat (info(2))
               numdec = 0
            else
               if (itype(3).eq.3) then
                  weight = .true.
               else
                  weight = .false.
               endif
               if (weight .and. nptcol.lt.ncol) then
                  weight = .false.
                  itype(3) = 4
                  type1(3) = 'Unscaled'
                  call putfat (info(3))
               endif
               if (weight) then
                  do i = 1, ncol
                     if (weight) then
                        if (isx(i).gt.0 .and. s(i).le.rtol) then
                           weight = .false.
                           itype(3) = 4
                           type1(3) = 'Unscaled'
                           call putfat (info(3))
                        endif
                     endif
                  enddo
               endif
               call isxvec (isx, ncol, nvar, nxmin)
               if (wtd .and. nptrow.lt.nrow) then
                  wtd = .false.
                  call putfat (info(4))
               endif
               if (numdec.eq.2) then
                  isend = 1
                  call pcatrn (isend, isx, itype(1), ncol, nrmax, nrow,
     +                         a, r, s, x,
     +                         abort, wtd)
                  if (abort) numdec = 0
               endif
            endif
         endif
c
c check if data are ready
c
         if (.not.ready) then
            if (numdec.ge.3 .and. numdec.le.13) then
               call putfat (info(2))
               numdec = 0
            endif
         endif
c
c check if data have been analysed
c
         if (.not.ok) then
            if (numdec.ge.8 .and. numdec.le.10) then
               call putfat (info(5))
               numdec = 0
            endif
         endif
c
c update the labels
c
         if (ok) then
            if (numdec.eq.9 .or. numdec.eq.10) then
               if (ready .and. notyet) then

c
c get the labels from store
c
                  if (nrow.le.nwmax) then
                     store = .false.
                     call savwrd (nrow,
     +                            wordx,
     +                            store)
                     if (wtd) then
c
c shuffle the labels if wtd = .true.
c
                        n = 0
                        do i = 1, nrow
                           if (r(i).gt.zero) then
                              n = n + 1
                              wordx(n) = wordx(i)
                           endif
                        enddo
                     else
                        n = nrow
                     endif
                  endif
               endif   
               notyet = .false.
            endif
         endif
c
c The main options .....................................................
c
         if (numdec.eq.1) then
c
c numdec = 1: new data
c ===========
c
            if (supply) then
               newdat = .true.
c
c store isx then deallocate workspace
c
               do i = 1, min(ncmax,nvmax)
                  isxsav(i) = isx(i)
               enddo
               deallocate(isx, stat = ierr)
               deallocate(b, stat = ierr)
               deallocate(r, stat = ierr)
               deallocate(s, stat = ierr)
               deallocate(wk, stat = ierr)
               deallocate(w1, stat = ierr)
               deallocate(x, stat = ierr)
               deallocate(wordx, stat = ierr)
               return
            endif
            ok = .false.
            ready = .false.
            call statmt (ncmax, ncsav, nout, nin, nrmax, nrsav, nsmall,
     +                   a, b, w1,
     +                   fname, fsav, title, tsav)
            ncol = ncsav
            nrow = nrsav
            if (ncsav.gt.0 .and. nrsav.gt.0) then
               abort = .false.
            else
               abort = .true.
            endif
            if (.not.abort .and. ncol.lt.1) then
               abort = .true.
               call putfat (info(6))
            endif
            if (.not.abort .and. nrow.lt.2) then
               abort = .true.
               call putfat (info(7))
            endif
            if (.not.abort) then
               i = (nrow*(nrow - 1))/2
               if (i.gt.ndmax) then
                  call putfat (info(8))
                  abort = .true.
               endif
            endif
            if (ncol.gt.nvmax) then
               abort = .true.
               call putfat (info(9))
            endif
            if (abort) then
c
c failure to read in data
c
               ready = .false.
               nvar = 0
               word80 = 'No data'
            else
c
c success so attempt to read labels off the file then store them
c
               ready = .true.       
               call eofint (isx, ncol,
     +                      fname,
     +                      abort, allpos)               
               call isxvec (isx, ncol, nvar, nxmin)
               word80 = chop80(title)
               if (nrow.gt.nwmax) then
                  wordx(1) = no_labels
                  i = 1
                  store = .true.
                  call savwrd (i,
     +                         wordx,
     +                         store)                  
               else   
                  isend = 1
                  call getwrd (isend, ncol, nin, nrow, nisx,
     +                         fname, wordx)
                  store = .true.
                  call savwrd (nrow,
     +                         wordx,
     +                         store)
               endif
               numdec = 2
            endif
         elseif (numdec.eq.2) then
c
c numdec = 2: calculate the distance matrix
c ===========
c

c
c step 1: define update
c ---------------------
c
            update = 'I'
c
c step 2: transform depending on itype(1)
c ---------------------------------------
c
            isend = 2
            call pcatrn (isend, isx, itype(1), ncol, nrmax, nrow,
     +                   a, r, s, x,
     +                   abort, wtd)
            if (abort) then
               ok = .false.
            else
               ok = .true.
c
c extra step to define n and only retain values for r(i) > 0
c
               if (wtd) then
                  n = 0
                  do i = 1, nrow
                     if (r(i).gt.zero) then
                        n = n + 1
                        do j = 1, ncol
                           x(n,j) = x(i,j)
                        enddo
                     endif
                  enddo
               else
                  n = nrow
               endif
            endif
c
c step 3: define dist depending on itype(2)
c -----------------------------------------
c
            i = itype(2)
            if (i.eq.1) then
               dist = 'A'
            elseif (i.eq.2) then
               dist = 'E'
            elseif (i.eq.3) then
               dist = 'S'
            elseif (i.eq.4 .or. i.eq.5) then
               dist = 'B'
            endif
c
c step 4: define scale1 depending on itype(3)
c -------------------------------------------
c
            i = itype(3)
            if (i.eq.1) then
               scale1 = 'S'
            elseif (i.eq.2) then
               scale1 = 'R'
            elseif (i.eq.3) then
               scale1 = 'G'
            else
               scale1 = 'U'
            endif
c
c step 5: call g03eaf$ only if ok and where n = ntotal
c ----------------------------------------------------
c
            if (ok) then
               m = ncol
               ldx = nrmax
               ifail = 1
               call g03eaf$(update, dist, scale1, n, m, x, ldx, isx,
     +                      b, d, ifail)
            else
               ifail = 3
            endif
            if (ifail.eq.0) then
c
c success so set ok = .true.
c
               if (dist.eq.'B') then
                  do i = 1, n*(n - 1)/2
                     d(i) = f100*d(i)
                  enddo
               endif     
               notyet = .true.
               ok = .true.
               done = .false.
               call putadv (info(10))
               numdec = 8
            else
c
c failure so set ok = .false.
c
               ok = .false.
               done = .true.
               numdec = numopt - 2
               if (ifail.ne.3)
     +         call putifa (ifail, nout, 'G03EAF/CLUST1')
               call putadv (info(11))
            endif
         elseif (numdec.eq.3) then
c
c numdec = 3: select a transformation
c
            write (text,100)
            numdec = itype(1)
            numopt = 6
            call lbox02 (icolor, ix, iy, numdec, numopt, numpos, 
     +                   text)
            if (numdec.ne.itype(1)) then
               ok = .false.
               itype(1) = numdec
               type1(1) = text(numdec)(1:40)
               numdec = 2
            else
               numdec = 1
            endif
         elseif (numdec.eq.4) then
c
c numdec = 4: select a distance measure
c ===========
c
            write (text,200)
            numdec = itype(2)
            numopt = 5
            call lbox02 (icolor, ix, iy, numdec, numopt, numpos,
     +                   text)
            if (numdec.ne.itype(2)) then
               ok = .false.
               itype(2) = numdec
               type1(2) = text(numdec)(1:40)
               numdec = 2
            else
               numdec = 1
            endif
         elseif (numdec.eq.5) then
c
c numdec = 5: select a scaling
c ===========
c
            write (text,300)
            numdec = itype(3)
            numopt = 4
            call lbox02 (icolor, ix, iy, numdec, numopt, numpos,
     +                   text)
            if (numdec.ne.itype(3)) then
               ok = .false.
               itype(3) = numdec
               type1(3) = text(numdec)(1:40)
               numdec = 2
            else
               numdec = 1
            endif
            if (itype(3).eq.3) then
               call putadv (info(12))
             endif
         elseif (numdec.eq.6) then
c
c numdec = 6: select a link
c ===========
c
            write (text,400)
            numdec = itype(4)
            numopt = 6
            call lbox02 (icolor, ix, iy, numdec, numopt, numpos, 
     +                   text)
            if (numdec.ne.itype(4)) then
               ok = .false.
               itype(4) = numdec
               type1(4) = text(numdec)(1:40)
               numdec = 2
            else
               numdec = 1
            endif
         elseif (numdec.eq.7) then
c
c numdec = 7: select to use/not-use weights r
c ===========
c
            numdec = 1
            numopt = 2
            text(1) = 'Unweighted for replicates'
            text(2) = 'Weighted for replicates'
            call lbox02 (icolor, ix, iy, numdec, numopt, numpos, 
     +                   text)
            if (numdec.eq.1) then
               if (wtd) then
                  ok = .false.
                  wtd = .false.
                  numdec = 2
               else
                  numdec = 1
               endif
            else
               if (wtd) then
                  numdec = 2
               else
                  ok = .false.
                  wtd = .true.
                  call putadv (info(13))
               endif
            endif
         elseif (numdec.eq.8) then
c
c numdec = 8: view/file/save
c
           if (ok) then
               write (text,600) word80, line, (type1(i), i = 1, 4),
     +                          cipher
               if (itype(2).eq.5) then
                  simmat = .true.
                  do i = 1, (n*(n - 1))/2
                     d(i) = f100 - d(i)
                  enddo
               else
                  simmat = .false.   
               endif
               call clust4 (n, nin, nout,
     +                      d,
     +                      info, text,
     +                      done, ok, simmat)
               if (itype(2).eq.5) then
                  do i = 1, (n*(n - 1))/2
                     d(i) = f100 - d(i)
                  enddo
               endif
            endif
            numdec = 9
         elseif (numdec.eq.9) then
c
c numdec = 9: classical metric scaling
c ============
c
            call cmscal (iwk, liwk, lwk1, n, ncmax, nout, nrmax,
     +                   d, w1, wk, x,
     +                   wordx)
            numdec = 1
         elseif (numdec.eq.10) then
c
c numdec = 10: non-metric scaling
c ============
c
            call nmscal (iwk, liwk, lwk1, n, ncmax, nout, nrmax,
     +                   d, w1, wk, x,
     +                   wordx)
            numdec = 1
         elseif (numdec.eq.11) then
c
c numdec = 11: select to suppress/restore variables
c ============
c
            call isxedi (isx, ncol, nvar, nxmin)
            ok = .false.
            numdec = 2
         elseif (numdec.eq.12) then
c
c numdec = 12: select to use a weighting vector
c ============
c
            ok = .false.
            isend = 3
            call pcawts (isend, nin, nptrow, nptcol, nrow, ncol, nrmax,
     +                   r, s, w1)
            numdec = 2
         elseif (numdec.eq.13) then
c
c numdec = 13: install/edit labels
c ===========
c
            if (nrow.gt.nwmax) then
               call putfat (too_many)
            else    
               isend = 1
               call getlbl (isend, nrow,
     +                      wordx,
     +                      ffiles)
               store = .true.
               call savwrd (nrow,
     +                      wordx,
     +                      store)
            endif
            notyet = .true.
         elseif (numdec.eq.numopt - 2) then
c
c numdec = numopt - 2: review progress
c ====================
c
             call revpro (nout)
             numdec = 2            
         elseif (numdec.eq.numopt - 1) then
c
c numdec = numopt - 1: help
c ====================
c
             write (text,700)
             ntext = 20
             numbld(1) = 1
             numbld(17) = 1
             next = .true.
             call tutor1 (icolor, numbld, ntext,
     +                    text, 
     +                    frame, next, updown)
             numbld(1) = 0
             numbld(17) = 0
             write (text,800)
             ntext = 20
             next = .true.
             numbld(1) = 1
             numbld(9) = 1
             numbld(18) = 1
             next = .true.
             call tutor1 (icolor, numbld, ntext,
     +                    text, 
     +                    frame, next, updown)
             numbld(1) = 0
             numbld(9) = 0
             numbld(18) = 0
             write (text,900)
             ntext = 20
             next = .false.
             numbld(1) = 1
             numbld(13) = 1
             next = .false.
             call tutor1 (icolor, numbld, ntext,
     +                    text, 
     +                    frame, next, updown)
             numbld(1) = 0
             numbld(13) = 0
             numdec = 2

         elseif (numdec.eq.numopt) then
c
c numdec = numopt: cancel
c ================
c
            newdat = .false.
            repeet = .false.
         endif
      enddo
c
c store isx then deallocate workspace
c
      do i = 1, min(ncmax,nvmax)
         isxsav(i) = isx(i)
      enddo
      deallocate(isx, stat = ierr)
      deallocate(b, stat = ierr)
      deallocate(r, stat = ierr)
      deallocate(s, stat = ierr)
      deallocate(wk, stat = ierr)
      deallocate(w1, stat = ierr)
      deallocate(x, stat = ierr)
      deallocate(wordx, stat = ierr)
c
c format statements
c
   50 format (
     +/' Metric and Non-metric scaling analysis number:', i3
     +/' -------------------------------------------------') 
  100 format (
     + 'Untransformed'
     +/'Square root'
     +/'Fourth root'
     +/'Log(x)'
     +/'Log(1 + x)'
     +/'Normalise variables to mean=0, st.dev.=1')
  200 format (
     + 'Absolute distance (city block metric)'
     +/'Euclidean distance'
     +/'Euclidean squared distance'
     +/'Bray-Curtis dissimilarity (%)'
     +/'Bray-Curtis similarity (%)')
  300 format (
     + 'Sample standard deviations'
     +/'Ranges'
     +/'Weights provided'
     +/'Unscaled')
  400 format (
     + 'Single link (nearest neighbour)'
     +/'Complete link (furthest neighbour)'
     +/'Group average'
     +/'Centroid'
     +/'Median'
     +/'Minimum variance')
  500 format (
     + ' Title for current scaling analysis data:'
     +/1x,A
     +/' Variables included:'
     +/1x,A
     +/' Transformation:',1x,a
     +/' Distance:',1x,a
     +/' Scaling:',1x,a
     +/' Linkage:',1x,a
     +/
     +/'Data options: New/Edit/Transform/View'
     +/'Calculate: distance matrix'
     +/'Change: transformation'
     +/'Change: distance measure'
     +/'Change: scaling'
     +/'Change: cluster link'
     +/'Change: weighting',1x,a
     +/'Distance matrix: View/File/Save As...'
     +/'Post-analysis scaling: classical metric (MDS)'
     +/'Post-analysis scaling: non-metric (STRESS)'
     +/'Variables: suppress/restore'
     +/'Install/Edit: weighting/scaling vectors'
     +/'Install/Edit: plot labels'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit scaling options')
  600 format (
     + ' Title for current scaling analysis data:'
     +/1x,A
     +/' Variables included:'
     +/1x,A
     +/' Transformation =',1X,A
     +/' Distance =',1X,A
     +/' Scaling =',1X,A
     +/' Linkage =',1X,A
     +/' Weighting',1X,A
     +/' Distance matrix (strict lower triangle) is:')
  700 format (
     + 'Overview of multivariate cluster analysis and scaling'
     +/
     +/'It is supposed that m variables have been measured for n cases'
     +/'and the data have been formatted as a matrix file with n rows'
     +/'(n > 1) and m columns (m > 1), e.g. using program MAKMAT.'
     +/'You can select variables (columns) to include and variables to'
     +/'suppress, and you can transform by logs, square roots, etc.'
     +/'to pre-process the data matrix before doing cluster analysis.'
     +/'Several alternative distance measures are available, and each'
     +/'gives a different distance matrix (i.e. dissimilarity matrix).'
     +/'To prevent swamping of small variables by large values you can'
     +/'use automatic scaling procedures or use a scaling vector S with'
     +/'m positive weights s(i), e.g. standard deviations.'
     +/'Advanced users may wish to use an arbitray row weighting vector'
     +/'R, e.g. r(i) could be no. of replicates to estimate case i.'
     +/
     +/'The distance matrix'
     +/
     +/'This is a symmetrical matrix with elements d(i,j), where these'
     +/'distances are not unique, but depend on the algorithms used.')
  800 format (
     + 'Pre-analysis transformation of variables'
     +/'This is required when variables differ greatly in size so that'
     +/'large variables will dominate small. If all x-values are counts'
     +/'root(x) is useful, for moderate differences in size log(x) (or'
     +/'log(1+x) if any x = 0) can be used, while root[root(x)] finds'
     +/'use where there are very large differences between variables.'
     +/'If all variables are measurements and not categorical variables'
     +/'or counts, standardisation to (0,1) is often recommended.'
     +/'Alternative distance measures'
     +/'With measurements, Euclidean or Euclidean squared distances'
     +/'should be used, but with counts the absolute distance or scaled'
     +/'absolute distance (i.e. Bray-Curtis) are used. You can select'
     +/'Bray-Curtis similarity, i.e. (100 - Bray Curtis dissimilarity)'
     +/'scaling instead of pre-analysis transformation'
     +/'Instead of transforming, scaling can be used, and experts can'
     +/'supply a vector of standard deviations that may be more'
     +/'representative than the current sample standard deviations.'
     +/'The link functions'
     +/'The group average is often recommended, but note that all these'
     +/'alternative settings will alter the shape of scaling plots.')
  900 format (
     + 'Post-analysis metric scaling (principal coordinates)'
     +/'If the d(i,j) in the distance matrix are meaningful and'
     +/'all eigenvalues are nonnegative, then the 2D and 3D plots can'
     +/'be interpreted as lower dimensional representations of the'
     +/'distances between the cases. For instance, coordinates with'
     +/'values 3, 4 and 5 can be represented as a triangle. If the'
     +/'distance matrix elements all obey the triangle inequality'
     +/'d(i,j) =< d(i,k) + d(j,k)'
     +/'then eigenvalues of the derived matrix will be nonnegative,'
     +/'and it will be possible to do this, otherwise a warning message'
     +/'will be generated.'
     +/
     +/'Post-analysis non-metric (ordinal) scaling'
     +/'If only the ranks are meaningful, then non-metric scaling will'
     +/'have to be used. This requires an iterative procedure to find'
     +/'a minimum of the STRESS or S-STRESS functions, which estimate'
     +/'the extent to which the fitted matrix preserves the order in'
     +/'the distance matrix. Non-metric scaling may only find a local'
     +/'minimum, and random starting estimates may be required if you'
     +/'want to confirm that a solution is global.')
 1000 format (
     + 'Weighting has been cancelled ... re-select if needed'          !1
     +/'First read in some data'                                       !2
     +/'Deficient S vector  ...  Scaling cancelled'                    !3
     +/'Deficient R vector  ...  replicate weighting cancelled'        !4
     +/'First calculate the distance matrix'                           !5
     +/'Must have at least 1 column'                                   !6
     +/'Must have at least 2 rows'                                     !7
     +/'Sample size is too large'                                      !8
     +/'Dimension exceeded: ncol > nvmax'                              !9
     +/'Distance matrix has been calculated'                           !10
     +/'Distance matrix cannot be calculated'                          !11
     +/'This requires a consistent scaling vector, S'                  !12
     +/'This requires a consistent replicates weighting vector, R'     !13
     +/'Distance matrix has been written to results file'              !14
     +/'Write (large) D-matrix to results file (usually no ?)'         !15
     +/'Write (huge) D-matrix to results file (almost certainly no ?)')!16
      end
c
c
