c
c
      subroutine clust4 (n, nin, nout,
     +                   d,
     +                   info, text,
     +                   done, ok, simmat)
c
c action: view/file/save strict lower triangle of distance matrix
c author: w.g.bardsley, university of manchester, u.k., 10/05/2005
c         16/05/2006 changed formats 300 and 400 to allow for i4 editing
c                    and trapped cases with n >= nmax1, and n >= nmax2 
c         04/11/2006 added intents 
c         05/06/2009 added call to clust5 for nearest neighbour distances
c                    replaced table1 by table5 and decreased nmax1 and nmax2 
c                    from 10000, 1000 to 5000 and 500
c         29/11/2021 added e_numbers and e_formats, etc.  
c         08/07/2022 checked that d09(nmax1) doesn't overflow due to d(n(n-1)/2)  
c                    and now outputs strict lower triangle with row colum labels
C         20/07/2022 option to suppress row and column labels to avoid confusion (as controlled by new_method)    
c
c             n: (input/unchanged) number of cases
c           nin: (input/unchanged) unconnected unit for file opening
c          nout: (input/unchanged) preconnected unit for results
c             d: (input/unchanged) distance matrix in lower triangular form
c          info: (input/unchanged) messages
c          text: (input/unchanged) title etc.
c          done: (input/output) depends on whether result has been recorded
c            ok: (input/output) check for consistency
c        symmat: (input/unchanged) matrix is a similarity matrix
c
      implicit none
c
c arguments
c
      integer,             intent (in)    :: n, nin, nout
      double precision,    intent (in)    :: d(n*(n - 1)/2)
      character (len = *), intent (in)    :: info(*), text(*)
      logical,             intent (in)    :: simmat
      logical,             intent (inout) :: done, ok
c
c locals
c
      integer    i, icount, j, k, l, numdec
      integer    icolor, isend, ix, iy
      parameter (icolor = 7, isend = 1, ix = 4, iy = 4)
      integer    nmax1, nmax2, numopt
      parameter (nmax1 = 5000, nmax2 = 500, numopt = 5)
      double     precision temp 
      character (len = 9) d9(nmax1), form09
      character (len = 13) d13, showrj
      character  items(numopt)*100, word100*100
      character  fname*1024
      character  blank*1, error1*100, error2*100, error3*100, iwarnu*4 
      parameter (blank = ' ',
     +           error1 = 'Distance matrix is too large to view',
     +           error2 = 'Matrix is too large to add to results file',
     +           error3 = 'This is a similarity not a distance matrix')
      logical    new_method
      logical    e_numbers, e_formats
      logical    abort, fileit, repeet
      external   e_formats, form09, showrj
      external   table5, listbx, yesno2, putadv, clust5,
     +           putwar, ofiles 
c
c initialise new_method and e_numbers
c     
      new_method = .false.
      e_numbers = e_formats()
c
c check
c
      if (n.lt.2) ok = .false.
      if (.not.ok) return
      if (simmat) then
         iwarnu = '[NA]'
         call putwar (error3)
      else
         iwarnu = blank
      endif        
      write (items,100) iwarnu
      numdec = 1
c
c main loop
c
     
      repeet = .true.
      do while (repeet)
         call listbx (numdec, numopt,
     +                items)
c
c trap large matrices and issue error messages
c
         if (numdec.eq.1 .and. n*(n - 1)/2.gt.nmax1) then
            numdec = numopt
            call putadv (error1)
         elseif (numdec.eq.2 .and. n*(n - 1)/2.gt.nmax2) then
            numdec = numopt
            call putadv (error2)
         endif
         if (numdec.eq.1) then
c
c numdec = 1: view distance matrix
c ===========
c
            k = 15
            call table5 (k, 'OPEN')
            do i = 1, 10
               if (i.eq.2 .or. i.eq.4 .or. i.eq.10) then
                  k = 4
               else
                  k = 0
               endif
               call table5 (k,text(i))
            enddo
            k = 0
            icount = 1
            do i = 2, n
               if (n.le.9) then
c
c small matrix so index is not required
c
                  if (e_numbers) then
                     write  (word100,200) (d(j), j = icount, 
     +                                           icount + i - 2)
                  else
                     do j = icount, icount + i - 2 
                        d9(j) = form09(d(j))
                     enddo 
                     write  (word100,250) (d9(j), j = icount,
     +                                            icount + i - 2) 
                  endif  
                  icount = icount + i - 1
                  call table5 (k, word100)
               elseif (i.le.9) then
c
c large matrix and short lines so just the index required
c                 
                  if (e_numbers) then
                     write  (word100,300) i, (d(j), j = icount,
     +                                              icount + i - 2)
                  else
                     do j = icount, icount + i - 2
                        d9(j) = form09(d(j))
                     enddo  
                     write  (word100,350) i, (d9(j), j = icount,
     +                                               icount + i - 2)   
                  endif  
                  icount = icount + i - 1
                  call table5 (k, word100)
               else
c
c large matrix and longer lines so index and wrap round required
c
                  do l = 1, (i - 1)/8
                     if (e_numbers) then
                        write  (word100,400) i, (d(j), j = icount,
     +                                                 icount + 7)
                     else
                        do j = icount, icount + 7
                           d9(j) = form09(d(j))
                        enddo
                        write  (word100,450) i, (d9(j), j = icount,
     +                                                  icount + 7)  
                     endif  
                     icount = icount + 8
                     call table5 (k, word100)
                  enddo
c
c the last items after a wrap round
c
                  l = i - 1 - ((i - 1)/8)*8
                  if (l.gt.0) then
                     if (e_numbers) then
                        write  (word100,300) i, (d(j), j = icount,
     +                                                 icount + l - 1)
                     else
                        do j = icount, icount + l - 1
                           d9(j) = form09(d(j))
                           enddo    
                           write  (word100,350) i, (d9(j), j = icount,
     +                                          icount + l - 1)
                     endif
                     icount = icount + l
                     call table5 (k, word100)
                  endif
               endif
            enddo
            call table5 (k, 'CLOSE')
         elseif (numdec.eq.2) then
c
c numdec = 2: file distance matrix
c ===========
c
            if (done) then
               fileit = .false.
               call putadv (info(14))
            else
               if (n.le.10) then
                   fileit = .true.
               elseif (n.le.50) then
                  fileit = .false.
                  call yesno2 (icolor, ix, iy, 
     +                         info(15),
     +                         fileit)
               else
                  fileit = .false.
                  call yesno2 (icolor, ix, iy,
     +                         info(16),
     +                         fileit)
               endif
               if (fileit) done = .true.
            endif
            if (fileit) then
               write (nout,'(a)') blank
               do i = 1, 9
                  write (nout,'(a)') text(i)
               enddo
               write (nout,'(a)') blank
               write (nout,'(a)') text(10)
               icount = 1
               do i = 2, n
                  if (n.le.9) then
c
c small matrix so index is not required
c                    
                     if (e_numbers) then
                        write  (word100,200) (d(j), j = icount,
     +                                              icount + i - 2)
                     else
                        do j = icount, icount + i - 2 
                           d9(j) = form09(d(j))
                        enddo 
                        write  (word100,250) (d9(j), j = icount,
     +                                               icount + i - 2)  
                     endif  
                     icount = icount + i - 1
                     write (nout,'(a)') word100
                  elseif (i.le.9) then
c
c large matrix and short lines so just the index required
c
                     if (e_numbers) then
                       write  (word100,300) i, (d(j), j = icount,
     +                                                icount + i - 2)
                     else
                        do j = icount, icount + i - 2
                           d9(j) = form09(d(j))
                        enddo  
                        write  (word100,350) i, (d9(j), j = icount,
     +                                                  icount + i - 2)  
                     endif  
                     icount = icount + i - 1
                     write (nout,'(a)') word100
                  else
c
c large matrix and longer lines so index and wrap round required
c
                    do l = 1, (i - 1)/8
                       if (e_numbers) then
                          write  (word100,400) i, (d(j), j = icount,
     +                                                   icount + 7)
                        else
                           do j = icount, icount + 7
                              d9(j) = form09(d(j))
                           enddo
                           write  (word100,450) i, (d9(j), j = icount,
     +                                                     icount + 7) 
                        endif  
                        icount = icount + 8
                        write (nout,'(a)') word100
                     enddo
c
c the last items after a wrap round
c
                    l = i - 1 - ((i - 1)/8)*8
                    if (l.gt.0) then
                        if (e_numbers) then
                           write  (word100,300) i, (d(j), j = icount,
     +                                          icount + l - 1)
                        else
                           do j = icount, icount + l - 1
                              d9(j) = form09(d(j))
                           enddo    
                           write  (word100,350) i, (d9(j), j = icount,
     +                                          icount + l - 1) 

                        endif  
                        icount = icount + l
                        write (nout,'(a)') word100
                     endif
                  endif
               enddo
               call putadv (info(14))
            endif
         elseif (numdec.eq.3) then
c
c numdec = 3: Save As ...
c ===========
c
            if (simmat) call putwar (error3) 
            call ofiles (isend, nin,
     +                   fname,
     +                   abort)
            if (.not.abort) then   
               open (unit = nin, file = fname) 
              
               if (new_method) then
                  write (nin,'(a)')   
     +'Distance matrix D(i,j) with row (i) and column (j) values'
                   write (nin,'(2i6)') n*(n - 1)/2, 3
               else
                  write (nin,'(a)')    
     +'Distance matrix D(i,j) as strict lower triangle packed by rows'
                  write (nin,'(2i6)') n*(n - 1)/2, 1
               endif
               k = 0
               do i = 2, n
                  do j = 1, i - 1
                     k = k + 1
                     temp = d(k)
                     d13 = showrj(temp)
                     if (new_method) then
                        if (e_numbers) then 
                           write (nin,'(i6,i6,2x,1p,e13.5)') i, j, temp
                        else   
                           write (nin,'(i6,i6,2x,a)') i, j, d13
                        endif
                     else 
                        if (e_numbers) then 
                           write (nin,'(2x,1p,e13.5)') temp
                        else   
                           write (nin,'(2x,a)') d13
                        endif
                     endif        
                  enddo
               enddo
              write (nin,'(i6)') 10
              do i = 1, 10
                  write (nin,'(a)') text(i)
               enddo   
               close (unit = nin)
            endif
         elseif (numdec.eq.4) then   
c
c numdec = 4: nearest neighbour distances
c ===========
c         
            if (simmat) then
               call putadv (error3)
            else     
               call clust5 (n, nin, nout,
     +                      d)             
            endif
         elseif (numdec.eq.numopt) then
c
c numdec = 5: cancel
c ===========
c
            repeet = .false.
         endif
      enddo
  100 format (
     + 'Strict lower triangle: view'
     +/'Strict lower triangle: write to results file'
     +/'Strict lower triangle: Save As ...'
     +/'Calculate nearest neighbour distances',1x,a
     +/'Quit ... Exit these options')
  200 format (1p,8e9.2)
  250 format (8(1x,a9))
  300 format (i4,')',1p,8e9.2)
  350 format (i4,')',8(1x,a9)) 
  400 format (i4,')',1p,8e9.2,'(+)')
  450 format (i4,')',8(1x,a9),'(+)')
      end
c
c




