c
c
      subroutine clust5 (n, nin, nout,
     +                   d)
c
c action: calculate nearest neighbours given a distance matrix
c author: w.g.bardsley, university of manchester, u.k., 05/06/2009
c         04/04/2011 added calls to puterr
c         29/12/2021 added calls to e_numbers and e_formats, etc.
c
      implicit none
c
c arguments
c      
      integer,          intent (in) :: n, nin, nout
      double precision, intent (in) :: d(n*(n - 1)/2)
c
c allocatable
c      
      integer, allocatable :: nearest(:)
      double precision, allocatable :: x(:), y(:)
c
c locals
c      
      integer    i, icount, icolor, ierr, j, nmax, npts
      integer    isend, numdec, numopt, numtxt
      parameter (isend = 1, numopt = 6, numtxt = 20)
      integer    numbld(numtxt)
      double precision dist
      double precision xbig, zero
      parameter (xbig = 1.0d+300, zero = 0.0d+00)
      character (len = 13) d13, showlj
      character  fname*1024, line*100, text(numtxt)*100, title*80
      character  ok1*10, ok2*10, ok3*10
      character  blank*1
      parameter (blank = ' ')
      logical    e_numbers, e_formats
      logical    abort, done1, done2, done3, repeet	
      logical    qtext, qtitle
      parameter (qtext = .true., qtitle = .true.)
      external   e_formats, showlj
      external   listbx, table5, vecout, putadv, patch2, puterr
      intrinsic  dble
      data       numbld /numtxt*0 /
c
c check then allocate
c      
      if (n.lt.2) return
      do i = 1, n*(n - 1)/2
         if (d(i).lt.zero) return
      enddo
      
      ierr = 0 
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y)) deallocate(y, stat = ierr)
      if (ierr.ne.0) return        
      if (allocated(nearest)) deallocate(nearest, stat = ierr)
      if (ierr.ne.0) return  
   
      nmax = n
      allocate(x(nmax), stat = ierr)
      call puterr (ierr, 'A, CLUST5 vector x')
      if (ierr.ne.0) return
      allocate(y(nmax), stat = ierr)
      call puterr (ierr, 'A, CLUST5 vector y')
      if (ierr.ne.0) return  
      allocate(nearest(nmax), stat = ierr)
      call puterr (ierr, 'A, CLUST5 vector nearest')
      if (ierr.ne.0) return  
c
c initialise distances
c        
      do i = 1, n
         nearest(i) = 0
         x(i) = xbig
      enddo     
c
c assign distances
c
      icount = 0
      do i = 2, n
         do j = 1, i - 1
            icount = icount + 1
            dist = d(icount)
            if (dist.lt.x(i)) then
              x(i) = dist
              nearest(i) = j
            endif   
            if (dist.lt.x(j)) then
               x(j) = dist  
               nearest(j) = i
            endif   
         enddo    
      enddo
c
c main loop
c  
      e_numbers = e_formats()
      ok1 = blank
      ok2 = blank
      ok3 = blank
      done1 = .false.
      done2 = .false.
      done3 = .false.
      
      repeet = .true.
      numdec = 1    
      do while (repeet)
         write (text,100) ok1, ok2, ok3
         call listbx (numdec, numopt,
     +                text)
         if (numdec.eq.1) then
c
c table
c          
            icolor = 15
            call table5 (icolor, 'OPEN')
            icolor = 4
            write (line,200)
            call table5 (icolor, line)
            icolor = 0
            do i = 1, n
               if (e_numbers) then
                  write (line,300) i, nearest(i), x(i)
               else
                  d13 = showlj(x(i))
                  write (line,350) i, nearest(i), d13
               endif  
               call table5 (icolor, line)
            enddo
            call table5 (icolor, 'CLOSE') 
            numdec = numopt 
         elseif (numdec.eq.2) then
c
c results file
c         
            if (.not.done1) then
               done1 = .true.
               write (nout,'(a)') 
               write (nout,200)
               do i = 1, n
                  if (e_numbers) then
                     write (nout,300) i, nearest(i), x(i)
                  else
                     d13 = showlj(x(i))
                     write (nout,350) i, nearest(i), d13
                  endif  
               enddo     
               ok1 = '(Done)'
            else
               write (line,400)
               call putadv (line)   
            endif   
            numdec = numopt 
        elseif (numdec.eq.3) then
c
c Save distances As ...
c         
            if (.not.done2) then
               fname = blank
               write (title,500) 
               npts = nmax
               close (unit = nin)
               call vecout (isend, nmax, nin, npts,
     +                      x,
     +                      fname, title,
     +                      abort, qtext, qtitle)
               close (unit = nin)         
               if (.not.abort) then
                  done2 = .true.
                  ok2 = '(Done)'
               endif   
            else 
               write (line,400)
               call putadv (line)                     
            endif    
            numdec = numopt 
         elseif (numdec.eq.4) then
c
c Save neighbours As ...
c         
            if (.not.done3) then
               fname = blank
               write (title,600) 
               npts = nmax
               do i = 1, npts
                  y(i) = dble(nearest(i))
               enddo   
               close (unit = nin)
               call vecout (isend, nmax, nin, npts,
     +                      y,
     +                      fname, title,
     +                      abort, qtext, qtitle)
               close (unit = nin)         
               if (.not.abort) then
                  done3 = .true.
                  ok3 = '(Done)'
               endif   
            else 
               write (line,400)
               call putadv (line)                     
            endif                
            numdec = numopt 
         elseif (numdec.eq.numopt - 1) then
c
c help
c         
            write (text,700)
            numbld(1) = 1
            numbld(10) = 1
            call patch2 (numbld, numtxt,
     +                   text)
            numbld(1) = 0
            numbld(10) = 0              
            numdec = 1 
         else
            repeet = .false.
         endif  
      enddo
c
c deallocate
c       
      deallocate(x, stat = ierr) 
      deallocate(y, stat = ierr) 
      deallocate(nearest, stat = ierr) 
c
c format statements
c      
  100 format (
     + 'View nearest neighbours and distances'
     +/'Write neighbours and distances to results file',2x,a
     +/'Save distances As ... ',2x,a
     +/'Save neighbours As ... ',2x,a
     +/'Help'
     +/'Quit ... Exit nearest neighbour options')      
  200 format ('  Object Nearest    Distance')
  300 format (2i8,1p,e15.5)     
  350 format (2i8,4x,a)     
  400 format ('Already been done')
  500 format ('Nearest neighbour distances')
  600 format ('Nearest neighbours')
  700 format (
     + 'Nearest neighbours and distances'
     +/
     +/'Given a n by m multivariate data matrix, the distances between'
     +/'cases is a n by n symmetric matrix with zero diagonals. To save'
     +/'space, the matrices are stored as strict lower triangles packed' 
     +/'by rows. That is, distances D(i,j) are kept as a vector V with'
     +/'n(n - 1)/2 elements, where V((i - 1)(i - 2)/2 + j) holds'
     +/'the distance D(i,j) for i > j.' 
     +/
     +/'This control provides the following procedures.'
     +/
     +/'1.`For each object i (1 =< i =< n) the distances between it and'
     +/'  `the remaining (n - 1) objects are compared.'
     +/'2.`The object that is closest, i.e. the nearest neighbour, is'
     +/'  ` recorded.'
     +/'3.`The nearest distances are also recorded.'
     +/'4.`The distances to nearest neighbours can be written in the'
     +/'  `logical order to a vector file.'
     +/'5.`The nearest neighbours can be written in logical order to a'
     +/'  `vector file, i.e. stored as numerical values not integers.')  
      end
c
c
c      
        