c
c
      subroutine cmscal (iwk, liwk, lwk, n, ncmax, nout, nrmax,
     +                   d, w1, wk, x,
     +                   wordx)
c
c action: classical metric scaling
c author: w.g.bardsley, university of manchester, u.k., 12/04/2005
c         16/05/2005 edited, changed epsi and calculation of frac as the
c                    eigenvalues are actually scaled on exit from g03faf$
c         10/11/2005 changed call pltlab to call lbplot
c         04/11/2006 added intents 
c         01/01/2008 added nwmax, no_labels, and too_many
c         27/10/2009 now also shows fraction based on absolute values 
c         12/11/2016 added call to pcaplt
c         30/12/2021 added e_numbers and e_formats, etc.
c
c     iwk: workspace
c    liwk: (input/unchanged) dimension >= 5*n
c     lwk: (input/unchanged) dimension >= n(n + 17)/2 - 1
c       n: (input/unchanged) effective sample size > 1
c   ncmax: (input/unchanged) dimension
c    nout: (input/unchanged) preconnected unit for results
c   nrmax: (input/unchanged) dimension
c       d: (input/unchanged) distance matrix packed as lower triangle by rows
c      w1: workspace
c      wk: workspace
c       x: workspace
c   wordx: (input/output) labels
c
      implicit   none
c
c arguments
c
      integer (kind = 7),  intent (in)    :: liwk, lwk
      integer,             intent (in)    :: n, ncmax, nout,
     +                                       nrmax
      integer,             intent (inout) :: iwk(liwk)
      double precision,    intent (in)    :: d(n*(n - 1)/2)
      double precision,    intent (inout) :: w1(n), wk(lwk),
     +                                       x(nrmax,ncmax)
      character (len = *), intent (inout) :: wordx(*)
c
c locals
c
      integer    i, l, m, numopt, nwmax, ntype
      parameter (l = 0, numopt = 9, nwmax = 2000, ntype = 3)
      integer    icolor, ifail, nbot, ndim, negeig, ntop, numdec
      integer    nx, ny, nz
      integer    ksav, k1, k2, k3, k4, k5, nswap
      double precision x_factor, y_factor
      double precision eigmin, frac1, frac2, scale1, scale2
      double precision f100, epsi, zero, one
      parameter (f100 = 100.0d+00, epsi = 1.0d-7, zero = 0.0d+00, 
     +           one = 1.0d+00)
      character (len = 100) line, text(30)
      character (len = 60 ) ptitle
      character (len = 50 ) xtitle, ytitle
      parameter (ptitle = 'Classical Metric Scaling')
      character (len = 13 ) d13, showrj
      character (len = 1  ) blank, minus, roots
      parameter (blank = ' ', minus = '-', roots = 'A')
      character  no_labels*11, too_many*80
      parameter (no_labels = '%no_labels%',
     +too_many = 'Too many labels requested ... maximum = 2000')   
      logical    e_numbers, e_formats
      logical    fileit 
      parameter (fileit = .true.)
      logical    done, done1, ok, repeet
      external   e_formats, showrj
      external   dsplay
      external   putfat, listbx, putifa, putadv, table5, getjm1,
     +           gks001, lbplot, putwar, viewit, pcaplt
      external   space5
      external   g03faf$
      intrinsic  abs, min
      save       nswap
      save       ndim, nx, ny, nz
      data       nswap / 1 /  
      data       ndim, nx, ny, nz / 2, 1, 2, 3 /
      save       x_factor, y_factor
      data       x_factor, y_factor / one, one / 
c
c check
c
      if (n.lt.2) then
         write (line,100)
         call putfat (line)
         return
      endif
      if (liwk.lt.5*n) then
         write (line,200)
         call putfat (line)
         return
      endif
      if (lwk.lt.n*(n + 17)/2 - 1) then
         write (line,300)
         call putfat (line)
         return
      endif
c
c main loop
c
      e_numbers = e_formats()
      ntop = min(n, ncmax)
      if (ndim.gt.ntop) ndim = ntop
      numdec = 1
      negeig = 0
      done = .true.
      done1 = .false.
      ok = .false.
      repeet = .true.
      do while (repeet)
         if (numdec.lt.1 .or. numdec.gt.numopt) numdec = 1
         write (text,400) ndim
         call listbx (numdec, numopt,
     +                text)
c
c check if choice is consistent
c
         if (numdec.ge.2 .and. numdec.le.8 .and. .not.ok) then
            write (line,500)
            call putfat (line)
            numdec = 0
         endif
         if (numdec.ge.2 .and. numdec.le.8 .and. negeig.gt.0) then
            if (.not.done1) then
               write (line,600) negeig
               call putwar (line)
               done1 = .true.
            endif   
         endif
         if (numdec.eq.5) then
            if (n.gt.nwmax .or. wordx(1).eq.no_labels) then
               call putfat (too_many)
               numdec = 0
            endif   
         endif  
         if (numdec.eq.1) then
c
c numdec = 1: analysis
c
            ifail = 1
            call g03faf$(roots, n, d, ndim, x, nrmax, w1, wk, iwk,
     +                   ifail)
            if (ifail.eq.0) then
               done = .false.
               done1 = .false.
               ok = .true.
               numdec = 2
               write (line,700)
               call putadv (line)
               call dsplay (ncmax, ndim, nout, nrmax, n, ntype, 
     +                      x,
     +                      'The calculated metric matrix',
     +                      fileit)
c
c calculate scaling factors and number of appreciably negative eigenvalues as follows:
c scale1 = sum of absolute values of eigenvalues returned by g03faf$
c negeig = number of eigenvalues appreciably less than zero
c              
               negeig = 0
               scale1 = zero
               scale2 = zero
               eigmin = epsi*abs(w1(1))
               do i = 1, n - 1
                  if (abs(w1(i)).le.eigmin) w1(i) = zero
                  if (i.le.ndim) scale1 = scale1 + w1(i)
                  scale2 = scale2 + abs(w1(i))
                  if (w1(i).lt.zero) negeig = negeig + 1
               enddo
               if (abs(w1(n)).le.eigmin) w1(n) = zero
               if (negeig.gt.0) then
                  write (line,600) negeig
                  call putwar (line)
                  done1 = .true.
               endif
c
c calculate frac1 and frac2 as follows:
c frac1 = fraction as returned by g03faf$
c frac2 = fraction using absolute values returned by g03faf$
c               
               frac1 = zero
               frac2 = zero
               do i = 1, ndim
                  frac1 = frac1 + w1(i)
                  frac2 = frac2 + abs(w1(i))
               enddo 
               frac1 = frac1/scale1
               frac2 = frac2/scale2
               numdec = 2
            else
               negeig = 1
               done = .true.
               ok = .false.
               call putifa (ifail, nout, 'G03FAF/CMSCAL')
            endif
         elseif (numdec.eq.2) then
c
c numdec = 2: display eigenvalues
c
            icolor = 15
            call table5 (icolor, 'OPEN')
            icolor = 4
            write (line,800)
            call table5 (icolor, line)
            icolor = 0
            do i = 1, n 
               if (e_numbers) then
                  write (line,900) w1(i)
               else
                  d13 = showrj(w1(i))
                  write (line,950) d13
               endif  
               call table5 (icolor, line)
            enddo
            icolor = 1
            if (negeig.gt.0) then
               write (line,1000) ndim, n - 1, frac1, f100*frac1,
     +                           ' (actual values)'
               call table5 (icolor, line)
               write (line,1000) ndim, n - 1, frac2, f100*frac2,
     +                           ' (absolute values)'
               call table5 (icolor, line)
            else  
               write (line,1000) ndim, n - 1, frac1, f100*frac1,
     +                           blank
               call table5 (icolor, line) 
            endif   
            call table5 (icolor, 'CLOSE')
            numdec = 1
         elseif (numdec.eq.3) then
c
c numdec = 3: file eigenvalues
c
            if (.not.done) then
               done = .true.
               write (nout,'(a)') blank
               write (nout,800)
               do i = 1, n
                  if (e_numbers) then 
                     write (nout,900) w1(i)
                  else
                     d13 = showrj(w1(i)) 
                     write (nout,950) d13
                  endif
               enddo
               if (negeig.gt.0) then
                  write (nout,1000) ndim, n - 1, frac1, f100*frac1,
     +                              ' (actual values)' 
                  write (nout,1000) ndim, n - 1, frac2, f100*frac2,
     +                              ' (absolute values)'
               else
                    write (nout,1000) ndim, n - 1, frac1, f100*frac1,
     +                                blank                    
               endif
            endif
            write (line,1100)
            call putadv (line)
            numdec = 1
         elseif (numdec.eq.4 .or. numdec.eq.5) then
c
c numdec = 4 or 5: 2D plots
c
            if (.not.ok .or. ndim.lt.2 .or. lwk.lt.2*n) then
               write (line,1200) 2
               call putfat (line)
            else
               ntop = ndim
               if (nx.gt.ntop .or. ny.gt.ntop) then
                  nx = 1
                  ny = 2
               endif
               call pcaplt (ntop, nx, ny, 
     +                      x_factor, y_factor)              
               if (x_factor.gt.zero) then
                  write (xtitle,1400) blank, nx
               else   
                  write (xtitle,1400) minus, nx
               endif
               if (y_factor.gt.zero) then   
                  write (ytitle,1400) blank, ny
               else  
                  write (ytitle,1400) minus, ny
               endif   
               do i = 1, n
                  wk(i) = x_factor*x(i,nx)
                  wk(n + i) = y_factor*x(i,ny)
               enddo
               k1 = 1
               k2 = n + 1
               if (numdec.eq.4) then
                  if (n.le.50) then
                     m = 5
                  elseif (n.le.100) then
                     m = 4
                  else
                     m = 1
                  endif
                  call gks001 (l, m, n,
     +                         wk(k1), wk(k2),
     +                         ptitle, xtitle, ytitle)
                  numdec = 5
               else
                  call lbplot (n,
     +                         wk(k1), wk(k2),
     +                         ptitle, wordx, xtitle, ytitle)
                  numdec = 6
               endif
            endif
         elseif (numdec.eq.6) then
c
c numdec = 6: 3D plot
c
            if (.not.ok .or. ndim.lt.3 .or. lwk.lt.5*n) then
               write (line,1200) 3
               call putfat (line)
            else
               if (ndim.eq.3) then
                  nx = 1
                  ny = 2
                  nz = 3
               else
                  nbot = 1
                  ntop = ndim
                  if (nx.gt.ntop) nx = ntop
                  if (ny.gt.ntop) ny = ntop
                  if (nz.gt.ntop) nz = ntop
                  write (line,1300) 'x'
                  call getjm1 (nbot, nx, ntop,
     +                         line)
                  write (line,1300) 'y'
                  call getjm1 (nbot, ny, ntop,
     +                         line)
                  write (line,1300) 'z'
                  call getjm1 (nbot, ny, ntop,
     +                         line)
               endif
               k1 = 0
               k2 = n
               k3 = 2*n
               k4 = 3*n
               k5 = 4*n
               do i = 1, n
                  wk(k1 + i) = x(i,nx)
                  wk(k3 + i) = x(i,ny)
                  wk(k5 + i) = x(i,nz)
               enddo
               k1 = k1 + 1
               k2 = k2 + 1
               k3 = k3 + 1
               k4 = k4 + 1
               k5 = k5 + 1
               call space5 (n, n,
     +                      wk(k1), wk(k2), wk(k3), wk(k4), wk(k5))
            endif
            numdec = 1
         elseif (numdec.eq.7) then
c
c numdec = 7: view calculated matrix
c         
            line = 'The calculated metric matrix'   
            call viewit (ndim, nrmax, n, ntype,
     +                   x,
     +                   line)  
            numdec = 4
         elseif (numdec.eq.8) then
c
c numdec = 8: change dimension
c
             ksav = ndim
             write (line,1500)
             nbot = 1
             ntop = min(n, ncmax)
             call getjm1 (nbot, ndim, ntop,
     +                    line)
             if (ksav.ne.ndim) ok = .false.
             numdec = 1  
         elseif (numdec.eq.numopt) then
c
c numdec = 10: cancel

            repeet = .false.
         endif
      enddo
  100 format ('Sample size too small (n < 2) in call to CMSCAL')
  200 format ('Workspace dimension LIWK too small in CMSCAL/G03FAF')
  300 format ('Workspace dimension LWK too small in CMSCAL/G03FAF')
  400 format (
     + 'Calculate: principal coordinates'
     +/'Eigenvalues: display'
     +/'Eigenvalues: write to the results file'
     +/'View: Plot as 2D (simple)'
     +/'View: Plot as 2D (advanced)'
     +/'View: Plot as 3D'
     +/'View: The calculated metric matrix'
     +/'Dimension: Change (current dimension, r =',i3,')'
     +/'Quit ... Exit principal coordinate options')
  500 format ('First analyse the distance matrix')
  600 format ('Number of negative eigenvalues =',i4)
  700 format ('Eigenvalues have been calculated')
  800 format ('Eigenvalues (divided by the trace of the E matrix)')
  900 format (1p,e13.5)
  950 format (1x,a)
 1000 format (
     +'[Sum 1 to',i3,']/[sum 1 to',i4,'] =',f8.4,' (',f6.2,'%)',a)
 1100 format ('Eigenvalues have been written to the results log file')
 1200 format ('Eigenvalues not yet calculated for dimension >=',i3)
 1300 format ('Number of the component to be plotted as',1x,a)
 1400 format (a1,'Component',i3)
 1500 format ('Number of dimensions required (r, usually 2 or 3)')
      end
c
c
