C
C
      SUBROUTINE CONTIN (NCMAX, NCOL, NIN, NOBS, NOUT, NPMAX, NRMAX,
     +                   NROW,
     +                   A, P, PRED, X,
     +                   FNAME, TITLE,
     +                   NEWDAT, SUPPLY)
C
C ACTION : Analysis of contingency table
C AUTHOR : W.G.Bardsley, University of Manchester, derived from CHISQD
C          07/02/2001 introduced CHOP80
C          20/01/2002 added output for conflation
C          01/07/2002 revised and added LOGLIN
C          27/01/2003 revised outputfor Fisher exact and corrected errors
C          10/02/2006 added NCOL, NPMAX, NROW, NEWDAT and SUPPLY to arguments
C          08/05/2011 added calls to FORM12
C          15/06/2014 now also outputs the rearranged contingency table
C          01/01/2021 added p = P(...) for increased clarity  
C          23/07/2021 added E_NUMBERS and E_FORMATS
C
C   NCMAX: (input/unchanged) max. column dimension
C    NCOL: (input/output) depending on SUPPLY
C     NIN: (input/unchanged) unconnected unit for data input not
C                            referenced if SUPPLY = .TRUE.
C    NOUT: (input/unchanged) preconnected unit for results
C   NPMAX: (input/unchanged) MAX(NRMAX, NCMAX, 21)
C   NRMAX: (input/unchanged) max. row dimension
C    NROW: (input/output) depending on SUPPLY
C    NOBS: workspace
C       A: (input/output) data returned or supplied if SUPPLY = .TRUE.
C       P: workspace
C    PRED: workspace
C       X: workspace
C   FNAME: (input/output) depending on SUPPLY
C   TITLE: (input/output) depending on SUPPLY
C  NEWDAT: (output) .TRUE. if SUPPLY = .TRUE> and new data requested
C  SUPPLY: (input/unchanged) if .TRUE. then data re supplied
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    NCMAX, NCOL, NIN, NOUT, NPMAX, NRMAX, NROW
      INTEGER    NOBS(NRMAX,NCMAX)
      DOUBLE PRECISION A(NRMAX,NCMAX), P(NPMAX), PRED(NRMAX,NCMAX),
     +                 X(NPMAX)
      CHARACTER  FNAME*(*), TITLE*(*)
      LOGICAL    NEWDAT, SUPPLY
C
C Locals
C
      INTEGER    N3
      PARAMETER (N3 = 3)
      INTEGER    K0, K1, K2, K3, K4, K5, K11
      PARAMETER (K0 = 0, K1 = 1, K2 = 2, K3 = 3, K4 = 4, K5 = 5,
     +           K11 = 11)
      INTEGER    KOBS(2,2)
      INTEGER    I11, I12, I21, I22, NC1, NC2, NCMIN, NR1, NR2, NRMIN  
      INTEGER    IFAIL, INOB, IPRED, MM, M1, NN, NDF, NPOS, NUM, N1
      INTEGER    I, ICOUNT, J, JCOUNT, K
      INTEGER    COLOUR
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NSTART, NUMDEC, NUMOPT,
     +           NUMTXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 0)
      INTEGER    NUMBLD(30), NUMPOS(10)
      DOUBLE PRECISION ZERO, PNT95, PNT99, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, PNT95 = 0.95D+00, PNT99 = 0.99D+00,
     +           ONE = 1.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION CHIS
      DOUBLE PRECISION PGCHI, PGLAM, P95, P99
      DOUBLE PRECISION A11, A12, A21, A22, C1, C2, R1, R2, SUM1
      DOUBLE PRECISION PCRIT, PL, PSUML, PSUMU, PU
      DOUBLE PRECISION BOT, DI, DIJ, DJ, DN, DSUM, TOP
      DOUBLE PRECISION G01ECF$, G01FCF$
      CHARACTER (LEN = 12) J12(3), FORM12, WORD12_NCOL, WORD12_NROW
      CHARACTER (LEN = 13) D13(4), SHOWLJ
      CHARACTER  CIPHER*40, DSIG*30, RESUL*30
      CHARACTER  CHOP60*60, CHOP80*80, LINE*100, TEXT(30)*100
      CHARACTER  CONFL(2)*30, C6*6
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    ABORT, FIXCOL, FIXROW, LABEL
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .FALSE.)
      LOGICAL    REPEET
      EXTERNAL   E_FORMATS, SHOWLJ
      EXTERNAL   G01AFF$, G01ECF$, G01FCF$
      EXTERNAL   PUTADV, MATTIN, PUTFAT, PUTIFA, TABLE1, PATCH1, FORM12,
     +           LBOX01, MIDDLE, CHOP60, CHOP80, LOGLIN, TRIML1, PLEVEL
      INTRINSIC  NINT, ABS, DBLE, LOG, MIN
      SAVE ICOUNT, JCOUNT
      DATA ICOUNT, JCOUNT / 0, 0 /
      DATA NUMBLD / 30*0 /
      DATA NUMPOS / 10*1 /
C
C Initialise
C
      IF (SUPPLY) THEN
         IF (NCOL.LT.K2 .OR. NROW.LT.K2) THEN
            CALL PUTFAT ('Must have no. cols >= 2, no. rows >= 2')
            NEWDAT = .TRUE.
            RETURN
         ELSE
            ABORT = .FALSE.
            DO J = K1, NCOL
               IF (.NOT.ABORT) THEN
                  DO I = K1, NROW
                     IF (.NOT.ABORT) THEN
                        IF (A(I,J).LT.ZERO) ABORT = .TRUE.
                     ENDIF
                  ENDDO
               ENDIF
            ENDDO
            IF (ABORT) THEN
               CALL PUTFAT (
     +'Contingency table frequencies must be non-negative integers')
               NEWDAT = .TRUE.
               RETURN
            ELSE
               NEWDAT = .FALSE.
            ENDIF
         ENDIF
      ELSE
         NCOL = K0
         NROW = K0
         TITLE = 'No data'
      ENDIF
      REPEET = .TRUE.
      DO WHILE (REPEET)
C
C Main menu
C
         WORD12_NCOL = FORM12(NCOL)
         WORD12_NROW = FORM12(NROW)
         WRITE (TEXT,100) CHOP60(TITLE), WORD12_NROW, WORD12_NCOL
         NUMBLD(1) = 4
         NUMBLD(4) = 1
         NSTART = 9
         NUMOPT = 5
         NUMTXT = NSTART + NUMOPT - 1
         NUMDEC = NUMOPT - K1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                NUMOPT, NUMPOS, NSTART, NUMTXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         NUMBLD(4) = 0
         IF (NUMDEC.EQ.K2 .OR. NUMDEC.EQ.K3) THEN
C
C Check that data is available before analysis is done
C
            IF (NCOL.LT.K2 .OR. NROW.LT.K2) THEN
               CALL PUTFAT ('First input your data')
               ABORT = .TRUE.
               NCOL = K0
               NROW = K0
               TITLE = 'No data'
               NUMDEC = K0
            ENDIF
         ENDIF
         IF (NUMDEC.EQ.K1) THEN
C
C New data
C
            IF (SUPPLY) THEN
               NEWDAT = .TRUE.
               RETURN
            ELSE
               I = N3
               J = NIN
               FNAME = BLANK
               FIXCOL = .FALSE.
               FIXROW = .FALSE.
               LABEL = .TRUE.
               CLOSE (UNIT = J)
               CALL PUTADV (
     +'Now input data formatted like chisqd.tf4 and chisqd.tf5')
               CALL MATTIN (I, NCMAX, NCOL, J, NRMAX, NROW,
     +                      A, X,
     +                      FNAME, TITLE,
     +                      ABORT, FIXCOL, FIXROW, LABEL)
               CLOSE (UNIT = J)
               IF (ABORT) THEN
                  NCOL = K0
                  NROW = K0
                  FNAME = BLANK
                  TITLE = 'No data'
               ENDIF
               IF (.NOT.ABORT .AND. (NCOL.LT.K2 .OR. NROW.LT.K2)) THEN
                  CALL PUTFAT ('Must have no. cols >= 2, no. rows >= 2')
                  ABORT = .TRUE.
                  NCOL = K0
                  NROW = K0
                  FNAME = BLANK
                  TITLE = 'No data'
               ENDIF
               IF (.NOT.ABORT .AND. NROW.EQ.NRMAX) THEN
                  CALL PUTFAT ('Too many rows requested')
                  WRITE (LINE,200) NRMAX - K1
                  CALL PUTADV (LINE)
                  ABORT = .TRUE.
                  NCOL = K0
                  NROW = K0
                  FNAME = BLANK
                  TITLE = 'No data'
               ENDIF
               IF (.NOT.ABORT .AND. NCOL.EQ.NCMAX) THEN
                  CALL PUTFAT ('Too many columns requested')
                  WRITE (LINE,200) NCMAX - K1
                  CALL PUTADV (LINE)
                  ABORT = .TRUE.
                  NCOL = K0
                  NROW = K0
                  FNAME = BLANK
                  TITLE = 'No data'
               ENDIF
               IF (.NOT.ABORT) THEN
                  DO J = K1, NCOL
                     IF (.NOT.ABORT) THEN
                        DO I = K1, NROW
                           IF (.NOT.ABORT) THEN
                              IF (A(I,J).LT.ZERO) ABORT = .TRUE.
                           ENDIF
                        ENDDO
                     ENDIF
                  ENDDO
                  IF (ABORT) THEN
                     CALL PUTFAT (
     +'Contingency table frequencies must be non-negative integers')
                     NCOL = K0
                     NROW = K0
                     TITLE = 'No data'
                  ENDIF
               ENDIF
            ENDIF
        ELSEIF (NUMDEC.EQ.K2) THEN
C
C First try NUM = 1
C
            MM = NROW + K1
            NN = NCOL + K1
            DO I = K1, NCOL
               DO J = K1, NROW
                  NOBS(J,I) = NINT(A(J,I))
               ENDDO
            ENDDO
            INOB = NRMAX
            IPRED = NRMAX
            NUM = K1
            IFAIL = K1
            CALL G01AFF$(INOB, IPRED, MM, NN, NOBS, NUM, PRED, CHIS,
     +                   P, NPOS, NDF, M1, N1, IFAIL)
            IF (IFAIL.EQ.K1) THEN
C
C Shrinking failed so try NUM = 0
C
               CALL PUTADV (
     +        'Singular data ... Automatic shrinking abandoned')
               MM = NROW + K1
               NN = NCOL + K1
               DO I = K1, NCOL
                  DO J = K1, NROW
                     NOBS(J,I) = NINT(A(J,I))
                  ENDDO
               ENDDO
               INOB = NRMAX
               IPRED = NRMAX
               NUM = K0
               IFAIL = K1
               CALL G01AFF$(INOB, IPRED, MM, NN, NOBS, NUM, PRED, CHIS,
     +                      P, NPOS, NDF, M1, N1, IFAIL)
            ENDIF
            IF (IFAIL.NE.K0) THEN
               CALL PUTIFA (IFAIL, NOUT, 'G01AFF/CONTIN')
            ELSE
               ICOUNT = ICOUNT + K1
            ENDIF
            IF (IFAIL.EQ.K0 .AND. NUM.GT.K0) THEN
C
C Fisher exact test if NUM > 0
C
               JCOUNT = JCOUNT + 1
               COLOUR = 15
               CALL TABLE1 (COLOUR, 'OPEN')
               WRITE (TEXT,300) JCOUNT, CHOP80(TITLE)
               WRITE (NOUT,350) JCOUNT, CHOP80(TITLE)
               DO I = K1, K5
                  IF (I.EQ.K1 .OR. I.EQ.K3 .OR. I.EQ.K5) THEN
                     COLOUR = K4
                  ELSE
                     COLOUR = K0
                  ENDIF
                  CALL TABLE1 (COLOUR, TEXT(I))
               ENDDO
               COLOUR = K0
    
C------------------------------------------------------------
C Start of code to construct the rearranged contingency table
C
               NC1 = NOBS(1,1) + NOBS(2,1)
               NC2 = NOBS(1,2) + NOBS(2,2)
               NR1 = NOBS(1,1) + NOBS(1,2)
               NR2 = NOBS(2,1) + NOBS(2,2)
               NCMIN = MIN(NC1,NC2)
               NRMIN = MIN(NR1,NR2)
               IF (NRMIN.LE.NCMIN) THEN
C
C Copy NOBS into KOBS and swap rows if required
C                 
                  IF (NR1.LE.NR2) THEN
                     KOBS(1,1) = NOBS(1,1)
                     KOBS(1,2) = NOBS(1,2)
                     KOBS(2,1) = NOBS(2,1)
                     KOBS(2,2) = NOBS(2,2)
                  ELSE   
                     KOBS(1,1) = NOBS(2,1)
                     KOBS(1,2) = NOBS(2,2)
                     KOBS(2,1) = NOBS(1,1)
                     KOBS(2,2) = NOBS(1,2)
                  ENDIF   
               ELSE
C
C Copy but transpose and swap eventual rows if required
C                 
                  IF (NC1.LE.NC2) THEN
                     KOBS(1,1) = NOBS(1,1)
                     KOBS(1,2) = NOBS(2,1)
                     KOBS(2,1) = NOBS(1,2)
                     KOBS(2,2) = NOBS(2,2)
                  ELSE
                     KOBS(1,1) = NOBS(1,2)
                     KOBS(1,2) = NOBS(2,2)
                     KOBS(2,1) = NOBS(1,1)
                     KOBS(2,2) = NOBS(2,1)
                  ENDIF  
                  NC1 = KOBS(1,1) + KOBS(2,1)
                  NC2 = KOBS(1,2) + KOBS(2,2)   
               ENDIF     
               IF (NC1.GT.NC2) THEN
C
C Swap columns if required
C                 
                  I11 = KOBS(1,1)
                  I12 = KOBS(1,2)
                  I21 = KOBS(2,1)
                  I22 = KOBS(2,2)
                  KOBS(1,1) = I12
                  KOBS(1,2) = I11
                  KOBS(2,1) = I22
                  KOBS(2,2) = I21
               ENDIF
C
C Rearranged contingency table now written to KOBS 
C-------------------------------------------------
               
               DO I = K1, K2
                  J = NOBS(I,K1)
                  K = NOBS(I,K2)
                  WRITE (TEXT(I),400) J, K,  
     +                                KOBS(I,K1), KOBS(I,K2)
                  WRITE (NOUT,400) J, K,  
     +                             KOBS(I,K1), KOBS(I,K2)
                  CALL TABLE1 (COLOUR, TEXT(I))
               ENDDO

               WRITE (TEXT,500)
               WRITE (NOUT,500)
               COLOUR = K4
               CALL TABLE1 (COLOUR, TEXT(1))
               CALL TABLE1 (COLOUR, TEXT(2))
               WRITE (C6,'(I6)') NPOS - K1
               CALL TRIML1 (C6)
               PCRIT = P(NPOS)
               PL = ZERO
               PU = ZERO
               PSUML = ZERO
               PSUMU = ZERO
               DO I = K1, NUM
                  IF (I.EQ.NPOS) THEN
                     COLOUR = K1
                     CIPHER = 'p(*), observed frequencies'
                     PSUML = PSUML + PCRIT
                     PSUMU = PSUMU + PCRIT
                  ELSE
                     COLOUR = K0
                     CIPHER = BLANK
                     IF (I.LT.NPOS) THEN
                        PSUML = PSUML + P(I)
                        IF (P(I).LE.PCRIT) PL = PL + P(I)
                     ELSEIF (I.GT.NPOS) THEN
                        PSUMU = PSUMU + P(I)
                        IF (P(I).LE.PCRIT) PU = PU + P(I)
                     ENDIF
                  ENDIF
                  WRITE (LINE,600) I - K1, P(I), CIPHER
                  WRITE (NOUT,600) I - K1, P(I), CIPHER
                  CALL TABLE1 (COLOUR, LINE)
               ENDDO
               CALL MIDDLE (ZERO, PL, ONE)
               CALL MIDDLE (ZERO, PU, ONE)
               CALL MIDDLE (ZERO, PSUML, ONE)
               CALL MIDDLE (ZERO, PSUMU, ONE)
               COLOUR = K4
               WRITE (LINE,700)
               WRITE (NOUT,'(A)') LINE
               CALL TABLE1 (COLOUR, LINE)
               COLOUR = K0
               WRITE (LINE,710) PL, 'sum of p(r) =< p(*) for r < '//C6
               WRITE (NOUT,'(A)') LINE
               CALL TABLE1 (COLOUR, LINE)
               WRITE (LINE,720) PSUML, 'sum of all p(r) for r =< '//C6
               WRITE (NOUT,'(A)') LINE
               CALL TABLE1 (COLOUR, LINE)
               WRITE (LINE,730) PSUMU, 'sum of all p(r) for r >= '//C6
               WRITE (NOUT,'(A)') LINE
               CALL TABLE1 (COLOUR, LINE)
               WRITE (LINE,740) PU, 'sum of p(r) =< p(*) for r > '//C6
               WRITE (NOUT,'(A)') LINE
               CALL TABLE1 (COLOUR, LINE)
               PSUML = PSUML + PU
               PSUMU = PSUMU + PL
               CALL MIDDLE (ZERO, PSUML, ONE)
               CALL MIDDLE (ZERO, PSUMU, ONE)
               WRITE (LINE,750) PSUML, 'P-sum2 + P-sum4'
               WRITE (NOUT,'(A)') LINE
               CALL TABLE1 (COLOUR, LINE)
               WRITE (LINE,760) PSUMU, 'P-sum1 + P-sum3'
               WRITE (NOUT,'(A)') LINE
               CALL TABLE1 (COLOUR, LINE)
               CALL TABLE1 (COLOUR, 'CLOSE')
               A11 = NOBS(1,1)
               A12 = NOBS(1,2)
               A21 = NOBS(2,1)
               A22 = NOBS(2,2)
               C1 = A11 + A21
               C2 = A12 + A22
               R1 = A11 + A12
               R2 = A21 + A22
               SUM1 = R1 + R2
               NDF = K1
               CHIS = SUM1*((ABS(A11*A22 - A12*A21) -
     +                      (SUM1/TWO))**2)/(C1*C2*R1*R2)
            ELSEIF (IFAIL.EQ.K0 .AND. MM.LT.K11 .AND. NN.LT.K11) THEN
               WRITE (NOUT,'(A)') BLANK
               WRITE (NOUT,800) ICOUNT
               DO I = K1, MM - 1
                  WRITE (NOUT,'(10I8)') (NOBS(I,J), J = K1, NN - K1)
               ENDDO
            ENDIF
C
C Significance levels
C
            IFAIL = K1
            PGCHI = G01ECF$('Upper-tail', CHIS, DBLE(NDF), IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01ECF/CONTIN')
            CALL PLEVEL (PGCHI, RESUL)
            IFAIL = K1
            P95 = G01FCF$(PNT95, DBLE(NDF), IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01FCF/CONTIN')
            IFAIL = K1
            P99 = G01FCF$(PNT99, DBLE(NDF), IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01FCF/CONTIN')
            IF (NROW.GT.M1) THEN
               WRITE (CONFL(1),900) NROW - M1
            ELSE
               CONFL(1) = BLANK
            ENDIF
            IF (NCOL.GT.N1) THEN
               WRITE (CONFL(2),900) NCOL - N1
            ELSE
               CONFL(2) = BLANK
            ENDIF
C
C Likelihood ratio test statistic -2log(lambda)
C
            DSUM = ZERO
            DN = DBLE(NOBS(MM,NN))
            DO I = K1, M1
               DI = DBLE(NOBS(I,NN))
               DO J = K1, N1
                  DJ = DBLE(NOBS(MM,J))
                  DIJ = DBLE(NOBS(I,J))
                  TOP = DIJ*DN
                  BOT = DI*DJ
                  IF (TOP.GT.ZERO .AND. BOT.GT.ZERO)
     +                DSUM = DSUM + DIJ*LOG(TOP/BOT)
               ENDDO
            ENDDO
            DSUM = TWO*DSUM
            IFAIL = K1
            PGLAM = G01ECF$('Upper-tail', DSUM, DBLE(NDF), IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01ECF/CONTIN')
            CALL PLEVEL (PGLAM, DSIG)
C
C Output results
C
            E_NUMBERS = E_FORMATS()
            IF (E_NUMBERS) THEN
               WRITE (TEXT,1000) ICOUNT, CHOP80(TITLE), NROW, CONFL(1),
     +                           NCOL, CONFL(2), CHIS, NDF,
     +                           PGCHI, RESUL, P95, P99, DSUM, PGLAM,
     +                           DSIG
               WRITE (NOUT,1100) ICOUNT, TITLE, NROW, CONFL(1), NCOL,
     +                           CONFL(2), CHIS, NDF,
     +                           PGCHI, RESUL, P95, P99, DSUM, PGLAM,
     +                           DSIG
            ELSE
               J12(1) = FORM12(NROW)
               J12(2) = FORM12(NCOL)
               J12(3) = FORM12(NDF)  
               D13(1) = SHOWLJ(CHIS)
               D13(2) = SHOWLJ(P95)
               D13(3) = SHOWLJ(P99)
               D13(4) = SHOWLJ(DSUM)
               WRITE (TEXT,1005) ICOUNT, CHOP80(TITLE), J12(1),
     +                           CONFL(1),
     +                           J12(2), CONFL(2), D13(1), J12(3),
     +                           PGCHI, RESUL, D13(2), D13(3), D13(4),
     +                           PGLAM, DSIG
               WRITE (NOUT,1105) ICOUNT, TITLE, J12(1), CONFL(1), 
     +                           J12(2), CONFL(2), D13(1), J12(3),
     +                           PGCHI, RESUL, D13(2), D13(3), D13(4),
     +                           PGLAM, DSIG                   
            ENDIF  
            NUMTXT = 15
            TEXT(NUMTXT) = BLANK
            IF (M1.EQ.K2 .AND. N1.EQ.K2) THEN
               NUMTXT = NUMTXT + K1
               WRITE (TEXT(NUMTXT),1200)
               WRITE (NOUT,1300)
            ENDIF
            COLOUR = 15
            CALL TABLE1 (COLOUR, 'OPEN')
            DO I = K1, NUMTXT
               IF (I.EQ.K1 .OR. I.EQ.K3 .OR. I.EQ.K5) THEN
                  COLOUR = K4
               ELSE
                  COLOUR = K0
               ENDIF
               CALL TABLE1 (COLOUR,TEXT(I))
            ENDDO
            CALL TABLE1 (COLOUR, 'CLOSE')
         ELSEIF (NUMDEC.EQ.K3) THEN
            CALL LOGLIN (NCMAX, NCOL, NOUT, NRMAX, NROW,
     +                   A, TITLE)
         ELSEIF (NUMDEC.EQ.K4) THEN
            WRITE (TEXT,1400)
            NUMBLD(1) = K1
            NUMTXT = 22
            CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMTXT, TEXT,
     +                   BORDER)
            NUMBLD(1) = K0
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statements
C
  100 FORMAT (
     + 'Contingency table analysis'
     +/
     +/'Current data:'
     +/A
     +/
     +/'Number of rows =',1X,A
     +/'Number of columns =',1X,A
     +/
     +/'Data: New/Edit/Transform/View'
     +/'Chi-square and Fisher exact tests'
     +/'GLM Log-linear model fitting'
     +/'Help'
     +/'Quit ... Exit contingency table analysis')
  200 FORMAT ('Maximum dimension in this version =',I6)
  300 FORMAT (
     + 'Fisher exact test',I4
     +/'Data:'
     +/A
     +/
     +/1X,'Observed   Rearranged so R1 is smallest marginal, C2 >= C1')
  350 FORMAT (
     +/'***'
     +/
     +/1X,'Fisher exact test',I4
     +/1X,'---------------------'
     +/1X,'Data: ',A
     +/1X,'Observed    Rearranged so R1 is smallest marginal, C2 >= C1'
     +/1X,'--------    -----------------------------------------------')
  400 FORMAT (1X,2I4,8X,2I4)
  500 FORMAT (/1X,
     +'p(  r) = p for f(1,1) is r after rearranging and adjusting')
  600 FORMAT (1X,'p(',I3,') =',f9.6,2X,A)
  700 FORMAT (1X,'P-Sums, for 1-tail and 2-tail test statistics')
  710 FORMAT (1X,'P-sum1 =',f9.6,2X,A)
  720 FORMAT (1X,'P-sum2 =',f9.6,2X,A)
  730 FORMAT (1X,'P-sum3 =',f9.6,2X,A)
  740 FORMAT (1X,'P-sum4 =',f9.6,2X,A)
  750 FORMAT (1X,'P-sum5 =',f9.6,2X,A)
  760 FORMAT (1X,'P-sum6 =',f9.6,2X,A)
  800 FORMAT (
     + 1X,'Observed chi-square frequencies',I4
     +/1X,'-----------------------------------')
  900 FORMAT (' [*',I3,' conflated]')
 1000 FORMAT (
     + 'Chi-square test',I4
     +/
     +/'H0: No-association, independence, homogeneity.'
     +/'Data:'
     +/A
     +/'Number of rows           =',I4,1X,A
     +/'Number of columns        =',I4,1X,A
     +/'Chi-sq. test statistic C =',1P,E12.5
     +/'Degrees of freedom       =',I4
     +/'p = P(chi-sq. >= C)      =',0P,F7.4,5X,A
     +/'Upper tail 5% point      =',1P,E12.5
     +/'Upper tail 1% point      =',   E12.5
     +/'L = -2*log(lambda)       =',   E12.5
     +/'p = P(chi-sq. >= L)      =',0P,F7.4,5X,A)
 1005 FORMAT (
     + 'Chi-square test',I4
     +/
     +/'H0: No-association, independence, homogeneity.'
     +/'Data:'
     +/A
     +/'Number of rows           =',1X,A,1X,A
     +/'Number of columns        =',1X,A,1X,A
     +/'Chi-sq. test statistic C =',1X,A
     +/'Degrees of freedom       =',1X,A
     +/'p = P(chi-sq. >= C)      =',F7.4,5X,A
     +/'Upper tail 5% point      =',1X,A
     +/'Upper tail 1% point      =',1X,A
     +/'L = -2*log(lambda)       =',1X,A
     +/'p = P(chi-sq. >= L)      =',F7.4,5X,A) 
 1100 FORMAT (
     +/'***'
     +/
     +/1X,'Chi-square test',I4
     +/1X,'-------------------'
     +/1X,'H0: No-association, independence, homogeneity.'
     +/1X,'Data: ',A
     +/1X,'Number of rows           =',I4,1X,A
     +/1X,'Number of columns        =',I4,1X,A
     +/1X,'Chi-sq. test statistic C =',1P,E10.3
     +/1X,'Degrees. of freedom      =',I4
     +/1X,'p = P(chi-sq. >= C)      =',0P,F7.4,5X,A
     +/1X,'Upper tail 5% point      =',1P,E12.5
     +/1X,'Upper tail 1% point      =',   E12.5
     +/1x,'L = -2*log(lambda)       =',   E12.5
     +/1X,'p = P(chi-sq. >= L)      =',0P,F7.4,5X,A)     
 1105 FORMAT (
     +/'***'
     +/
     +/1X,'Chi-square test',I4
     +/1X,'-------------------'
     +/1X,'H0: No-association, independence, homogeneity.'
     +/1X,'Data: ',A
     +/1X,'Number of rows           =',1X,A,1X,A
     +/1X,'Number of columns        =',1X,A,1X,A
     +/1X,'Chi-sq. test statistic C =',1X,A
     +/1X,'Degrees. of freedom      =',1X,A
     +/1X,'p = P(chi-sq. >= C)      =',F7.4,5X,A
     +/1X,'Upper tail 5% point      =',1X,A
     +/1X,'Upper tail 1% point      =',1X,A
     +/1x,'L = -2*log(lambda)       =',1X,A
     +/1X,'p = P(chi-sq. >= L)      =',F7.4,5X,A)
 1200 FORMAT ('Yate''s correction used in chi-square')
 1300 FORMAT (1X,'Yate''s correction used in chi-square')
 1400 FORMAT (
     + 'Analysis of two way contingency tables'
     +/
     +/'This procedure takes a matrix with r rows and c columns of non-'
     +/'negative integer frequencies f(i,j) to test H0: no association'
     +/'between the categorical variables, i.e., p(i,j) = p(i.)p(.j).'
     +/
     +/'A chi-square test is performed (with conflation if necessary'
     +/'by adding sparse rows and/or columns to reduce the degrees of'
     +/'freedom) which should be reasonably meaningful if all expected'
     +/'frequencies exceed 1.0. Yates continuity correction is used if'
     +/'appropriate, and the likelihood ratio test statistic is given'
     +/'for use as an alternative to the Pearson chi-square statistic.'
     +/'For small 2 by 2 tables a Fisher exact test is also performed.'
     +/
     +/'Log-linear models can be fitted if all f(i,j) > 0, by creating'
     +/'dummy indicator variables, then fitting a generalized linear'
     +/'model assuming Poisson errors and a log link. Because this'
     +/'leads to aliasing with the constant term, the constraint that'
     +/'both row coefficients and column coefficients sum to zero is'
     +/'imposed, then iterative techniques are used for GLM fitting.'
     +/
     +/'Suitable test files are chisqd.tf4 and chisqd.tf5.')
      END

C
C
