C
C
      SUBROUTINE CORCOF (N, R, X, Y)
C
C ACTION : Calculate correlation coefficient
C AUTHOR : W. G. Bardsley, 5/5/92
C          03/02/2001 revised
C          Date of this version 13/02/2001
C
      IMPLICIT   NONE
      INTEGER    N
      INTEGER    I, N1, N2
      PARAMETER (N1 = 1, N2 = 2)
      DOUBLE PRECISION R, X(N), Y(N)
      DOUBLE PRECISION ROOT, RTOL, SXX, SYY, SXY, XBAR, YBAR
      DOUBLE PRECISION X02AMF$
      DOUBLE PRECISION RBOT, RTOP, ZERO
      PARAMETER (RBOT = -1.0D+00, RTOP = 1.0D+00, ZERO = 0.0D+00)
      EXTERNAL   PUTFAT
      EXTERNAL   X02AMF$
      INTRINSIC  SQRT, DBLE
C
C Initialise then check N
C
      R = ZERO
      IF (N.LT.N2) THEN
          CALL PUTFAT ('Sample size to small to calculate R')
          RETURN
      ENDIF
C
C Calculate
C
      RTOL = 1.0D+09*X02AMF$()
      SXX = ZERO
      SYY = ZERO
      SXY = ZERO
      XBAR = ZERO
      YBAR = ZERO
      DO I = N1, N
         XBAR = XBAR + X(I)
         YBAR = YBAR + Y(I)
      ENDDO
      XBAR = XBAR/DBLE(N)
      YBAR = YBAR/DBLE(N)
      DO I = N1, N
         SXX = SXX + (X(I) - XBAR)**2
         SYY = SYY + (Y(I) - YBAR)**2
         SXY = SXY + (X(I) - XBAR)*(Y(I) - YBAR)
      ENDDO
      ROOT = SQRT(SXX*SYY)
      IF (ROOT.GT.RTOL) THEN
         R = SXY/ROOT
         IF (R.LT.RBOT) THEN
            R = RBOT
         ELSEIF (R.GT.RTOP) THEN
            R = RTOP
         ENDIF
      ELSE
         CALL PUTFAT ('R cannot be calculated')
      ENDIF
      END
C
C
