c
c
      subroutine corrpa (ncmax, ncol, nin, nout, nrmax, nrow,
     +                   a,
     +                   fname, title,
     +                   newdat)
c
c action: call pacorr for partial correlation analysis
c author: w.g.bardsley, university of manchester, u.k., 10/01/2006
c         05/03/2006 added ncol, nrow, title, and newdat to argument
c                    list, calculated corr before calling pacorr
c         27/07/2006 changed allocation dimension to allow for m > n 
c         02/11/2006 now uses dummy variables and added fname to arguments
c
c  ncmax: (input/unchanged) dimension
c   ncol: (input/unchanged) dimension
c    nin: (input/unchanged) unconnected unit for data input
c   nout: (input/unchanged) preconnected unit for results
c  nrmax: (input/unchanged) dimension
c   nrow: (input/unchanged) dimension
c      a: (input/unchanged) data or correlation matrix
c  fname: (input/unchanged) file name
c  title: (input/unchanged) data title
c newdat: (output) request for new data
c
      implicit   none
c
c arguments
c
      integer,             intent (in)  :: ncmax, ncol, nin, nout,
     +                                     nrmax, nrow
      double precision,    intent (in)  :: a(nrmax,ncmax)
      character (len = *), intent (in)  :: fname, title
      logical,             intent (out) :: newdat
c
c local allocatable arrays
c
      double precision, allocatable :: a1(:,:), b(:,:), corr(:,:), x(:),
     +                                 y(:)
c
c locals
c
      integer    i, ierr, ifail, j, ncol1, nrow1, nsamp, nsav, numdec,
     +           nvar
      integer    isend, jsend, numopt, numtxt
      parameter (isend = 4, jsend = 1, numopt = 6, numtxt = 20)
      integer    numbld(numtxt)
      character  fname1*1024, line*100, text(numtxt)*100, title1*80
      character  blank*1
      parameter (blank = ' ')
      logical    abort, repeet
      logical    query, supply
      parameter (query = .false., supply = .true.)
      external   pacorr, putifa, listbx, isitcv, getjge, patch2, viewer
      external   g02baf$
      save       nsav
      data       nsav / 30 /
      data       numbld / numtxt*0 /
c
c check
c                                 
      newdat = .false.
      if (ncol.lt.2 .or. ncol.gt.ncmax .or.
     +    nrow.lt.2 .or. nrow.gt.nrmax) return
         
c
c allocate workspace
c
      ierr = 0
      if (allocated(a1)) deallocate(a1, stat = ierr)
      if (ierr.ne.0) return   
      if (allocated(b)) deallocate(b, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(corr)) deallocate(corr, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y)) deallocate(y, stat = ierr)
      if (ierr.ne.0) return
      allocate(a1(nrmax,ncmax), stat = ierr)
      if (ierr.ne.0) return 
      allocate(b(ncmax,ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(corr(ncmax,ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(x(ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(y(ncmax), stat = ierr)
      if (ierr.ne.0) return
c
c main loop
c              
      ncol1 = ncol
      nrow1 = nrow      
      do j = 1, ncol1
         do i = 1, nrow1 
            a1(i,j) = a(i,j)
         enddo
      enddo  
      fname1 = fname
      title1 = title
      numdec = numopt - 2
      repeet = .true.
      do while (repeet)
         write (text,100)
         call listbx (numdec, numopt,
     +                text)
         if (numdec.eq.1) then
c
c numdec = 1: calculate corr
c ===========
c
            ifail = 1
            call g02baf$(nrow1, ncol1, a1, nrmax, x, y, b, ncmax, corr,
     +                   ncmax, ifail)
            call putifa (ifail, nout, 'G02BAF/CORRPA')
            nsamp = nrow1
         elseif (numdec.eq.2) then
c
c numdec = 2: check if correlation matrix
c ===========
c
            call isitcv (isend, ncol1, nrmax, nrow1,
     +                   a1,
     +                   abort)
            if (abort) then
               ifail = -1
            else
               write (line,200)
               ifail = 1
               call getjge (nsav, ifail,
     +                      line)
               nsamp = nsav
               ifail = 0
               do j = 1, ncol1
                  do i = 1, nrow1
                     corr(i,j) = a1(i,j)
                  enddo
               enddo
            endif      
         elseif (numdec.eq.3) then        
c
c numdec = 3: view file
c ==========
c         
            call viewer (jsend,
     +                   fname1, blank, blank)               
            ifail = -1
         elseif (numdec.eq.numopt - 2) then
c
c numdec = numopt - 2: help
c ====================
c
            write (text,300)
            numbld(1) = 1
            numbld(6) = 1
            numbld(12) = 1
            call patch2 (numbld, numtxt,
     +                   text)
            numbld(1) = 0
            numbld(6) = 0
            numbld(12) = 0
            ifail = -1
         elseif (numdec.eq.numopt - 1) then
c
c numdec = numopt - 1: get new data
c ====================
c
            newdat = .true.
            repeet = .false.
         else
c
c numdec = numopt: exit
c ================
c
            newdat = .false.
            repeet = .false.
         endif
c
c if OK from options 1 or 2 call pacorr
c
         if (repeet .and. ifail.eq.0) then
            nvar = ncol1
            call pacorr (ncmax, nin, nout, nrmax, nsamp, nvar,
     +                   a1, b, corr, x, y,
     +                   fname1, title1,
     +                   query, supply)
         endif
      enddo
c
c deallocate workspace
c
      deallocate(a1, stat = ierr)
      deallocate(b, stat = ierr)
      deallocate(corr, stat = ierr)
      deallocate(x, stat = ierr)
      deallocate(y, stat = ierr)
c
c format statement
c
  100 format (
     + 'Analyse: as a data matrix'
     +/'Analyse: as a correlation matrix' 
     +/'View current file'
     +/'Help'
     +/'New data'
     +/'Quit ... Exit correlation data options')
  200 format ('Sample size used to calculate correlation matrix')
  300 format (
     + 'Data formats for calculating partial correlations'
     +/
     +/'To perform these calculations your data set A(i,j) must be'
     +/'supplied in one of two possible formats.'
     +/
     +/'1) Supplying a data matrix'
     +/
     +/'You simply provide a n by m data matrix and the correlation'
     +/'matrix will be calculated automatically before presenting the'
     +/'options for subsequently calculating partial correlations.'
     +/
     +/'2) Supplying a correlation matrix'
     +/
     +/'Before analysis the following investigations will be done to'
     +/'make sure the matrix is actually a correlation matrix.'
     +/'a)`the diagonals A(i,i) must all be one, i.e. A(i,i) = 1'
     +/'b)`the matrix must be symmetrical, i.e.  A(i,j) = A(j,i)'
     +/'c)`all A(i,j) must be correlations, i.e. -1 =< A(i,j) =< 1.'
     +/'Also the sample size used to calculate the correlation matrix'
     +/'must be supplied.')
      end
c
c
