c
c coxgof
c coxplt
c
      subroutine coxgof (isend, n, nd, nout, nrmax, ns, nwk,
     +                   res, sur, tp, wk)
c
c action: goodness of fit from Cox regression with G12BAF
c author: w.g.bardsley, university of manchester, u.k., 01/11/2005
c         05/07/2010 added extra step at origin if tp(1) > 0
c         28/12/2014 added call to coxplt
c         09/10/2021 added e_numbers and e_formats, etc. 
c
c isend: (input/unchanged) isend = 1(residuals), isend = 2(survivor functions)
c     n: (input/unchanged) dimension
c    nd: (input/unchanged) dimension
c  nout: (input/unchanged) pre-connected unit for results
c nrmax: (input/unchanged) dimension
c    ns: (input/unchanged) number of strata
c   nwk: (input/unchanged) dimension
c   res: (input/unchanged) residuals
c   sur: (input/unchanged) survivor functions
c    tp: (input/unchanged) distinct survival times
c    wk: workspace
c
      implicit   none
c
c arguments
c
      integer    isend, n, nd, nout, nrmax, ns, nwk
      double precision res(n), tp(nd), sur(nrmax,ns), wk(nwk)
c
c locals
c
      integer    i, j, jsend, k, nd2, nstart, nstop, numdec, numopt
      integer    lplot, mplot, nplot
      integer    nmax
      parameter (nmax = 12)
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      character (len = 13) d13, showrj 
      character  line*100, text(10)*100
      character  blank*1, ptitle*50, xtitle*4, ytitle*4
      parameter (blank = ' ', xtitle = 'Time', ytitle = 'S(t)')
      logical    e_numbers, e_formats
      logical    done1, done2, done3, repeet
      external   e_formats, showrj
      external   table1, hnplot, putadv, listbx, getjm1, gks001, putfat
      external   coxplt
      intrinsic  min
c
c check
c
      if (n.lt.2 .or. nd.lt.2 .or. ns.lt.1) return
c
c initialise
c
      e_numbers = e_formats() 
      done1 = .false.
      done2 = .false.
      done3 = .false.
      repeet = .true.
      if (isend.eq.1) then
c
c isend = 1: analyse residuals
c ============================
c
         write (text,100)
         numopt = 5
         do while (repeet)
            numdec = 1
            call listbx (numdec, numopt,
     +                   text)
            if (numdec.eq.1) then
c
c display residuals
c
               j = 15
               call table1 (j, 'OPEN')
               j = 4
               write (line,200)
               call table1 (j, line)
               j = 0
               if (e_numbers) then
                  do i = 1, n
                     write (line,300) i, res(i)
                     call table1 (j, line)
                  enddo
               else
                  do i = 1, n
                     d13 = showrj(res(i))
                     write (line,350) i, d13
                     call table1 (j, line)
                  enddo
               endif  
               call table1 (j, 'CLOSE')
            elseif (numdec.eq.2) then
c
c save residuals to results file
c
               if (.not.done1) then
                  done1 = .true.
                  write (nout,'(a)') blank
                  write (nout,200)
                  if (e_numbers) then
                     do i = 1, n
                       write (nout,300) i, res(i)
                     enddo
                  else
                     do i = 1, n
                       d13 = showrj(res(i))
                       write (nout,350) i, d13
                     enddo
                  endif  
               endif
               write (line,400)
               call putadv (line)
            elseif (numdec.ge.3 .and. numdec.le.4) then
c
c half-normal and full-normal residuals plots
c
               jsend = numdec - 2
               call hnplot (jsend, n,
     +                      res)
            else
c
c cancel residuals analysis
c
               repeet = .false.
            endif
         enddo
      elseif (isend.eq.2) then
c
c isend = 2: analyse survivor functions
c =====================================
c

         numopt = 5
         write (text,600)
         do while (repeet)
            numdec = 1
            call listbx (numdec, numopt,
     +                   text)
            if (numdec.eq.1 .or. numdec.eq.2) then
               if (.not.done2) then
                  done2 = .true.
                  if (ns.le.nmax) then
                     nstart = 1
                     nstop = ns
                  else
                     write (line,500)
                     i = 1
                     j = ns
                     nstart = 1
                     call getjm1 (i, nstart, j,
     +                            line)
                     nstop = min(ns, nstart + nmax - 1)
                  endif
               endif
            endif
            if (numdec.eq.4 .and. ns.eq.1) numdec = 3
            if (numdec.eq.1) then
c
c table of survivor functions
c
               write (line,700) nstart, nstop
               j = 15
               call table1 (j, 'OPEN')
               j = 4
               call table1 (j, line)
               j = 0
               if (e_numbers) then
                  do i = 1, nd
                     write (line,800) tp(i), (sur(i,k), k = nstart,
     +                                                      nstop)
                     call table1 (j, line)
                  enddo
               else
                  do i = 1, nd
                     d13 = showrj(tp(i))
                     write (line,850) d13, (sur(i,k), k = nstart, nstop)
                     call table1 (j, line)
                  enddo
               endif  
               call table1 (j, 'CLOSE')
            elseif (numdec.eq.2) then
c
c save survivor functions to results file
c
               if (.not.done3) then
                  done3 = .true.
                  write (nout,'(a)') blank
                  write (nout,700) nstart, nstop
                  if (e_numbers) then
                     do i = 1, nd
                        write (nout,800) tp(i), (sur(i,k),
     +                                   k = nstart, nstop)
                     enddo
                  else
                     do i = 1, nd
                        d13 = showrj(tp(i))
                        write (nout,850) d13, (sur(i,k),
     +                                   k = nstart, nstop)
                     enddo  
                  endif
               endif
               write (line,400)
               call putadv (line)
            elseif (numdec.eq.3) then
c
c plot survivor functions
c
               if (tp(1).gt.zero) then
                  j = 4*nd + 2 
               else
                  j = 4*nd - 2
               endif      
               if (nwk.ge.j) then
                  if (ns.eq.1) then
                     j = 1
                  else
                     write (line,900)
                     i = 1
                     j = 1
                     k = ns
                     call getjm1 (i, j, k,
     +                            line)
                  endif
                  write (ptitle,1000) j
                  if (tp(1).gt.zero) then
c
c add an extra step at the origin
c                    
                     nd2 = 2*nd + 2
                     
                     nplot = 1
                     wk(nplot) = zero
                     wk(nd2 + nplot) = one
                     
                     nplot = nplot + 1
                     wk(nplot) = tp(1)
                     wk(nd2 + nplot) = one
                     
                     nplot = nplot + 1
                     wk(nplot) = tp(1)
                     wk(nd2 + nplot) = sur(1,j)
                  else 
c
c start steps at the first data point
c                      
                     nd2 = 2*nd
                     nplot = 1
                     wk(nplot) = tp(1)
                     wk(nd2 + nplot) = sur(1,j)
                  endif   
                  do i = 2, nd
                     nplot = nplot + 1
                     wk(nplot) = tp(i)
                     wk(nd2 + nplot) = sur(i - 1,j)
                     nplot = nplot + 1
                     wk(nplot) = tp(i)
                     wk(nd2 + nplot) = sur(i,j)
                  enddo
                  lplot = 1
                  mplot = 0
                  call gks001 (lplot, mplot, nplot,
     +                         wk(1), wk(nd2 + 1),
     +                         ptitle, xtitle, ytitle)
               else
                  write (line,1100)
                  call putfat (line)
               endif
            elseif (numdec.eq.4) then  
               call coxplt (nd, nrmax, ns,
     +                      sur, tp) 
            else
c
c cancel survivor functions analysis
c
               repeet = .false.
            endif
         enddo
      endif   
c
c format statements
c      
  100 format (
     + 'Display residuals'
     +/'Save residuals to results file'
     +/'Half normal plot'
     +/'Full normal plot'
     +/'Quit ... Exit residuals analysis')
  200 format ('Observation     Residuals')
  300 format (i6,5x,1p,1x,e13.5)
  350 format (i6,5x,1x,a13)
  400 format ('Table requested has been written to the results file')
  500 format ('Strata number to start display')
  600 format (
     + 'Display survivor functions'
     +/'Save survivor functions to results file'
     +/'Plot a survivor function'
     +/'Plot all survivor functions'
     +/'Quit ... Exit survivor analysis')
  700 format ('     Time then S(t) for strata',i3,1x,'to',i3)
  800 format (1p,e13.5,0p,10f8.4)
  850 format (1x,a13,10f8.4)
  900 format ('Stratum for survivor function plot')
 1000 format ('S(t) for stratum',i3)
 1100 format ('Insufficient workspace in call to COXGOF')
      end
c
c-------------------------------------------------------------------------------
c
      subroutine coxplt (nd, nrmax, ns,
     +                   sur, tp)
c
c action: multiple survivor step functions after calling G12BAF from COXREG
c author: w.g.bardsley, university of manchester, u.k., 28/12/2014
c
c    nd: number of distinct time points
c nrmax: leading dimension of sur
c    ns: number of strata
c   sur: survivor functions
c    tp: discrete survival times
c     
      implicit none
c
c arguments
c       
      integer,          intent (in) :: nd, nrmax, ns
      double precision, intent (in) :: sur(nrmax,ns), tp(nd)
c
c allocatable 
c      
      integer,                 allocatable :: jfiles(:), lfiles(:),
     +                                        mfiles(:)
      double precision,       allocatable :: x(:), y(:)
      character (len = 1024), allocatable :: files(:)
c
c locals
c    
      integer    i, iadd1, ifail, ios, j, k, nfiles, nout, npts  
      integer    icolor(5)
      integer    n2
      parameter (n2 = 2)
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      character (len = 40  ) titles(4)
      character (len = 100 ) line
      character (len = 1024) temp
      logical    askif, there
      parameter (askif = .false.)
      external   deleet, getnou, gettmp, putadv, smplot
      data       icolor / 0, 4, 1, 2, 3 /
c
c check if ns > 1
c      
      if (ns.le.1) then
         write (line,100) ns
         call putadv (line)
         return
      endif
c
c define npts then allocate
c      
      npts = 2*nd + 1
      allocate (jfiles(ns), stat = ios)
      allocate (lfiles(ns), stat = ios)
      allocate (mfiles(ns), stat = ios)
      allocate (x(npts), stat = ios)
      allocate (y(npts), stat = ios)
      allocate (files(ns), stat = ios)
c
c create the step curve for each stratum
c      
      iadd1 = 0
      do k = 1, ns
         call getnou (nout)
         call gettmp (ifail,
     +                temp) 
         open (unit = nout, file = temp, iostat = ios)
         if (ios.ne.0) return
         write (nout,'(a)',iostat=ios) 'Temporary file'  
         write (nout,'(2i6)',iostat=ios) npts, n2 
         x(1) = zero
         y(1) = one
         j = 1
         do i = 1, nd
            j = j + 1
            x(j) = tp(i)
            if (i.eq.1) then
               y(j) = y(1)
            else
               y(j) = y(j - 1)
            endif        
            j = j + 1
            x(j) = tp(i)
            y(j) = sur(i,k)
         enddo
         do i = 1, npts
            write (nout,'(2e12.4)',iostat=ios) x(i), y(i)
         enddo
         close (unit = nout)
         iadd1 = iadd1 + 1
         if (iadd1.lt.0 .or. iadd1.gt.5) iadd1 = 1
         jfiles(k) = icolor(iadd1)
         lfiles(k) = 1
         mfiles(k) = 0
         files(k) = temp
      enddo 
c
c plot
c       
      nfiles = ns
      titles(1) = 'Cox Regression Survivor Functions'
      titles(2) = 'Time'
      titles(3) = 'S(t)'
      titles(4) = ' '       
      call smplot (jfiles, lfiles, mfiles, nfiles,
     +             files, titles)
c
c clean up
c     
      do i = 1, ns
         call deleet (files(i),
     +                askif, there)
      enddo  
      deallocate(jfiles, stat = ios)      
      deallocate(lfiles, stat = ios)      
      deallocate(mfiles, stat = ios)      
      deallocate(files, stat = ios)      
      deallocate(x, stat = ios)      
      deallocate(y, stat = ios)      
 100  format ('The number of strata =',i2)
      end
c
c            