c    
c
      subroutine coxreg (ic, isi, iwk, ncmax, ncol, nin, nout, nrmax,
     +                   nrow, nwmax,
     +                   b, cov, omega, res, sc, se, sur, t, tp, wk, z,
     +                   fname, title,
     +                   newdat, supply)
c
c action: Cox regression using G02GCF and G12BAF
c author: w.g.bardsley, university of manchester, u.k., 01/11/2005
c         16/11/2005 added tpos to argument list for coxdat
c         12/02/2006 added ncol, nrow, fname, title, newdat and supply
c                    to arguments and redimensioned sur(nrmax,ncmax + 7)
c         05/07/2010 added extra step at origin
c         03/04/2013 switched off over-zealous error message from g02gcf and the
c                    offset functionality, increased maxit from 100 to 300 and
c                    added intents
c         09/10/2021 added e_numbers and e_formats, etc. 
c                               
c
c  ncmax: (input/unchanged) dimension
c   ncol: (input/unchanged) if supply = .true. o/w not referenced
c    nin: (input/unchanged) unconnected unit for data input
c   nout: (input/unchanged) preconnected unit for results
c  nrmax: (input/unchanged) dimension
c   nrow: (input/unchanged) if supply = .true. o/w not referenced
c  nwmax: (input/unchanged) dimension
c         Note: nwmax must be >= ncmax*(ncmax + 9)/2 + nrmax for the largest
c               possible data set and >= 4*nrmax for the maximum case survivor
c               function plot
c newdat: (output) 
c supply: (input/unchanged)
c all other arguments are workspaces
c
c
      implicit   none
c
c arguments
c
      integer,            intent (in)    :: ncmax, ncol, nin, nout,
     +                                      nrmax, nrow, nwmax
      integer,            intent (inout) :: ic(nrmax), isi(nrmax), 
     +                                      iwk(2*nrmax)
      double precision,   intent (inout) :: b(ncmax),
     +                                      cov(ncmax*(ncmax + 1)/2),
     +                                      omega(nrmax), res(nrmax),
     +                                      sc(ncmax), se(ncmax),
     +                                      sur(nrmax,ncmax + 7),
     +                                      t(nrmax), tp(nrmax),
     +                                      wk(nwmax), z(nrmax,ncmax)
      character (len = *), intent (inout) :: fname, title
      logical,             intent (in)    :: supply
      logical,             intent (out)   ::  newdat
c
c locals
c
      integer    nvmax, nxmin, n0
      parameter (nvmax = 100, nxmin = 1, n0 = 0)
      integer    isz(nvmax)
      integer    numopt, numsta, numtxt
      parameter (numopt = 9, numsta = 11, numtxt = numopt + numsta - 1)
      integer    numbld(30)
      integer    icount, isend, jcount, m, n, noff, numdec, nvar
      integer    i, idf, ifail, iprint, irank, j, maxit, nd, ns
      double precision dev, tol
      double precision df, prob, pval, temp, tnu
      double precision zero, one, epsi, pnt05, pnt1, pnt2, pnt95
      parameter (zero = 0.0d+00, one = 1.0d+00, epsi = 1.0d-20,
     +           pnt05 = 0.05d+00, pnt1 = 0.1d+00, pnt2 = 0.2d+00,
     +           pnt95 = 0.95d+00)
      double precision g01ebf$, g01fbf$
      character (len = 1024) fname2
      character (len = 100 ) header, line, text(30)
      character (len = 80  ) fname1, title1, title2
      character (len = 80  ) chop80, trim80
      character (len = 20  ) nodata, nofile, novars
      parameter (nodata = 'No data',
     +           nofile = 'No file',
     +           novars = 'No variables')
      character (len = 13  ) d13(6), showlj, showrj 
      character (len = 12  ) form12, word12
      character (len = 5   ) off
      character (len = 3   ) stars
      character (len = 1   ) blank, offset
      parameter (blank = ' ')
      logical    e_numbers, e_formats
      logical    abort, fitted, ready, repeet, showit
      logical    fixcol, fixrow, label
      parameter (fixcol = .false., fixrow = .false., label = .true.)
      logical    tpos
      parameter (tpos = .true.)
      external   e_formats, showlj, showrj
      external   coxdat, lstbox, mattin, putadv, putfat, putwar, form12,
     +           chop80, trim80, putifa, isxvec, isxtyp, table1, revpro,
     +           coxgof, isxedi, vec1in, patch2
      external   g12baf$, g02gcf$, g01ebf$, g01fbf$
      intrinsic  log, dble
      save       icount, isz, jcount
      data       icount, isz, jcount / 0, nvmax*1, 0 /
      data       numbld / 30*0 /
c
c initialise newdat
c
      newdat = .false.
c
c initialise fitted
c
      fitted = .false.
      if (supply) then
         m = ncol
         n = nrow
         if (m.lt.4 .or. n.lt.2) then
            write (line,500)
            call putfat (line)
            return
         elseif (m*(m + 9)/2 + n.gt.nwmax) then
            write (line,600)
            call putfat (line)
            return
         endif
         call coxdat (ic, isi, nrmax, m, nrmax, n, ncmax, nin,
     +                nrmax, ns,
     +                sur, t, z,
     +                fname, title,
     +                abort, tpos)
         if (abort) then
            call putfat (title)
            return
         else
            ready = .true.
            fname1 = trim80(fname)
            title1 = chop80(title)
            icount = icount + 1
            write (nout,700) icount, fname1, title1
            numdec = 2
         endif
      else
         fname1 = nofile
         title1 = nodata
         ready = .false.
         m = 0
         n = 0
      endif
      noff = 0
      nvar = 0
      numdec = numopt - 1
      header = novars
      offset = 'N'
      repeet = .true.
c
c main menu
c
      e_numbers = e_formats()
      do while (repeet)
         if (numdec.lt.1) then
            numdec = 1
         elseif (numdec.gt.numopt) then
            numdec = numopt
         endif     
         if (offset.eq.'Y') then
            off = 'Yes'
         else
            off = 'No'
         endif
         if (m.gt.0) then
            call isxvec (isz, m, nvar, nxmin)
            call isxtyp (isz, m, nvar, nxmin,
     +                   header,
     +                   showit)
         else
            header = novars
            showit = .false.
         endif
         write (text,100) fname1, title1, header, off
         numbld(1) = 1
         numbld(4) = 1
         numbld(6) = 1
         numbld(8) = 1
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0
         numbld(4) = 0
         numbld(6) = 0
         numbld(8) = 0
c
c check numdec
c
         if (.not.ready) then
            if (numdec.ge.2 .and. numdec.le.6) then
               write (line,200)
               call putfat (line)
               numdec = 0
            endif
         endif
         if (.not.fitted) then
            if (numdec.ge.3 .and. numdec.le.4) then
               write (line,300)
               call putfat (line)
               numdec = 0
            endif
         endif
         if (numdec.eq.1) then
c
c numdec = 1: input new data file
c ===========
c
            if (supply) then
               newdat = .true.
               return
            endif
            ready = .false.
            fitted = .false.
            noff = 0
            offset = 'N'
            write (line,400)
            call putadv (line)
            close (unit = nin)
            isend = 2
            call mattin (isend, ncmax, m, nin, nrmax, n,
     +                   sur, wk,
     +                   fname, title,
     +                   abort, fixcol, fixrow, label)
            close (unit = nin)
            if (.not.abort) then
               if (m.lt.4 .or. n.lt.2) then
                  write (line,500)
                  call putfat (line)
                  abort = .true.
               elseif (m*(m + 9)/2 + n.gt.nwmax) then
                  write (line,600)
                  call putfat (line)
                  abort = .true.
               endif
            endif
            if (.not.abort) then
c
c transform data into Cox regression format
c
               call coxdat (ic, isi, nrmax, m, nrmax, n, ncmax, nin,
     +                      nrmax, ns,
     +                      sur, t, z,
     +                      fname, title,
     +                      abort, tpos)
               if (abort) call putfat (title)
            endif
            if (abort) then
               ready = .false.
               m = 0
               n = 0
               fname1 = nofile
               title1 = nodata
               line = novars
               numdec = 1
            else
               ready = .true.
               fname1 = trim80(fname)
               title1 = chop80(title)
               icount = icount + 1
               write (nout,700) icount, fname1, title1
               numdec = 2
            endif
         elseif (numdec.eq.2) then
c
c numdec = 2: fit
c ===========
c
            ifail = 1
            tol = 0.001D+00
            maxit = 300
            do i = 1, n
               tp(i) = one - dble(ic(i))
               sur(i,7) = log(t(i))
            enddo
c
c first fit an exponential model
c
            call g02gcf$('L', 'M', 'Y', 'U', n, z, nrmax, m, isz,
     +                    nvar + 1, tp, res, zero, dev, idf, b, irank,
     +                    se, cov, sur, nrmax, tol, maxit, n0, zero,
     +                    wk, ifail)
            if (ifail.gt.0 .and. ifail.le.4) then
               call putifa (ifail, nout, 'G02GCF/COXREG')
            else
               if (irank.ne.nvar + 1) then
                  write (line,800)
                  call putwar (line)
               endif
               do i = 1, nvar
                  b(i) = b(i + 1)
               enddo
               iprint = -1
               ifail = 1
c
c fit Cox model using starting estimates from exponential model
c
               call g12baf$(offset, n, m, ns, z, nrmax, isz, nvar, t,
     +                      ic, omega, isi, dev, b, se, sc, cov, res,
     +                      nd, tp, sur, nrmax, tol, maxit, iprint, wk,
     +                      iwk, ifail)
               if (ifail.ne.0) then
                  fitted = .false.
                  call putifa (ifail, nout, 'G12BAF/COXREG')
               else
                  jcount = jcount + 1
                  fitted = .true.
                  write (nout,'(a)') blank
                  j = 15
                  call table1 (j, 'OPEN')
                  if (showit) then
                     write (nout,'(a)') header
                     j = 0
                     call table1 (j, header)
                  endif
                  word12 = form12(n)
                  if (e_numbers) then
                     write (text,900) jcount, icount, off, dev, word12
                     write (nout,900) jcount, icount, off, dev, word12
                  else
                     d13(1) = showlj(dev)
                     write (text,950) jcount, icount, off, trim(d13(1)),
     +                      word12
                     write (nout,950) jcount, icount, off, trim(d13(1)),
     +                      word12
                  endif  
                  do i = 1, 3
                     if (i.le.2) then
                        j = 0
                     else
                        j = 4
                     endif
                     call table1 (j, text(i))
                  enddo
                  df = dble(n - nvar)
                  ifail = 1
                  tnu = g01fbf$('C', pnt95, df, ifail)
                  call putifa (ifail, nout, 'G01FBF/COXREG')
                  j = 0
                  do i = 1, nvar
                     pval = b(i)/max(se(i),epsi)
                     ifail = 1
                     prob = g01ebf$('S', pval, df, ifail)
                     call putifa (ifail, nout, 'G01EBF/COXREG')
                     if (prob.gt.pnt2) then
                        stars = '***'
                     elseif (prob.gt.pnt1) then
                        stars = '**'
                     elseif (prob.gt.pnt05) then
                        stars = '*'
                     else
                        stars = blank
                     endif
                     if (e_numbers) then
                        write (line,1000) i, b(i), sc(i),
     +                                    b(i) - tnu*se(i),
     +                                    b(i) + tnu*se(i),
     +                                    se(i), prob, stars
                     else
                        d13(1) = showrj(b(i))
                        d13(2) = showrj(sc(i))
                        temp = b(i) - tnu*se(i)
                        d13(3) = showrj(temp)
                        temp = b(i) + tnu*se(i)
                        d13(4) = showrj(temp)
                        d13(5) = showrj(se(i))
                        write (line,1050) i, d13(1), d13(2),
     +                                    d13(3),
     +                                    d13(4),
     +                                    d13(5), prob, stars
                     endif  
                     write (nout,'(a)') line
                     call table1 (j, line)
                  enddo
                  call table1 (j, 'CLOSE')
               endif
            endif
         elseif (numdec.ge.3 .and. numdec.le.4) then
c
c numdec = 3 or 4: residuals or survivor functions
c ================
c
            if (fitted) then
               isend = numdec - 2
               call coxgof (isend, n, nd, nout, nrmax, ns, nwmax,
     +                      res, sur, tp, wk)
            endif
         elseif (numdec.eq.5) then
c
c numdec = 5: suppress/restore variables
c ===========
c
            if (m.eq.1) then
               write (line,1100)
               call putadv (line)
            else
               fitted = .false.
               call isxedi (isz, m, nvar, nxmin)
            endif
         elseif (numdec.eq.6) then
c
c numdec = 6: install an offset vector
c ===========
c 
            if (offset.eq.'N' .or. offset.eq.'y') then
               call putadv ('This feature is currently disabled')
               offset = 'N'
            else   
               write (line,1200) n
               call putadv (line)
               close (unit = nin)
               isend = 2
               call vec1in (isend, nin, nrmax, noff,
     +                      omega,
     +                      fname2, title2,
     +                      abort, fixrow, label)
               close (unit = nin)
               if (abort) then
                  offset = 'N'
               elseif (noff.lt.n) then
                  write (line,1300)
                  call putfat (line)
                  offset = 'N'
               else
                  fitted = .false.
                  offset = 'Y'
               endif
            endif   
         elseif (numdec.eq.numopt - 2) then
c
c numdec = numopt - 2: results
c ====================
c
            call revpro (nout)
         elseif (numdec.eq.numopt - 1) then
c
c numdec = numopt - 1: help
c ====================
c
            write (text,1400)
            j = 22
            numbld(1) = 1
            numbld(5) = 1
            numbld(8) = 1
            numbld(12) = 1
            numbld(16) = 1
            call patch2 (numbld, j,
     +                   text)
            numbld(1) = 0
            numbld(5) = 0
            numbld(8) = 0
            numbld(12) = 0
            numbld(16) = 0
         elseif (numdec.eq.numopt) then
c
c numdec = numopt: cancel
c ================
c
            repeet = .false.
         endif
c
c check if current offset is large enough
c
         if (repeet .and. offset.eq.'Y') then
            if (noff.lt.n) then
               offset = 'N'
               noff = 0
               write (line,1300)
               call putadv (line)
            endif
         endif
      enddo
c
c format statements
c      
  100 format (
     + 'Cox regression'
     +/
     +/'Current data file:'
     +/a
     +/'Current data title:'
     +/a
     +/'Current variables:'
     +/a
     +/'Include offset:',a
     +/
     +/'Data: New/Edit/Transform/View'
     +/'Fit the current data'
     +/'Analyse residuals'
     +/'Analyse survivor functions'
     +/'Suppress/Restore variables'
     +/'Install an offset vector'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit Cox regression options')
  200 format ('First input your data')
  300 format ('First fit the data')
  400 format ('Input a file formatted like cox.tf1 as x1,...xm,y,t,s')
  500 format ('Data matrix must have at least 4 columns and 2 rows')
  600 format ('Insufficient workspace in call to COXREG')
  700 format (
     +/'Cox regression data set',i4
     +/'File:',1x,a
     +/'Title:',1x,a)
  800 format ('Covariates are not of full rank')
  900 format (
     + 'Cox regression:',i4,', Data set:',i4,', Offset included:',1x,a
     +/'Deviance =',1p,e13.5,', Number of time points =',1x,a
     +/'B(i)     Estimate         Score    Lower95%cl    Upper95%cl',
     +'     Std.error   p') 
  950 format (
     + 'Cox regression:',i4,', Data set:',i4,', Offset included:',1x,a
     +/'Deviance =',1x,a,', Number of time points =',1x,a
     +/'B(i)     Estimate         Score    Lower95%cl    Upper95%cl',
     +'     Std.error   p')    
 1000 format (i3,1p,5(1x,e13.5),0p,f7.4,2x,a)  
 1050 format (i3,5(1x,a13),f7.4,2x,a)  
 1100 format ('Cannot suppress the only covariate')
 1200 format ('Input an offset vector with dimension >=',i6)
 1300 format ('Offset vector is too small for this data set')
 1400 format (
     + 'Cox regression: parameters, residuals, and survivor functions.'
     +/
     +/'Data files can have cases arranged in any order but they must'
     +/'be formatted as x1, x2,..., xm, y, t, s, as follows.'
     +/'Columns 1 to m'
     +/'These must contain the covariates x(1) to x(m), where m >= 1.'
     +/
     +/'Column m + 1'
     +/'This must contain the indicator value y, defined as y = 0 for'
     +/'failure, or y = 1 if right censored. No other value is allowed.'
     +/
     +/'Column m + 2'
     +/'This must be the time for failure or right censoring. Note that'
     +/'the times can be in any order but they must be non-negative.'
     +/
     +/'Column m + 3'
     +/'This must be the stratum indicator (in any order), using 1 for'
     +/'cases in stratum 1, 2 for cases in stratum 2, and so on. If'
     +/'there are no strata, set all values in the last column to 1.'
     +/
     +/'Test files are cox.tf1, cox.tf2, cox.tf3, cox.tf4, g12baf.tf1,'
     +/'and experienced users can install an offset vector.')
      end
c
c